/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.collect.IteratorInt;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.index.IndexManager;
import org.eclipse.mat.parser.index.IndexWriter;
import org.eclipse.mat.parser.internal.PreliminaryIndexImpl;
import org.eclipse.mat.parser.internal.SnapshotImplBuilder;
import org.eclipse.mat.parser.internal.snapshot.ObjectMarker;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.parser.model.XGCRootInfo;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.SilentProgressListener;

class GarbageCleaner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] clean(final PreliminaryIndexImpl idx, SnapshotImplBuilder builder, Map<String, String> arguments, IProgressListener listener) throws IOException {
        IndexManager idxManager = new IndexManager();
        try {
            Serializable un;
            listener.beginTask(Messages.GarbageCleaner_RemovingUnreachableObjects, 11);
            listener.subTask(Messages.GarbageCleaner_SearchingForUnreachableObjects.pattern);
            int oldNoOfObjects = idx.identifiers.size();
            boolean[] reachable = new boolean[oldNoOfObjects];
            int newNoOfObjects = 0;
            int[] newRoots = idx.gcRoots.getAllKeys();
            IIndexReader.IOne2LongIndex identifiers = idx.identifiers;
            IIndexReader.IOne2ManyIndex preOutbound = idx.outbound;
            IIndexReader.IOne2OneIndex object2classId = idx.object2classId;
            HashMapIntObject<ClassImpl> classesById = idx.classesById;
            int numProcessors = Runtime.getRuntime().availableProcessors();
            ObjectMarker marker = new ObjectMarker(newRoots, reachable, preOutbound, new SilentProgressListener(listener));
            if (numProcessors > 1) {
                try {
                    marker.markMultiThreaded(numProcessors);
                }
                catch (InterruptedException e) {
                    IOException ioe = new IOException(e.getMessage());
                    ioe.initCause(e);
                    throw ioe;
                }
                for (boolean b : reachable) {
                    if (!b) continue;
                    ++newNoOfObjects;
                }
            } else {
                try {
                    newNoOfObjects = marker.markSingleThreaded();
                }
                catch (IProgressListener.OperationCanceledException e) {
                    int[] len$ = null;
                    idx.delete();
                    if (idxManager != null && listener.isCanceled()) {
                        idxManager.delete();
                    }
                    return len$;
                }
            }
            marker = null;
            if (newNoOfObjects < oldNoOfObjects && (un = idx.getSnapshotInfo().getProperty("keep_unreachable_objects")) instanceof Integer) {
                int newRoot = (Integer)un;
                GarbageCleaner.markUnreachbleAsGCRoots(idx, reachable, newNoOfObjects, newRoot, listener);
                newNoOfObjects = oldNoOfObjects;
            }
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
            listener.subTask(Messages.GarbageCleaner_ReIndexingObjects.pattern);
            final int[] map = new int[oldNoOfObjects];
            long[] id2a = new long[newNoOfObjects];
            ArrayList<ClassImpl> classes2remove = new ArrayList<ClassImpl>();
            final IIndexReader.IOne2OneIndex preA2size = idx.array2size;
            int jj = 0;
            for (int ii = 0; ii < oldNoOfObjects; ++ii) {
                if (reachable[ii]) {
                    map[ii] = jj;
                    id2a[jj++] = identifiers.get(ii);
                    continue;
                }
                map[ii] = -1;
                int classId = object2classId.get(ii);
                ClassImpl clazz = classesById.get(classId);
                int arraySize = preA2size.get(ii);
                if (arraySize > 0) {
                    clazz.removeInstance(arraySize);
                    continue;
                }
                ClassImpl c = classesById.get(ii);
                if (c == null) {
                    clazz.removeInstance(clazz.getHeapSizePerInstance());
                    continue;
                }
                clazz.removeInstance(c.getUsedHeapSize());
                classes2remove.add(c);
            }
            for (ClassImpl c : classes2remove) {
                classesById.remove(c.getObjectId());
                ClassImpl superclass = classesById.get(c.getSuperClassId());
                if (superclass == null) continue;
                superclass.removeSubClass(c);
            }
            reachable = null;
            identifiers.close();
            identifiers.delete();
            identifiers = null;
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
            listener.subTask(Messages.GarbageCleaner_ReIndexingClasses.pattern);
            HashMapIntObject<ClassImpl> classesByNewId = new HashMapIntObject<ClassImpl>(classesById.size());
            Iterator<ClassImpl> iter = classesById.values();
            while (iter.hasNext()) {
                ClassImpl clazz = iter.next();
                int index = map[clazz.getObjectId()];
                clazz.setObjectId(index);
                if (clazz.getSuperClassId() >= 0) {
                    clazz.setSuperClassIndex(map[clazz.getSuperClassId()]);
                }
                clazz.setClassLoaderIndex(map[clazz.getClassLoaderId()]);
                classesByNewId.put(index, clazz);
            }
            idx.getSnapshotInfo().setNumberOfClasses(classesByNewId.size());
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
            File indexFile = IndexManager.Index.IDENTIFIER.getFile(idx.snapshotInfo.getPrefix());
            listener.subTask(MessageUtil.format(Messages.GarbageCleaner_Writing, indexFile.getAbsolutePath()));
            idxManager.setReader(IndexManager.Index.IDENTIFIER, new IndexWriter.LongIndexStreamer().writeTo(indexFile, id2a));
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
            indexFile = IndexManager.Index.O2CLASS.getFile(idx.snapshotInfo.getPrefix());
            listener.subTask(MessageUtil.format(Messages.GarbageCleaner_Writing, indexFile.getAbsolutePath()));
            idxManager.setReader(IndexManager.Index.O2CLASS, new IndexWriter.IntIndexStreamer().writeTo(indexFile, new NewObjectIntIterator(){

                @Override
                int doGetNextInt(int index) {
                    return map[idx.object2classId.get(this.nextIndex)];
                }

                @Override
                int[] getMap() {
                    return map;
                }
            }));
            object2classId.close();
            object2classId.delete();
            object2classId = null;
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
            indexFile = IndexManager.Index.A2SIZE.getFile(idx.snapshotInfo.getPrefix());
            listener.subTask(MessageUtil.format(Messages.GarbageCleaner_Writing, indexFile.getAbsolutePath()));
            final BitField arrayObjects = new BitField(newNoOfObjects);
            idxManager.setReader(IndexManager.Index.A2SIZE, new IndexWriter.IntIndexStreamer().writeTo(indexFile, new NewObjectIntIterator(){
                IIndexReader.IOne2OneIndex a2size;
                int newIndex;
                {
                    this.a2size = preA2size;
                    this.newIndex = 0;
                }

                @Override
                int doGetNextInt(int index) {
                    int size = this.a2size.get(this.nextIndex);
                    if (size > 0) {
                        arrayObjects.set(this.newIndex);
                    }
                    ++this.newIndex;
                    return size;
                }

                @Override
                int[] getMap() {
                    return map;
                }
            }));
            preA2size.close();
            preA2size.delete();
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
            listener.subTask(Messages.GarbageCleaner_ReIndexingOutboundIndex.pattern);
            IndexWriter.IntArray1NSortedWriter w_out = new IndexWriter.IntArray1NSortedWriter(newNoOfObjects, IndexManager.Index.OUTBOUND.getFile(idx.snapshotInfo.getPrefix()));
            IndexWriter.InboundWriter w_in = new IndexWriter.InboundWriter(newNoOfObjects, IndexManager.Index.INBOUND.getFile(idx.snapshotInfo.getPrefix()));
            for (int ii = 0; ii < oldNoOfObjects; ++ii) {
                int k = map[ii];
                if (k < 0) continue;
                int[] a = preOutbound.get(ii);
                int[] tl = new int[a.length];
                for (int jj2 = 0; jj2 < a.length; ++jj2) {
                    int t;
                    tl[jj2] = t = map[a[jj2]];
                    w_in.log(t, k, jj2 == 0);
                }
                w_out.log(k, tl);
            }
            preOutbound.close();
            preOutbound.delete();
            preOutbound = null;
            if (listener.isCanceled()) {
                w_in.cancel();
                w_out.cancel();
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
            listener.subTask(MessageUtil.format(Messages.GarbageCleaner_Writing, w_in.getIndexFile().getAbsolutePath()));
            idxManager.setReader(IndexManager.Index.INBOUND, w_in.flush(listener, new KeyWriterImpl(classesByNewId)));
            w_in = null;
            if (listener.isCanceled()) {
                w_out.cancel();
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
            listener.subTask(MessageUtil.format(Messages.GarbageCleaner_Writing, w_out.getIndexFile().getAbsolutePath()));
            idxManager.setReader(IndexManager.Index.OUTBOUND, w_out.flush());
            w_out = null;
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
            HashMapIntObject<XGCRootInfo[]> roots = GarbageCleaner.fix(idx.gcRoots, map);
            idx.getSnapshotInfo().setNumberOfGCRoots(roots.size());
            HashMapIntObject<HashMapIntObject<XGCRootInfo[]>> rootsPerThread = new HashMapIntObject<HashMapIntObject<XGCRootInfo[]>>();
            IteratorInt iter2 = idx.thread2objects2roots.keys();
            while (iter2.hasNext()) {
                int threadId = iter2.next();
                int fixedThreadId = map[threadId];
                if (fixedThreadId < 0) continue;
                rootsPerThread.put(fixedThreadId, GarbageCleaner.fix(idx.thread2objects2roots.get(threadId), map));
            }
            builder.setIndexManager(idxManager);
            builder.setClassCache(classesByNewId);
            builder.setArrayObjects(arrayObjects);
            builder.setRoots(roots);
            builder.setRootsPerThread(rootsPerThread);
            int[] nArray = map;
            return nArray;
        }
        finally {
            idx.delete();
            if (idxManager != null && listener.isCanceled()) {
                idxManager.delete();
            }
        }
    }

    private static HashMapIntObject<XGCRootInfo[]> fix(HashMapIntObject<List<XGCRootInfo>> roots, int[] map) {
        HashMapIntObject<XGCRootInfo[]> answer = new HashMapIntObject<XGCRootInfo[]>(roots.size());
        Iterator<List<XGCRootInfo>> iter = roots.values();
        while (iter.hasNext()) {
            List<XGCRootInfo> r = iter.next();
            XGCRootInfo[] a = new XGCRootInfo[r.size()];
            for (int ii = 0; ii < a.length; ++ii) {
                a[ii] = r.get(ii);
                a[ii].setObjectId(map[a[ii].getObjectId()]);
                if (a[ii].getContextAddress() == 0L) continue;
                a[ii].setContextId(map[a[ii].getContextId()]);
            }
            answer.put(a[0].getObjectId(), a);
        }
        return answer;
    }

    private static void markUnreachbleAsGCRoots(PreliminaryIndexImpl idx, boolean[] reachable, int noReachableObjects, int extraRootType, IProgressListener listener) {
        int noOfObjects = reachable.length;
        IIndexReader.IOne2LongIndex identifiers = idx.identifiers;
        IIndexReader.IOne2ManyIndex preOutbound = idx.outbound;
        int[] root = new int[1];
        ObjectMarker marker = new ObjectMarker(root, reachable, preOutbound, new SilentProgressListener(listener));
        boolean[] inbounds = new boolean[noOfObjects];
        for (int ii = 0; ii < noOfObjects; ++ii) {
            if (reachable[ii]) continue;
            for (int out : preOutbound.get(ii)) {
                inbounds[out] = true;
            }
        }
        for (int pass = 0; pass < 2; ++pass) {
            for (int ii = 0; ii < noOfObjects && noReachableObjects < noOfObjects; ++ii) {
                if (reachable[ii] || pass != 1 && inbounds[ii]) continue;
                root[0] = ii;
                XGCRootInfo xgc = new XGCRootInfo(identifiers.get(ii), 0L, extraRootType);
                xgc.setObjectId(ii);
                ArrayList<XGCRootInfo> xgcs = new ArrayList<XGCRootInfo>(1);
                xgcs.add(xgc);
                idx.gcRoots.put(ii, xgcs);
                int marked = marker.markSingleThreaded();
                noReachableObjects += marked;
            }
        }
        idx.setGcRoots(idx.gcRoots);
        idx.getSnapshotInfo().setNumberOfGCRoots(idx.gcRoots.size());
    }

    private static class KeyWriterImpl
    implements IndexWriter.KeyWriter {
        HashMapIntObject<ClassImpl> classesByNewId;

        KeyWriterImpl(HashMapIntObject<ClassImpl> classesByNewId) {
            this.classesByNewId = classesByNewId;
        }

        @Override
        public void storeKey(int index, Serializable key) {
            ClassImpl impl = this.classesByNewId.get(index);
            impl.setCacheEntry(key);
        }
    }

    private static abstract class NewObjectIntIterator
    extends NewObjectIterator
    implements IteratorInt {
        private NewObjectIntIterator() {
        }

        @Override
        public int next() {
            int answer = this.doGetNextInt(this.nextIndex);
            this.findNext();
            return answer;
        }

        abstract int doGetNextInt(int var1);
    }

    private static abstract class NewObjectIterator {
        int nextIndex = -1;
        int[] $map = this.getMap();

        public NewObjectIterator() {
            this.findNext();
        }

        protected void findNext() {
            ++this.nextIndex;
            while (this.nextIndex < this.$map.length && this.$map[this.nextIndex] < 0) {
                ++this.nextIndex;
            }
        }

        public boolean hasNext() {
            return this.nextIndex < this.$map.length;
        }

        abstract int[] getMap();
    }
}

