/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.parser.IIndexBuilder;
import org.eclipse.mat.parser.internal.GarbageCleaner;
import org.eclipse.mat.parser.internal.PreliminaryIndexImpl;
import org.eclipse.mat.parser.internal.SnapshotImpl;
import org.eclipse.mat.parser.internal.SnapshotImplBuilder;
import org.eclipse.mat.parser.internal.util.ParserRegistry;
import org.eclipse.mat.parser.model.XSnapshotInfo;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

public class SnapshotFactory {
    private Map<File, SnapshotEntry> snapshotCache = new HashMap<File, SnapshotEntry>();

    public ISnapshot openSnapshot(File file, Map<String, String> args, IProgressListener listener) throws SnapshotException {
        ISnapshot answer = null;
        SnapshotEntry entry = this.snapshotCache.get(file);
        if (entry != null && (answer = (ISnapshot)entry.snapshot.get()) != null) {
            entry.usageCount++;
            return answer;
        }
        String name = file.getAbsolutePath();
        int p = name.lastIndexOf(46);
        String prefix = p >= 0 ? name.substring(0, p + 1) : name + ".";
        this.deleteIndexFiles(file);
        answer = this.parse(file, prefix, args, listener);
        entry = new SnapshotEntry(1, answer);
        this.snapshotCache.put(file, entry);
        return answer;
    }

    private ISnapshot parse(File file, String prefix, Map<String, String> args, IProgressListener listener) throws SnapshotException {
        List<ParserRegistry.Parser> parsers = ParserRegistry.matchParser(file.getName());
        if (parsers.isEmpty()) {
            parsers.addAll(ParserRegistry.allParsers());
        }
        ArrayList<IOException> errors = new ArrayList<IOException>();
        for (ParserRegistry.Parser parser : parsers) {
            IIndexBuilder indexBuilder = parser.getIndexBuilder();
            if (indexBuilder == null) continue;
            try {
                indexBuilder.init(file, prefix);
                XSnapshotInfo snapshotInfo = new XSnapshotInfo();
                snapshotInfo.setPath(file.getAbsolutePath());
                snapshotInfo.setPrefix(prefix);
                snapshotInfo.setProperty("$heapFormat", (Serializable)((Object)parser.getId()));
                if (Boolean.parseBoolean(args.get("keep_unreachable_objects"))) {
                    snapshotInfo.setProperty("keep_unreachable_objects", Integer.valueOf(2048));
                }
                PreliminaryIndexImpl idx = new PreliminaryIndexImpl(snapshotInfo);
                indexBuilder.fill(idx, listener);
                SnapshotImplBuilder builder = new SnapshotImplBuilder(idx.getSnapshotInfo());
                int[] purgedMapping = GarbageCleaner.clean(idx, builder, args, listener);
                indexBuilder.clean(purgedMapping, listener);
                SnapshotImpl snapshot = builder.create(parser);
                snapshot.calculateDominatorTree(listener);
                return snapshot;
            }
            catch (IOException ioe) {
                errors.add(ioe);
                indexBuilder.cancel();
            }
            catch (Exception e) {
                indexBuilder.cancel();
                throw SnapshotException.rethrow(e);
            }
        }
        throw new SnapshotException(MessageUtil.format(Messages.SnapshotFactoryImpl_Error_NoParserRegistered, file.getName()));
    }

    private void deleteIndexFiles(File file) {
        Pattern logPattern;
        Pattern indexPattern;
        String filename;
        int p;
        String fragment;
        File[] files;
        File directory = file.getParentFile();
        if (directory == null) {
            directory = new File(".");
        }
        if ((files = directory.listFiles(new FileFilter(fragment = (p = (filename = file.getName()).lastIndexOf(46)) >= 0 ? filename.substring(0, p) : filename, indexPattern = Pattern.compile("\\.(.*\\.)?index$"), logPattern = Pattern.compile("\\.inbound\\.index.*\\.log$")){
            final /* synthetic */ String val$fragment;
            final /* synthetic */ Pattern val$indexPattern;
            final /* synthetic */ Pattern val$logPattern;
            {
                this.val$fragment = string2;
                this.val$indexPattern = pattern;
                this.val$logPattern = pattern2;
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return false;
                }
                String name = f.getName();
                return name.startsWith(this.val$fragment) && (this.val$indexPattern.matcher(name).matches() || this.val$logPattern.matcher(name).matches());
            }
        })) != null) {
            for (File f : files) {
                f.delete();
            }
        }
    }

    private static class SnapshotEntry {
        private int usageCount;
        private WeakReference<ISnapshot> snapshot;

        public SnapshotEntry(int usageCount, ISnapshot snapshot) {
            this.usageCount = usageCount;
            this.snapshot = new WeakReference<ISnapshot>(snapshot);
        }
    }
}

