/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.parser.IObjectReader;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.index.IndexManager;
import org.eclipse.mat.parser.internal.DominatorTree;
import org.eclipse.mat.parser.internal.snapshot.ObjectCache;
import org.eclipse.mat.parser.internal.snapshot.PathsFromGCRootsTreeBuilder;
import org.eclipse.mat.parser.internal.snapshot.RetainedSizeCache;
import org.eclipse.mat.parser.internal.util.IntStack;
import org.eclipse.mat.parser.model.AbstractObjectImpl;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.parser.model.ClassLoaderImpl;
import org.eclipse.mat.parser.model.InstanceImpl;
import org.eclipse.mat.parser.model.XGCRootInfo;
import org.eclipse.mat.parser.model.XSnapshotInfo;
import org.eclipse.mat.snapshot.IPathsFromGCRootsComputer;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.PathsFromGCRootsTree;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

public final class SnapshotImpl
implements ISnapshot {
    private XSnapshotInfo snapshotInfo;
    private HashMapIntObject<ClassImpl> classCache;
    private HashMapIntObject<XGCRootInfo[]> roots;
    private HashMapIntObject<HashMapIntObject<XGCRootInfo[]>> rootsPerThread;
    private HashMapIntObject<String> loaderLabels;
    private BitField arrayObjects;
    private IndexManager indexManager;
    private RetainedSizeCache retainedSizeCache;
    private IObjectReader heapObjectReader;
    private boolean dominatorTreeCalculated;
    private Map<String, List<IClass>> classCacheByName;
    private ObjectCache<IObject> objectCache;
    private boolean parsedThreads = false;

    public static SnapshotImpl create(XSnapshotInfo snapshotInfo, IObjectReader heapObjectReader, HashMapIntObject<ClassImpl> classCache, HashMapIntObject<XGCRootInfo[]> roots, HashMapIntObject<HashMapIntObject<XGCRootInfo[]>> rootsPerThread, BitField arrayObjects, IndexManager indexManager) throws IOException, SnapshotException {
        SnapshotImpl answer = new SnapshotImpl(snapshotInfo, heapObjectReader, classCache, roots, rootsPerThread, null, arrayObjects, indexManager);
        answer.calculateLoaderLabels();
        return answer;
    }

    private SnapshotImpl(XSnapshotInfo snapshotInfo, IObjectReader heapObjectReader, HashMapIntObject<ClassImpl> classCache, HashMapIntObject<XGCRootInfo[]> roots, HashMapIntObject<HashMapIntObject<XGCRootInfo[]>> rootsPerThread, HashMapIntObject<String> loaderLabels, BitField arrayObjects, IndexManager indexManager) throws SnapshotException, IOException {
        this.snapshotInfo = snapshotInfo;
        this.heapObjectReader = heapObjectReader;
        this.classCache = classCache;
        this.roots = roots;
        this.rootsPerThread = rootsPerThread;
        this.loaderLabels = loaderLabels;
        this.arrayObjects = arrayObjects;
        this.indexManager = indexManager;
        this.retainedSizeCache = new RetainedSizeCache(snapshotInfo);
        this.classCacheByName = new HashMap<String, List<IClass>>(this.classCache.size());
        Iterator<ClassImpl> iter = this.classCache.values();
        while (iter.hasNext()) {
            ClassImpl clasz = iter.next();
            clasz.setSnapshot(this);
            List<IClass> list = this.classCacheByName.get(clasz.getName());
            if (list == null) {
                list = new ArrayList<IClass>();
                this.classCacheByName.put(clasz.getName(), list);
            }
            list.add(clasz);
        }
        this.dominatorTreeCalculated = indexManager.dominated() != null && indexManager.o2retained() != null && indexManager.dominator() != null;
        this.objectCache = new HeapObjectCache(this, 1000);
        this.heapObjectReader.open(this);
    }

    private void calculateLoaderLabels() throws SnapshotException {
        this.loaderLabels = new HashMapIntObject();
        long usedHeapSize = 0L;
        int systemClassLoaderId = this.indexManager.o2address().reverse(0L);
        Object[] classes = this.classCache.getAllValues();
        for (int i = 0; i < classes.length; ++i) {
            ClassImpl clasz = (ClassImpl)classes[i];
            usedHeapSize += clasz.getTotalSize();
            int classLoaderId = clasz.getClassLoaderId();
            String label = this.loaderLabels.get(classLoaderId);
            if (label != null) continue;
            if (classLoaderId == systemClassLoaderId) {
                label = "<system class loader>";
            } else {
                IObject classLoader = this.getObject(classLoaderId);
                label = classLoader.getClassSpecificName();
                if (label == null) {
                    label = "__none__";
                }
            }
            this.loaderLabels.put(classLoaderId, label);
        }
        Collection<IClass> loaderClasses = this.getClassesByName("java.lang.ClassLoader", true);
        if (loaderClasses != null) {
            for (IClass clazz : loaderClasses) {
                for (int classLoaderId : clazz.getObjectIds()) {
                    String label = this.loaderLabels.get(classLoaderId);
                    if (label != null) continue;
                    if (classLoaderId == systemClassLoaderId) {
                        label = "<system class loader>";
                    } else {
                        IObject classLoader = this.getObject(classLoaderId);
                        label = classLoader.getClassSpecificName();
                        if (label == null) {
                            label = "__none__";
                        }
                    }
                    this.loaderLabels.put(classLoaderId, label);
                }
            }
        }
        this.snapshotInfo.setUsedHeapSize(usedHeapSize);
        this.snapshotInfo.setNumberOfObjects(this.indexManager.idx.size());
        this.snapshotInfo.setNumberOfClassLoaders(this.loaderLabels.size());
        this.snapshotInfo.setNumberOfGCRoots(this.roots.size());
        this.snapshotInfo.setNumberOfClasses(this.classCache.size());
        this.objectCache.clear();
    }

    @Override
    public XSnapshotInfo getSnapshotInfo() {
        return this.snapshotInfo;
    }

    public int[] getGCRoots() throws SnapshotException {
        return this.roots.getAllKeys();
    }

    @Override
    public Collection<IClass> getClassesByName(String name, boolean includeSubClasses) throws SnapshotException {
        List<IClass> list = this.classCacheByName.get(name);
        if (list == null) {
            return null;
        }
        if (!includeSubClasses) {
            return Collections.unmodifiableCollection(list);
        }
        HashSet<IClass> answer = new HashSet<IClass>();
        answer.addAll(list);
        for (IClass clazz : list) {
            answer.addAll(clazz.getAllSubclasses());
        }
        return answer;
    }

    @Override
    public IPathsFromGCRootsComputer getPathsFromGCRoots(int objectId, Map<IClass, Set<String>> excludeList) throws SnapshotException {
        return new PathsFromGCRootsComputerImpl(objectId, excludeList);
    }

    public void calculateDominatorTree(IProgressListener listener) throws SnapshotException, IProgressListener.OperationCanceledException {
        try {
            DominatorTree.calculate(this, listener);
            this.dominatorTreeCalculated = this.indexManager.dominated() != null && this.indexManager.o2retained() != null && this.indexManager.dominator() != null;
        }
        catch (IOException e) {
            throw new SnapshotException(e);
        }
    }

    @Override
    public IObject getObject(int objectId) throws SnapshotException {
        IObject answer = this.classCache.get(objectId);
        if (answer != null) {
            return answer;
        }
        return this.objectCache.get(objectId);
    }

    public GCRootInfo[] getGCRootInfo(int objectId) throws SnapshotException {
        return this.roots.get(objectId);
    }

    @Override
    public IClass getClassOf(int objectId) throws SnapshotException {
        if (this.isClass(objectId)) {
            return this.getObject(objectId).getClazz();
        }
        return (IClass)this.getObject(this.indexManager.o2class().get(objectId));
    }

    public long mapIdToAddress(int objectId) throws SnapshotException {
        return this.indexManager.o2address().get(objectId);
    }

    @Override
    public int getHeapSize(int objectId) throws SnapshotException {
        if (this.arrayObjects.get(objectId)) {
            return this.indexManager.a2size().get(objectId);
        }
        IClass clazz = this.classCache.get(objectId);
        if (clazz != null) {
            return clazz.getUsedHeapSize();
        }
        clazz = this.classCache.get(this.indexManager.o2class().get(objectId));
        return clazz.getHeapSizePerInstance();
    }

    public boolean isArray(int objectId) {
        if (this.arrayObjects.get(objectId)) {
            IClass clazz = this.classCache.get(this.indexManager.o2class().get(objectId));
            return clazz.isArrayType();
        }
        return false;
    }

    public boolean isClass(int objectId) {
        return this.classCache.containsKey(objectId);
    }

    @Override
    public int mapAddressToId(long objectAddress) throws SnapshotException {
        int objectId = this.indexManager.o2address().reverse(objectAddress);
        if (objectId < 0) {
            throw new SnapshotException(MessageUtil.format(Messages.SnapshotImpl_Error_ObjectNotFound, "0x" + Long.toHexString(objectAddress)));
        }
        return objectId;
    }

    @Override
    public void dispose() {
        IOException error = null;
        try {
            this.heapObjectReader.close();
        }
        catch (IOException e1) {
            error = e1;
        }
        try {
            this.indexManager.close();
        }
        catch (IOException e1) {
            error = e1;
        }
        this.retainedSizeCache.close();
        if (error != null) {
            throw new RuntimeException(error);
        }
    }

    @Override
    public boolean isClassLoader(int objectId) {
        return this.loaderLabels.containsKey(objectId);
    }

    public String getClassLoaderLabel(int objectId) {
        return this.loaderLabels.get(objectId);
    }

    public void setClassLoaderLabel(int objectId, String label) {
        if (label == null) {
            throw new NullPointerException(Messages.SnapshotImpl_Label.pattern);
        }
        String old = this.loaderLabels.put(objectId, label);
        if (old == null) {
            throw new RuntimeException(Messages.SnapshotImpl_Error_ReplacingNonExistentClassLoader.pattern);
        }
    }

    public IndexManager getIndexManager() {
        return this.indexManager;
    }

    public IObjectReader getHeapObjectReader() {
        return this.heapObjectReader;
    }

    public HashMapIntObject<HashMapIntObject<XGCRootInfo[]>> getRootsPerThread() {
        return this.rootsPerThread;
    }

    private static final class HeapObjectCache
    extends ObjectCache<IObject> {
        SnapshotImpl snapshot;

        private HeapObjectCache(SnapshotImpl snapshot, int maxSize) {
            super(maxSize);
            this.snapshot = snapshot;
        }

        @Override
        protected IObject load(int objectId) {
            try {
                IObject answer = null;
                if (this.snapshot.isArray(objectId)) {
                    answer = this.snapshot.heapObjectReader.read(objectId, this.snapshot);
                } else {
                    ClassImpl classImpl = (ClassImpl)this.snapshot.getObject(this.snapshot.indexManager.o2class().get(objectId));
                    answer = this.snapshot.isClassLoader(objectId) ? new ClassLoaderImpl(objectId, Long.MIN_VALUE, classImpl, null) : new InstanceImpl(objectId, Long.MIN_VALUE, classImpl, null);
                }
                ((AbstractObjectImpl)answer).setSnapshot(this.snapshot);
                return answer;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SnapshotException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class PathsFromGCRootsComputerImpl
    implements IPathsFromGCRootsComputer {
        private int state;
        private int nextState;
        int objectId;
        LinkedList<Path> fifo = new LinkedList();
        BitField visited = new BitField(SnapshotImpl.access$100(SnapshotImpl.this).o2address().size());
        BitField excludeInstances;
        IIndexReader.IOne2ManyIndex inboundIndex;
        int currentId;
        Path currentPath;
        int[] currentReferrers;
        int lastReadReferrer;
        int[] referringThreads;
        int currentReferringThread;
        int[] foundPath;
        Map<IClass, Set<String>> excludeMap;

        public PathsFromGCRootsComputerImpl(int objectId, Map<IClass, Set<String>> excludeMap) throws SnapshotException {
            this.objectId = objectId;
            this.excludeMap = excludeMap;
            this.inboundIndex = SnapshotImpl.this.indexManager.inbound();
            if (excludeMap != null) {
                this.initExcludeInstances();
            }
            this.currentId = objectId;
            this.visited.set(objectId);
            if (SnapshotImpl.this.roots.get(objectId) == null) {
                this.fifo.add(new Path(objectId, null));
            }
        }

        private void initExcludeInstances() throws SnapshotException {
            this.excludeInstances = new BitField(SnapshotImpl.this.indexManager.o2address().size());
            for (IClass clazz : this.excludeMap.keySet()) {
                int[] objects;
                for (int objId : objects = clazz.getObjectIds()) {
                    this.excludeInstances.set(objId);
                }
            }
        }

        private boolean refersOnlyThroughExcluded(int referrerId, int referentId) throws SnapshotException {
            if (!this.excludeInstances.get(referrerId)) {
                return false;
            }
            IObject referrerObject = SnapshotImpl.this.getObject(referrerId);
            Set<String> excludeFields = this.excludeMap.get(referrerObject.getClazz());
            if (excludeFields == null) {
                return true;
            }
            long referentAddr = SnapshotImpl.this.mapIdToAddress(referentId);
            List<NamedReference> refs = referrerObject.getOutboundReferences();
            for (NamedReference reference : refs) {
                if (referentAddr != reference.getObjectAddress() || excludeFields.contains(reference.getName())) continue;
                return false;
            }
            return true;
        }

        @Override
        public int[] getNextShortestPath() throws SnapshotException {
            switch (this.state) {
                case 0: {
                    if (SnapshotImpl.this.roots.containsKey(this.currentId)) {
                        this.referringThreads = null;
                        this.state = 2;
                        this.nextState = 1;
                        this.foundPath = new int[]{this.currentId};
                        return this.getNextShortestPath();
                    }
                    this.state = 3;
                    return this.getNextShortestPath();
                }
                case 1: {
                    return null;
                }
                case 2: {
                    if (this.referringThreads == null) {
                        this.referringThreads = this.getReferringTreads(SnapshotImpl.this.getGCRootInfo(this.foundPath[this.foundPath.length - 1]));
                        this.currentReferringThread = 0;
                        if (this.referringThreads.length == 0) {
                            this.state = this.nextState;
                            return this.foundPath;
                        }
                    }
                    if (this.currentReferringThread < this.referringThreads.length) {
                        int[] result = new int[this.foundPath.length + 1];
                        System.arraycopy(this.foundPath, 0, result, 0, this.foundPath.length);
                        result[result.length - 1] = this.referringThreads[this.currentReferringThread];
                        ++this.currentReferringThread;
                        return result;
                    }
                    this.state = this.nextState;
                    return this.getNextShortestPath();
                }
                case 3: {
                    int[] res;
                    if (this.currentReferrers != null && (res = this.processCurrentReferrefs(this.lastReadReferrer + 1)) != null) {
                        return res;
                    }
                    while (this.fifo.size() > 0) {
                        this.currentPath = this.fifo.getFirst();
                        this.fifo.removeFirst();
                        this.currentId = this.currentPath.getIndex();
                        this.currentReferrers = this.inboundIndex.get(this.currentId);
                        if (this.currentReferrers == null || (res = this.processCurrentReferrefs(0)) == null) continue;
                        return res;
                    }
                    return null;
                }
            }
            throw new RuntimeException(Messages.SnapshotImpl_Error_UnrecognizedState.pattern + this.state);
        }

        private int[] getReferringTreads(GCRootInfo[] rootInfos) {
            SetInt threads = new SetInt();
            for (GCRootInfo info : rootInfos) {
                if (info.getContextAddress() == 0L || info.getObjectAddress() == info.getContextAddress()) continue;
                threads.add(info.getContextId());
            }
            return threads.toArray();
        }

        @Override
        public PathsFromGCRootsTree getTree(Collection<int[]> paths) {
            PathsFromGCRootsTreeBuilder rootBuilder = new PathsFromGCRootsTreeBuilder(this.objectId);
            for (int[] path : paths) {
                PathsFromGCRootsTreeBuilder current = rootBuilder;
                for (int k = 1; k < path.length; ++k) {
                    int childId = path[k];
                    PathsFromGCRootsTreeBuilder child = current.getObjectReferers().get(childId);
                    if (child == null) {
                        child = new PathsFromGCRootsTreeBuilder(childId);
                        current.addObjectReferer(child);
                    }
                    current = child;
                }
            }
            return rootBuilder.toPathsFromGCRootsTree();
        }

        private int[] path2Int(Path p) {
            IntStack s = new IntStack();
            while (p != null) {
                s.push(p.getIndex());
                p = p.getNext();
            }
            int[] res = new int[s.size()];
            for (int i = 0; i < res.length; ++i) {
                res[i] = s.pop();
            }
            return res;
        }

        private int[] processCurrentReferrefs(int fromIndex) throws SnapshotException {
            GCRootInfo[] rootInfo = null;
            for (int i = fromIndex; i < this.currentReferrers.length; ++i) {
                rootInfo = (GCRootInfo[])SnapshotImpl.this.roots.get(this.currentReferrers[i]);
                if (rootInfo == null) continue;
                if (this.excludeMap == null) {
                    this.lastReadReferrer = i;
                    Path p = new Path(this.currentReferrers[i], this.currentPath);
                    this.referringThreads = null;
                    this.state = 2;
                    this.nextState = 3;
                    this.foundPath = this.path2Int(p);
                    return this.getNextShortestPath();
                }
                if (this.refersOnlyThroughExcluded(this.currentReferrers[i], this.currentId)) continue;
                this.lastReadReferrer = i;
                Path p = new Path(this.currentReferrers[i], this.currentPath);
                this.referringThreads = null;
                this.state = 2;
                this.nextState = 3;
                this.foundPath = this.path2Int(p);
                return this.getNextShortestPath();
            }
            for (int referrer : this.currentReferrers) {
                if (referrer < 0 || this.visited.get(referrer) || SnapshotImpl.this.roots.containsKey(referrer)) continue;
                if (this.excludeMap == null) {
                    this.fifo.add(new Path(referrer, this.currentPath));
                    this.visited.set(referrer);
                    continue;
                }
                if (this.refersOnlyThroughExcluded(referrer, this.currentId)) continue;
                this.fifo.add(new Path(referrer, this.currentPath));
                this.visited.set(referrer);
            }
            return null;
        }
    }

    private static class Path {
        int index;
        Path next;

        public Path(int index, Path next) {
            this.index = index;
            this.next = next;
        }

        public Path getNext() {
            return this.next;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

