/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.snapshot;

import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.internal.util.IntStack;
import org.eclipse.mat.util.IProgressListener;

public class ObjectMarker {
    int[] roots;
    boolean[] bits;
    IIndexReader.IOne2ManyIndex outbound;
    IProgressListener progressListener;

    public ObjectMarker(int[] roots, boolean[] bits, IIndexReader.IOne2ManyIndex outbound, IProgressListener progressListener) {
        this.roots = roots;
        this.bits = bits;
        this.outbound = outbound;
        this.progressListener = progressListener;
    }

    public int markSingleThreaded() throws IProgressListener.OperationCanceledException {
        int count = 0;
        int size = 0;
        int[] data = new int[10240];
        int rootsToProcess = 0;
        for (int rootId : this.roots) {
            if (this.bits[rootId]) continue;
            if (size == data.length) {
                int[] newArr = new int[data.length << 1];
                System.arraycopy(data, 0, newArr, 0, data.length);
                data = newArr;
            }
            data[size++] = rootId;
            this.bits[rootId] = true;
            ++count;
            ++rootsToProcess;
        }
        this.progressListener.beginTask(Messages.ObjectMarker_CalculateRetainedSize, rootsToProcess);
        while (size > 0) {
            int current = data[--size];
            if (size <= rootsToProcess) {
                --rootsToProcess;
                this.progressListener.worked(1);
                if (this.progressListener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
            }
            for (int child : this.outbound.get(current)) {
                if (this.bits[child]) continue;
                if (size == data.length) {
                    int[] newArr = new int[data.length << 1];
                    System.arraycopy(data, 0, newArr, 0, data.length);
                    data = newArr;
                }
                data[size++] = child;
                this.bits[child] = true;
                ++count;
            }
        }
        this.progressListener.done();
        return count;
    }

    public void markMultiThreaded(int numberOfThreads) throws InterruptedException {
        int i;
        IntStack rootsStack = new IntStack(this.roots.length);
        for (int rootId : this.roots) {
            if (this.bits[rootId]) continue;
            rootsStack.push(rootId);
            this.bits[rootId] = true;
        }
        this.progressListener.beginTask(Messages.ObjectMarker_CalculateRetainedSize, rootsStack.size());
        DfsThread[] dfsthreads = new DfsThread[numberOfThreads];
        Thread[] threads = new Thread[numberOfThreads];
        for (i = 0; i < numberOfThreads; ++i) {
            DfsThread dfsthread;
            dfsthreads[i] = dfsthread = new DfsThread(rootsStack);
            Thread thread = new Thread((Runnable)dfsthread, "ObjectMarkerThread-" + (i + 1));
            thread.start();
            threads[i] = thread;
        }
        for (i = 0; i < numberOfThreads; ++i) {
            threads[i].join();
        }
        if (this.progressListener.isCanceled()) {
            return;
        }
        this.progressListener.done();
    }

    public class DfsThread
    implements Runnable {
        int size = 0;
        int[] data = new int[10240];
        IntStack rootsStack;

        public DfsThread(IntStack roots) {
            this.rootsStack = roots;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[DOLOOP]], but top level block is 5[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

