/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.model;

import java.io.Serializable;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.parser.internal.SnapshotImpl;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.snapshot.registry.ClassSpecificNameResolverRegistry;
import org.eclipse.mat.util.MessageUtil;

public abstract class AbstractObjectImpl
implements Serializable,
IObject {
    protected transient SnapshotImpl source;
    protected ClassImpl classInstance;
    private long address;
    private int objectId;

    public AbstractObjectImpl(int objectId, long address, ClassImpl classInstance) {
        this.objectId = objectId;
        this.address = address;
        this.classInstance = classInstance;
    }

    @Override
    public long getObjectAddress() {
        return this.address;
    }

    @Override
    public int getObjectId() {
        return this.objectId;
    }

    public void setObjectAddress(long address) {
        this.address = address;
    }

    public void setObjectId(int objectId) {
        this.objectId = objectId;
    }

    @Override
    public ClassImpl getClazz() {
        return this.classInstance;
    }

    public void setClassInstance(ClassImpl classInstance) {
        this.classInstance = classInstance;
    }

    public void setSnapshot(ISnapshot dump) {
        this.source = (SnapshotImpl)dump;
    }

    @Override
    public ISnapshot getSnapshot() {
        return this.source;
    }

    public String toString() {
        StringBuffer s = new StringBuffer(256);
        s.append(this.getClazz().getName());
        s.append(" [");
        this.appendFields(s);
        s.append("]");
        return s.toString();
    }

    protected StringBuffer appendFields(StringBuffer buf) {
        return buf.append("id=0x").append(Long.toHexString(this.getObjectAddress()));
    }

    @Override
    public String getClassSpecificName() {
        return ClassSpecificNameResolverRegistry.resolve(this);
    }

    @Override
    public String getTechnicalName() {
        StringBuilder builder = new StringBuilder(256);
        builder.append(this.getClazz().getName());
        builder.append(" @ 0x");
        builder.append(Long.toHexString(this.getObjectAddress()));
        return builder.toString();
    }

    @Override
    public final Object resolveValue(String name) throws SnapshotException {
        int p = name.indexOf(46);
        String n = p < 0 ? name : name.substring(0, p);
        Field f = this.internalGetField(n);
        if (f == null || f.getValue() == null) {
            return null;
        }
        if (p < 0) {
            Object answer = f.getValue();
            if (answer instanceof ObjectReference) {
                answer = ((ObjectReference)answer).getObject();
            }
            return answer;
        }
        if (!(f.getValue() instanceof ObjectReference)) {
            String msg = MessageUtil.format(Messages.AbstractObjectImpl_Error_FieldIsNotReference, n, this.getTechnicalName(), name.substring(p + 1));
            throw new SnapshotException(msg);
        }
        ObjectReference ref = (ObjectReference)f.getValue();
        if (ref == null) {
            return null;
        }
        int objectId = ref.getObjectId();
        if (objectId < 0) {
            String msg = MessageUtil.format(Messages.AbstractObjectImpl_Error_FieldContainsIllegalReference, n, this.getTechnicalName(), Long.toHexString(ref.getObjectAddress()));
            throw new SnapshotException(msg);
        }
        return this.source.getObject(objectId).resolveValue(name.substring(p + 1));
    }

    protected abstract Field internalGetField(String var1);

    public boolean equals(Object obj) {
        return obj instanceof IObject && this.objectId == ((IObject)obj).getObjectId();
    }

    public int hashCode() {
        return this.objectId;
    }

    protected static int alignUpTo8(int n) {
        return n % 8 == 0 ? n : n + 8 - n % 8;
    }
}

