/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayLong;
import org.eclipse.mat.parser.model.AbstractObjectImpl;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.FieldDescriptor;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.snapshot.model.PseudoReference;

public class ClassImpl
extends AbstractObjectImpl
implements Comparable<ClassImpl>,
IClass {
    protected String name;
    protected int superClassId = -1;
    protected long superClassAddress;
    protected int classLoaderId = -1;
    protected long classLoaderAddress;
    protected Field[] staticFields;
    protected FieldDescriptor[] fields;
    protected int usedHeapSize;
    protected int instanceSize;
    protected int instanceCount;
    protected long totalSize;
    protected boolean isArrayType;
    private List<IClass> subClasses;
    private Serializable cacheEntry;

    public ClassImpl(long address, String name, long superId, long loaderId, Field[] staticFields, FieldDescriptor[] fields) {
        super(-1, address, null);
        this.name = name;
        this.superClassAddress = superId;
        this.classLoaderAddress = loaderId;
        this.staticFields = staticFields;
        this.fields = fields;
        this.instanceSize = -1;
        this.totalSize = 0L;
        this.isArrayType = name.endsWith("[]");
    }

    public void setCacheEntry(Serializable cacheEntry) {
        this.cacheEntry = cacheEntry;
    }

    public void setSuperClassIndex(int superClassIndex) {
        this.superClassId = superClassIndex;
    }

    public void setClassLoaderIndex(int classLoaderIndex) {
        this.classLoaderId = classLoaderIndex;
    }

    @Override
    public int[] getObjectIds() throws UnsupportedOperationException, SnapshotException {
        try {
            return this.source.getIndexManager().c2objects().getObjectsOf(this.cacheEntry);
        }
        catch (IOException e) {
            throw new SnapshotException(e);
        }
    }

    @Override
    public int getUsedHeapSize() {
        return this.usedHeapSize;
    }

    public ArrayLong getReferences() {
        ArrayLong answer = new ArrayLong(this.staticFields.length);
        answer.add(this.classInstance.getObjectAddress());
        if (this.superClassAddress != 0L) {
            answer.add(this.superClassAddress);
        }
        answer.add(this.classLoaderAddress);
        for (int ii = 0; ii < this.staticFields.length; ++ii) {
            if (!(this.staticFields[ii].getValue() instanceof ObjectReference)) continue;
            ObjectReference ref = (ObjectReference)this.staticFields[ii].getValue();
            answer.add(ref.getObjectAddress());
        }
        return answer;
    }

    @Override
    public List<NamedReference> getOutboundReferences() {
        LinkedList<NamedReference> answer = new LinkedList<NamedReference>();
        answer.add(new PseudoReference(this.source, this.classInstance.getObjectAddress(), "<class>"));
        if (this.superClassAddress != 0L) {
            answer.add(new PseudoReference(this.source, this.superClassAddress, "<super>"));
        }
        answer.add(new PseudoReference(this.source, this.classLoaderAddress, "<classloader>"));
        for (int ii = 0; ii < this.staticFields.length; ++ii) {
            if (!(this.staticFields[ii].getValue() instanceof ObjectReference)) continue;
            ObjectReference ref = (ObjectReference)this.staticFields[ii].getValue();
            String fieldName = this.staticFields[ii].getName();
            if (fieldName.startsWith("<")) {
                answer.add(new PseudoReference(this.source, ref.getObjectAddress(), fieldName));
                continue;
            }
            answer.add(new NamedReference(this.source, ref.getObjectAddress(), fieldName));
        }
        return answer;
    }

    public long getClassLoaderAddress() {
        return this.classLoaderAddress;
    }

    public void setClassLoaderAddress(long address) {
        this.classLoaderAddress = address;
    }

    @Override
    public List<FieldDescriptor> getFieldDescriptors() {
        return Arrays.asList(this.fields);
    }

    @Override
    public int getHeapSizePerInstance() {
        return this.instanceSize;
    }

    public void setHeapSizePerInstance(int size) {
        this.instanceSize = size;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Field> getStaticFields() {
        return Arrays.asList(this.staticFields);
    }

    public long getSuperClassAddress() {
        return this.superClassAddress;
    }

    @Override
    public int getSuperClassId() {
        return this.superClassId;
    }

    @Override
    public ClassImpl getSuperClass() {
        try {
            return this.superClassAddress != 0L ? (ClassImpl)this.source.getObject(this.superClassId) : null;
        }
        catch (SnapshotException e) {
            throw new RuntimeException(e);
        }
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    @Override
    public boolean hasSuperClass() {
        return this.superClassAddress != 0L;
    }

    @Override
    public int compareTo(ClassImpl other) {
        long otherAddress;
        long myAddress = this.getObjectAddress();
        return myAddress > (otherAddress = other.getObjectAddress()) ? 1 : (myAddress == otherAddress ? 0 : -1);
    }

    public void addInstance(int usedHeapSize) {
        ++this.instanceCount;
        this.totalSize += (long)usedHeapSize;
    }

    public void removeInstance(int heapSizePerInstance) {
        --this.instanceCount;
        this.totalSize -= (long)heapSizePerInstance;
    }

    @Override
    public List<IClass> getAllSubclasses() {
        if (this.subClasses == null || this.subClasses.isEmpty()) {
            return new ArrayList<IClass>();
        }
        ArrayList<IClass> answer = new ArrayList<IClass>(this.subClasses.size() * 2);
        answer.addAll(this.subClasses);
        for (IClass subClass : this.subClasses) {
            answer.addAll(subClass.getAllSubclasses());
        }
        return answer;
    }

    @Override
    protected StringBuffer appendFields(StringBuffer buf) {
        return super.appendFields(buf).append(";name=").append(this.getName());
    }

    @Override
    public boolean isArrayType() {
        return this.isArrayType;
    }

    @Override
    public String getTechnicalName() {
        StringBuilder builder = new StringBuilder(256);
        builder.append("class ");
        builder.append(this.getName());
        builder.append(" @ 0x");
        builder.append(Long.toHexString(this.getObjectAddress()));
        return builder.toString();
    }

    @Override
    protected Field internalGetField(String name) {
        for (Field f : this.staticFields) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public int getClassLoaderId() {
        return this.classLoaderId;
    }

    public void addSubClass(ClassImpl clazz) {
        if (this.subClasses == null) {
            this.subClasses = new ArrayList<IClass>();
        }
        this.subClasses.add(clazz);
    }

    public void removeSubClass(ClassImpl clazz) {
        this.subClasses.remove(clazz);
    }

    public void setUsedHeapSize(int usedHeapSize) {
        this.usedHeapSize = usedHeapSize;
    }

    @Override
    public boolean doesExtend(String className) throws SnapshotException {
        if (className.equals(this.name)) {
            return true;
        }
        return this.hasSuperClass() && this.source != null ? ((ClassImpl)this.source.getObject(this.superClassId)).doesExtend(className) : false;
    }

    @Override
    public void setSnapshot(ISnapshot dump) {
        super.setSnapshot(dump);
        for (Field f : this.staticFields) {
            if (!(f.getValue() instanceof ObjectReference)) continue;
            ObjectReference ref = (ObjectReference)f.getValue();
            f.setValue(new ObjectReference(dump, ref.getObjectAddress()));
        }
    }
}

