/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.collect.IteratorInt;
import org.eclipse.mat.parser.model.AbstractObjectImpl;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.parser.model.XGCRootInfo;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.snapshot.model.PseudoReference;
import org.eclipse.mat.snapshot.model.ThreadToLocalReference;

public class InstanceImpl
extends AbstractObjectImpl
implements IInstance {
    private volatile List<Field> fields;
    private volatile Map<String, Field> name2field;

    public InstanceImpl(int objectId, long address, ClassImpl clazz, List<Field> fields) {
        super(objectId, address, clazz);
        this.fields = fields;
    }

    @Override
    public long getObjectAddress() {
        try {
            long address = super.getObjectAddress();
            if (address == Long.MIN_VALUE) {
                address = this.source.mapIdToAddress(this.getObjectId());
                this.setObjectAddress(address);
            }
            return address;
        }
        catch (SnapshotException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getObjectId() {
        try {
            int objectId = super.getObjectId();
            if (objectId < 0) {
                objectId = this.source.mapAddressToId(this.getObjectAddress());
                this.setObjectId(objectId);
            }
            return objectId;
        }
        catch (SnapshotException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Field> getFields() {
        if (this.fields == null) {
            this.readFully();
        }
        return this.fields;
    }

    protected void setFields(List<Field> fields) {
        this.fields = fields;
    }

    protected synchronized void readFully() {
        if (this.fields != null) {
            return;
        }
        try {
            int objectId = this.getObjectId();
            InstanceImpl fullCopy = (InstanceImpl)this.source.getHeapObjectReader().read(objectId, this.source);
            this.setObjectAddress(fullCopy.getObjectAddress());
            this.fields = fullCopy.fields;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SnapshotException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getUsedHeapSize() {
        try {
            return this.getSnapshot().getHeapSize(this.getObjectId());
        }
        catch (SnapshotException e) {
            return this.classInstance.getHeapSizePerInstance();
        }
    }

    @Override
    public List<NamedReference> getOutboundReferences() {
        HashMapIntObject<XGCRootInfo[]> localVars;
        ArrayList<NamedReference> list = new ArrayList<NamedReference>();
        list.add(new PseudoReference(this.source, this.classInstance.getObjectAddress(), "<class>"));
        HashMapIntObject<HashMapIntObject<XGCRootInfo[]>> threadToLocalVars = this.source.getRootsPerThread();
        if (threadToLocalVars != null && (localVars = threadToLocalVars.get(this.getObjectId())) != null) {
            IteratorInt localsIds = localVars.keys();
            while (localsIds.hasNext()) {
                int localId = localsIds.next();
                GCRootInfo[] rootInfo = localVars.get(localId);
                ThreadToLocalReference ref = new ThreadToLocalReference(this.source, rootInfo[0].getObjectAddress(), "<" + GCRootInfo.getTypeSetAsString(rootInfo) + ">", localId, rootInfo);
                list.add(ref);
            }
        }
        for (Field field : this.getFields()) {
            if (!(field.getValue() instanceof ObjectReference)) continue;
            ObjectReference ref = (ObjectReference)field.getValue();
            list.add(new NamedReference(this.source, ref.getObjectAddress(), field.getName()));
        }
        return list;
    }

    @Override
    protected Field internalGetField(String name) {
        if (this.name2field == null) {
            List<Field> fields = this.getFields();
            HashMap<String, Field> n2f = new HashMap<String, Field>(fields.size());
            for (Field f : fields) {
                n2f.put(f.getName(), f);
            }
            this.name2field = n2f;
        }
        return this.name2field.get(name);
    }
}

