/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot.model;

import java.io.Serializable;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.util.MessageUtil;

public abstract class GCRootInfo
implements Serializable {
    private static final String[] TYPE_STRING = new String[]{MessageUtil.format(Messages.GCRootInfo_Unkown, new Object[0]), MessageUtil.format(Messages.GCRootInfo_SystemClass, new Object[0]), MessageUtil.format(Messages.GCRootInfo_JNILocal, new Object[0]), MessageUtil.format(Messages.GCRootInfo_JNIGlobal, new Object[0]), MessageUtil.format(Messages.GCRootInfo_ThreadBlock, new Object[0]), MessageUtil.format(Messages.GCRootInfo_BusyMonitor, new Object[0]), MessageUtil.format(Messages.GCRootInfo_JavaLocal, new Object[0]), MessageUtil.format(Messages.GCRootInfo_NativeStack, new Object[0]), MessageUtil.format(Messages.GCRootInfo_Thread, new Object[0]), MessageUtil.format(Messages.GCRootInfo_Finalizable, new Object[0]), MessageUtil.format(Messages.GCRootInfo_Unfinalized, new Object[0]), MessageUtil.format(Messages.GCRootInfo_Unreachable, new Object[0])};
    protected int objectId;
    private long objectAddress;
    protected int contextId;
    private long contextAddress;
    private int type;

    public GCRootInfo(long objectAddress, long contextAddress, int type) {
        this.objectAddress = objectAddress;
        this.contextAddress = contextAddress;
        this.type = type;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public long getObjectAddress() {
        return this.objectAddress;
    }

    public long getContextAddress() {
        return this.contextAddress;
    }

    public int getContextId() {
        return this.contextId;
    }

    public int getType() {
        return this.type;
    }

    public static String getTypeSetAsString(GCRootInfo[] roots) {
        int typeSet = 0;
        for (GCRootInfo info : roots) {
            typeSet |= info.getType();
        }
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < TYPE_STRING.length; ++i) {
            if ((1 << i & typeSet) == 0) continue;
            if (!first) {
                buf.append(", ");
            } else {
                if (1 << i == typeSet) {
                    return TYPE_STRING[i];
                }
                first = false;
            }
            buf.append(TYPE_STRING[i]);
        }
        return buf.toString();
    }
}

