/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android;

import android.content.Context;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.settings.PromptSettingsData;

class DialogStringResolver {
    private static final String PROMPT_TITLE_RES_NAME = "com.crashlytics.CrashSubmissionPromptTitle";
    private static final String PROMPT_MESSAGE_RES_NAME = "com.crashlytics.CrashSubmissionPromptMessage";
    private static final String SUBMISSION_SEND_RES_NAME = "com.crashlytics.CrashSubmissionSendTitle";
    private static final String SUBMISSION_ALWAYS_SEND_RES_NAME = "com.crashlytics.CrashSubmissionAlwaysSendTitle";
    private static final String SUBMISSION_CANCEL_RES_NAME = "com.crashlytics.CrashSubmissionCancelTitle";
    private final Context context;
    private final PromptSettingsData promptData;

    public DialogStringResolver(Context context, PromptSettingsData promptData) {
        this.context = context;
        this.promptData = promptData;
    }

    public String getTitle() {
        return this.resourceOrFallbackValue(PROMPT_TITLE_RES_NAME, this.promptData.title);
    }

    public String getMessage() {
        return this.resourceOrFallbackValue(PROMPT_MESSAGE_RES_NAME, this.promptData.message);
    }

    public String getSendButtonTitle() {
        return this.resourceOrFallbackValue(SUBMISSION_SEND_RES_NAME, this.promptData.sendButtonTitle);
    }

    public String getAlwaysSendButtonTitle() {
        return this.resourceOrFallbackValue(SUBMISSION_ALWAYS_SEND_RES_NAME, this.promptData.alwaysSendButtonTitle);
    }

    public String getCancelButtonTitle() {
        return this.resourceOrFallbackValue(SUBMISSION_CANCEL_RES_NAME, this.promptData.cancelButtonTitle);
    }

    private String resourceOrFallbackValue(String resourceName, String settingsValue) {
        return this.stringOrFallback(CommonUtils.getStringsFileValue((Context)this.context, (String)resourceName), settingsValue);
    }

    private String stringOrFallback(String firstChoice, String fallback) {
        return this.isNullOrEmpty(firstChoice) ? fallback : firstChoice;
    }

    private boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }
}

