/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android;

import android.util.Log;
import io.fabric.sdk.android.Logger;

public class DefaultLogger
implements Logger {
    private int logLevel;

    public DefaultLogger(int logLevel) {
        this.logLevel = logLevel;
    }

    public DefaultLogger() {
        this.logLevel = 4;
    }

    @Override
    public boolean isLoggable(String tag, int level) {
        return this.logLevel <= level;
    }

    @Override
    public int getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public void d(String tag, String text, Throwable throwable) {
        if (this.isLoggable(tag, 3)) {
            Log.d((String)tag, (String)text, (Throwable)throwable);
        }
    }

    @Override
    public void v(String tag, String text, Throwable throwable) {
        if (this.isLoggable(tag, 2)) {
            Log.v((String)tag, (String)text, (Throwable)throwable);
        }
    }

    @Override
    public void i(String tag, String text, Throwable throwable) {
        if (this.isLoggable(tag, 4)) {
            Log.i((String)tag, (String)text, (Throwable)throwable);
        }
    }

    @Override
    public void w(String tag, String text, Throwable throwable) {
        if (this.isLoggable(tag, 5)) {
            Log.w((String)tag, (String)text, (Throwable)throwable);
        }
    }

    @Override
    public void e(String tag, String text, Throwable throwable) {
        if (this.isLoggable(tag, 6)) {
            Log.e((String)tag, (String)text, (Throwable)throwable);
        }
    }

    @Override
    public void d(String tag, String text) {
        this.d(tag, text, null);
    }

    @Override
    public void v(String tag, String text) {
        this.v(tag, text, null);
    }

    @Override
    public void i(String tag, String text) {
        this.i(tag, text, null);
    }

    @Override
    public void w(String tag, String text) {
        this.w(tag, text, null);
    }

    @Override
    public void e(String tag, String text) {
        this.e(tag, text, null);
    }

    @Override
    public void log(int priority, String tag, String msg) {
        this.log(priority, tag, msg, false);
    }

    @Override
    public void log(int priority, String tag, String msg, boolean forceLog) {
        if (forceLog || this.isLoggable(tag, priority)) {
            Log.println((int)priority, (String)tag, (String)msg);
        }
    }
}

