/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.common;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.common.AdvertisingInfo;
import io.fabric.sdk.android.services.common.AdvertisingInfoReflectionStrategy;
import io.fabric.sdk.android.services.common.AdvertisingInfoServiceStrategy;
import io.fabric.sdk.android.services.common.AdvertisingInfoStrategy;
import io.fabric.sdk.android.services.common.BackgroundPriorityRunnable;
import io.fabric.sdk.android.services.persistence.PreferenceStore;
import io.fabric.sdk.android.services.persistence.PreferenceStoreImpl;

class AdvertisingInfoProvider {
    private static final String ADVERTISING_INFO_PREFERENCES = "TwitterAdvertisingInfoPreferences";
    private static final String PREFKEY_LIMIT_AD_TRACKING = "limit_ad_tracking_enabled";
    private static final String PREFKEY_ADVERTISING_ID = "advertising_id";
    private final Context context;
    private final PreferenceStore preferenceStore;

    public AdvertisingInfoProvider(Context context) {
        this.context = context.getApplicationContext();
        this.preferenceStore = new PreferenceStoreImpl(context, ADVERTISING_INFO_PREFERENCES);
    }

    public AdvertisingInfo getAdvertisingInfo() {
        AdvertisingInfo infoToReturn = this.getInfoFromPreferences();
        if (this.isInfoValid(infoToReturn)) {
            Fabric.getLogger().d("Fabric", "Using AdvertisingInfo from Preference Store");
            this.refreshInfoIfNeededAsync(infoToReturn);
            return infoToReturn;
        }
        infoToReturn = this.getAdvertisingInfoFromStrategies();
        this.storeInfoToPreferences(infoToReturn);
        return infoToReturn;
    }

    private void refreshInfoIfNeededAsync(final AdvertisingInfo advertisingInfo) {
        new Thread(new BackgroundPriorityRunnable(){

            @Override
            public void onRun() {
                AdvertisingInfo infoToStore = AdvertisingInfoProvider.this.getAdvertisingInfoFromStrategies();
                if (!advertisingInfo.equals(infoToStore)) {
                    Fabric.getLogger().d("Fabric", "Asychronously getting Advertising Info and storing it to preferences");
                    AdvertisingInfoProvider.this.storeInfoToPreferences(infoToStore);
                }
            }
        }).start();
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private void storeInfoToPreferences(AdvertisingInfo infoToReturn) {
        if (this.isInfoValid(infoToReturn)) {
            this.preferenceStore.save(this.preferenceStore.edit().putString(PREFKEY_ADVERTISING_ID, infoToReturn.advertisingId).putBoolean(PREFKEY_LIMIT_AD_TRACKING, infoToReturn.limitAdTrackingEnabled));
        } else {
            this.preferenceStore.save(this.preferenceStore.edit().remove(PREFKEY_ADVERTISING_ID).remove(PREFKEY_LIMIT_AD_TRACKING));
        }
    }

    protected AdvertisingInfo getInfoFromPreferences() {
        String advertisingId = this.preferenceStore.get().getString(PREFKEY_ADVERTISING_ID, "");
        boolean limitAd = this.preferenceStore.get().getBoolean(PREFKEY_LIMIT_AD_TRACKING, false);
        return new AdvertisingInfo(advertisingId, limitAd);
    }

    public AdvertisingInfoStrategy getReflectionStrategy() {
        return new AdvertisingInfoReflectionStrategy(this.context);
    }

    public AdvertisingInfoStrategy getServiceStrategy() {
        return new AdvertisingInfoServiceStrategy(this.context);
    }

    private boolean isInfoValid(AdvertisingInfo advertisingInfo) {
        return advertisingInfo != null && !TextUtils.isEmpty((CharSequence)advertisingInfo.advertisingId);
    }

    private AdvertisingInfo getAdvertisingInfoFromStrategies() {
        AdvertisingInfoStrategy adInfoStrategy = this.getReflectionStrategy();
        AdvertisingInfo infoToReturn = adInfoStrategy.getAdvertisingInfo();
        if (!this.isInfoValid(infoToReturn)) {
            adInfoStrategy = this.getServiceStrategy();
            infoToReturn = adInfoStrategy.getAdvertisingInfo();
            if (!this.isInfoValid(infoToReturn)) {
                Fabric.getLogger().d("Fabric", "AdvertisingInfo not present");
            } else {
                Fabric.getLogger().d("Fabric", "Using AdvertisingInfo from Service Provider");
            }
        } else {
            Fabric.getLogger().d("Fabric", "Using AdvertisingInfo from Reflection Provider");
        }
        return infoToReturn;
    }
}

