/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.events;

import android.content.Context;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.events.EventsFilesManager;
import io.fabric.sdk.android.services.events.EventsStorageListener;
import io.fabric.sdk.android.services.events.EventsStrategy;
import java.util.concurrent.ScheduledExecutorService;

public abstract class EventsHandler<T>
implements EventsStorageListener {
    protected final Context context;
    protected final ScheduledExecutorService executor;
    protected EventsStrategy<T> strategy;

    public EventsHandler(Context context, EventsStrategy<T> strategy, EventsFilesManager filesManager, ScheduledExecutorService executor) {
        this.context = context.getApplicationContext();
        this.executor = executor;
        this.strategy = strategy;
        filesManager.registerRollOverListener(this);
    }

    public void recordEventAsync(final T event, final boolean sendImmediately) {
        this.executeAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    EventsHandler.this.strategy.recordEvent(event);
                    if (sendImmediately) {
                        EventsHandler.this.strategy.rollFileOver();
                    }
                }
                catch (Exception e) {
                    CommonUtils.logControlledError(EventsHandler.this.context, "Failed to record event.", e);
                }
            }
        });
    }

    public void recordEventSync(final T event) {
        this.executeSync(new Runnable(){

            @Override
            public void run() {
                try {
                    EventsHandler.this.strategy.recordEvent(event);
                }
                catch (Exception e) {
                    CommonUtils.logControlledError(EventsHandler.this.context, "Crashlytics failed to record event", e);
                }
            }
        });
    }

    @Override
    public void onRollOver(String rolledOverFile) {
        this.executeAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    EventsHandler.this.strategy.sendEvents();
                }
                catch (Exception e) {
                    CommonUtils.logControlledError(EventsHandler.this.context, "Failed to send events files.", e);
                }
            }
        });
    }

    public void disable() {
        this.executeAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    EventsStrategy prevStrategy = EventsHandler.this.strategy;
                    EventsHandler.this.strategy = EventsHandler.this.getDisabledEventsStrategy();
                    prevStrategy.deleteAllEvents();
                }
                catch (Exception e) {
                    CommonUtils.logControlledError(EventsHandler.this.context, "Failed to disable events.", e);
                }
            }
        });
    }

    protected abstract EventsStrategy<T> getDisabledEventsStrategy();

    protected void executeSync(Runnable runnable) {
        try {
            this.executor.submit(runnable).get();
        }
        catch (Exception e) {
            CommonUtils.logControlledError(this.context, "Failed to run events task", e);
        }
    }

    protected void executeAsync(Runnable runnable) {
        try {
            this.executor.submit(runnable);
        }
        catch (Exception e) {
            CommonUtils.logControlledError(this.context, "Failed to submit events task", e);
        }
    }
}

