/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.network;

import io.fabric.sdk.android.services.network.SystemKeyStore;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;

final class CertificateChainCleaner {
    private CertificateChainCleaner() {
    }

    public static X509Certificate[] getCleanChain(X509Certificate[] chain, SystemKeyStore systemKeyStore) throws CertificateException {
        X509Certificate trustRoot;
        int i;
        LinkedList<X509Certificate> cleanChain = new LinkedList<X509Certificate>();
        boolean trustedChain = false;
        if (systemKeyStore.isTrustRoot(chain[0])) {
            trustedChain = true;
        }
        cleanChain.add(chain[0]);
        for (i = 1; i < chain.length; ++i) {
            if (systemKeyStore.isTrustRoot(chain[i])) {
                trustedChain = true;
            }
            if (!CertificateChainCleaner.isValidLink(chain[i], chain[i - 1])) break;
            cleanChain.add(chain[i]);
        }
        if ((trustRoot = systemKeyStore.getTrustRootFor(chain[i - 1])) != null) {
            cleanChain.add(trustRoot);
            trustedChain = true;
        }
        if (trustedChain) {
            return cleanChain.toArray(new X509Certificate[cleanChain.size()]);
        }
        throw new CertificateException("Didn't find a trust anchor in chain cleanup!");
    }

    private static boolean isValidLink(X509Certificate parent, X509Certificate child) {
        if (!parent.getSubjectX500Principal().equals(child.getIssuerX500Principal())) {
            return false;
        }
        try {
            child.verify(parent.getPublicKey());
        }
        catch (GeneralSecurityException gse) {
            return false;
        }
        return true;
    }
}

