/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.network;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;

class SystemKeyStore {
    final KeyStore trustStore;
    private final HashMap<Principal, X509Certificate> trustRoots;

    public SystemKeyStore(InputStream keystoreStream, String passwd) {
        KeyStore trustStore = this.getTrustStore(keystoreStream, passwd);
        this.trustRoots = this.initializeTrustedRoots(trustStore);
        this.trustStore = trustStore;
    }

    public boolean isTrustRoot(X509Certificate certificate) {
        X509Certificate trustRoot = this.trustRoots.get(certificate.getSubjectX500Principal());
        return trustRoot != null && trustRoot.getPublicKey().equals(certificate.getPublicKey());
    }

    public X509Certificate getTrustRootFor(X509Certificate certificate) {
        X509Certificate trustRoot = this.trustRoots.get(certificate.getIssuerX500Principal());
        if (trustRoot == null) {
            return null;
        }
        if (trustRoot.getSubjectX500Principal().equals(certificate.getSubjectX500Principal())) {
            return null;
        }
        try {
            certificate.verify(trustRoot.getPublicKey());
        }
        catch (GeneralSecurityException e) {
            return null;
        }
        return trustRoot;
    }

    private HashMap<Principal, X509Certificate> initializeTrustedRoots(KeyStore trustStore) {
        try {
            HashMap<Principal, X509Certificate> trusted = new HashMap<Principal, X509Certificate>();
            Enumeration<String> aliases = trustStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                X509Certificate cert = (X509Certificate)trustStore.getCertificate(alias);
                if (cert == null) continue;
                trusted.put(cert.getSubjectX500Principal(), cert);
            }
            return trusted;
        }
        catch (KeyStoreException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore getTrustStore(InputStream keystoreStream, String passwd) {
        try {
            KeyStore trustStore = KeyStore.getInstance("BKS");
            try (BufferedInputStream bin = new BufferedInputStream(keystoreStream);){
                trustStore.load(bin, passwd.toCharArray());
            }
            return trustStore;
        }
        catch (KeyStoreException kse) {
            throw new AssertionError((Object)kse);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (CertificateException e) {
            throw new AssertionError((Object)e);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

