/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.settings;

import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.persistence.FileStoreImpl;
import io.fabric.sdk.android.services.settings.CachedSettingsIo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import org.json.JSONObject;

class DefaultCachedSettingsIo
implements CachedSettingsIo {
    private final Kit kit;

    public DefaultCachedSettingsIo(Kit kit) {
        this.kit = kit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject readCachedSettings() {
        Fabric.getLogger().d("Fabric", "Reading cached settings...");
        FileInputStream fis = null;
        JSONObject toReturn = null;
        try {
            File settingsFile = new File(new FileStoreImpl(this.kit).getFilesDir(), "com.crashlytics.settings.json");
            if (settingsFile.exists()) {
                fis = new FileInputStream(settingsFile);
                String settingsStr = CommonUtils.streamToString(fis);
                toReturn = new JSONObject(settingsStr);
            } else {
                Fabric.getLogger().d("Fabric", "No cached settings found.");
            }
            CommonUtils.closeOrLog(fis, "Error while closing settings cache file.");
        }
        catch (Exception e) {
            Fabric.getLogger().e("Fabric", "Failed to fetch cached settings", e);
        }
        finally {
            CommonUtils.closeOrLog(fis, "Error while closing settings cache file.");
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeCachedSettings(long expiresAtMillis, JSONObject settingsJson) {
        Fabric.getLogger().d("Fabric", "Writing settings to cache file...");
        if (settingsJson != null) {
            FileWriter writer = null;
            try {
                settingsJson.put("expires_at", expiresAtMillis);
                writer = new FileWriter(new File(new FileStoreImpl(this.kit).getFilesDir(), "com.crashlytics.settings.json"));
                writer.write(settingsJson.toString());
                writer.flush();
                CommonUtils.closeOrLog(writer, "Failed to close settings writer.");
            }
            catch (Exception e) {
                Fabric.getLogger().e("Fabric", "Failed to cache settings", e);
            }
            finally {
                CommonUtils.closeOrLog(writer, "Failed to close settings writer.");
            }
        }
    }
}

