/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.settings;

import android.annotation.SuppressLint;
import android.content.SharedPreferences;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.common.CurrentTimeProvider;
import io.fabric.sdk.android.services.persistence.PreferenceStore;
import io.fabric.sdk.android.services.persistence.PreferenceStoreImpl;
import io.fabric.sdk.android.services.settings.CachedSettingsIo;
import io.fabric.sdk.android.services.settings.SettingsCacheBehavior;
import io.fabric.sdk.android.services.settings.SettingsController;
import io.fabric.sdk.android.services.settings.SettingsData;
import io.fabric.sdk.android.services.settings.SettingsJsonTransform;
import io.fabric.sdk.android.services.settings.SettingsRequest;
import io.fabric.sdk.android.services.settings.SettingsSpiCall;
import org.json.JSONException;
import org.json.JSONObject;

class DefaultSettingsController
implements SettingsController {
    private static final String LOAD_ERROR_MESSAGE = "Unknown error while loading Crashlytics settings. Crashes will be cached until settings can be retrieved.";
    private static final String PREFS_BUILD_INSTANCE_IDENTIFIER = "existing_instance_identifier";
    private final SettingsRequest settingsRequest;
    private final SettingsJsonTransform settingsJsonTransform;
    private final CurrentTimeProvider currentTimeProvider;
    private final CachedSettingsIo cachedSettingsIo;
    private final SettingsSpiCall settingsSpiCall;
    private final Kit kit;
    private final PreferenceStore preferenceStore;

    public DefaultSettingsController(Kit kit, SettingsRequest settingsRequest, CurrentTimeProvider currentTimeProvider, SettingsJsonTransform settingsJsonTransform, CachedSettingsIo cachedSettingsIo, SettingsSpiCall settingsSpiCall) {
        this.kit = kit;
        this.settingsRequest = settingsRequest;
        this.currentTimeProvider = currentTimeProvider;
        this.settingsJsonTransform = settingsJsonTransform;
        this.cachedSettingsIo = cachedSettingsIo;
        this.settingsSpiCall = settingsSpiCall;
        this.preferenceStore = new PreferenceStoreImpl(this.kit);
    }

    @Override
    public SettingsData loadSettingsData() {
        return this.loadSettingsData(SettingsCacheBehavior.USE_CACHE);
    }

    @Override
    public SettingsData loadSettingsData(SettingsCacheBehavior cacheBehavior) {
        SettingsData toReturn = null;
        try {
            JSONObject settingsJson;
            if (!Fabric.isDebuggable() && !this.buildInstanceIdentifierChanged()) {
                toReturn = this.getCachedSettingsData(cacheBehavior);
            }
            if (toReturn == null && (settingsJson = this.settingsSpiCall.invoke(this.settingsRequest)) != null) {
                toReturn = this.settingsJsonTransform.buildFromJson(this.currentTimeProvider, settingsJson);
                this.cachedSettingsIo.writeCachedSettings(toReturn.expiresAtMillis, settingsJson);
                this.logSettings(settingsJson, "Loaded settings: ");
                this.setStoredBuildInstanceIdentifier(this.getBuildInstanceIdentifierFromContext());
            }
            if (toReturn == null) {
                toReturn = this.getCachedSettingsData(SettingsCacheBehavior.IGNORE_CACHE_EXPIRATION);
            }
        }
        catch (Exception e) {
            Fabric.getLogger().e("Fabric", LOAD_ERROR_MESSAGE, e);
        }
        return toReturn;
    }

    private SettingsData getCachedSettingsData(SettingsCacheBehavior cacheBehavior) {
        SettingsData toReturn = null;
        try {
            if (!SettingsCacheBehavior.SKIP_CACHE_LOOKUP.equals((Object)cacheBehavior)) {
                JSONObject settingsJson = this.cachedSettingsIo.readCachedSettings();
                if (settingsJson != null) {
                    SettingsData settingsData = this.settingsJsonTransform.buildFromJson(this.currentTimeProvider, settingsJson);
                    if (settingsData != null) {
                        this.logSettings(settingsJson, "Loaded cached settings: ");
                        long currentTimeMillis = this.currentTimeProvider.getCurrentTimeMillis();
                        if (SettingsCacheBehavior.IGNORE_CACHE_EXPIRATION.equals((Object)cacheBehavior) || !settingsData.isExpired(currentTimeMillis)) {
                            toReturn = settingsData;
                            Fabric.getLogger().d("Fabric", "Returning cached settings.");
                        } else {
                            Fabric.getLogger().d("Fabric", "Cached settings have expired.");
                        }
                    } else {
                        Fabric.getLogger().e("Fabric", "Failed to transform cached settings data.", null);
                    }
                } else {
                    Fabric.getLogger().d("Fabric", "No cached settings data found.");
                }
            }
        }
        catch (Exception e) {
            Fabric.getLogger().e("Fabric", "Failed to get cached settings", e);
        }
        return toReturn;
    }

    private void logSettings(JSONObject json, String message) throws JSONException {
        if (!CommonUtils.isClsTrace(this.kit.getContext())) {
            json = this.settingsJsonTransform.sanitizeTraceInfo(json);
        }
        Fabric.getLogger().d("Fabric", message + json.toString());
    }

    String getBuildInstanceIdentifierFromContext() {
        return CommonUtils.createInstanceIdFrom(CommonUtils.resolveBuildId(this.kit.getContext()));
    }

    String getStoredBuildInstanceIdentifier() {
        SharedPreferences sharedPreferences = this.preferenceStore.get();
        return sharedPreferences.getString(PREFS_BUILD_INSTANCE_IDENTIFIER, "");
    }

    @SuppressLint(value={"CommitPrefEdits"})
    boolean setStoredBuildInstanceIdentifier(String buildInstanceIdentifier) {
        SharedPreferences.Editor editor = this.preferenceStore.edit();
        editor.putString(PREFS_BUILD_INSTANCE_IDENTIFIER, buildInstanceIdentifier);
        return this.preferenceStore.save(editor);
    }

    boolean buildInstanceIdentifierChanged() {
        String currentInstanceIdentifier;
        String existingInstanceIdentifier = this.getStoredBuildInstanceIdentifier();
        return !existingInstanceIdentifier.equals(currentInstanceIdentifier = this.getBuildInstanceIdentifierFromContext());
    }
}

