/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import java.util.HashMap;
import java.util.Map;

public final class EventAttributes {
    public static final int MAX_STRING_LENGTH = 100;
    public static final int MAX_NUM_ATTRIBUTES = 20;
    final Map<String, Object> attributes = new HashMap<String, Object>();

    public EventAttributes put(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        if (value == null) {
            throw new NullPointerException("value must not be null");
        }
        EventAttributes.validateStringLength(key);
        EventAttributes.validateStringLength(value);
        this.putAttribute(key, value);
        return this;
    }

    public EventAttributes put(String key, Number value) {
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        if (value == null) {
            throw new NullPointerException("value must not be null");
        }
        EventAttributes.validateStringLength(key);
        this.putAttribute(key, value);
        return this;
    }

    void putAttribute(String key, Object value) {
        if (this.attributes.size() >= 20 && !this.attributes.containsKey(key)) {
            throw new IllegalStateException(String.format("Event cannot have more than %d attributes", 20));
        }
        this.attributes.put(key, value);
    }

    static void validateStringLength(String value) {
        if (value.length() > 100) {
            throw new IllegalArgumentException(String.format("String cannot be longer than %d characters", 100));
        }
    }
}

