/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import android.content.Context;
import com.crashlytics.android.answers.Answers;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.services.common.AbstractSpiCall;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.common.ResponseParser;
import io.fabric.sdk.android.services.events.FilesSender;
import io.fabric.sdk.android.services.network.HttpMethod;
import io.fabric.sdk.android.services.network.HttpRequest;
import io.fabric.sdk.android.services.network.HttpRequestFactory;
import java.io.File;
import java.util.List;

class SessionAnalyticsFilesSender
extends AbstractSpiCall
implements FilesSender {
    static final String FILE_PARAM_NAME = "session_analytics_file_";
    static final String FILE_CONTENT_TYPE = "application/vnd.crashlytics.android.events";
    private final String apiKey;

    public SessionAnalyticsFilesSender(Kit kit, String protocolAndHostOverride, String url, HttpRequestFactory requestFactory, String apiKey) {
        super(kit, protocolAndHostOverride, url, requestFactory, HttpMethod.POST);
        this.apiKey = apiKey;
    }

    public boolean send(List<File> files) {
        HttpRequest httpRequest = this.getHttpRequest();
        httpRequest = this.applyHeadersTo(httpRequest, this.apiKey);
        httpRequest = this.applyMultipartDataTo(httpRequest, files);
        CommonUtils.logControlled((Context)Answers.getInstance().getContext(), (String)("Sending " + files.size() + " analytics files to " + this.getUrl()));
        int statusCode = httpRequest.code();
        CommonUtils.logControlled((Context)Answers.getInstance().getContext(), (String)("Response code for analytics file send is " + statusCode));
        return 0 == ResponseParser.parse((int)statusCode);
    }

    private HttpRequest applyHeadersTo(HttpRequest request, String apiKey) {
        return request.header("X-CRASHLYTICS-API-CLIENT-TYPE", "android").header("X-CRASHLYTICS-API-CLIENT-VERSION", Answers.getInstance().getVersion()).header("X-CRASHLYTICS-API-KEY", apiKey);
    }

    private HttpRequest applyMultipartDataTo(HttpRequest request, List<File> files) {
        int i = 0;
        for (File file : files) {
            CommonUtils.logControlled((Context)Answers.getInstance().getContext(), (String)("Adding analytics session file " + file.getName() + " to multipart POST"));
            request.part(FILE_PARAM_NAME + i, file.getName(), FILE_CONTENT_TYPE, file);
            ++i;
        }
        return request;
    }
}

