/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import android.app.Activity;
import com.crashlytics.android.answers.SessionEventMetadata;
import java.util.Collections;
import java.util.Map;

final class SessionEvent {
    static final String ACTIVITY_KEY = "activity";
    static final String SESSION_ID_KEY = "sessionId";
    public final SessionEventMetadata sessionEventMetadata;
    public final long timestamp;
    public final Type type;
    public final Map<String, String> details;
    public final String customType;
    public final Map<String, Object> customAttributes;
    private String stringRepresentation;

    public static SessionEvent buildActivityLifecycleEvent(SessionEventMetadata metadata, Type type, Activity activity) {
        Map<String, String> details = Collections.singletonMap(ACTIVITY_KEY, activity.getClass().getName());
        return SessionEvent.buildEvent(metadata, type, details);
    }

    public static SessionEvent buildInstallEvent(SessionEventMetadata metadata) {
        return SessionEvent.buildEvent(metadata, Type.INSTALL, Collections.emptyMap());
    }

    public static SessionEvent buildErrorEvent(SessionEventMetadata metadata, String sessionId) {
        Map<String, String> details = Collections.singletonMap(SESSION_ID_KEY, sessionId);
        return SessionEvent.buildEvent(metadata, Type.ERROR, details);
    }

    public static SessionEvent buildCrashEvent(SessionEventMetadata metadata, String sessionId) {
        Map<String, String> details = Collections.singletonMap(SESSION_ID_KEY, sessionId);
        return SessionEvent.buildEvent(metadata, Type.CRASH, details);
    }

    public static SessionEvent buildCustomEvent(SessionEventMetadata metadata, String customType, Map<String, Object> customAttributes) {
        return SessionEvent.buildEvent(metadata, Type.CUSTOM, Collections.emptyMap(), customType, customAttributes);
    }

    private static SessionEvent buildEvent(SessionEventMetadata metadata, Type type, Map<String, String> details) {
        return SessionEvent.buildEvent(metadata, type, details, null, Collections.emptyMap());
    }

    private static SessionEvent buildEvent(SessionEventMetadata metadata, Type type, Map<String, String> details, String customType, Map<String, Object> customAttributes) {
        return new SessionEvent(metadata, System.currentTimeMillis(), type, details, customType, customAttributes);
    }

    private SessionEvent(SessionEventMetadata sessionEventMetadata, long timestamp, Type type, Map<String, String> details, String customType, Map<String, Object> customAttributes) {
        this.sessionEventMetadata = sessionEventMetadata;
        this.timestamp = timestamp;
        this.type = type;
        this.details = details;
        this.customType = customType;
        this.customAttributes = customAttributes;
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            StringBuilder sb = new StringBuilder().append("[").append(this.getClass().getSimpleName()).append(": ").append("timestamp=").append(this.timestamp).append(", type=").append((Object)this.type).append(", details=").append(this.details.toString()).append(", customType=").append(this.customType).append(", customAttributes=").append(this.customAttributes.toString()).append(", metadata=[").append(this.sessionEventMetadata).append("]]");
            this.stringRepresentation = sb.toString();
        }
        return this.stringRepresentation;
    }

    static enum Type {
        CREATE,
        START,
        RESUME,
        SAVE_INSTANCE_STATE,
        PAUSE,
        STOP,
        DESTROY,
        ERROR,
        CRASH,
        INSTALL,
        CUSTOM;

    }
}

