/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import android.content.Context;
import com.crashlytics.android.answers.Answers;
import com.crashlytics.android.answers.DisabledSessionAnalyticsManagerStrategy;
import com.crashlytics.android.answers.SessionAnalyticsFilesManager;
import com.crashlytics.android.answers.SessionAnalyticsManagerStrategy;
import com.crashlytics.android.answers.SessionEvent;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.events.EventsFilesManager;
import io.fabric.sdk.android.services.events.EventsHandler;
import io.fabric.sdk.android.services.events.EventsStrategy;
import io.fabric.sdk.android.services.settings.AnalyticsSettingsData;
import java.util.concurrent.ScheduledExecutorService;

class SessionEventsHandler
extends EventsHandler<SessionEvent> {
    SessionEventsHandler(Context context, EventsStrategy<SessionEvent> strategy, SessionAnalyticsFilesManager filesManager, ScheduledExecutorService executor) {
        super(context, strategy, (EventsFilesManager)filesManager, executor);
    }

    protected EventsStrategy<SessionEvent> getDisabledEventsStrategy() {
        return new DisabledSessionAnalyticsManagerStrategy();
    }

    protected void setAnalyticsSettingsData(final AnalyticsSettingsData analyticsSettingsData, final String protocolAndHostOverride) {
        super.executeAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    ((SessionAnalyticsManagerStrategy)SessionEventsHandler.this.strategy).setAnalyticsSettingsData(analyticsSettingsData, protocolAndHostOverride);
                }
                catch (Exception e) {
                    CommonUtils.logControlledError((Context)Answers.getInstance().getContext(), (String)"Crashlytics failed to set analytics settings data.", (Throwable)e);
                }
            }
        });
    }
}

