/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.client;

import android.content.Context;
import android.os.RemoteException;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.doubleclick.PublisherInterstitialAd;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zza;
import com.google.android.gms.ads.internal.client.zzb;
import com.google.android.gms.ads.internal.client.zzc;
import com.google.android.gms.ads.internal.client.zzg;
import com.google.android.gms.ads.internal.client.zzi;
import com.google.android.gms.ads.internal.client.zzk;
import com.google.android.gms.ads.internal.client.zzr;
import com.google.android.gms.ads.internal.client.zzx;
import com.google.android.gms.ads.purchase.InAppPurchaseListener;
import com.google.android.gms.ads.purchase.PlayStorePurchaseListener;
import com.google.android.gms.internal.zzcj;
import com.google.android.gms.internal.zzee;
import com.google.android.gms.internal.zzfk;
import com.google.android.gms.internal.zzfo;

public class zzz {
    private final zzee zzsR = new zzee();
    private final Context mContext;
    private final zzg zznH;
    private AdListener zzrV;
    private zza zzrU;
    private zzr zzsT;
    private String zzoL;
    private String zzsU;
    private AppEventListener zzsq;
    private PlayStorePurchaseListener zzsX;
    private InAppPurchaseListener zzsW;
    private PublisherInterstitialAd zzsZ;
    private OnCustomRenderedAdLoadedListener zzsY;

    public zzz(Context context) {
        this(context, zzg.zzcw(), null);
    }

    public zzz(Context context, PublisherInterstitialAd publisherInterstitialAd) {
        this(context, zzg.zzcw(), publisherInterstitialAd);
    }

    public zzz(Context context, zzg zzg2, PublisherInterstitialAd publisherInterstitialAd) {
        this.mContext = context;
        this.zznH = zzg2;
        this.zzsZ = publisherInterstitialAd;
    }

    public AdListener getAdListener() {
        return this.zzrV;
    }

    public String getAdUnitId() {
        return this.zzoL;
    }

    public AppEventListener getAppEventListener() {
        return this.zzsq;
    }

    public InAppPurchaseListener getInAppPurchaseListener() {
        return this.zzsW;
    }

    public OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzsY;
    }

    public boolean isLoaded() {
        try {
            if (this.zzsT == null) {
                return false;
            }
            return this.zzsT.isReady();
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to check if ad is ready.", remoteException);
            return false;
        }
    }

    public void zza(zzx zzx2) {
        try {
            if (this.zzsT == null) {
                this.zzL("loadAd");
            }
            if (this.zzsT.zza(this.zznH.zza(this.mContext, zzx2))) {
                this.zzsR.zzf(zzx2.zzcJ());
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to load ad.", remoteException);
        }
    }

    public void setAdListener(AdListener adListener) {
        try {
            this.zzrV = adListener;
            if (this.zzsT != null) {
                this.zzsT.zza(adListener != null ? new zzc(adListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AdListener.", remoteException);
        }
    }

    public void zza(zza zza2) {
        try {
            this.zzrU = zza2;
            if (this.zzsT != null) {
                this.zzsT.zza(zza2 != null ? new zzb(zza2) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AdClickListener.", remoteException);
        }
    }

    public void setAdUnitId(String adUnitId) {
        if (this.zzoL != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on InterstitialAd.");
        }
        this.zzoL = adUnitId;
    }

    public void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzsq = appEventListener;
            if (this.zzsT != null) {
                this.zzsT.zza(appEventListener != null ? new zzi(appEventListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AppEventListener.", remoteException);
        }
    }

    public void setInAppPurchaseListener(InAppPurchaseListener inAppPurchaseListener) {
        if (this.zzsX != null) {
            throw new IllegalStateException("Play store purchase parameter has already been set.");
        }
        try {
            this.zzsW = inAppPurchaseListener;
            if (this.zzsT != null) {
                this.zzsT.zza(inAppPurchaseListener != null ? new zzfk(inAppPurchaseListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the InAppPurchaseListener.", remoteException);
        }
    }

    public void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        try {
            this.zzsY = onCustomRenderedAdLoadedListener;
            if (this.zzsT != null) {
                this.zzsT.zza(onCustomRenderedAdLoadedListener != null ? new zzcj(onCustomRenderedAdLoadedListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the OnCustomRenderedAdLoadedListener.", remoteException);
        }
    }

    public void setPlayStorePurchaseParams(PlayStorePurchaseListener playStorePurchaseListener, String publicKey) {
        if (this.zzsW != null) {
            throw new IllegalStateException("In app purchase parameter has already been set.");
        }
        try {
            this.zzsX = playStorePurchaseListener;
            this.zzsU = publicKey;
            if (this.zzsT != null) {
                this.zzsT.zza(playStorePurchaseListener != null ? new zzfo(playStorePurchaseListener) : null, publicKey);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the play store purchase parameter.", remoteException);
        }
    }

    public String getMediationAdapterClassName() {
        try {
            if (this.zzsT != null) {
                return this.zzsT.getMediationAdapterClassName();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public void show() {
        try {
            this.zzM("show");
            this.zzsT.showInterstitial();
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to show interstitial.", remoteException);
        }
    }

    private void zzL(String string) throws RemoteException {
        if (this.zzoL == null) {
            this.zzM(string);
        }
        this.zzsT = zzk.zzcB().zzb(this.mContext, new AdSizeParcel(), this.zzoL, this.zzsR);
        if (this.zzrV != null) {
            this.zzsT.zza(new zzc(this.zzrV));
        }
        if (this.zzrU != null) {
            this.zzsT.zza(new zzb(this.zzrU));
        }
        if (this.zzsq != null) {
            this.zzsT.zza(new zzi(this.zzsq));
        }
        if (this.zzsW != null) {
            this.zzsT.zza(new zzfk(this.zzsW));
        }
        if (this.zzsX != null) {
            this.zzsT.zza(new zzfo(this.zzsX), this.zzsU);
        }
        if (this.zzsY != null) {
            this.zzsT.zza(new zzcj(this.zzsY));
        }
    }

    private void zzM(String string) {
        if (this.zzsT == null) {
            throw new IllegalStateException("The ad unit ID must be set on InterstitialAd before " + string + " is called.");
        }
    }
}

