/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzj;
import com.google.android.gms.ads.internal.overlay.zzl;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.internal.zzex;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzhn;
import com.google.android.gms.internal.zzid;
import com.google.android.gms.internal.zzie;

@zzgd
public class zzc
extends zzex.zza
implements zzl {
    static final int zzzj = Color.argb((int)0, (int)0, (int)0, (int)0);
    private final Activity mActivity;
    AdOverlayInfoParcel zzzk;
    zzh zzzl;
    zzid zzoA;
    zzc zzzm;
    zzj zzzn;
    boolean zzzo = false;
    FrameLayout zzzp;
    WebChromeClient.CustomViewCallback zzzq;
    boolean zzzr = false;
    boolean zzzs = false;
    RelativeLayout zzyG;
    boolean zzzt = false;
    int zzzu = 0;
    private boolean zzzv;
    private boolean zzzw = false;
    private boolean zzzx = true;

    public zzc(Activity activity) {
        this.mActivity = activity;
    }

    public void close() {
        this.zzzu = 2;
        this.mActivity.finish();
    }

    public zzh zzeq() {
        return this.zzzl;
    }

    public void zzer() {
        if (this.zzzk != null && this.zzzo) {
            this.setRequestedOrientation(this.zzzk.orientation);
        }
        if (this.zzzp != null) {
            this.mActivity.setContentView((View)this.zzyG);
            this.zzaE();
            this.zzzp.removeAllViews();
            this.zzzp = null;
        }
        if (this.zzzq != null) {
            this.zzzq.onCustomViewHidden();
            this.zzzq = null;
        }
        this.zzzo = false;
    }

    public void zzd(int n, int n2, int n3, int n4) {
        if (this.zzzl != null) {
            this.zzzl.zzf(n, n2, n3, n4);
        }
    }

    public void zze(int n, int n2, int n3, int n4) {
        if (this.zzzl == null) {
            this.zzzl = new zzh((Context)this.mActivity, this.zzoA);
            this.zzyG.addView((View)this.zzzl, 0, new ViewGroup.LayoutParams(-1, -1));
            this.zzzl.zzf(n, n2, n3, n4);
            this.zzoA.zzgF().zzD(false);
        }
    }

    @Override
    public void zzes() {
        this.zzzu = 1;
        this.mActivity.finish();
    }

    @Override
    public void onBackPressed() {
        this.zzzu = 0;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        this.zzzr = savedInstanceState != null ? savedInstanceState.getBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", false) : false;
        try {
            this.zzzk = AdOverlayInfoParcel.zzb(this.mActivity.getIntent());
            if (this.zzzk == null) {
                throw new zza("Could not get info for ad overlay.");
            }
            if (this.zzzk.zzpJ.zzGI > 7500000) {
                this.zzzu = 3;
            }
            if (this.mActivity.getIntent() != null) {
                this.zzzx = this.mActivity.getIntent().getBooleanExtra("shouldCallOnOverlayOpened", true);
            }
            this.zzzs = this.zzzk.zzzN != null ? this.zzzk.zzzN.zzoU : false;
            if (savedInstanceState == null) {
                if (this.zzzk.zzzD != null && this.zzzx) {
                    this.zzzk.zzzD.zzaW();
                }
                if (this.zzzk.zzzK != 1 && this.zzzk.zzzC != null) {
                    this.zzzk.zzzC.onAdClicked();
                }
            }
            this.zzyG = new zzb((Context)this.mActivity, this.zzzk.zzzM);
            switch (this.zzzk.zzzK) {
                case 1: {
                    this.zzu(false);
                    break;
                }
                case 2: {
                    this.zzzm = new zzc(this.zzzk.zzzE);
                    this.zzu(false);
                    break;
                }
                case 3: {
                    this.zzu(true);
                    break;
                }
                case 4: {
                    if (this.zzzr) {
                        this.zzzu = 3;
                        this.mActivity.finish();
                        break;
                    }
                    if (!zzo.zzbs().zza((Context)this.mActivity, this.zzzk.zzzB, this.zzzk.zzzJ)) {
                        this.zzzu = 3;
                        this.mActivity.finish();
                    }
                    break;
                }
                default: {
                    throw new zza("Could not determine ad overlay type.");
                }
            }
        }
        catch (zza zza2) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaC(zza2.getMessage());
            this.zzzu = 3;
            this.mActivity.finish();
        }
    }

    @Override
    public void onRestart() {
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onResume() {
        if (this.zzzk != null && this.zzzk.zzzK == 4) {
            if (this.zzzr) {
                this.zzzu = 3;
                this.mActivity.finish();
            } else {
                this.zzzr = true;
            }
        }
        if (this.zzoA != null && !this.zzoA.isDestroyed()) {
            zzo.zzbx().zzb(this.zzoA.getWebView());
        } else {
            com.google.android.gms.ads.internal.util.client.zzb.zzaC("The webview does not exit. Ignoring action.");
        }
    }

    @Override
    public void onPause() {
        if (this.zzzl != null) {
            this.zzzl.pause();
        }
        this.zzer();
        if (!(this.zzoA == null || this.mActivity.isFinishing() && this.zzzm != null)) {
            zzo.zzbx().zza(this.zzoA.getWebView());
        }
        this.zzeu();
    }

    @Override
    public void onSaveInstanceState(Bundle outBundle) {
        outBundle.putBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", this.zzzr);
    }

    @Override
    public void onStop() {
        this.zzeu();
    }

    @Override
    public void onDestroy() {
        if (this.zzzl != null) {
            this.zzzl.destroy();
        }
        if (this.zzoA != null) {
            this.zzyG.removeView((View)this.zzoA.getWebView());
        }
        this.zzeu();
    }

    public void zzt(boolean bl) {
        int n = bl ? 50 : 32;
        this.zzzn = new zzj((Context)this.mActivity, n, this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        int n2 = bl ? 11 : 9;
        layoutParams.addRule(n2);
        this.zzzn.zza(bl, this.zzzk.zzzH);
        this.zzyG.addView((View)this.zzzn, (ViewGroup.LayoutParams)layoutParams);
    }

    @Override
    public void zzaE() {
        this.zzzv = true;
    }

    public void zza(boolean bl, boolean bl2) {
        if (this.zzzn != null) {
            this.zzzn.zza(bl, bl2);
        }
    }

    public void zzet() {
        this.zzyG.removeView((View)this.zzzn);
        this.zzt(true);
    }

    public void setRequestedOrientation(int requestedOrientation) {
        this.mActivity.setRequestedOrientation(requestedOrientation);
    }

    public void zza(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zzzp = new FrameLayout((Context)this.mActivity);
        this.zzzp.setBackgroundColor(-16777216);
        this.zzzp.addView(view, -1, -1);
        this.mActivity.setContentView((View)this.zzzp);
        this.zzaE();
        this.zzzq = customViewCallback;
        this.zzzo = true;
    }

    protected void zzu(boolean bl) throws zza {
        Window window;
        if (!this.zzzv) {
            this.mActivity.requestWindowFeature(1);
        }
        if ((window = this.mActivity.getWindow()) == null) {
            throw new zza("Invalid activity, no window available.");
        }
        if (!this.zzzs || this.zzzk.zzzN != null && this.zzzk.zzzN.zzoV) {
            window.setFlags(1024, 1024);
        }
        boolean bl2 = this.zzzk.zzzE.zzgF().zzbU();
        this.zzzt = false;
        if (bl2) {
            if (this.zzzk.orientation == zzo.zzbx().zzgq()) {
                this.zzzt = this.mActivity.getResources().getConfiguration().orientation == 1;
            } else if (this.zzzk.orientation == zzo.zzbx().zzgr()) {
                this.zzzt = this.mActivity.getResources().getConfiguration().orientation == 2;
            }
        }
        com.google.android.gms.ads.internal.util.client.zzb.zzay("Delay onShow to next orientation change: " + this.zzzt);
        this.setRequestedOrientation(this.zzzk.orientation);
        if (zzo.zzbx().zza(window)) {
            com.google.android.gms.ads.internal.util.client.zzb.zzay("Hardware acceleration on the AdActivity window enabled.");
        }
        if (!this.zzzs) {
            this.zzyG.setBackgroundColor(-16777216);
        } else {
            this.zzyG.setBackgroundColor(zzzj);
        }
        this.mActivity.setContentView((View)this.zzyG);
        this.zzaE();
        if (bl) {
            this.zzoA = zzo.zzbw().zza((Context)this.mActivity, this.zzzk.zzzE.zzaN(), true, bl2, null, this.zzzk.zzpJ);
            this.zzoA.zzgF().zzb(null, null, this.zzzk.zzzF, this.zzzk.zzzJ, true, this.zzzk.zzzL, null, this.zzzk.zzzE.zzgF().zzgM(), null);
            this.zzoA.zzgF().zza(new zzie.zza(){

                @Override
                public void zza(zzid zzid2, boolean bl) {
                    zzid2.zzgF().zzgS();
                    zzid2.zzew();
                }
            });
            if (this.zzzk.zzzf != null) {
                this.zzoA.loadUrl(this.zzzk.zzzf);
            } else if (this.zzzk.zzzI != null) {
                this.zzoA.loadDataWithBaseURL(this.zzzk.zzzG, this.zzzk.zzzI, "text/html", "UTF-8", null);
            } else {
                throw new zza("No URL or HTML to display in ad overlay.");
            }
            if (this.zzzk.zzzE != null) {
                this.zzzk.zzzE.zzb(this);
            }
        } else {
            this.zzoA = this.zzzk.zzzE;
            this.zzoA.setContext((Context)this.mActivity);
        }
        this.zzoA.zza(this);
        ViewParent viewParent = this.zzoA.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView((View)this.zzoA.getWebView());
        }
        if (this.zzzs) {
            this.zzoA.setBackgroundColor(zzzj);
        }
        this.zzyG.addView((View)this.zzoA.getWebView(), -1, -1);
        if (!bl && !this.zzzt) {
            this.zzew();
        }
        this.zzt(bl2);
        if (this.zzoA.zzgG()) {
            this.zza(bl2, true);
        }
    }

    protected void zzeu() {
        if (!this.mActivity.isFinishing() || this.zzzw) {
            return;
        }
        this.zzzw = true;
        if (this.mActivity.isFinishing()) {
            if (this.zzoA != null) {
                this.zzv(this.zzzu);
                this.zzyG.removeView((View)this.zzoA.getWebView());
                if (this.zzzm != null) {
                    this.zzoA.setContext(this.zzzm.zzpH);
                    this.zzoA.zzB(false);
                    this.zzzm.zzzA.addView((View)this.zzoA.getWebView(), this.zzzm.index, this.zzzm.zzzz);
                    this.zzzm = null;
                }
            }
            if (this.zzzk != null && this.zzzk.zzzD != null) {
                this.zzzk.zzzD.zzaV();
            }
        }
    }

    public void zzev() {
        if (this.zzzt) {
            this.zzzt = false;
            this.zzew();
        }
    }

    protected void zzew() {
        this.zzoA.zzew();
    }

    protected void zzv(int n) {
        this.zzoA.zzv(n);
    }

    @zzgd
    static final class zzb
    extends RelativeLayout {
        zzhn zzqn;

        public zzb(Context context, String string) {
            super(context);
            this.zzqn = new zzhn(context, string);
        }

        public boolean onInterceptTouchEvent(MotionEvent event) {
            this.zzqn.zzd(event);
            return false;
        }
    }

    @zzgd
    public static class zzc {
        public final int index;
        public final ViewGroup.LayoutParams zzzz;
        public final ViewGroup zzzA;
        public final Context zzpH;

        public zzc(zzid zzid2) throws zza {
            this.zzzz = zzid2.getLayoutParams();
            ViewParent viewParent = zzid2.getParent();
            this.zzpH = zzid2.zzgC();
            if (viewParent == null || !(viewParent instanceof ViewGroup)) {
                throw new zza("Could not get the parent of the WebView for an overlay.");
            }
            this.zzzA = (ViewGroup)viewParent;
            this.index = this.zzzA.indexOfChild((View)zzid2.getWebView());
            this.zzzA.removeView((View)zzid2.getWebView());
            zzid2.zzB(true);
        }
    }

    @zzgd
    private static final class zza
    extends Exception {
        public zza(String string) {
            super(string);
        }
    }
}

