/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.purchase;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import com.google.android.gms.ads.internal.purchase.zzb;
import com.google.android.gms.ads.internal.purchase.zzf;
import com.google.android.gms.ads.internal.purchase.zzg;
import com.google.android.gms.ads.internal.purchase.zzh;
import com.google.android.gms.ads.internal.purchase.zzk;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.internal.zzfj;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzhh;
import com.google.android.gms.internal.zzhl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@zzgd
public class zzc
extends zzhh
implements ServiceConnection {
    private final Object zzqt = new Object();
    private boolean zzAC = false;
    private Context mContext;
    private zzfj zzAD;
    private zzb zzAE;
    private zzh zzAF;
    private List<zzf> zzAG = null;
    private zzk zzAH;

    public zzc(Context context, zzfj zzfj2, zzk zzk2) {
        this(context, zzfj2, zzk2, new zzb(context), zzh.zzy(context.getApplicationContext()));
    }

    zzc(Context context, zzfj zzfj2, zzk zzk2, zzb zzb2, zzh zzh2) {
        this.mContext = context;
        this.zzAD = zzfj2;
        this.zzAH = zzk2;
        this.zzAE = zzb2;
        this.zzAF = zzh2;
        this.zzAG = this.zzAF.zzf(10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzdP() {
        Object object = this.zzqt;
        synchronized (object) {
            Intent intent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
            intent.setPackage("com.android.vending");
            com.google.android.gms.common.stats.zzb.zzoO().zza(this.mContext, intent, (ServiceConnection)this, 1);
            this.zzd(SystemClock.elapsedRealtime());
            com.google.android.gms.common.stats.zzb.zzoO().zza(this.mContext, (ServiceConnection)this);
            this.zzAE.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzqt;
        synchronized (object) {
            com.google.android.gms.common.stats.zzb.zzoO().zza(this.mContext, (ServiceConnection)this);
            this.zzAE.destroy();
        }
    }

    public void onServiceDisconnected(ComponentName name) {
        com.google.android.gms.ads.internal.util.client.zzb.zzaA("In-app billing service disconnected.");
        this.zzAE.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceConnected(ComponentName name, IBinder service) {
        Object object = this.zzqt;
        synchronized (object) {
            this.zzAE.zzK(service);
            this.zzfe();
            this.zzAC = true;
            this.zzqt.notify();
        }
    }

    protected void zzfe() {
        int n;
        Bundle bundle;
        if (this.zzAG.isEmpty()) {
            return;
        }
        HashMap<String, zzf> hashMap = new HashMap<String, zzf>();
        for (zzf object2 : this.zzAG) {
            hashMap.put(object2.zzAT, object2);
        }
        Object object3 = null;
        while ((bundle = this.zzAE.zzi(this.mContext.getPackageName(), (String)object3)) != null && (n = zzo.zzbF().zzb(bundle)) == 0) {
            ArrayList arrayList = bundle.getStringArrayList("INAPP_PURCHASE_ITEM_LIST");
            ArrayList arrayList2 = bundle.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
            ArrayList arrayList3 = bundle.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
            object3 = bundle.getString("INAPP_CONTINUATION_TOKEN");
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!hashMap.containsKey(arrayList.get(i))) continue;
                String string = (String)arrayList.get(i);
                String string2 = (String)arrayList2.get(i);
                String string3 = (String)arrayList3.get(i);
                zzf zzf2 = (zzf)hashMap.get(string);
                String string4 = zzo.zzbF().zzai(string2);
                if (!zzf2.zzAS.equals(string4)) continue;
                this.zza(zzf2, string2, string3);
                hashMap.remove(string);
            }
            if (object3 != null && !hashMap.isEmpty()) continue;
        }
        for (String string : hashMap.keySet()) {
            this.zzAF.zza((zzf)hashMap.get(string));
        }
    }

    protected void zza(final zzf zzf2, String string, String string2) {
        final Intent intent = new Intent();
        zzo.zzbF();
        intent.putExtra("RESPONSE_CODE", 0);
        zzo.zzbF();
        intent.putExtra("INAPP_PURCHASE_DATA", string);
        zzo.zzbF();
        intent.putExtra("INAPP_DATA_SIGNATURE", string2);
        zzhl.zzGk.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (zzc.this.zzAH.zza(zzf2.zzAS, -1, intent)) {
                        zzc.this.zzAD.zza(new zzg(zzc.this.mContext, zzf2.zzAT, true, -1, intent, zzf2));
                    } else {
                        zzc.this.zzAD.zza(new zzg(zzc.this.mContext, zzf2.zzAT, false, -1, intent, zzf2));
                    }
                }
                catch (RemoteException remoteException) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzaC("Fail to verify and dispatch pending transaction");
                }
            }
        });
    }

    private void zzd(long l) {
        do {
            if (this.zze(l)) continue;
            com.google.android.gms.ads.internal.util.client.zzb.zzaB("Timeout waiting for pending transaction to be processed.");
        } while (!this.zzAC);
    }

    private boolean zze(long l) {
        long l2 = 60000L - (SystemClock.elapsedRealtime() - l);
        if (l2 <= 0L) {
            return false;
        }
        try {
            this.zzqt.wait(l2);
        }
        catch (InterruptedException interruptedException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaC("waitWithTimeout_lock interrupted");
        }
        return true;
    }
}

