/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.internal.zzaj;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzao;
import com.google.android.gms.internal.zzdg;
import com.google.android.gms.internal.zzdo;
import com.google.android.gms.internal.zzds;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzhh;
import com.google.android.gms.internal.zzhp;
import com.google.android.gms.internal.zzid;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzgd
public final class zzdf {
    public static final zzdg zzvV = new zzdg(){

        @Override
        public void zza(zzid zzid2, Map<String, String> map) {
        }
    };
    public static final zzdg zzvW = new zzdg(){

        @Override
        public void zza(zzid zzid2, Map<String, String> map) {
            String string2 = map.get("urls");
            if (TextUtils.isEmpty((CharSequence)string2)) {
                zzb.zzaC("URLs missing in canOpenURLs GMSG.");
                return;
            }
            String[] stringArray = string2.split(",");
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            PackageManager packageManager = zzid2.getContext().getPackageManager();
            for (String string3 : stringArray) {
                String[] stringArray2 = string3.split(";", 2);
                String string4 = stringArray2[0].trim();
                String string5 = stringArray2.length > 1 ? stringArray2[1].trim() : "android.intent.action.VIEW";
                Uri uri = Uri.parse((String)string4);
                Intent intent = new Intent(string5, uri);
                ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 65536);
                hashMap.put(string3, resolveInfo != null);
            }
            zzid2.zzc("openableURLs", hashMap);
        }
    };
    public static final zzdg zzvX = new zzdg(){

        @Override
        public void zza(zzid zzid2, Map<String, String> map) {
            JSONArray jSONArray;
            JSONObject jSONObject;
            PackageManager packageManager = zzid2.getContext().getPackageManager();
            String string2 = map.get("data");
            try {
                jSONObject = new JSONObject(string2);
            }
            catch (JSONException jSONException) {
                zzid2.zzb("openableIntents", new JSONObject());
                return;
            }
            try {
                jSONArray = jSONObject.getJSONArray("intents");
            }
            catch (JSONException jSONException) {
                zzid2.zzb("openableIntents", new JSONObject());
                return;
            }
            JSONObject jSONObject2 = new JSONObject();
            for (int i = 0; i < jSONArray.length(); ++i) {
                ResolveInfo resolveInfo;
                JSONObject jSONObject3;
                try {
                    jSONObject3 = jSONArray.getJSONObject(i);
                }
                catch (JSONException jSONException) {
                    zzb.zzb("Error parsing the intent data.", jSONException);
                    continue;
                }
                String string3 = jSONObject3.optString("id");
                String string4 = jSONObject3.optString("u");
                String string5 = jSONObject3.optString("i");
                String string6 = jSONObject3.optString("m");
                String string7 = jSONObject3.optString("p");
                String string8 = jSONObject3.optString("c");
                String string9 = jSONObject3.optString("f");
                String string10 = jSONObject3.optString("e");
                Intent intent = new Intent();
                if (!TextUtils.isEmpty((CharSequence)string4)) {
                    intent.setData(Uri.parse((String)string4));
                }
                if (!TextUtils.isEmpty((CharSequence)string5)) {
                    intent.setAction(string5);
                }
                if (!TextUtils.isEmpty((CharSequence)string6)) {
                    intent.setType(string6);
                }
                if (!TextUtils.isEmpty((CharSequence)string7)) {
                    intent.setPackage(string7);
                }
                if (!TextUtils.isEmpty((CharSequence)string8) && ((ResolveInfo)(resolveInfo = string8.split("/", 2))).length == 2) {
                    intent.setComponent(new ComponentName((String)resolveInfo[0], (String)resolveInfo[1]));
                }
                boolean bl = (resolveInfo = packageManager.resolveActivity(intent, 65536)) != null;
                try {
                    jSONObject2.put(string3, bl);
                    continue;
                }
                catch (JSONException jSONException) {
                    zzb.zzb("Error constructing openable urls response.", jSONException);
                }
            }
            zzid2.zzb("openableIntents", jSONObject2);
        }
    };
    public static final zzdg zzvY = new zzdg(){

        @Override
        public void zza(zzid zzid2, Map<String, String> map) {
            Object object;
            String string2 = map.get("u");
            if (string2 == null) {
                zzb.zzaC("URL missing from click GMSG.");
                return;
            }
            Uri uri = Uri.parse((String)string2);
            try {
                object = zzid2.zzgH();
                if (object != null && object.zzb(uri)) {
                    uri = object.zza(uri, zzid2.getContext());
                }
            }
            catch (zzao zzao2) {
                zzb.zzaC("Unable to append parameter to URL: " + string2);
            }
            string2 = uri.toString();
            object = new zzhp(zzid2.getContext(), zzid2.zzgI().zzGG, string2);
            ((zzhh)object).zzgi();
        }
    };
    public static final zzdg zzvZ = new zzdg(){

        @Override
        public void zza(zzid zzid2, Map<String, String> map) {
            zzc zzc2 = zzid2.zzgD();
            if (zzc2 != null) {
                zzc2.close();
            } else {
                zzc zzc3 = zzid2.zzgE();
                if (zzc3 != null) {
                    zzc3.close();
                } else {
                    zzb.zzaC("A GMSG tried to close something that wasn't an overlay.");
                }
            }
        }
    };
    public static final zzdg zzwa = new zzdg(){

        @Override
        public void zza(zzid zzid2, Map<String, String> map) {
            zzid2.zzC("1".equals(map.get("custom_close")));
        }
    };
    public static final zzdg zzwb = new zzdg(){

        @Override
        public void zza(zzid zzid2, Map<String, String> map) {
            String string2 = map.get("u");
            if (string2 == null) {
                zzb.zzaC("URL missing from httpTrack GMSG.");
                return;
            }
            zzhp zzhp2 = new zzhp(zzid2.getContext(), zzid2.zzgI().zzGG, string2);
            zzhp2.zzgi();
        }
    };
    public static final zzdg zzwc = new zzdg(){

        @Override
        public void zza(zzid zzid2, Map<String, String> map) {
            zzb.zzaA("Received log message: " + map.get("string"));
        }
    };
    public static final zzdg zzwd = new zzdg(){

        @Override
        public void zza(zzid zzid2, Map<String, String> map) {
            String string2 = map.get("tx");
            String string3 = map.get("ty");
            String string4 = map.get("td");
            try {
                int n = Integer.parseInt(string2);
                int n2 = Integer.parseInt(string3);
                int n3 = Integer.parseInt(string4);
                zzan zzan2 = zzid2.zzgH();
                if (zzan2 != null) {
                    zzaj zzaj2 = zzan2.zzab();
                    zzaj2.zza(n, n2, n3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                zzb.zzaC("Could not parse touch parameters from gmsg.");
            }
        }
    };
    public static final zzdg zzwe = new zzdo();
    public static final zzdg zzwf = new zzds();
}

