/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.internal.zzdg;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzhk;
import com.google.android.gms.internal.zzhl;
import com.google.android.gms.internal.zzid;
import java.io.BufferedOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzgd
public class zzdh
implements zzdg {
    private final Context mContext;
    private final VersionInfoParcel zzoM;

    public zzdh(Context context, VersionInfoParcel versionInfoParcel) {
        this.mContext = context;
        this.zzoM = versionInfoParcel;
    }

    protected zzb zzb(JSONObject jSONObject) {
        String string2 = jSONObject.optString("http_request_id");
        String string3 = jSONObject.optString("url");
        String string4 = jSONObject.optString("post_body", null);
        URL uRL = null;
        try {
            uRL = new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzb("Error constructing http request.", malformedURLException);
        }
        ArrayList<zza> arrayList = new ArrayList<zza>();
        JSONArray jSONArray = jSONObject.optJSONArray("headers");
        if (jSONArray == null) {
            jSONArray = new JSONArray();
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.optJSONObject(i);
            if (jSONObject2 == null) continue;
            String string5 = jSONObject2.optString("key");
            String string6 = jSONObject2.optString("value");
            arrayList.add(new zza(string5, string6));
        }
        return new zzb(string2, uRL, arrayList, string4);
    }

    protected JSONObject zza(zzd zzd2) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("http_request_id", (Object)zzd2.zzdJ());
            if (zzd2.getBody() != null) {
                jSONObject.put("body", (Object)zzd2.getBody());
            }
            JSONArray jSONArray = new JSONArray();
            for (zza zza2 : zzd2.zzdO()) {
                jSONArray.put((Object)new JSONObject().put("key", (Object)zza2.getKey()).put("value", (Object)zza2.getValue()));
            }
            jSONObject.put("headers", (Object)jSONArray);
            jSONObject.put("response_code", zzd2.getResponseCode());
        }
        catch (JSONException jSONException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzb("Error constructing JSON for http response.", jSONException);
        }
        return jSONObject;
    }

    protected zzc zza(zzb zzb2) {
        try {
            Object object;
            HttpURLConnection httpURLConnection = (HttpURLConnection)zzb2.zzdK().openConnection();
            zzo.zzbv().zza(this.mContext, this.zzoM.zzGG, false, httpURLConnection);
            for (zza object22 : zzb2.zzdL()) {
                httpURLConnection.addRequestProperty(object22.getKey(), object22.getValue());
            }
            if (!TextUtils.isEmpty((CharSequence)zzb2.zzdM())) {
                httpURLConnection.setDoOutput(true);
                object = zzb2.zzdM().getBytes();
                httpURLConnection.setFixedLengthStreamingMode(((Object)object).length);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
                bufferedOutputStream.write((byte[])object);
                bufferedOutputStream.close();
            }
            object = new ArrayList();
            if (httpURLConnection.getHeaderFields() != null) {
                for (Map.Entry<String, List<String>> entry : httpURLConnection.getHeaderFields().entrySet()) {
                    for (String string2 : entry.getValue()) {
                        ((ArrayList)object).add(new zza(entry.getKey(), string2));
                    }
                }
            }
            zzd zzd2 = new zzd(zzb2.zzdJ(), httpURLConnection.getResponseCode(), (List<zza>)object, zzo.zzbv().zza(new InputStreamReader(httpURLConnection.getInputStream())));
            return new zzc(true, zzd2, null);
        }
        catch (Exception exception) {
            return new zzc(false, null, exception.toString());
        }
    }

    public JSONObject zzT(String string2) {
        JSONObject jSONObject;
        try {
            jSONObject = new JSONObject(string2);
        }
        catch (JSONException jSONException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaz("The request is not a valid JSON.");
            try {
                return new JSONObject().put("success", false);
            }
            catch (JSONException jSONException2) {
                return new JSONObject();
            }
        }
        JSONObject jSONObject2 = new JSONObject();
        String string3 = "";
        try {
            string3 = jSONObject.optString("http_request_id");
            zzb zzb2 = this.zzb(jSONObject);
            zzc zzc2 = this.zza(zzb2);
            if (zzc2.isSuccess()) {
                JSONObject jSONObject3 = this.zza(zzc2.zzdN());
                jSONObject2.put("response", (Object)jSONObject3);
                jSONObject2.put("success", true);
            } else {
                jSONObject2.put("response", (Object)new JSONObject().put("http_request_id", (Object)string3));
                jSONObject2.put("success", false);
                jSONObject2.put("reason", (Object)zzc2.getReason());
            }
        }
        catch (Exception exception) {
            try {
                jSONObject2.put("response", (Object)new JSONObject().put("http_request_id", (Object)string3));
                jSONObject2.put("success", false);
                jSONObject2.put("reason", (Object)exception.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return jSONObject2;
    }

    @Override
    public void zza(final zzid zzid2, final Map<String, String> map) {
        zzhk.zza(new Runnable(){

            @Override
            public void run() {
                com.google.android.gms.ads.internal.util.client.zzb.zzay("Received Http request.");
                String string2 = (String)map.get("http_request");
                final JSONObject jSONObject = zzdh.this.zzT(string2);
                if (jSONObject == null) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzaz("Response should not be null.");
                    return;
                }
                zzhl.zzGk.post(new Runnable(){

                    @Override
                    public void run() {
                        zzid2.zzb("fetchHttpRequestCompleted", jSONObject);
                        com.google.android.gms.ads.internal.util.client.zzb.zzay("Dispatched http response.");
                    }
                });
            }
        });
    }

    @zzgd
    class zzc {
        private final zzd zzwp;
        private final boolean zzwq;
        private final String zzwr;

        public zzc(boolean bl, zzd zzd2, String string2) {
            this.zzwq = bl;
            this.zzwp = zzd2;
            this.zzwr = string2;
        }

        public String getReason() {
            return this.zzwr;
        }

        public zzd zzdN() {
            return this.zzwp;
        }

        public boolean isSuccess() {
            return this.zzwq;
        }
    }

    @zzgd
    static class zzd {
        private final String zzwl;
        private final int zzws;
        private final List<zza> zzwt;
        private final String zzvj;

        public zzd(String string2, int n, List<zza> list, String string3) {
            this.zzwl = string2;
            this.zzws = n;
            this.zzwt = list == null ? new ArrayList<zza>() : list;
            this.zzvj = string3;
        }

        public String zzdJ() {
            return this.zzwl;
        }

        public int getResponseCode() {
            return this.zzws;
        }

        public Iterable<zza> zzdO() {
            return this.zzwt;
        }

        public String getBody() {
            return this.zzvj;
        }
    }

    @zzgd
    static class zzb {
        private final String zzwl;
        private final URL zzwm;
        private final ArrayList<zza> zzwn;
        private final String zzwo;

        public zzb(String string2, URL uRL, ArrayList<zza> arrayList, String string3) {
            this.zzwl = string2;
            this.zzwm = uRL;
            this.zzwn = arrayList == null ? new ArrayList() : arrayList;
            this.zzwo = string3;
        }

        public String zzdJ() {
            return this.zzwl;
        }

        public URL zzdK() {
            return this.zzwm;
        }

        public ArrayList<zza> zzdL() {
            return this.zzwn;
        }

        public String zzdM() {
            return this.zzwo;
        }
    }

    @zzgd
    static class zza {
        private final String zztw;
        private final String mValue;

        public zza(String string2, String string3) {
            this.zztw = string2;
            this.mValue = string3;
        }

        public String getKey() {
            return this.zztw;
        }

        public String getValue() {
            return this.mValue;
        }
    }
}

