/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.internal.DataItemAssetParcelable;
import com.google.android.gms.wearable.zzf;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class PutDataRequest
implements SafeParcelable {
    public static final String WEAR_URI_SCHEME = "wear";
    public static final Parcelable.Creator<PutDataRequest> CREATOR = new zzf();
    private static final Random zzaSX = new SecureRandom();
    final int zzCY;
    private final Uri mUri;
    private final Bundle zzaSY;
    private byte[] zzauL;

    PutDataRequest(int versionCode, Uri uri, Bundle assets, byte[] data) {
        this.zzCY = versionCode;
        this.mUri = uri;
        this.zzaSY = assets;
        this.zzaSY.setClassLoader(DataItemAssetParcelable.class.getClassLoader());
        this.zzauL = data;
    }

    private PutDataRequest(int versionCode, Uri uri) {
        this(versionCode, uri, new Bundle(), null);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzf.zza(this, dest, flags);
    }

    public static PutDataRequest createFromDataItem(DataItem source) {
        PutDataRequest putDataRequest = PutDataRequest.zzn(source.getUri());
        for (Map.Entry<String, DataItemAsset> entry : source.getAssets().entrySet()) {
            if (entry.getValue().getId() == null) {
                throw new IllegalStateException("Cannot create an asset for a put request without a digest: " + entry.getKey());
            }
            putDataRequest.putAsset(entry.getKey(), Asset.createFromRef(entry.getValue().getId()));
        }
        putDataRequest.setData(source.getData());
        return putDataRequest;
    }

    public static PutDataRequest zzn(Uri uri) {
        return new PutDataRequest(1, uri);
    }

    public static PutDataRequest createWithAutoAppendedId(String pathPrefix) {
        StringBuilder stringBuilder = new StringBuilder(pathPrefix);
        if (!pathPrefix.endsWith("/")) {
            stringBuilder.append("/");
        }
        stringBuilder.append("PN").append(zzaSX.nextLong());
        Uri uri = PutDataRequest.zzfg(stringBuilder.toString());
        return new PutDataRequest(1, uri);
    }

    public static PutDataRequest create(String path) {
        Uri uri = PutDataRequest.zzfg(path);
        return PutDataRequest.zzn(uri);
    }

    private static Uri zzfg(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("An empty path was supplied.");
        }
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException("A path must start with a single / .");
        }
        if (string.startsWith("//")) {
            throw new IllegalArgumentException("A path must start with a single / .");
        }
        return new Uri.Builder().scheme(WEAR_URI_SCHEME).path(string).build();
    }

    public Uri getUri() {
        return this.mUri;
    }

    public byte[] getData() {
        return this.zzauL;
    }

    public PutDataRequest setData(byte[] data) {
        this.zzauL = data;
        return this;
    }

    public Map<String, Asset> getAssets() {
        HashMap<String, Asset> hashMap = new HashMap<String, Asset>();
        for (String string : this.zzaSY.keySet()) {
            hashMap.put(string, (Asset)this.zzaSY.getParcelable(string));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public Bundle zzAR() {
        return this.zzaSY;
    }

    public Asset getAsset(String key) {
        return (Asset)this.zzaSY.getParcelable(key);
    }

    public boolean hasAsset(String key) {
        return this.zzaSY.containsKey(key);
    }

    public PutDataRequest putAsset(String key, Asset value) {
        zzu.zzu((Object)key);
        zzu.zzu((Object)value);
        this.zzaSY.putParcelable(key, (Parcelable)value);
        return this;
    }

    public PutDataRequest removeAsset(String key) {
        this.zzaSY.remove(key);
        return this;
    }

    public String toString() {
        return this.toString(Log.isLoggable((String)"DataMap", (int)3));
    }

    public String toString(boolean verbose) {
        StringBuilder stringBuilder = new StringBuilder("PutDataRequest[");
        stringBuilder.append("dataSz=" + (this.zzauL == null ? "null" : Integer.valueOf(this.zzauL.length)));
        stringBuilder.append(", numAssets=" + this.zzaSY.size());
        stringBuilder.append(", uri=" + this.mUri);
        if (!verbose) {
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        stringBuilder.append("]\n  assets: ");
        Set set = this.zzaSY.keySet();
        for (String string : set) {
            stringBuilder.append("\n    " + string + ": " + this.zzaSY.getParcelable(string));
        }
        stringBuilder.append("\n  ]");
        return stringBuilder.toString();
    }
}

