/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;

public class ImageTypeSpecifier {
    protected ColorModel colorModel;
    protected SampleModel sampleModel;

    public ImageTypeSpecifier(ColorModel colorModel, SampleModel sampleModel) {
    }

    public ImageTypeSpecifier(RenderedImage renderedImage) {
    }

    public static ImageTypeSpecifier createPacked(ColorSpace colorSpace, int n, int n2, int n3, int n4, int n5, boolean bl) {
        return null;
    }

    public static ImageTypeSpecifier createInterleaved(ColorSpace colorSpace, int[] nArray, int n, boolean bl, boolean bl2) {
        return null;
    }

    public static ImageTypeSpecifier createBanded(ColorSpace colorSpace, int[] nArray, int[] nArray2, int n, boolean bl, boolean bl2) {
        return null;
    }

    public static ImageTypeSpecifier createGrayscale(int n, int n2, boolean bl) {
        return null;
    }

    public static ImageTypeSpecifier createGrayscale(int n, int n2, boolean bl, boolean bl2) {
        return null;
    }

    public static ImageTypeSpecifier createIndexed(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n, int n2) {
        return null;
    }

    public static ImageTypeSpecifier createFromBufferedImageType(int n) {
        return null;
    }

    public static ImageTypeSpecifier createFromRenderedImage(RenderedImage renderedImage) {
        return null;
    }

    public int getBufferedImageType() {
        return 0;
    }

    public int getNumComponents() {
        return 0;
    }

    public int getNumBands() {
        return 0;
    }

    public int getBitsPerBand(int n) {
        return 0;
    }

    public SampleModel getSampleModel() {
        return null;
    }

    public SampleModel getSampleModel(int n, int n2) {
        return null;
    }

    public ColorModel getColorModel() {
        return null;
    }

    public BufferedImage createBufferedImage(int n, int n2) {
        return null;
    }

    public boolean equals(Object object) {
        return false;
    }

    public int hashCode() {
        return 0;
    }

    static class Banded
    extends ImageTypeSpecifier {
        ColorSpace colorSpace;
        int[] bankIndices;
        int[] bandOffsets;
        int dataType;
        boolean hasAlpha;
        boolean isAlphaPremultiplied;

        public Banded(ColorSpace colorSpace, int[] bankIndices, int[] bandOffsets, int dataType, boolean hasAlpha, boolean isAlphaPremultiplied) {
            if (colorSpace == null) {
                throw new IllegalArgumentException("colorSpace == null!");
            }
            if (bankIndices == null) {
                throw new IllegalArgumentException("bankIndices == null!");
            }
            if (bandOffsets == null) {
                throw new IllegalArgumentException("bandOffsets == null!");
            }
            if (bankIndices.length != bandOffsets.length) {
                throw new IllegalArgumentException("bankIndices.length != bandOffsets.length!");
            }
            if (dataType != 0 && dataType != 2 && dataType != 1 && dataType != 3 && dataType != 4 && dataType != 5) {
                throw new IllegalArgumentException("Bad value for dataType!");
            }
            int numBands = colorSpace.getNumComponents() + (hasAlpha ? 1 : 0);
            if (bandOffsets.length != numBands) {
                throw new IllegalArgumentException("bandOffsets.length is wrong!");
            }
            this.colorSpace = colorSpace;
            this.bankIndices = (int[])bankIndices.clone();
            this.bandOffsets = (int[])bandOffsets.clone();
            this.dataType = dataType;
            this.hasAlpha = hasAlpha;
            this.isAlphaPremultiplied = isAlphaPremultiplied;
            this.colorModel = ImageTypeSpecifier.createComponentCM((ColorSpace)colorSpace, (int)bankIndices.length, (int)dataType, (boolean)hasAlpha, (boolean)isAlphaPremultiplied);
            int w = 1;
            int h = 1;
            this.sampleModel = new BandedSampleModel(dataType, w, h, w, bankIndices, bandOffsets);
        }

        @Override
        public boolean equals(Object o) {
            int i;
            if (!(o instanceof Banded)) {
                return false;
            }
            Banded that = (Banded)o;
            if (!this.colorSpace.equals(that.colorSpace) || this.dataType != that.dataType || this.hasAlpha != that.hasAlpha || this.isAlphaPremultiplied != that.isAlphaPremultiplied || this.bankIndices.length != that.bankIndices.length || this.bandOffsets.length != that.bandOffsets.length) {
                return false;
            }
            for (i = 0; i < this.bankIndices.length; ++i) {
                if (this.bankIndices[i] == that.bankIndices[i]) continue;
                return false;
            }
            for (i = 0; i < this.bandOffsets.length; ++i) {
                if (this.bandOffsets[i] == that.bandOffsets[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 3 * this.bandOffsets.length + 7 * this.bankIndices.length + 21 * this.dataType + (this.hasAlpha ? 19 : 29);
        }
    }

    static class Grayscale
    extends ImageTypeSpecifier {
        int bits;
        int dataType;
        boolean isSigned;
        boolean hasAlpha;
        boolean isAlphaPremultiplied;

        public Grayscale(int bits, int dataType, boolean isSigned, boolean hasAlpha, boolean isAlphaPremultiplied) {
            if (bits != 1 && bits != 2 && bits != 4 && bits != 8 && bits != 16) {
                throw new IllegalArgumentException("Bad value for bits!");
            }
            if (dataType != 0 && dataType != 2 && dataType != 1) {
                throw new IllegalArgumentException("Bad value for dataType!");
            }
            if (bits > 8 && dataType == 0) {
                throw new IllegalArgumentException("Too many bits for dataType!");
            }
            this.bits = bits;
            this.dataType = dataType;
            this.isSigned = isSigned;
            this.hasAlpha = hasAlpha;
            this.isAlphaPremultiplied = isAlphaPremultiplied;
            ColorSpace colorSpace = ColorSpace.getInstance(1003);
            if (bits == 8 && dataType == 0 || bits == 16 && (dataType == 2 || dataType == 1)) {
                int numBands = hasAlpha ? 2 : 1;
                int transparency = hasAlpha ? 3 : 1;
                int[] nBits = new int[numBands];
                nBits[0] = bits;
                if (numBands == 2) {
                    nBits[1] = bits;
                }
                this.colorModel = new ComponentColorModel(colorSpace, nBits, hasAlpha, isAlphaPremultiplied, transparency, dataType);
                int[] bandOffsets = new int[numBands];
                bandOffsets[0] = 0;
                if (numBands == 2) {
                    bandOffsets[1] = 1;
                }
                int w = 1;
                int h = 1;
                this.sampleModel = new PixelInterleavedSampleModel(dataType, w, h, numBands, w * numBands, bandOffsets);
            } else {
                int numEntries = 1 << bits;
                byte[] arr = new byte[numEntries];
                for (int i = 0; i < numEntries; ++i) {
                    arr[i] = (byte)(i * 255 / (numEntries - 1));
                }
                this.colorModel = new IndexColorModel(bits, numEntries, arr, arr, arr);
                this.sampleModel = new MultiPixelPackedSampleModel(dataType, 1, 1, bits);
            }
        }
    }

    static class Indexed
    extends ImageTypeSpecifier {
        byte[] redLUT;
        byte[] greenLUT;
        byte[] blueLUT;
        byte[] alphaLUT = null;
        int bits;
        int dataType;

        public Indexed(byte[] redLUT, byte[] greenLUT, byte[] blueLUT, byte[] alphaLUT, int bits, int dataType) {
            if (redLUT == null || greenLUT == null || blueLUT == null) {
                throw new IllegalArgumentException("LUT is null!");
            }
            if (bits != 1 && bits != 2 && bits != 4 && bits != 8 && bits != 16) {
                throw new IllegalArgumentException("Bad value for bits!");
            }
            if (dataType != 0 && dataType != 2 && dataType != 1 && dataType != 3) {
                throw new IllegalArgumentException("Bad value for dataType!");
            }
            if (bits > 8 && dataType == 0 || bits > 16 && dataType != 3) {
                throw new IllegalArgumentException("Too many bits for dataType!");
            }
            int len = 1 << bits;
            if (redLUT.length != len || greenLUT.length != len || blueLUT.length != len || alphaLUT != null && alphaLUT.length != len) {
                throw new IllegalArgumentException("LUT has improper length!");
            }
            this.redLUT = (byte[])redLUT.clone();
            this.greenLUT = (byte[])greenLUT.clone();
            this.blueLUT = (byte[])blueLUT.clone();
            if (alphaLUT != null) {
                this.alphaLUT = (byte[])alphaLUT.clone();
            }
            this.bits = bits;
            this.dataType = dataType;
            this.colorModel = alphaLUT == null ? new IndexColorModel(bits, redLUT.length, redLUT, greenLUT, blueLUT) : new IndexColorModel(bits, redLUT.length, redLUT, greenLUT, blueLUT, alphaLUT);
            if (bits == 8 && dataType == 0 || bits == 16 && (dataType == 2 || dataType == 1)) {
                int[] bandOffsets = new int[]{0};
                this.sampleModel = new PixelInterleavedSampleModel(dataType, 1, 1, 1, 1, bandOffsets);
            } else {
                this.sampleModel = new MultiPixelPackedSampleModel(dataType, 1, 1, bits);
            }
        }
    }

    static class Interleaved
    extends ImageTypeSpecifier {
        ColorSpace colorSpace;
        int[] bandOffsets;
        int dataType;
        boolean hasAlpha;
        boolean isAlphaPremultiplied;

        public Interleaved(ColorSpace colorSpace, int[] bandOffsets, int dataType, boolean hasAlpha, boolean isAlphaPremultiplied) {
            int minBandOffset;
            if (colorSpace == null) {
                throw new IllegalArgumentException("colorSpace == null!");
            }
            if (bandOffsets == null) {
                throw new IllegalArgumentException("bandOffsets == null!");
            }
            int numBands = colorSpace.getNumComponents() + (hasAlpha ? 1 : 0);
            if (bandOffsets.length != numBands) {
                throw new IllegalArgumentException("bandOffsets.length is wrong!");
            }
            if (dataType != 0 && dataType != 2 && dataType != 1 && dataType != 3 && dataType != 4 && dataType != 5) {
                throw new IllegalArgumentException("Bad value for dataType!");
            }
            this.colorSpace = colorSpace;
            this.bandOffsets = (int[])bandOffsets.clone();
            this.dataType = dataType;
            this.hasAlpha = hasAlpha;
            this.isAlphaPremultiplied = isAlphaPremultiplied;
            this.colorModel = ImageTypeSpecifier.createComponentCM((ColorSpace)colorSpace, (int)bandOffsets.length, (int)dataType, (boolean)hasAlpha, (boolean)isAlphaPremultiplied);
            int maxBandOffset = minBandOffset = bandOffsets[0];
            for (int i = 0; i < bandOffsets.length; ++i) {
                int offset = bandOffsets[i];
                minBandOffset = Math.min(offset, minBandOffset);
                maxBandOffset = Math.max(offset, maxBandOffset);
            }
            int pixelStride = maxBandOffset - minBandOffset + 1;
            int w = 1;
            int h = 1;
            this.sampleModel = new PixelInterleavedSampleModel(dataType, w, h, pixelStride, w * pixelStride, bandOffsets);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Interleaved)) {
                return false;
            }
            Interleaved that = (Interleaved)o;
            if (!this.colorSpace.equals(that.colorSpace) || this.dataType != that.dataType || this.hasAlpha != that.hasAlpha || this.isAlphaPremultiplied != that.isAlphaPremultiplied || this.bandOffsets.length != that.bandOffsets.length) {
                return false;
            }
            for (int i = 0; i < this.bandOffsets.length; ++i) {
                if (this.bandOffsets[i] == that.bandOffsets[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 4 * this.bandOffsets.length + 25 * this.dataType + (this.hasAlpha ? 17 : 18);
        }
    }

    static class Packed
    extends ImageTypeSpecifier {
        ColorSpace colorSpace;
        int redMask;
        int greenMask;
        int blueMask;
        int alphaMask;
        int transferType;
        boolean isAlphaPremultiplied;

        public Packed(ColorSpace colorSpace, int redMask, int greenMask, int blueMask, int alphaMask, int transferType, boolean isAlphaPremultiplied) {
            if (colorSpace == null) {
                throw new IllegalArgumentException("colorSpace == null!");
            }
            if (colorSpace.getType() != 5) {
                throw new IllegalArgumentException("colorSpace is not of type TYPE_RGB!");
            }
            if (transferType != 0 && transferType != 1 && transferType != 3) {
                throw new IllegalArgumentException("Bad value for transferType!");
            }
            if (redMask == 0 && greenMask == 0 && blueMask == 0 && alphaMask == 0) {
                throw new IllegalArgumentException("No mask has at least 1 bit set!");
            }
            this.colorSpace = colorSpace;
            this.redMask = redMask;
            this.greenMask = greenMask;
            this.blueMask = blueMask;
            this.alphaMask = alphaMask;
            this.transferType = transferType;
            this.isAlphaPremultiplied = isAlphaPremultiplied;
            int bits = 32;
            this.colorModel = new DirectColorModel(colorSpace, bits, redMask, greenMask, blueMask, alphaMask, isAlphaPremultiplied, transferType);
            this.sampleModel = this.colorModel.createCompatibleSampleModel(1, 1);
        }
    }
}

