/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.TooManyListenersException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import jdk.internal.access.JavaSecurityAccess;
import jdk.internal.access.SharedSecrets;
import sun.awt.AWTAccessor;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.reflect.misc.MethodUtil;
import sun.swing.SwingAccessor;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public class TransferHandler
implements Serializable {
    public static final int NONE = 0;
    public static final int COPY = 1;
    public static final int MOVE = 2;
    public static final int COPY_OR_MOVE = 3;

    public static Action getCutAction() {
        return null;
    }

    public static Action getCopyAction() {
        return null;
    }

    public static Action getPasteAction() {
        return null;
    }

    public TransferHandler(String string) {
    }

    protected TransferHandler() {
    }

    public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
    }

    public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) throws IllegalStateException {
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        return false;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        return false;
    }

    public int getSourceActions(JComponent jComponent) {
        return 0;
    }

    public Icon getVisualRepresentation(Transferable transferable) {
        return null;
    }

    protected Transferable createTransferable(JComponent jComponent) {
        return null;
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
    }

    private static class DragHandler
    implements DragGestureListener,
    DragSourceListener {
        private boolean scrolls;

        private DragHandler() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            JComponent c = (JComponent)dge.getComponent();
            TransferHandler th = c.getTransferHandler();
            Transferable t = th.createTransferable(c);
            if (t != null) {
                this.scrolls = c.getAutoscrolls();
                c.setAutoscrolls(false);
                try {
                    Image im = th.getDragImage();
                    if (im == null) {
                        dge.startDrag(null, t, this);
                    } else {
                        dge.startDrag(null, im, th.getDragImageOffset(), t, this);
                    }
                    return;
                }
                catch (RuntimeException re) {
                    c.setAutoscrolls(this.scrolls);
                }
            }
            th.exportDone(c, t, 0);
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dsde) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            DragSourceContext dsc = dsde.getDragSourceContext();
            JComponent c = (JComponent)dsc.getComponent();
            if (dsde.getDropSuccess()) {
                c.getTransferHandler().exportDone(c, dsc.getTransferable(), dsde.getDropAction());
            } else {
                c.getTransferHandler().exportDone(c, dsc.getTransferable(), 0);
            }
            c.setAutoscrolls(this.scrolls);
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }
    }

    private static class DropHandler
    implements DropTargetListener,
    Serializable,
    ActionListener {
        private Timer timer;
        private Point lastPosition;
        private Rectangle outer = new Rectangle();
        private Rectangle inner = new Rectangle();
        private int hysteresis = 10;
        private Component component;
        private Object state;
        private TransferSupport support = new TransferSupport(null, (DropTargetEvent)null);
        private static final int AUTOSCROLL_INSET = 10;

        private DropHandler() {
        }

        private void updateAutoscrollRegion(JComponent c) {
            Rectangle visible = c.getVisibleRect();
            this.outer.setBounds(visible.x, visible.y, visible.width, visible.height);
            Insets i = new Insets(0, 0, 0, 0);
            if (c instanceof Scrollable) {
                int minSize = 20;
                if (visible.width >= minSize) {
                    i.right = 10;
                    i.left = 10;
                }
                if (visible.height >= minSize) {
                    i.bottom = 10;
                    i.top = 10;
                }
            }
            this.inner.setBounds(visible.x + i.left, visible.y + i.top, visible.width - (i.left + i.right), visible.height - (i.top + i.bottom));
        }

        private void autoscroll(JComponent c, Point pos) {
            if (c instanceof Scrollable) {
                Rectangle r;
                Scrollable s = (Scrollable)((Object)c);
                if (pos.y < this.inner.y) {
                    dy = s.getScrollableUnitIncrement(this.outer, 1, -1);
                    r = new Rectangle(this.inner.x, this.outer.y - dy, this.inner.width, dy);
                    c.scrollRectToVisible(r);
                } else if (pos.y > this.inner.y + this.inner.height) {
                    dy = s.getScrollableUnitIncrement(this.outer, 1, 1);
                    r = new Rectangle(this.inner.x, this.outer.y + this.outer.height, this.inner.width, dy);
                    c.scrollRectToVisible(r);
                }
                if (pos.x < this.inner.x) {
                    dx = s.getScrollableUnitIncrement(this.outer, 0, -1);
                    r = new Rectangle(this.outer.x - dx, this.inner.y, dx, this.inner.height);
                    c.scrollRectToVisible(r);
                } else if (pos.x > this.inner.x + this.inner.width) {
                    dx = s.getScrollableUnitIncrement(this.outer, 0, 1);
                    r = new Rectangle(this.outer.x + this.outer.width, this.inner.y, dx, this.inner.height);
                    c.scrollRectToVisible(r);
                }
            }
        }

        private void initPropertiesIfNecessary() {
            if (this.timer == null) {
                Toolkit t = Toolkit.getDefaultToolkit();
                Integer prop = (Integer)t.getDesktopProperty("DnD.Autoscroll.interval");
                this.timer = new Timer(prop == null ? 100 : prop, this);
                prop = (Integer)t.getDesktopProperty("DnD.Autoscroll.initialDelay");
                this.timer.setInitialDelay(prop == null ? 100 : prop);
                prop = (Integer)t.getDesktopProperty("DnD.Autoscroll.cursorHysteresis");
                if (prop != null) {
                    this.hysteresis = prop;
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.updateAutoscrollRegion((JComponent)this.component);
            if (this.outer.contains(this.lastPosition) && !this.inner.contains(this.lastPosition)) {
                this.autoscroll((JComponent)this.component, this.lastPosition);
            }
        }

        private void setComponentDropLocation(TransferSupport support, boolean forDrop) {
            DropLocation dropLocation;
            DropLocation dropLocation2 = dropLocation = support == null ? null : support.getDropLocation();
            if (SunToolkit.isInstanceOf(this.component, "javax.swing.text.JTextComponent")) {
                this.state = SwingAccessor.getJTextComponentAccessor().setDropLocation((JTextComponent)this.component, dropLocation, this.state, forDrop);
            } else if (this.component instanceof JComponent) {
                this.state = ((JComponent)this.component).setDropLocation(dropLocation, this.state, forDrop);
            }
        }

        private void handleDrag(DropTargetDragEvent e) {
            TransferHandler importer = ((HasGetTransferHandler)((Object)this.component)).getTransferHandler();
            if (importer == null) {
                e.rejectDrag();
                this.setComponentDropLocation(null, false);
                return;
            }
            this.support.setDNDVariables(this.component, e);
            boolean canImport = importer.canImport(this.support);
            if (canImport) {
                e.acceptDrag(this.support.getDropAction());
            } else {
                e.rejectDrag();
            }
            boolean showLocation = this.support.showDropLocationIsSet ? this.support.showDropLocation : canImport;
            this.setComponentDropLocation(showLocation ? this.support : null, false);
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            this.state = null;
            this.component = e.getDropTargetContext().getComponent();
            this.handleDrag(e);
            if (this.component instanceof JComponent) {
                this.lastPosition = e.getLocation();
                this.updateAutoscrollRegion((JComponent)this.component);
                this.initPropertiesIfNecessary();
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            this.handleDrag(e);
            if (!(this.component instanceof JComponent)) {
                return;
            }
            Point p = e.getLocation();
            if (Math.abs(p.x - this.lastPosition.x) > this.hysteresis || Math.abs(p.y - this.lastPosition.y) > this.hysteresis) {
                if (this.timer.isRunning()) {
                    this.timer.stop();
                }
            } else if (!this.timer.isRunning()) {
                this.timer.start();
            }
            this.lastPosition = p;
        }

        @Override
        public void dragExit(DropTargetEvent e) {
            this.cleanup(false);
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            TransferHandler importer = ((HasGetTransferHandler)((Object)this.component)).getTransferHandler();
            if (importer == null) {
                e.rejectDrop();
                this.cleanup(false);
                return;
            }
            this.support.setDNDVariables(this.component, e);
            boolean canImport = importer.canImport(this.support);
            if (canImport) {
                boolean success;
                e.acceptDrop(this.support.getDropAction());
                boolean showLocation = this.support.showDropLocationIsSet ? this.support.showDropLocation : canImport;
                this.setComponentDropLocation(showLocation ? this.support : null, false);
                try {
                    success = importer.importData(this.support);
                }
                catch (RuntimeException re) {
                    success = false;
                }
                e.dropComplete(success);
                this.cleanup(success);
            } else {
                e.rejectDrop();
                this.cleanup(false);
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
            if (this.component == null) {
                return;
            }
            this.handleDrag(e);
        }

        private void cleanup(boolean forDrop) {
            this.setComponentDropLocation(null, forDrop);
            if (this.component instanceof JComponent) {
                ((JComponent)this.component).dndDone();
            }
            if (this.timer != null) {
                this.timer.stop();
            }
            this.state = null;
            this.component = null;
            this.lastPosition = null;
        }
    }

    static class PropertyTransferable
    implements Transferable {
        JComponent component;
        PropertyDescriptor property;

        PropertyTransferable(PropertyDescriptor p, JComponent c) {
            this.property = p;
            this.component = c;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] flavors = new DataFlavor[1];
            Class<?> propertyType = this.property.getPropertyType();
            String mimeType = "application/x-java-jvm-local-objectref;class=" + propertyType.getName();
            try {
                flavors[0] = new DataFlavor(mimeType);
            }
            catch (ClassNotFoundException cnfe) {
                flavors = new DataFlavor[]{};
            }
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            Class<?> propertyType = this.property.getPropertyType();
            return "application".equals(flavor.getPrimaryType()) && "x-java-jvm-local-objectref".equals(flavor.getSubType()) && flavor.getRepresentationClass().isAssignableFrom(propertyType);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            Method reader = this.property.getReadMethod();
            Object value = null;
            try {
                value = MethodUtil.invoke(reader, this.component, null);
            }
            catch (Exception ex) {
                throw new IOException("Property read failed: " + this.property.getName());
            }
            return value;
        }
    }

    private static class SwingDragGestureRecognizer
    extends DragGestureRecognizer {
        SwingDragGestureRecognizer(DragGestureListener dgl) {
            super(DragSource.getDefaultDragSource(), null, 0, dgl);
        }

        void gestured(JComponent c, MouseEvent e, int srcActions, int action) {
            this.setComponent(c);
            this.setSourceActions(srcActions);
            this.appendEvent(e);
            this.fireDragGestureRecognized(action, e.getPoint());
        }

        @Override
        protected void registerListeners() {
        }

        @Override
        protected void unregisterListeners() {
        }
    }

    static class SwingDropTarget
    extends DropTarget
    implements UIResource {
        private EventListenerList listenerList;

        SwingDropTarget(Component c) {
            super(c, 0x40000003, null);
            try {
                super.addDropTargetListener(TransferHandler.getDropTargetListener());
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
        }

        @Override
        public void addDropTargetListener(DropTargetListener dtl) throws TooManyListenersException {
            if (this.listenerList == null) {
                this.listenerList = new EventListenerList();
            }
            this.listenerList.add(DropTargetListener.class, dtl);
        }

        @Override
        public void removeDropTargetListener(DropTargetListener dtl) {
            if (this.listenerList != null) {
                this.listenerList.remove(DropTargetListener.class, dtl);
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            super.dragEnter(e);
            if (this.listenerList != null) {
                Object[] listeners = this.listenerList.getListenerList();
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != DropTargetListener.class) continue;
                    ((DropTargetListener)listeners[i + 1]).dragEnter(e);
                }
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            super.dragOver(e);
            if (this.listenerList != null) {
                Object[] listeners = this.listenerList.getListenerList();
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != DropTargetListener.class) continue;
                    ((DropTargetListener)listeners[i + 1]).dragOver(e);
                }
            }
        }

        @Override
        public void dragExit(DropTargetEvent e) {
            DropTargetListener dtListener;
            super.dragExit(e);
            if (this.listenerList != null) {
                Object[] listeners = this.listenerList.getListenerList();
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != DropTargetListener.class) continue;
                    ((DropTargetListener)listeners[i + 1]).dragExit(e);
                }
            }
            if (!this.isActive() && (dtListener = TransferHandler.getDropTargetListener()) instanceof DropHandler) {
                DropHandler dropHandler = (DropHandler)dtListener;
                dropHandler.cleanup(false);
            }
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            super.drop(e);
            if (this.listenerList != null) {
                Object[] listeners = this.listenerList.getListenerList();
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != DropTargetListener.class) continue;
                    ((DropTargetListener)listeners[i + 1]).drop(e);
                }
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
            super.dropActionChanged(e);
            if (this.listenerList != null) {
                Object[] listeners = this.listenerList.getListenerList();
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != DropTargetListener.class) continue;
                    ((DropTargetListener)listeners[i + 1]).dropActionChanged(e);
                }
            }
        }
    }

    static class TransferAction
    extends UIAction
    implements UIResource {
        private static final JavaSecurityAccess javaSecurityAccess = SharedSecrets.getJavaSecurityAccess();
        private static Object SandboxClipboardKey = new Object();

        TransferAction(String name) {
            super(name);
        }

        @Override
        public boolean accept(Object sender) {
            return !(sender instanceof JComponent) || ((JComponent)sender).getTransferHandler() != null;
        }

        @Override
        public void actionPerformed(final ActionEvent e) {
            Object src = e.getSource();
            final PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    this.actionPerformedImpl(e);
                    return null;
                }
            };
            AccessControlContext stack = AccessController.getContext();
            AccessControlContext srcAcc = AWTAccessor.getComponentAccessor().getAccessControlContext((Component)src);
            final AccessControlContext eventAcc = AWTAccessor.getAWTEventAccessor().getAccessControlContext(e);
            if (srcAcc == null) {
                javaSecurityAccess.doIntersectionPrivilege(action, stack, eventAcc);
            } else {
                javaSecurityAccess.doIntersectionPrivilege(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        javaSecurityAccess.doIntersectionPrivilege(action, eventAcc);
                        return null;
                    }
                }, stack, srcAcc);
            }
        }

        private void actionPerformedImpl(ActionEvent e) {
            Object src = e.getSource();
            if (src instanceof JComponent) {
                JComponent c = (JComponent)src;
                TransferHandler th = c.getTransferHandler();
                Clipboard clipboard = this.getClipboard(c);
                String name = (String)this.getValue("Name");
                Transferable trans = null;
                try {
                    if (clipboard != null && th != null && name != null) {
                        if ("cut".equals(name)) {
                            th.exportToClipboard(c, clipboard, 2);
                        } else if ("copy".equals(name)) {
                            th.exportToClipboard(c, clipboard, 1);
                        } else if ("paste".equals(name)) {
                            trans = clipboard.getContents(null);
                        }
                    }
                }
                catch (IllegalStateException ise) {
                    UIManager.getLookAndFeel().provideErrorFeedback(c);
                    return;
                }
                if (trans != null) {
                    th.importData(new TransferSupport((Component)c, trans));
                }
            }
        }

        private Clipboard getClipboard(JComponent c) {
            if (SwingUtilities2.canAccessSystemClipboard()) {
                return c.getToolkit().getSystemClipboard();
            }
            Clipboard clipboard = (Clipboard)AppContext.getAppContext().get(SandboxClipboardKey);
            if (clipboard == null) {
                clipboard = new Clipboard("Sandboxed Component Clipboard");
                AppContext.getAppContext().put(SandboxClipboardKey, clipboard);
            }
            return clipboard;
        }
    }
}

