/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.Position;
import sun.swing.DefaultLookup;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public class BasicComboBoxUI
extends ComboBoxUI {
    protected JComboBox comboBox;
    protected boolean hasFocus;
    protected JList listBox;
    protected CellRendererPane currentValuePane;
    protected ComboPopup popup;
    protected Component editor;
    protected JButton arrowButton;
    protected KeyListener keyListener;
    protected FocusListener focusListener;
    protected PropertyChangeListener propertyChangeListener;
    protected ItemListener itemListener;
    protected MouseListener popupMouseListener;
    protected MouseMotionListener popupMouseMotionListener;
    protected KeyListener popupKeyListener;
    protected ListDataListener listDataListener;
    protected boolean isMinimumSizeDirty;
    protected Dimension cachedMinimumSize;

    public static ComponentUI createUI(JComponent jComponent) {
        return null;
    }

    public void installUI(JComponent jComponent) {
    }

    public void uninstallUI(JComponent jComponent) {
    }

    protected void installDefaults() {
    }

    protected void installListeners() {
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
    }

    protected ComboPopup createPopup() {
        return null;
    }

    protected KeyListener createKeyListener() {
        return null;
    }

    protected FocusListener createFocusListener() {
        return null;
    }

    protected ListDataListener createListDataListener() {
        return null;
    }

    protected ItemListener createItemListener() {
        return null;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return null;
    }

    protected LayoutManager createLayoutManager() {
        return null;
    }

    protected ListCellRenderer createRenderer() {
        return null;
    }

    protected ComboBoxEditor createEditor() {
        return null;
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
    }

    public void addEditor() {
    }

    public void removeEditor() {
    }

    protected void configureEditor() {
    }

    protected void unconfigureEditor() {
    }

    public void configureArrowButton() {
    }

    public void unconfigureArrowButton() {
    }

    protected JButton createArrowButton() {
        return null;
    }

    public boolean isPopupVisible(JComboBox jComboBox) {
        return false;
    }

    public void setPopupVisible(JComboBox jComboBox, boolean bl) {
    }

    public boolean isFocusTraversable(JComboBox jComboBox) {
        return false;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    public int getAccessibleChildrenCount(JComponent jComponent) {
        return 0;
    }

    public Accessible getAccessibleChild(JComponent jComponent, int n) {
        return null;
    }

    protected boolean isNavigationKey(int n) {
        return false;
    }

    protected void selectNextPossibleValue() {
    }

    protected void selectPreviousPossibleValue() {
    }

    protected void toggleOpenClose() {
    }

    protected Rectangle rectangleForCurrentValue() {
        return null;
    }

    protected Insets getInsets() {
        return null;
    }

    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
    }

    public void paintCurrentValueBackground(Graphics graphics, Rectangle rectangle, boolean bl) {
    }

    protected Dimension getDefaultSize() {
        return null;
    }

    protected Dimension getDisplaySize() {
        return null;
    }

    protected void installKeyboardActions() {
    }

    protected void uninstallKeyboardActions() {
    }

    private static class Actions
    extends UIAction {
        private static final String HIDE = "hidePopup";
        private static final String DOWN = "selectNext";
        private static final String DOWN_2 = "selectNext2";
        private static final String TOGGLE = "togglePopup";
        private static final String TOGGLE_2 = "spacePopup";
        private static final String UP = "selectPrevious";
        private static final String UP_2 = "selectPrevious2";
        private static final String ENTER = "enterPressed";
        private static final String PAGE_DOWN = "pageDownPassThrough";
        private static final String PAGE_UP = "pageUpPassThrough";
        private static final String HOME = "homePassThrough";
        private static final String END = "endPassThrough";

        Actions(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String key = this.getName();
            JComboBox comboBox = (JComboBox)e.getSource();
            BasicComboBoxUI ui = (BasicComboBoxUI)BasicLookAndFeel.getUIOfType((ComponentUI)comboBox.getUI(), BasicComboBoxUI.class);
            if (key == HIDE) {
                comboBox.firePopupMenuCanceled();
                comboBox.setPopupVisible(false);
            } else if (key == PAGE_DOWN || key == PAGE_UP || key == HOME || key == END) {
                int index = this.getNextIndex(comboBox, key);
                if (index >= 0 && index < comboBox.getItemCount()) {
                    if (UIManager.getBoolean("ComboBox.noActionOnKeyNavigation") && comboBox.isPopupVisible()) {
                        ui.listBox.setSelectedIndex(index);
                        ui.listBox.ensureIndexIsVisible(index);
                        comboBox.repaint();
                    } else {
                        comboBox.setSelectedIndex(index);
                    }
                }
            } else if (key == DOWN) {
                if (comboBox.isShowing()) {
                    if (comboBox.isPopupVisible()) {
                        if (ui != null) {
                            ui.selectNextPossibleValue();
                        }
                    } else {
                        comboBox.setPopupVisible(true);
                    }
                }
            } else if (key == DOWN_2) {
                if (comboBox.isShowing()) {
                    if ((comboBox.isEditable() || ui != null && ui.isTableCellEditor()) && !comboBox.isPopupVisible()) {
                        comboBox.setPopupVisible(true);
                    } else if (ui != null) {
                        ui.selectNextPossibleValue();
                    }
                }
            } else if (key == TOGGLE || key == TOGGLE_2) {
                if (!(ui == null || key != TOGGLE && comboBox.isEditable())) {
                    if (ui.isTableCellEditor()) {
                        comboBox.setSelectedIndex(ui.popup.getList().getSelectedIndex());
                    } else {
                        comboBox.setPopupVisible(!comboBox.isPopupVisible());
                    }
                }
            } else if (key == UP) {
                if (ui != null) {
                    if (ui.isPopupVisible(comboBox)) {
                        ui.selectPreviousPossibleValue();
                    } else if (DefaultLookup.getBoolean(comboBox, ui, "ComboBox.showPopupOnNavigation", false)) {
                        ui.setPopupVisible(comboBox, true);
                    }
                }
            } else if (key == UP_2) {
                if (comboBox.isShowing() && ui != null) {
                    if (comboBox.isEditable() && !comboBox.isPopupVisible()) {
                        comboBox.setPopupVisible(true);
                    } else {
                        ui.selectPreviousPossibleValue();
                    }
                }
            } else if (key == ENTER) {
                if (comboBox.isPopupVisible()) {
                    if (UIManager.getBoolean("ComboBox.noActionOnKeyNavigation")) {
                        Object listItem = ui.popup.getList().getSelectedValue();
                        if (listItem != null) {
                            comboBox.getEditor().setItem(listItem);
                            comboBox.setSelectedItem(listItem);
                        }
                        comboBox.setPopupVisible(false);
                    } else {
                        Object listItem;
                        boolean isEnterSelectablePopup = UIManager.getBoolean("ComboBox.isEnterSelectablePopup");
                        if ((!comboBox.isEditable() || isEnterSelectablePopup || ui.isTableCellEditor) && (listItem = ui.popup.getList().getSelectedValue()) != null) {
                            comboBox.getEditor().setItem(listItem);
                            comboBox.setSelectedItem(listItem);
                        }
                        comboBox.setPopupVisible(false);
                    }
                } else {
                    JRootPane root;
                    if (ui.isTableCellEditor && !comboBox.isEditable()) {
                        comboBox.setSelectedItem(comboBox.getSelectedItem());
                    }
                    if ((root = SwingUtilities.getRootPane(comboBox)) != null) {
                        Action action;
                        Object obj;
                        InputMap im = root.getInputMap(2);
                        ActionMap am = root.getActionMap();
                        if (im != null && am != null && (obj = im.get(KeyStroke.getKeyStroke(10, 0))) != null && (action = am.get(obj)) != null) {
                            action.actionPerformed(new ActionEvent(root, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers()));
                        }
                    }
                }
            }
        }

        private int getNextIndex(JComboBox<?> comboBox, String key) {
            int listHeight = comboBox.getMaximumRowCount();
            int selectedIndex = comboBox.getSelectedIndex();
            if (UIManager.getBoolean("ComboBox.noActionOnKeyNavigation") && comboBox.getUI() instanceof BasicComboBoxUI) {
                selectedIndex = ((BasicComboBoxUI)comboBox.getUI()).listBox.getSelectedIndex();
            }
            if (key == PAGE_UP) {
                int index = selectedIndex - listHeight;
                return index < 0 ? 0 : index;
            }
            if (key == PAGE_DOWN) {
                int index = selectedIndex + listHeight;
                int max = comboBox.getItemCount();
                return index < max ? index : max - 1;
            }
            if (key == HOME) {
                return 0;
            }
            if (key == END) {
                return comboBox.getItemCount() - 1;
            }
            return comboBox.getSelectedIndex();
        }

        @Override
        public boolean accept(Object c) {
            JRootPane root;
            if (this.getName() == HIDE) {
                return c != null && ((JComboBox)c).isPopupVisible();
            }
            if (this.getName() == ENTER && (root = SwingUtilities.getRootPane((JComboBox)c)) != null && c != null && !((JComboBox)c).isPopupVisible()) {
                Object obj;
                InputMap im = root.getInputMap(2);
                ActionMap am = root.getActionMap();
                if (im != null && am != null && (obj = im.get(KeyStroke.getKeyStroke(10, 0))) == null) {
                    return false;
                }
            }
            return true;
        }
    }

    public class ComboBoxLayoutManager
    implements LayoutManager {
        public ComboBoxLayoutManager(BasicComboBoxUI basicComboBoxUI) {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return null;
        }

        public Dimension minimumLayoutSize(Container container) {
            return null;
        }

        public void layoutContainer(Container container) {
        }
    }

    class DefaultKeySelectionManager
    implements JComboBox.KeySelectionManager,
    UIResource {
        private String prefix = "";
        private String typedString = "";

        DefaultKeySelectionManager() {
        }

        public int selectionForKey(char aKey, ComboBoxModel<?> aModel) {
            int index;
            if (BasicComboBoxUI.this.lastTime == 0L) {
                this.prefix = "";
                this.typedString = "";
            }
            boolean startingFromSelection = true;
            int startIndex = BasicComboBoxUI.this.comboBox.getSelectedIndex();
            if (BasicComboBoxUI.this.time - BasicComboBoxUI.this.lastTime < BasicComboBoxUI.this.timeFactor) {
                this.typedString = this.typedString + aKey;
                if (this.prefix.length() == 1 && aKey == this.prefix.charAt(0)) {
                    ++startIndex;
                } else {
                    this.prefix = this.typedString;
                }
            } else {
                ++startIndex;
                this.typedString = "" + aKey;
                this.prefix = this.typedString;
            }
            BasicComboBoxUI.this.lastTime = BasicComboBoxUI.this.time;
            if (startIndex < 0 || startIndex >= aModel.getSize()) {
                startingFromSelection = false;
                startIndex = 0;
            }
            if ((index = BasicComboBoxUI.this.listBox.getNextMatch(this.prefix, startIndex, Position.Bias.Forward)) < 0 && startingFromSelection) {
                index = BasicComboBoxUI.this.listBox.getNextMatch(this.prefix, 0, Position.Bias.Forward);
            }
            return index;
        }
    }

    public class FocusHandler
    implements FocusListener {
        public FocusHandler(BasicComboBoxUI basicComboBoxUI) {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    private class Handler
    implements ActionListener,
    FocusListener,
    KeyListener,
    LayoutManager,
    ListDataListener,
    PropertyChangeListener {
        private Handler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (e.getSource() == BasicComboBoxUI.this.editor) {
                if ("border".equals(propertyName)) {
                    BasicComboBoxUI.this.isMinimumSizeDirty = true;
                    BasicComboBoxUI.this.isDisplaySizeDirty = true;
                    BasicComboBoxUI.this.comboBox.revalidate();
                }
            } else {
                JComboBox comboBox = (JComboBox)e.getSource();
                if (propertyName == "model") {
                    ComboBoxModel newModel = (ComboBoxModel)e.getNewValue();
                    ComboBoxModel oldModel = (ComboBoxModel)e.getOldValue();
                    if (oldModel != null && BasicComboBoxUI.this.listDataListener != null) {
                        oldModel.removeListDataListener(BasicComboBoxUI.this.listDataListener);
                    }
                    if (newModel != null && BasicComboBoxUI.this.listDataListener != null) {
                        newModel.addListDataListener(BasicComboBoxUI.this.listDataListener);
                    }
                    if (BasicComboBoxUI.this.editor != null) {
                        comboBox.configureEditor(comboBox.getEditor(), comboBox.getSelectedItem());
                    }
                    BasicComboBoxUI.this.isMinimumSizeDirty = true;
                    BasicComboBoxUI.this.isDisplaySizeDirty = true;
                    comboBox.revalidate();
                    comboBox.repaint();
                } else if (propertyName == "editor" && comboBox.isEditable()) {
                    BasicComboBoxUI.this.addEditor();
                    comboBox.revalidate();
                } else if (propertyName == "editable") {
                    if (comboBox.isEditable()) {
                        comboBox.setRequestFocusEnabled(false);
                        BasicComboBoxUI.this.addEditor();
                    } else {
                        comboBox.setRequestFocusEnabled(true);
                        BasicComboBoxUI.this.removeEditor();
                    }
                    BasicComboBoxUI.this.updateToolTipTextForChildren();
                    comboBox.revalidate();
                } else if (propertyName == "enabled") {
                    boolean enabled = comboBox.isEnabled();
                    if (BasicComboBoxUI.this.editor != null) {
                        BasicComboBoxUI.this.editor.setEnabled(enabled);
                    }
                    if (BasicComboBoxUI.this.arrowButton != null) {
                        BasicComboBoxUI.this.arrowButton.setEnabled(enabled);
                    }
                    comboBox.repaint();
                } else if (propertyName == "focusable") {
                    boolean focusable = comboBox.isFocusable();
                    if (BasicComboBoxUI.this.editor != null) {
                        BasicComboBoxUI.this.editor.setFocusable(focusable);
                    }
                    if (BasicComboBoxUI.this.arrowButton != null) {
                        BasicComboBoxUI.this.arrowButton.setFocusable(focusable);
                    }
                    comboBox.repaint();
                } else if (propertyName == "maximumRowCount") {
                    if (BasicComboBoxUI.this.isPopupVisible(comboBox)) {
                        BasicComboBoxUI.this.setPopupVisible(comboBox, false);
                        BasicComboBoxUI.this.setPopupVisible(comboBox, true);
                    }
                } else if (propertyName == "font") {
                    BasicComboBoxUI.this.listBox.setFont(comboBox.getFont());
                    if (BasicComboBoxUI.this.editor != null) {
                        BasicComboBoxUI.this.editor.setFont(comboBox.getFont());
                    }
                    BasicComboBoxUI.this.isMinimumSizeDirty = true;
                    BasicComboBoxUI.this.isDisplaySizeDirty = true;
                    comboBox.validate();
                } else if (SwingUtilities2.isScaleChanged(e)) {
                    BasicComboBoxUI.this.isMinimumSizeDirty = true;
                    BasicComboBoxUI.this.isDisplaySizeDirty = true;
                    comboBox.validate();
                } else if (propertyName == "ToolTipText") {
                    BasicComboBoxUI.this.updateToolTipTextForChildren();
                } else if (propertyName == "JComboBox.isTableCellEditor") {
                    Boolean inTable = (Boolean)e.getNewValue();
                    BasicComboBoxUI.this.isTableCellEditor = inTable.equals(Boolean.TRUE);
                } else if (propertyName == "prototypeDisplayValue") {
                    BasicComboBoxUI.this.isMinimumSizeDirty = true;
                    BasicComboBoxUI.this.isDisplaySizeDirty = true;
                    comboBox.revalidate();
                } else if (propertyName == "renderer") {
                    BasicComboBoxUI.this.isMinimumSizeDirty = true;
                    BasicComboBoxUI.this.isDisplaySizeDirty = true;
                    comboBox.revalidate();
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (BasicComboBoxUI.this.isNavigationKey(e.getKeyCode(), e.getModifiers())) {
                BasicComboBoxUI.this.lastTime = 0L;
            } else if (BasicComboBoxUI.this.comboBox.isEnabled() && BasicComboBoxUI.this.comboBox.getModel().getSize() != 0 && this.isTypeAheadKey(e) && e.getKeyChar() != '\uffff') {
                BasicComboBoxUI.this.time = e.getWhen();
                if (BasicComboBoxUI.this.comboBox.selectWithKeyChar(e.getKeyChar())) {
                    e.consume();
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        private boolean isTypeAheadKey(KeyEvent e) {
            return !e.isAltDown() && !BasicGraphicsUtils.isMenuShortcutKeyDown((InputEvent)e);
        }

        @Override
        public void focusGained(FocusEvent e) {
            ComboBoxEditor comboBoxEditor = BasicComboBoxUI.this.comboBox.getEditor();
            if (comboBoxEditor != null && e.getSource() == comboBoxEditor.getEditorComponent()) {
                return;
            }
            BasicComboBoxUI.this.hasFocus = true;
            BasicComboBoxUI.this.comboBox.repaint();
            if (BasicComboBoxUI.this.comboBox.isEditable() && BasicComboBoxUI.this.editor != null) {
                BasicComboBoxUI.this.editor.requestFocus();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            ComboBoxEditor editor = BasicComboBoxUI.this.comboBox.getEditor();
            if (editor != null && e.getSource() == editor.getEditorComponent()) {
                Object item = editor.getItem();
                Object selectedItem = BasicComboBoxUI.this.comboBox.getSelectedItem();
                if (!e.isTemporary() && item != null && !item.equals(selectedItem == null ? "" : selectedItem)) {
                    BasicComboBoxUI.this.comboBox.actionPerformed(new ActionEvent(editor, 0, "", EventQueue.getMostRecentEventTime(), 0));
                }
            }
            BasicComboBoxUI.this.hasFocus = false;
            if (!e.isTemporary()) {
                BasicComboBoxUI.this.setPopupVisible(BasicComboBoxUI.this.comboBox, false);
            }
            BasicComboBoxUI.this.comboBox.repaint();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            if (e.getIndex0() != -1 || e.getIndex1() != -1) {
                BasicComboBoxUI.this.isMinimumSizeDirty = true;
                BasicComboBoxUI.this.comboBox.revalidate();
            }
            if (BasicComboBoxUI.this.comboBox.isEditable() && BasicComboBoxUI.this.editor != null) {
                BasicComboBoxUI.this.comboBox.configureEditor(BasicComboBoxUI.this.comboBox.getEditor(), BasicComboBoxUI.this.comboBox.getSelectedItem());
            }
            BasicComboBoxUI.this.isDisplaySizeDirty = true;
            BasicComboBoxUI.this.comboBox.repaint();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.contentsChanged(e);
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.contentsChanged(e);
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return parent.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return parent.getMinimumSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            int buttonHeight;
            JComboBox cb = (JComboBox)parent;
            int width = cb.getWidth();
            int height = cb.getHeight();
            Insets insets = BasicComboBoxUI.this.getInsets();
            int buttonWidth = buttonHeight = height - (insets.top + insets.bottom);
            if (BasicComboBoxUI.this.arrowButton != null) {
                Insets arrowInsets = BasicComboBoxUI.this.arrowButton.getInsets();
                int n = buttonWidth = BasicComboBoxUI.this.squareButton ? buttonHeight : BasicComboBoxUI.this.arrowButton.getPreferredSize().width + arrowInsets.left + arrowInsets.right;
            }
            if (BasicComboBoxUI.this.arrowButton != null) {
                if (BasicGraphicsUtils.isLeftToRight((Component)cb)) {
                    BasicComboBoxUI.this.arrowButton.setBounds(width - (insets.right + buttonWidth), insets.top, buttonWidth, buttonHeight);
                } else {
                    BasicComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, buttonWidth, buttonHeight);
                }
            }
            if (BasicComboBoxUI.this.editor != null) {
                Rectangle cvb = BasicComboBoxUI.this.rectangleForCurrentValue();
                BasicComboBoxUI.this.editor.setBounds(cvb);
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object item = BasicComboBoxUI.this.comboBox.getEditor().getItem();
            if (item != null) {
                Action action;
                ActionMap am;
                if (!BasicComboBoxUI.this.comboBox.isPopupVisible() && !item.equals(BasicComboBoxUI.this.comboBox.getSelectedItem())) {
                    BasicComboBoxUI.this.comboBox.setSelectedItem(BasicComboBoxUI.this.comboBox.getEditor().getItem());
                }
                if ((am = BasicComboBoxUI.this.comboBox.getActionMap()) != null && (action = am.get("enterPressed")) != null) {
                    action.actionPerformed(new ActionEvent(BasicComboBoxUI.this.comboBox, evt.getID(), evt.getActionCommand(), evt.getModifiers()));
                }
            }
        }
    }

    public class ItemHandler
    implements ItemListener {
        public ItemHandler(BasicComboBoxUI basicComboBoxUI) {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
        }
    }

    public class KeyHandler
    extends KeyAdapter {
        public KeyHandler(BasicComboBoxUI basicComboBoxUI) {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }
    }

    public class ListDataHandler
    implements ListDataListener {
        public ListDataHandler(BasicComboBoxUI basicComboBoxUI) {
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public PropertyChangeHandler(BasicComboBoxUI basicComboBoxUI) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }
    }
}

