/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;
import javax.swing.SortingFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DesktopPaneUI;
import javax.swing.plaf.UIResource;
import sun.swing.UIAction;

public class BasicDesktopPaneUI
extends DesktopPaneUI {
    protected JDesktopPane desktop;
    protected DesktopManager desktopManager;
    @Deprecated
    protected KeyStroke minimizeKey;
    @Deprecated
    protected KeyStroke maximizeKey;
    @Deprecated
    protected KeyStroke closeKey;
    @Deprecated
    protected KeyStroke navigateKey;
    @Deprecated
    protected KeyStroke navigateKey2;

    public static ComponentUI createUI(JComponent jComponent) {
        return null;
    }

    public void installUI(JComponent jComponent) {
    }

    public void uninstallUI(JComponent jComponent) {
    }

    protected void installDefaults() {
    }

    protected void uninstallDefaults() {
    }

    protected void installListeners() {
    }

    protected void uninstallListeners() {
    }

    protected void installDesktopManager() {
    }

    protected void uninstallDesktopManager() {
    }

    protected void installKeyboardActions() {
    }

    protected void registerKeyboardActions() {
    }

    protected void unregisterKeyboardActions() {
    }

    protected void uninstallKeyboardActions() {
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return null;
    }

    private static class Actions
    extends UIAction {
        private static String CLOSE = "close";
        private static String ESCAPE = "escape";
        private static String MAXIMIZE = "maximize";
        private static String MINIMIZE = "minimize";
        private static String MOVE = "move";
        private static String RESIZE = "resize";
        private static String RESTORE = "restore";
        private static String LEFT = "left";
        private static String RIGHT = "right";
        private static String UP = "up";
        private static String DOWN = "down";
        private static String SHRINK_LEFT = "shrinkLeft";
        private static String SHRINK_RIGHT = "shrinkRight";
        private static String SHRINK_UP = "shrinkUp";
        private static String SHRINK_DOWN = "shrinkDown";
        private static String NEXT_FRAME = "selectNextFrame";
        private static String PREVIOUS_FRAME = "selectPreviousFrame";
        private static String NAVIGATE_NEXT = "navigateNext";
        private static String NAVIGATE_PREVIOUS = "navigatePrevious";
        private final int MOVE_RESIZE_INCREMENT = 10;
        private static boolean moving = false;
        private static boolean resizing = false;
        private static JInternalFrame sourceFrame = null;
        private static Component focusOwner = null;

        Actions() {
            super(null);
        }

        Actions(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            JDesktopPane dp = (JDesktopPane)e.getSource();
            String key = this.getName();
            if (CLOSE == key || MAXIMIZE == key || MINIMIZE == key || RESTORE == key) {
                this.setState(dp, key);
            } else if (ESCAPE == key) {
                if (sourceFrame == dp.getSelectedFrame() && focusOwner != null) {
                    focusOwner.requestFocus();
                }
                moving = false;
                resizing = false;
                sourceFrame = null;
                focusOwner = null;
            } else if (MOVE == key || RESIZE == key) {
                sourceFrame = dp.getSelectedFrame();
                if (sourceFrame == null) {
                    return;
                }
                moving = key == MOVE;
                resizing = key == RESIZE;
                focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (!SwingUtilities.isDescendingFrom(focusOwner, sourceFrame)) {
                    focusOwner = null;
                }
                sourceFrame.requestFocus();
            } else if (LEFT == key || RIGHT == key || UP == key || DOWN == key || SHRINK_RIGHT == key || SHRINK_LEFT == key || SHRINK_UP == key || SHRINK_DOWN == key) {
                JInternalFrame c = dp.getSelectedFrame();
                if (sourceFrame == null || c != sourceFrame || KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() != sourceFrame) {
                    return;
                }
                Insets minOnScreenInsets = UIManager.getInsets("Desktop.minOnScreenInsets");
                if (minOnScreenInsets == null) {
                    minOnScreenInsets = new Insets(0, 0, 0, 0);
                }
                Dimension size = c.getSize();
                Dimension minSize = c.getMinimumSize();
                int dpWidth = dp.getWidth();
                int dpHeight = dp.getHeight();
                Point loc = c.getLocation();
                if (LEFT == key) {
                    if (moving) {
                        c.setLocation(loc.x + size.width - 10 < minOnScreenInsets.right ? -size.width + minOnScreenInsets.right : loc.x - 10, loc.y);
                    } else if (resizing) {
                        c.setLocation(loc.x - 10, loc.y);
                        c.setSize(size.width + 10, size.height);
                    }
                } else if (RIGHT == key) {
                    if (moving) {
                        c.setLocation(loc.x + 10 > dpWidth - minOnScreenInsets.left ? dpWidth - minOnScreenInsets.left : loc.x + 10, loc.y);
                    } else if (resizing) {
                        c.setSize(size.width + 10, size.height);
                    }
                } else if (UP == key) {
                    if (moving) {
                        c.setLocation(loc.x, loc.y + size.height - 10 < minOnScreenInsets.bottom ? -size.height + minOnScreenInsets.bottom : loc.y - 10);
                    } else if (resizing) {
                        c.setLocation(loc.x, loc.y - 10);
                        c.setSize(size.width, size.height + 10);
                    }
                } else if (DOWN == key) {
                    if (moving) {
                        c.setLocation(loc.x, loc.y + 10 > dpHeight - minOnScreenInsets.top ? dpHeight - minOnScreenInsets.top : loc.y + 10);
                    } else if (resizing) {
                        c.setSize(size.width, size.height + 10);
                    }
                } else if (SHRINK_LEFT == key && resizing) {
                    int delta = minSize.width < size.width - 10 ? 10 : size.width - minSize.width;
                    if (loc.x + size.width - delta < minOnScreenInsets.left) {
                        delta = loc.x + size.width - minOnScreenInsets.left;
                    }
                    c.setSize(size.width - delta, size.height);
                } else if (SHRINK_RIGHT == key && resizing) {
                    int delta = minSize.width < size.width - 10 ? 10 : size.width - minSize.width;
                    if (loc.x + delta > dpWidth - minOnScreenInsets.right) {
                        delta = dpWidth - minOnScreenInsets.right - loc.x;
                    }
                    c.setLocation(loc.x + delta, loc.y);
                    c.setSize(size.width - delta, size.height);
                } else if (SHRINK_UP == key && resizing) {
                    int delta = minSize.height < size.height - 10 ? 10 : size.height - minSize.height;
                    if (loc.y + size.height - delta < minOnScreenInsets.bottom) {
                        delta = loc.y + size.height - minOnScreenInsets.bottom;
                    }
                    c.setSize(size.width, size.height - delta);
                } else if (SHRINK_DOWN == key && resizing) {
                    int delta = minSize.height < size.height - 10 ? 10 : size.height - minSize.height;
                    if (loc.y + delta > dpHeight - minOnScreenInsets.top) {
                        delta = dpHeight - minOnScreenInsets.top - loc.y;
                    }
                    c.setLocation(loc.x, loc.y + delta);
                    c.setSize(size.width, size.height - delta);
                }
            } else if (NEXT_FRAME == key || PREVIOUS_FRAME == key) {
                dp.selectFrame(key == NEXT_FRAME);
            } else if (NAVIGATE_NEXT == key || NAVIGATE_PREVIOUS == key) {
                FocusTraversalPolicy policy;
                Container cycleRoot;
                boolean moveForward = true;
                if (NAVIGATE_PREVIOUS == key) {
                    moveForward = false;
                }
                if ((cycleRoot = dp.getFocusCycleRootAncestor()) != null && (policy = cycleRoot.getFocusTraversalPolicy()) instanceof SortingFocusTraversalPolicy) {
                    SortingFocusTraversalPolicy sPolicy = (SortingFocusTraversalPolicy)policy;
                    boolean idc = sPolicy.getImplicitDownCycleTraversal();
                    try {
                        sPolicy.setImplicitDownCycleTraversal(false);
                        if (moveForward) {
                            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(dp);
                        } else {
                            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent(dp);
                        }
                    }
                    finally {
                        sPolicy.setImplicitDownCycleTraversal(idc);
                    }
                }
            }
        }

        private void setState(JDesktopPane dp, String state) {
            if (state == CLOSE) {
                JInternalFrame f = dp.getSelectedFrame();
                if (f == null) {
                    return;
                }
                f.doDefaultCloseAction();
            } else if (state == MAXIMIZE) {
                JInternalFrame f = dp.getSelectedFrame();
                if (f == null) {
                    return;
                }
                if (!f.isMaximum()) {
                    if (f.isIcon()) {
                        try {
                            f.setIcon(false);
                            f.setMaximum(true);
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                    } else {
                        try {
                            f.setMaximum(true);
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                    }
                }
            } else if (state == MINIMIZE) {
                JInternalFrame f = dp.getSelectedFrame();
                if (f == null) {
                    return;
                }
                if (!f.isIcon()) {
                    try {
                        f.setIcon(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                }
            } else if (state == RESTORE) {
                JInternalFrame f = dp.getSelectedFrame();
                if (f == null) {
                    return;
                }
                try {
                    if (f.isIcon()) {
                        f.setIcon(false);
                    } else if (f.isMaximum()) {
                        f.setMaximum(false);
                    }
                    f.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean accept(Object sender) {
            if (sender instanceof JDesktopPane) {
                JDesktopPane dp = (JDesktopPane)sender;
                String action = this.getName();
                if (action == NEXT_FRAME || action == PREVIOUS_FRAME) {
                    return true;
                }
                JInternalFrame iFrame = dp.getSelectedFrame();
                if (iFrame == null) {
                    return false;
                }
                if (action == CLOSE) {
                    return iFrame.isClosable();
                }
                if (action == MINIMIZE) {
                    return iFrame.isIconifiable();
                }
                if (action == MAXIMIZE) {
                    return iFrame.isMaximizable();
                }
                return true;
            }
            return false;
        }
    }

    private static class BasicDesktopManager
    extends DefaultDesktopManager
    implements UIResource {
        private BasicDesktopManager() {
        }
    }

    protected class CloseAction
    extends AbstractAction {
        protected CloseAction(BasicDesktopPaneUI basicDesktopPaneUI) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public boolean isEnabled() {
            return false;
        }
    }

    private class Handler
    implements PropertyChangeListener {
        private Handler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("desktopManager" == propertyName) {
                BasicDesktopPaneUI.this.installDesktopManager();
            }
        }
    }

    protected class MaximizeAction
    extends AbstractAction {
        protected MaximizeAction(BasicDesktopPaneUI basicDesktopPaneUI) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public boolean isEnabled() {
            return false;
        }
    }

    protected class MinimizeAction
    extends AbstractAction {
        protected MinimizeAction(BasicDesktopPaneUI basicDesktopPaneUI) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public boolean isEnabled() {
            return false;
        }
    }

    protected class NavigateAction
    extends AbstractAction {
        protected NavigateAction(BasicDesktopPaneUI basicDesktopPaneUI) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public boolean isEnabled() {
            return false;
        }
    }

    protected class OpenAction
    extends AbstractAction {
        protected OpenAction(BasicDesktopPaneUI basicDesktopPaneUI) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public boolean isEnabled() {
            return false;
        }
    }
}

