/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.basic.BasicTransferable;
import sun.awt.shell.ShellFolder;
import sun.swing.SwingUtilities2;

public class BasicFileChooserUI
extends FileChooserUI {
    protected Icon directoryIcon;
    protected Icon fileIcon;
    protected Icon computerIcon;
    protected Icon hardDriveIcon;
    protected Icon floppyDriveIcon;
    protected Icon newFolderIcon;
    protected Icon upFolderIcon;
    protected Icon homeFolderIcon;
    protected Icon listViewIcon;
    protected Icon detailsViewIcon;
    protected int saveButtonMnemonic;
    protected int openButtonMnemonic;
    protected int cancelButtonMnemonic;
    protected int updateButtonMnemonic;
    protected int helpButtonMnemonic;
    protected int directoryOpenButtonMnemonic;
    protected String saveButtonText;
    protected String openButtonText;
    protected String cancelButtonText;
    protected String updateButtonText;
    protected String helpButtonText;
    protected String directoryOpenButtonText;
    protected String saveButtonToolTipText;
    protected String openButtonToolTipText;
    protected String cancelButtonToolTipText;
    protected String updateButtonToolTipText;
    protected String helpButtonToolTipText;
    protected String directoryOpenButtonToolTipText;

    public BasicFileChooserUI(JFileChooser jFileChooser) {
    }

    public void installUI(JComponent jComponent) {
    }

    public void uninstallUI(JComponent jComponent) {
    }

    public void installComponents(JFileChooser jFileChooser) {
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
    }

    protected void installListeners(JFileChooser jFileChooser) {
    }

    protected void uninstallListeners(JFileChooser jFileChooser) {
    }

    protected void installDefaults(JFileChooser jFileChooser) {
    }

    protected void installIcons(JFileChooser jFileChooser) {
    }

    protected void installStrings(JFileChooser jFileChooser) {
    }

    protected void uninstallDefaults(JFileChooser jFileChooser) {
    }

    protected void uninstallIcons(JFileChooser jFileChooser) {
    }

    protected void uninstallStrings(JFileChooser jFileChooser) {
    }

    protected void createModel() {
    }

    public BasicDirectoryModel getModel() {
        return null;
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return null;
    }

    public String getFileName() {
        return null;
    }

    public String getDirectoryName() {
        return null;
    }

    public void setFileName(String string) {
    }

    public void setDirectoryName(String string) {
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
    }

    public JFileChooser getFileChooser() {
        return null;
    }

    public JPanel getAccessoryPanel() {
        return null;
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return null;
    }

    public String getApproveButtonToolTipText(JFileChooser jFileChooser) {
        return null;
    }

    public void clearIconCache() {
    }

    protected MouseListener createDoubleClickListener(JFileChooser jFileChooser, JList jList) {
        return null;
    }

    public ListSelectionListener createListSelectionListener(JFileChooser jFileChooser) {
        return null;
    }

    protected boolean isDirectorySelected() {
        return false;
    }

    protected void setDirectorySelected(boolean bl) {
    }

    protected File getDirectory() {
        return null;
    }

    protected void setDirectory(File file) {
    }

    public FileFilter getAcceptAllFileFilter(JFileChooser jFileChooser) {
        return null;
    }

    public FileView getFileView(JFileChooser jFileChooser) {
        return null;
    }

    public String getDialogTitle(JFileChooser jFileChooser) {
        return null;
    }

    public int getApproveButtonMnemonic(JFileChooser jFileChooser) {
        return 0;
    }

    public String getApproveButtonText(JFileChooser jFileChooser) {
        return null;
    }

    public Action getNewFolderAction() {
        return null;
    }

    public Action getGoHomeAction() {
        return null;
    }

    public Action getChangeToParentDirectoryAction() {
        return null;
    }

    public Action getApproveSelectionAction() {
        return null;
    }

    public Action getCancelSelectionAction() {
        return null;
    }

    public Action getUpdateAction() {
        return null;
    }

    protected class AcceptAllFileFilter
    extends FileFilter {
        public AcceptAllFileFilter(BasicFileChooserUI basicFileChooserUI) {
        }

        public boolean accept(File file) {
            return false;
        }

        public String getDescription() {
            return null;
        }
    }

    protected class ApproveSelectionAction
    extends AbstractAction {
        protected ApproveSelectionAction(BasicFileChooserUI basicFileChooserUI) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    protected class BasicFileView
    extends FileView {
        protected Hashtable<File, Icon> iconCache;

        public BasicFileView(BasicFileChooserUI basicFileChooserUI) {
        }

        public void clearIconCache() {
        }

        public String getName(File file) {
            return null;
        }

        public String getDescription(File file) {
            return null;
        }

        public String getTypeDescription(File file) {
            return null;
        }

        public Icon getCachedIcon(File file) {
            return null;
        }

        public void cacheIcon(File file, Icon icon) {
        }

        public Icon getIcon(File file) {
            return null;
        }

        public Boolean isHidden(File file) {
            return null;
        }
    }

    protected class CancelSelectionAction
    extends AbstractAction {
        protected CancelSelectionAction(BasicFileChooserUI basicFileChooserUI) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    protected class ChangeToParentDirectoryAction
    extends AbstractAction {
        protected ChangeToParentDirectoryAction(BasicFileChooserUI basicFileChooserUI) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    protected class DoubleClickListener
    extends MouseAdapter {
        public DoubleClickListener(BasicFileChooserUI basicFileChooserUI, JList jList) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }
    }

    static class FileTransferHandler
    extends TransferHandler
    implements UIResource {
        FileTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            JTable table;
            int[] rows;
            Object[] values = null;
            if (c instanceof JList) {
                values = ((JList)c).getSelectedValues();
            } else if (c instanceof JTable && (rows = (table = (JTable)c).getSelectedRows()) != null) {
                values = new Object[rows.length];
                for (int i = 0; i < rows.length; ++i) {
                    values[i] = table.getValueAt(rows[i], 0);
                }
            }
            if (values == null || values.length == 0) {
                return null;
            }
            StringBuilder plainBuf = new StringBuilder();
            StringBuilder htmlBuf = new StringBuilder();
            htmlBuf.append("<html>\n<body>\n<ul>\n");
            for (Object obj : values) {
                String val = obj == null ? "" : obj.toString();
                plainBuf.append(val).append('\n');
                htmlBuf.append("  <li>").append(val).append('\n');
            }
            plainBuf.deleteCharAt(plainBuf.length() - 1);
            htmlBuf.append("</ul>\n</body>\n</html>");
            return new FileTransferable(plainBuf.toString(), htmlBuf.toString(), values);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        static class FileTransferable
        extends BasicTransferable {
            Object[] fileData;

            FileTransferable(String plainData, String htmlData, Object[] fileData) {
                super(plainData, htmlData);
                this.fileData = fileData;
            }

            @Override
            protected DataFlavor[] getRicherFlavors() {
                DataFlavor[] flavors = new DataFlavor[]{DataFlavor.javaFileListFlavor};
                return flavors;
            }

            @Override
            protected Object getRicherData(DataFlavor flavor) {
                if (DataFlavor.javaFileListFlavor.equals(flavor)) {
                    ArrayList<Object> files = new ArrayList<Object>();
                    for (Object file : this.fileData) {
                        files.add(file);
                    }
                    return files;
                }
                return null;
            }
        }
    }

    static class GlobFilter
    extends FileFilter {
        Pattern pattern;
        String globPattern;

        GlobFilter() {
        }

        public void setPattern(String globPattern) {
            char[] gPat = globPattern.toCharArray();
            char[] rPat = new char[gPat.length * 2];
            boolean isWin32 = File.separatorChar == '\\';
            boolean inBrackets = false;
            int j = 0;
            this.globPattern = globPattern;
            if (isWin32) {
                int len = gPat.length;
                if (globPattern.endsWith("*.*")) {
                    len -= 2;
                }
                block16: for (int i = 0; i < len; ++i) {
                    switch (gPat[i]) {
                        case '*': {
                            rPat[j++] = 46;
                            rPat[j++] = 42;
                            continue block16;
                        }
                        case '?': {
                            rPat[j++] = 46;
                            continue block16;
                        }
                        case '\\': {
                            rPat[j++] = 92;
                            rPat[j++] = 92;
                            continue block16;
                        }
                        default: {
                            if ("+()^$.{}[]".indexOf(gPat[i]) >= 0) {
                                rPat[j++] = 92;
                            }
                            rPat[j++] = gPat[i];
                        }
                    }
                }
            } else {
                block17: for (int i = 0; i < gPat.length; ++i) {
                    switch (gPat[i]) {
                        case '*': {
                            if (!inBrackets) {
                                rPat[j++] = 46;
                            }
                            rPat[j++] = 42;
                            continue block17;
                        }
                        case '?': {
                            rPat[j++] = inBrackets ? 63 : 46;
                            continue block17;
                        }
                        case '[': {
                            inBrackets = true;
                            rPat[j++] = gPat[i];
                            if (i >= gPat.length - 1) continue block17;
                            switch (gPat[i + 1]) {
                                case '!': 
                                case '^': {
                                    rPat[j++] = 94;
                                    ++i;
                                    break;
                                }
                                case ']': {
                                    rPat[j++] = gPat[++i];
                                }
                            }
                            continue block17;
                        }
                        case ']': {
                            rPat[j++] = gPat[i];
                            inBrackets = false;
                            continue block17;
                        }
                        case '\\': {
                            if (i == 0 && gPat.length > 1 && gPat[1] == '~') {
                                rPat[j++] = gPat[++i];
                                continue block17;
                            }
                            rPat[j++] = 92;
                            if (i < gPat.length - 1 && "*?[]".indexOf(gPat[i + 1]) >= 0) {
                                rPat[j++] = gPat[++i];
                                continue block17;
                            }
                            rPat[j++] = 92;
                            continue block17;
                        }
                        default: {
                            if (!Character.isLetterOrDigit(gPat[i])) {
                                rPat[j++] = 92;
                            }
                            rPat[j++] = gPat[i];
                        }
                    }
                }
            }
            this.pattern = Pattern.compile(new String(rPat, 0, j), 2);
        }

        @Override
        public boolean accept(File f) {
            if (f == null) {
                return false;
            }
            if (f.isDirectory()) {
                return true;
            }
            return this.pattern.matcher(f.getName()).matches();
        }

        @Override
        public String getDescription() {
            return this.globPattern;
        }
    }

    protected class GoHomeAction
    extends AbstractAction {
        protected GoHomeAction(BasicFileChooserUI basicFileChooserUI) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private class Handler
    implements MouseListener,
    ListSelectionListener {
        JList<?> list;

        Handler() {
        }

        Handler(JList<?> list) {
            this.list = list;
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            int index;
            if (this.list != null && SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() % 2 == 0 && (index = SwingUtilities2.loc2IndexFileList(this.list, evt.getPoint())) >= 0) {
                File f = (File)this.list.getModel().getElementAt(index);
                try {
                    f = ShellFolder.getNormalizedFile(f);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (BasicFileChooserUI.this.getFileChooser().isTraversable(f)) {
                    this.list.clearSelection();
                    BasicFileChooserUI.this.changeDirectory(f);
                } else {
                    BasicFileChooserUI.this.getFileChooser().approveSelection();
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            if (this.list != null) {
                TransferHandler th2;
                TransferHandler th1 = BasicFileChooserUI.this.getFileChooser().getTransferHandler();
                if (th1 != (th2 = this.list.getTransferHandler())) {
                    this.list.setTransferHandler(th1);
                }
                if (BasicFileChooserUI.this.getFileChooser().getDragEnabled() != this.list.getDragEnabled()) {
                    this.list.setDragEnabled(BasicFileChooserUI.this.getFileChooser().getDragEnabled());
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            if (!evt.getValueIsAdjusting()) {
                boolean useSetDirectory;
                JFileChooser chooser = BasicFileChooserUI.this.getFileChooser();
                FileSystemView fsv = chooser.getFileSystemView();
                JList list = (JList)evt.getSource();
                int fsm = chooser.getFileSelectionMode();
                boolean bl = useSetDirectory = BasicFileChooserUI.this.usesSingleFilePane && fsm == 0;
                if (chooser.isMultiSelectionEnabled()) {
                    File[] files = null;
                    Object[] objects = list.getSelectedValues();
                    if (objects != null) {
                        if (objects.length == 1 && ((File)objects[0]).isDirectory() && chooser.isTraversable((File)objects[0]) && (useSetDirectory || !fsv.isFileSystem((File)objects[0]))) {
                            BasicFileChooserUI.this.setDirectorySelected(true);
                            BasicFileChooserUI.this.setDirectory((File)objects[0]);
                        } else {
                            ArrayList<File> fList = new ArrayList<File>(objects.length);
                            for (Object object : objects) {
                                File f = (File)object;
                                boolean isDir = f.isDirectory();
                                if ((!chooser.isFileSelectionEnabled() || isDir) && (!chooser.isDirectorySelectionEnabled() || !fsv.isFileSystem(f) || !isDir)) continue;
                                fList.add(f);
                            }
                            if (fList.size() > 0) {
                                files = fList.toArray(new File[fList.size()]);
                            }
                            BasicFileChooserUI.this.setDirectorySelected(false);
                        }
                    }
                    chooser.setSelectedFiles(files);
                } else {
                    File file = (File)list.getSelectedValue();
                    if (file != null && file.isDirectory() && chooser.isTraversable(file) && (useSetDirectory || !fsv.isFileSystem(file))) {
                        BasicFileChooserUI.this.setDirectorySelected(true);
                        BasicFileChooserUI.this.setDirectory(file);
                        if (BasicFileChooserUI.this.usesSingleFilePane) {
                            chooser.setSelectedFile(null);
                        }
                    } else {
                        BasicFileChooserUI.this.setDirectorySelected(false);
                        if (file != null) {
                            chooser.setSelectedFile(file);
                        }
                    }
                }
            }
        }
    }

    protected class NewFolderAction
    extends AbstractAction {
        protected NewFolderAction(BasicFileChooserUI basicFileChooserUI) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    protected class SelectionListener
    implements ListSelectionListener {
        protected SelectionListener(BasicFileChooserUI basicFileChooserUI) {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
        }
    }

    protected class UpdateAction
    extends AbstractAction {
        protected UpdateAction(BasicFileChooserUI basicFileChooserUI) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }
}

