/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollBarUI;
import sun.swing.UIAction;

public class BasicScrollBarUI
extends ScrollBarUI
implements LayoutManager,
SwingConstants {
    protected Dimension minimumThumbSize;
    protected Dimension maximumThumbSize;
    protected Color thumbHighlightColor;
    protected Color thumbLightShadowColor;
    protected Color thumbDarkShadowColor;
    protected Color thumbColor;
    protected Color trackColor;
    protected Color trackHighlightColor;
    protected JScrollBar scrollbar;
    protected JButton incrButton;
    protected JButton decrButton;
    protected boolean isDragging;
    protected TrackListener trackListener;
    protected ArrowButtonListener buttonListener;
    protected ModelListener modelListener;
    protected Rectangle thumbRect;
    protected Rectangle trackRect;
    protected int trackHighlight;
    protected static final int NO_HIGHLIGHT = 0;
    protected static final int DECREASE_HIGHLIGHT = 1;
    protected static final int INCREASE_HIGHLIGHT = 2;
    protected ScrollListener scrollListener;
    protected PropertyChangeListener propertyChangeListener;
    protected Timer scrollTimer;

    public static ComponentUI createUI(JComponent jComponent) {
        return null;
    }

    protected void configureScrollBarColors() {
    }

    public void installUI(JComponent jComponent) {
    }

    public void uninstallUI(JComponent jComponent) {
    }

    protected void installDefaults() {
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
    }

    protected void installListeners() {
    }

    protected void installKeyboardActions() {
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
    }

    protected void uninstallDefaults() {
    }

    protected TrackListener createTrackListener() {
        return null;
    }

    protected ArrowButtonListener createArrowButtonListener() {
        return null;
    }

    protected ModelListener createModelListener() {
        return null;
    }

    protected ScrollListener createScrollListener() {
        return null;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return null;
    }

    protected void setThumbRollover(boolean bl) {
    }

    public boolean isThumbRollover() {
        return false;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    protected JButton createDecreaseButton(int n) {
        return null;
    }

    protected JButton createIncreaseButton(int n) {
        return null;
    }

    protected void paintDecreaseHighlight(Graphics graphics) {
    }

    protected void paintIncreaseHighlight(Graphics graphics) {
    }

    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
    }

    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
    }

    protected Dimension getMinimumThumbSize() {
        return null;
    }

    protected Dimension getMaximumThumbSize() {
        return null;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        return null;
    }

    public Dimension minimumLayoutSize(Container container) {
        return null;
    }

    protected void layoutVScrollbar(JScrollBar jScrollBar) {
    }

    protected void layoutHScrollbar(JScrollBar jScrollBar) {
    }

    public void layoutContainer(Container container) {
    }

    protected void setThumbBounds(int n, int n2, int n3, int n4) {
    }

    protected Rectangle getThumbBounds() {
        return null;
    }

    protected Rectangle getTrackBounds() {
        return null;
    }

    protected void scrollByBlock(int n) {
    }

    protected void scrollByUnit(int n) {
    }

    public boolean getSupportsAbsolutePositioning() {
        return false;
    }

    private static class Actions
    extends UIAction {
        private static final String POSITIVE_UNIT_INCREMENT = "positiveUnitIncrement";
        private static final String POSITIVE_BLOCK_INCREMENT = "positiveBlockIncrement";
        private static final String NEGATIVE_UNIT_INCREMENT = "negativeUnitIncrement";
        private static final String NEGATIVE_BLOCK_INCREMENT = "negativeBlockIncrement";
        private static final String MIN_SCROLL = "minScroll";
        private static final String MAX_SCROLL = "maxScroll";

        Actions(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JScrollBar scrollBar = (JScrollBar)e.getSource();
            String key = this.getName();
            if (key == POSITIVE_UNIT_INCREMENT) {
                this.scroll(scrollBar, 1, false);
            } else if (key == POSITIVE_BLOCK_INCREMENT) {
                this.scroll(scrollBar, 1, true);
            } else if (key == NEGATIVE_UNIT_INCREMENT) {
                this.scroll(scrollBar, -1, false);
            } else if (key == NEGATIVE_BLOCK_INCREMENT) {
                this.scroll(scrollBar, -1, true);
            } else if (key == MIN_SCROLL) {
                this.scroll(scrollBar, 2, true);
            } else if (key == MAX_SCROLL) {
                this.scroll(scrollBar, 3, true);
            }
        }

        private void scroll(JScrollBar scrollBar, int dir, boolean block) {
            if (dir == -1 || dir == 1) {
                int amount = block ? (dir == -1 ? -1 * scrollBar.getBlockIncrement(-1) : scrollBar.getBlockIncrement(1)) : (dir == -1 ? -1 * scrollBar.getUnitIncrement(-1) : scrollBar.getUnitIncrement(1));
                scrollBar.setValue(scrollBar.getValue() + amount);
            } else if (dir == 2) {
                scrollBar.setValue(scrollBar.getMinimum());
            } else if (dir == 3) {
                scrollBar.setValue(scrollBar.getMaximum());
            }
        }
    }

    protected class ArrowButtonListener
    extends MouseAdapter {
        protected ArrowButtonListener(BasicScrollBarUI basicScrollBarUI) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    private class Handler
    implements FocusListener,
    PropertyChangeListener {
        private Handler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            BasicScrollBarUI.this.scrollbar.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            BasicScrollBarUI.this.scrollbar.repaint();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if ("model" == propertyName) {
                BoundedRangeModel oldModel = (BoundedRangeModel)e.getOldValue();
                BoundedRangeModel newModel = (BoundedRangeModel)e.getNewValue();
                oldModel.removeChangeListener(BasicScrollBarUI.this.modelListener);
                newModel.addChangeListener(BasicScrollBarUI.this.modelListener);
                BasicScrollBarUI.this.scrollBarValue = BasicScrollBarUI.this.scrollbar.getValue();
                BasicScrollBarUI.this.scrollbar.repaint();
                BasicScrollBarUI.this.scrollbar.revalidate();
            } else if ("orientation" == propertyName) {
                BasicScrollBarUI.this.updateButtonDirections();
            } else if ("componentOrientation" == propertyName) {
                BasicScrollBarUI.this.updateButtonDirections();
                InputMap inputMap = BasicScrollBarUI.this.getInputMap(0);
                SwingUtilities.replaceUIInputMap(BasicScrollBarUI.this.scrollbar, 0, inputMap);
            }
        }
    }

    protected class ModelListener
    implements ChangeListener {
        protected ModelListener(BasicScrollBarUI basicScrollBarUI) {
        }

        public void stateChanged(ChangeEvent changeEvent) {
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public PropertyChangeHandler(BasicScrollBarUI basicScrollBarUI) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }
    }

    protected class ScrollListener
    implements ActionListener {
        public ScrollListener(BasicScrollBarUI basicScrollBarUI) {
        }

        public ScrollListener(BasicScrollBarUI basicScrollBarUI, int n, boolean bl) {
        }

        public void setDirection(int n) {
        }

        public void setScrollByBlock(boolean bl) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    protected class TrackListener
    extends MouseAdapter
    implements MouseMotionListener {
        protected transient int offset;
        protected transient int currentMouseX;
        protected transient int currentMouseY;

        protected TrackListener(BasicScrollBarUI basicScrollBarUI) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

