/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public class BasicSplitPaneUI
extends SplitPaneUI {
    protected static final String NON_CONTINUOUS_DIVIDER = "nonContinuousDivider";
    protected static int KEYBOARD_DIVIDER_MOVE_OFFSET;
    protected JSplitPane splitPane;
    protected BasicHorizontalLayoutManager layoutManager;
    protected BasicSplitPaneDivider divider;
    protected PropertyChangeListener propertyChangeListener;
    protected FocusListener focusListener;
    protected int dividerSize;
    protected Component nonContinuousLayoutDivider;
    protected boolean draggingHW;
    protected int beginDragDividerLocation;
    @Deprecated
    protected KeyStroke upKey;
    @Deprecated
    protected KeyStroke downKey;
    @Deprecated
    protected KeyStroke leftKey;
    @Deprecated
    protected KeyStroke rightKey;
    @Deprecated
    protected KeyStroke homeKey;
    @Deprecated
    protected KeyStroke endKey;
    @Deprecated
    protected KeyStroke dividerResizeToggleKey;
    @Deprecated
    protected ActionListener keyboardUpLeftListener;
    @Deprecated
    protected ActionListener keyboardDownRightListener;
    @Deprecated
    protected ActionListener keyboardHomeListener;
    @Deprecated
    protected ActionListener keyboardEndListener;
    @Deprecated
    protected ActionListener keyboardResizeToggleListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return null;
    }

    public void installUI(JComponent jComponent) {
    }

    protected void installDefaults() {
    }

    protected void installListeners() {
    }

    protected void installKeyboardActions() {
    }

    public void uninstallUI(JComponent jComponent) {
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
    }

    protected void uninstallKeyboardActions() {
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return null;
    }

    protected FocusListener createFocusListener() {
        return null;
    }

    @Deprecated
    protected ActionListener createKeyboardUpLeftListener() {
        return null;
    }

    @Deprecated
    protected ActionListener createKeyboardDownRightListener() {
        return null;
    }

    @Deprecated
    protected ActionListener createKeyboardHomeListener() {
        return null;
    }

    @Deprecated
    protected ActionListener createKeyboardEndListener() {
        return null;
    }

    @Deprecated
    protected ActionListener createKeyboardResizeToggleListener() {
        return null;
    }

    public int getOrientation() {
        return 0;
    }

    public void setOrientation(int n) {
    }

    public boolean isContinuousLayout() {
        return false;
    }

    public void setContinuousLayout(boolean bl) {
    }

    public int getLastDragLocation() {
        return 0;
    }

    public void setLastDragLocation(int n) {
    }

    public BasicSplitPaneDivider getDivider() {
        return null;
    }

    protected Component createDefaultNonContinuousLayoutDivider() {
        return null;
    }

    protected void setNonContinuousLayoutDivider(Component component) {
    }

    protected void setNonContinuousLayoutDivider(Component component, boolean bl) {
    }

    public Component getNonContinuousLayoutDivider() {
        return null;
    }

    public JSplitPane getSplitPane() {
        return null;
    }

    public BasicSplitPaneDivider createDefaultDivider() {
        return null;
    }

    public void resetToPreferredSizes(JSplitPane jSplitPane) {
    }

    public void setDividerLocation(JSplitPane jSplitPane, int n) {
    }

    public int getDividerLocation(JSplitPane jSplitPane) {
        return 0;
    }

    public int getMinimumDividerLocation(JSplitPane jSplitPane) {
        return 0;
    }

    public int getMaximumDividerLocation(JSplitPane jSplitPane) {
        return 0;
    }

    public void finishedPaintingChildren(JSplitPane jSplitPane, Graphics graphics) {
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    public Insets getInsets(JComponent jComponent) {
        return null;
    }

    protected void resetLayoutManager() {
    }

    protected void startDragging() {
    }

    protected void dragDividerTo(int n) {
    }

    protected void finishDraggingTo(int n) {
    }

    @Deprecated
    protected int getDividerBorderSize() {
        return 0;
    }

    private static class Actions
    extends UIAction {
        private static final String NEGATIVE_INCREMENT = "negativeIncrement";
        private static final String POSITIVE_INCREMENT = "positiveIncrement";
        private static final String SELECT_MIN = "selectMin";
        private static final String SELECT_MAX = "selectMax";
        private static final String START_RESIZE = "startResize";
        private static final String TOGGLE_FOCUS = "toggleFocus";
        private static final String FOCUS_OUT_FORWARD = "focusOutForward";
        private static final String FOCUS_OUT_BACKWARD = "focusOutBackward";

        Actions(String key) {
            super(key);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            JSplitPane splitPane = (JSplitPane)ev.getSource();
            BasicSplitPaneUI ui = (BasicSplitPaneUI)BasicLookAndFeel.getUIOfType((ComponentUI)splitPane.getUI(), BasicSplitPaneUI.class);
            if (ui == null) {
                return;
            }
            String key = this.getName();
            if (key == NEGATIVE_INCREMENT) {
                if (ui.dividerKeyboardResize) {
                    splitPane.setDividerLocation(Math.max(0, ui.getDividerLocation(splitPane) - ui.getKeyboardMoveIncrement()));
                }
            } else if (key == POSITIVE_INCREMENT) {
                if (ui.dividerKeyboardResize) {
                    splitPane.setDividerLocation(ui.getDividerLocation(splitPane) + ui.getKeyboardMoveIncrement());
                }
            } else if (key == SELECT_MIN) {
                if (ui.dividerKeyboardResize) {
                    splitPane.setDividerLocation(0);
                }
            } else if (key == SELECT_MAX) {
                if (ui.dividerKeyboardResize) {
                    int rightI;
                    Insets insets = splitPane.getInsets();
                    int bottomI = insets != null ? insets.bottom : 0;
                    int n = rightI = insets != null ? insets.right : 0;
                    if (ui.orientation == 0) {
                        splitPane.setDividerLocation(splitPane.getHeight() - bottomI);
                    } else {
                        splitPane.setDividerLocation(splitPane.getWidth() - rightI);
                    }
                }
            } else if (key == START_RESIZE) {
                if (!ui.dividerKeyboardResize) {
                    splitPane.requestFocus();
                } else {
                    JSplitPane parentSplitPane = (JSplitPane)SwingUtilities.getAncestorOfClass(JSplitPane.class, splitPane);
                    if (parentSplitPane != null) {
                        parentSplitPane.requestFocus();
                    }
                }
            } else if (key == TOGGLE_FOCUS) {
                this.toggleFocus(splitPane);
            } else if (key == FOCUS_OUT_FORWARD) {
                this.moveFocus(splitPane, 1);
            } else if (key == FOCUS_OUT_BACKWARD) {
                this.moveFocus(splitPane, -1);
            }
        }

        private void moveFocus(JSplitPane splitPane, int direction) {
            Container rootAncestor = splitPane.getFocusCycleRootAncestor();
            FocusTraversalPolicy policy = rootAncestor.getFocusTraversalPolicy();
            Component focusOn = direction > 0 ? policy.getComponentAfter(rootAncestor, splitPane) : policy.getComponentBefore(rootAncestor, splitPane);
            HashSet<Component> focusFrom = new HashSet<Component>();
            if (splitPane.isAncestorOf(focusOn)) {
                do {
                    focusFrom.add(focusOn);
                    rootAncestor = focusOn.getFocusCycleRootAncestor();
                    policy = rootAncestor.getFocusTraversalPolicy();
                    Component component = focusOn = direction > 0 ? policy.getComponentAfter(rootAncestor, focusOn) : policy.getComponentBefore(rootAncestor, focusOn);
                } while (splitPane.isAncestorOf(focusOn) && !focusFrom.contains(focusOn));
            }
            if (focusOn != null && !splitPane.isAncestorOf(focusOn)) {
                focusOn.requestFocus();
            }
        }

        private void toggleFocus(JSplitPane splitPane) {
            Component left = splitPane.getLeftComponent();
            Component right = splitPane.getRightComponent();
            KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component focus = manager.getFocusOwner();
            Component focusOn = this.getNextSide(splitPane, focus);
            if (focusOn != null) {
                if (focus != null && (SwingUtilities.isDescendingFrom(focus, left) && SwingUtilities.isDescendingFrom(focusOn, left) || SwingUtilities.isDescendingFrom(focus, right) && SwingUtilities.isDescendingFrom(focusOn, right))) {
                    return;
                }
                SwingUtilities2.compositeRequestFocus(focusOn);
            }
        }

        private Component getNextSide(JSplitPane splitPane, Component focus) {
            Component next;
            Component left = splitPane.getLeftComponent();
            Component right = splitPane.getRightComponent();
            if (focus != null && SwingUtilities.isDescendingFrom(focus, left) && right != null && (next = this.getFirstAvailableComponent(right)) != null) {
                return next;
            }
            JSplitPane parentSplitPane = (JSplitPane)SwingUtilities.getAncestorOfClass(JSplitPane.class, splitPane);
            if (parentSplitPane != null) {
                next = this.getNextSide(parentSplitPane, focus);
            } else {
                next = this.getFirstAvailableComponent(left);
                if (next == null) {
                    next = this.getFirstAvailableComponent(right);
                }
            }
            return next;
        }

        private Component getFirstAvailableComponent(Component c) {
            if (c instanceof JSplitPane) {
                JSplitPane sp = (JSplitPane)c;
                Component left = this.getFirstAvailableComponent(sp.getLeftComponent());
                c = left != null ? left : this.getFirstAvailableComponent(sp.getRightComponent());
            }
            return c;
        }
    }

    public class BasicHorizontalLayoutManager
    implements LayoutManager2 {
        protected int[] sizes;
        protected Component[] components;

        public void layoutContainer(Container container) {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            return null;
        }

        public Dimension preferredLayoutSize(Container container) {
            return null;
        }

        public void removeLayoutComponent(Component component) {
        }

        public void addLayoutComponent(Component component, Object object) {
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        public void invalidateLayout(Container container) {
        }

        public Dimension maximumLayoutSize(Container container) {
            return null;
        }

        public void resetToPreferredSizes() {
        }

        protected void resetSizeAt(int n) {
        }

        protected void setSizes(int[] nArray) {
        }

        protected int[] getSizes() {
            return null;
        }

        protected int getPreferredSizeOfComponent(Component component) {
            return 0;
        }

        protected int getSizeOfComponent(Component component) {
            return 0;
        }

        protected int getAvailableSize(Dimension dimension, Insets insets) {
            return 0;
        }

        protected int getInitialLocation(Insets insets) {
            return 0;
        }

        protected void setComponentToSize(Component component, int n, int n2, Insets insets, Dimension dimension) {
        }

        protected void updateComponents() {
        }
    }

    public class BasicVerticalLayoutManager
    extends BasicHorizontalLayoutManager {
        public BasicVerticalLayoutManager(BasicSplitPaneUI basicSplitPaneUI) {
        }
    }

    public class FocusHandler
    extends FocusAdapter {
        public FocusHandler(BasicSplitPaneUI basicSplitPaneUI) {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    private class Handler
    implements FocusListener,
    PropertyChangeListener {
        private Handler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getSource() == BasicSplitPaneUI.this.splitPane) {
                String changeName = e.getPropertyName();
                if (changeName == "orientation") {
                    BasicSplitPaneUI.this.orientation = BasicSplitPaneUI.this.splitPane.getOrientation();
                    BasicSplitPaneUI.this.resetLayoutManager();
                } else if (changeName == "continuousLayout") {
                    BasicSplitPaneUI.this.setContinuousLayout(BasicSplitPaneUI.this.splitPane.isContinuousLayout());
                    if (!BasicSplitPaneUI.this.isContinuousLayout()) {
                        if (BasicSplitPaneUI.this.nonContinuousLayoutDivider == null) {
                            BasicSplitPaneUI.this.setNonContinuousLayoutDivider(BasicSplitPaneUI.this.createDefaultNonContinuousLayoutDivider(), true);
                        } else if (BasicSplitPaneUI.this.nonContinuousLayoutDivider.getParent() == null) {
                            BasicSplitPaneUI.this.setNonContinuousLayoutDivider(BasicSplitPaneUI.this.nonContinuousLayoutDivider, true);
                        }
                    }
                } else if (changeName == "dividerSize") {
                    BasicSplitPaneUI.this.divider.setDividerSize(BasicSplitPaneUI.this.splitPane.getDividerSize());
                    BasicSplitPaneUI.this.dividerSize = BasicSplitPaneUI.this.divider.getDividerSize();
                    BasicSplitPaneUI.this.splitPane.revalidate();
                    BasicSplitPaneUI.this.splitPane.repaint();
                }
            }
        }

        @Override
        public void focusGained(FocusEvent ev) {
            BasicSplitPaneUI.this.dividerKeyboardResize = true;
            BasicSplitPaneUI.this.splitPane.repaint();
        }

        @Override
        public void focusLost(FocusEvent ev) {
            BasicSplitPaneUI.this.dividerKeyboardResize = false;
            BasicSplitPaneUI.this.splitPane.repaint();
        }
    }

    public class KeyboardDownRightHandler
    implements ActionListener {
        public KeyboardDownRightHandler(BasicSplitPaneUI basicSplitPaneUI) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public class KeyboardEndHandler
    implements ActionListener {
        public KeyboardEndHandler(BasicSplitPaneUI basicSplitPaneUI) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public class KeyboardHomeHandler
    implements ActionListener {
        public KeyboardHomeHandler(BasicSplitPaneUI basicSplitPaneUI) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public class KeyboardResizeToggleHandler
    implements ActionListener {
        public KeyboardResizeToggleHandler(BasicSplitPaneUI basicSplitPaneUI) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public class KeyboardUpLeftHandler
    implements ActionListener {
        public KeyboardUpLeftHandler(BasicSplitPaneUI basicSplitPaneUI) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public class PropertyHandler
    implements PropertyChangeListener {
        public PropertyHandler(BasicSplitPaneUI basicSplitPaneUI) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }
    }
}

