/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public class BasicTabbedPaneUI
extends TabbedPaneUI
implements SwingConstants {
    protected JTabbedPane tabPane;
    protected Color highlight;
    protected Color lightHighlight;
    protected Color shadow;
    protected Color darkShadow;
    protected Color focus;
    protected int textIconGap;
    protected int tabRunOverlay;
    protected Insets tabInsets;
    protected Insets selectedTabPadInsets;
    protected Insets tabAreaInsets;
    protected Insets contentBorderInsets;
    @Deprecated
    protected KeyStroke upKey;
    @Deprecated
    protected KeyStroke downKey;
    @Deprecated
    protected KeyStroke leftKey;
    @Deprecated
    protected KeyStroke rightKey;
    protected int[] tabRuns;
    protected int runCount;
    protected int selectedRun;
    protected Rectangle[] rects;
    protected int maxTabHeight;
    protected int maxTabWidth;
    protected ChangeListener tabChangeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MouseListener mouseListener;
    protected FocusListener focusListener;
    protected transient Rectangle calcRect;

    public static ComponentUI createUI(JComponent jComponent) {
        return null;
    }

    public void installUI(JComponent jComponent) {
    }

    public void uninstallUI(JComponent jComponent) {
    }

    protected LayoutManager createLayoutManager() {
        return null;
    }

    protected void installComponents() {
    }

    protected JButton createScrollButton(int n) {
        return null;
    }

    protected void uninstallComponents() {
    }

    protected void installDefaults() {
    }

    protected void uninstallDefaults() {
    }

    protected void installListeners() {
    }

    protected void uninstallListeners() {
    }

    protected MouseListener createMouseListener() {
        return null;
    }

    protected FocusListener createFocusListener() {
        return null;
    }

    protected ChangeListener createChangeListener() {
        return null;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return null;
    }

    protected void installKeyboardActions() {
    }

    protected void uninstallKeyboardActions() {
    }

    protected void setRolloverTab(int n) {
    }

    protected int getRolloverTab() {
        return 0;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    protected void paintTabArea(Graphics graphics, int n, int n2) {
    }

    protected void paintTab(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
    }

    protected void layoutLabel(int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
    }

    protected void paintIcon(Graphics graphics, int n, int n2, Icon icon, Rectangle rectangle, boolean bl) {
    }

    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
    }

    protected int getTabLabelShiftX(int n, int n2, boolean bl) {
        return 0;
    }

    protected int getTabLabelShiftY(int n, int n2, boolean bl) {
        return 0;
    }

    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
    }

    protected void paintContentBorder(Graphics graphics, int n, int n2) {
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    protected void paintContentBorderLeftEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n) {
        return null;
    }

    public int getTabRunCount(JTabbedPane jTabbedPane) {
        return 0;
    }

    public int tabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        return 0;
    }

    protected Rectangle getTabBounds(int n, Rectangle rectangle) {
        return null;
    }

    protected Component getVisibleComponent() {
        return null;
    }

    protected void setVisibleComponent(Component component) {
    }

    protected void assureRectsCreated(int n) {
    }

    protected void expandTabRunsArray() {
    }

    protected int getRunForTab(int n, int n2) {
        return 0;
    }

    protected int lastTabInRun(int n, int n2) {
        return 0;
    }

    protected int getTabRunOverlay(int n) {
        return 0;
    }

    protected int getTabRunIndent(int n, int n2) {
        return 0;
    }

    protected boolean shouldPadTabRun(int n, int n2) {
        return false;
    }

    protected boolean shouldRotateTabRuns(int n) {
        return false;
    }

    protected Icon getIconForTab(int n) {
        return null;
    }

    protected View getTextViewForTab(int n) {
        return null;
    }

    protected int calculateTabHeight(int n, int n2, int n3) {
        return 0;
    }

    protected int calculateMaxTabHeight(int n) {
        return 0;
    }

    protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
        return 0;
    }

    protected int calculateMaxTabWidth(int n) {
        return 0;
    }

    protected int calculateTabAreaHeight(int n, int n2, int n3) {
        return 0;
    }

    protected int calculateTabAreaWidth(int n, int n2, int n3) {
        return 0;
    }

    protected Insets getTabInsets(int n, int n2) {
        return null;
    }

    protected Insets getSelectedTabPadInsets(int n) {
        return null;
    }

    protected Insets getTabAreaInsets(int n) {
        return null;
    }

    protected Insets getContentBorderInsets(int n) {
        return null;
    }

    protected FontMetrics getFontMetrics() {
        return null;
    }

    protected void navigateSelectedTab(int n) {
    }

    protected void selectNextTabInRun(int n) {
    }

    protected void selectPreviousTabInRun(int n) {
    }

    protected void selectNextTab(int n) {
    }

    protected void selectPreviousTab(int n) {
    }

    protected void selectAdjacentRunTab(int n, int n2, int n3) {
    }

    protected int getFocusIndex() {
        return 0;
    }

    protected int getTabRunOffset(int n, int n2, int n3, boolean bl) {
        return 0;
    }

    protected int getPreviousTabIndex(int n) {
        return 0;
    }

    protected int getNextTabIndex(int n) {
        return 0;
    }

    protected int getNextTabIndexInRun(int n, int n2) {
        return 0;
    }

    protected int getPreviousTabIndexInRun(int n, int n2) {
        return 0;
    }

    protected int getPreviousTabRun(int n) {
        return 0;
    }

    protected int getNextTabRun(int n) {
        return 0;
    }

    protected static void rotateInsets(Insets insets, Insets insets2, int n) {
    }

    private static class Actions
    extends UIAction {
        static final String NEXT = "navigateNext";
        static final String PREVIOUS = "navigatePrevious";
        static final String RIGHT = "navigateRight";
        static final String LEFT = "navigateLeft";
        static final String UP = "navigateUp";
        static final String DOWN = "navigateDown";
        static final String PAGE_UP = "navigatePageUp";
        static final String PAGE_DOWN = "navigatePageDown";
        static final String REQUEST_FOCUS = "requestFocus";
        static final String REQUEST_FOCUS_FOR_VISIBLE = "requestFocusForVisibleComponent";
        static final String SET_SELECTED = "setSelectedIndex";
        static final String SELECT_FOCUSED = "selectTabWithFocus";
        static final String SCROLL_FORWARD = "scrollTabsForwardAction";
        static final String SCROLL_BACKWARD = "scrollTabsBackwardAction";

        Actions(String key) {
            super(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String key = this.getName();
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BasicTabbedPaneUI ui = (BasicTabbedPaneUI)BasicLookAndFeel.getUIOfType((ComponentUI)pane.getUI(), BasicTabbedPaneUI.class);
            if (ui == null) {
                return;
            }
            if (key == NEXT) {
                ui.navigateSelectedTab(12);
            } else if (key == PREVIOUS) {
                ui.navigateSelectedTab(13);
            } else if (key == RIGHT) {
                ui.navigateSelectedTab(3);
            } else if (key == LEFT) {
                ui.navigateSelectedTab(7);
            } else if (key == UP) {
                ui.navigateSelectedTab(1);
            } else if (key == DOWN) {
                ui.navigateSelectedTab(5);
            } else if (key == PAGE_UP) {
                int tabPlacement = pane.getTabPlacement();
                if (tabPlacement == 1 || tabPlacement == 3) {
                    ui.navigateSelectedTab(7);
                } else {
                    ui.navigateSelectedTab(1);
                }
            } else if (key == PAGE_DOWN) {
                int tabPlacement = pane.getTabPlacement();
                if (tabPlacement == 1 || tabPlacement == 3) {
                    ui.navigateSelectedTab(3);
                } else {
                    ui.navigateSelectedTab(5);
                }
            } else if (key == REQUEST_FOCUS) {
                pane.requestFocus();
            } else if (key == REQUEST_FOCUS_FOR_VISIBLE) {
                ui.requestFocusForVisibleComponent();
            } else if (key == SET_SELECTED) {
                String command = e.getActionCommand();
                if (command != null && command.length() > 0) {
                    Integer index;
                    int mnemonic = e.getActionCommand().charAt(0);
                    if (mnemonic >= 97 && mnemonic <= 122) {
                        mnemonic -= 32;
                    }
                    if ((index = (Integer)ui.mnemonicToIndexMap.get(mnemonic)) != null && pane.isEnabledAt(index)) {
                        pane.setSelectedIndex(index);
                    }
                }
            } else if (key == SELECT_FOCUSED) {
                int focusIndex = ui.getFocusIndex();
                if (focusIndex != -1) {
                    pane.setSelectedIndex(focusIndex);
                }
            } else if (key == SCROLL_FORWARD) {
                if (ui.scrollableTabLayoutEnabled()) {
                    ui.tabScroller.scrollForward(pane.getTabPlacement());
                }
            } else if (key == SCROLL_BACKWARD && ui.scrollableTabLayoutEnabled()) {
                ui.tabScroller.scrollBackward(pane.getTabPlacement());
            }
        }
    }

    public class FocusHandler
    extends FocusAdapter {
        public FocusHandler(BasicTabbedPaneUI basicTabbedPaneUI) {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    private class Handler
    implements ChangeListener,
    ContainerListener,
    FocusListener,
    MouseListener,
    MouseMotionListener,
    PropertyChangeListener {
        private Handler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            String name = e.getPropertyName();
            boolean isScrollLayout = BasicTabbedPaneUI.this.scrollableTabLayoutEnabled();
            if (name == "mnemonicAt") {
                BasicTabbedPaneUI.this.updateMnemonics();
                pane.repaint();
            } else if (name == "displayedMnemonicIndexAt") {
                pane.repaint();
            } else if (name == "indexForTitle") {
                BasicTabbedPaneUI.this.calculatedBaseline = false;
                Integer index = (Integer)e.getNewValue();
                this.updateHtmlViews(index, false);
            } else if (name == "tabLayoutPolicy") {
                BasicTabbedPaneUI.this.uninstallUI(pane);
                BasicTabbedPaneUI.this.installUI(pane);
                BasicTabbedPaneUI.this.calculatedBaseline = false;
            } else if (name == "tabPlacement") {
                if (BasicTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                    BasicTabbedPaneUI.this.tabScroller.createButtons();
                }
                BasicTabbedPaneUI.this.calculatedBaseline = false;
            } else if (name == "opaque" && isScrollLayout) {
                boolean newVal = (Boolean)e.getNewValue();
                BasicTabbedPaneUI.this.tabScroller.tabPanel.setOpaque(newVal);
                BasicTabbedPaneUI.this.tabScroller.viewport.setOpaque(newVal);
            } else if (name == "background" && isScrollLayout) {
                Color newVal = (Color)e.getNewValue();
                BasicTabbedPaneUI.this.tabScroller.tabPanel.setBackground(newVal);
                BasicTabbedPaneUI.this.tabScroller.viewport.setBackground(newVal);
                Color newColor = BasicTabbedPaneUI.this.selectedColor == null ? newVal : BasicTabbedPaneUI.this.selectedColor;
                BasicTabbedPaneUI.this.tabScroller.scrollForwardButton.setBackground(newColor);
                BasicTabbedPaneUI.this.tabScroller.scrollBackwardButton.setBackground(newColor);
            } else if (name == "indexForTabComponent") {
                Component c;
                if (BasicTabbedPaneUI.this.tabContainer != null) {
                    BasicTabbedPaneUI.this.tabContainer.removeUnusedTabComponents();
                }
                if ((c = BasicTabbedPaneUI.this.tabPane.getTabComponentAt((Integer)e.getNewValue())) != null) {
                    if (BasicTabbedPaneUI.this.tabContainer == null) {
                        BasicTabbedPaneUI.this.installTabContainer();
                    } else {
                        BasicTabbedPaneUI.this.tabContainer.add(c);
                    }
                }
                BasicTabbedPaneUI.this.tabPane.revalidate();
                BasicTabbedPaneUI.this.tabPane.repaint();
                BasicTabbedPaneUI.this.calculatedBaseline = false;
            } else if (name == "indexForNullComponent") {
                BasicTabbedPaneUI.this.isRunsDirty = true;
                this.updateHtmlViews((Integer)e.getNewValue(), true);
            } else if (name == "font" || SwingUtilities2.isScaleChanged(e)) {
                BasicTabbedPaneUI.this.calculatedBaseline = false;
            }
        }

        private void updateHtmlViews(int index, boolean inserted) {
            String title = BasicTabbedPaneUI.this.tabPane.getTitleAt(index);
            boolean isHTML = BasicHTML.isHTMLString(title);
            if (isHTML) {
                if (BasicTabbedPaneUI.this.htmlViews == null) {
                    BasicTabbedPaneUI.this.htmlViews = BasicTabbedPaneUI.this.createHTMLVector();
                } else {
                    View v = BasicHTML.createHTMLView(BasicTabbedPaneUI.this.tabPane, title);
                    this.setHtmlView(v, inserted, index);
                }
            } else if (BasicTabbedPaneUI.this.htmlViews != null) {
                this.setHtmlView(null, inserted, index);
            }
            BasicTabbedPaneUI.this.updateMnemonics();
        }

        private void setHtmlView(View v, boolean inserted, int index) {
            if (inserted || index >= BasicTabbedPaneUI.this.htmlViews.size()) {
                BasicTabbedPaneUI.this.htmlViews.insertElementAt(v, index);
            } else {
                BasicTabbedPaneUI.this.htmlViews.setElementAt(v, index);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            tabPane.revalidate();
            tabPane.repaint();
            BasicTabbedPaneUI.this.setFocusIndex(tabPane.getSelectedIndex(), false);
            if (tabPane.getLayout() instanceof TabbedPaneScrollLayout) {
                BasicTabbedPaneUI.this.ensureCurrentLayout();
                int index = tabPane.getSelectedIndex();
                if (index < BasicTabbedPaneUI.this.rects.length && index != -1) {
                    BasicTabbedPaneUI.this.tabScroller.tabPanel.scrollRectToVisible((Rectangle)BasicTabbedPaneUI.this.rects[index].clone());
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            BasicTabbedPaneUI.this.setRolloverTab(e.getX(), e.getY());
        }

        @Override
        public void mouseExited(MouseEvent e) {
            BasicTabbedPaneUI.this.setRolloverTab(-1);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!BasicTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int tabIndex = BasicTabbedPaneUI.this.tabForCoordinate(BasicTabbedPaneUI.this.tabPane, e.getX(), e.getY());
            if (tabIndex >= 0 && BasicTabbedPaneUI.this.tabPane.isEnabledAt(tabIndex)) {
                if (tabIndex != BasicTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    BasicTabbedPaneUI.this.tabPane.setSelectedIndex(tabIndex);
                } else if (BasicTabbedPaneUI.this.tabPane.isRequestFocusEnabled()) {
                    BasicTabbedPaneUI.this.tabPane.requestFocus(FocusEvent.Cause.MOUSE_EVENT);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            BasicTabbedPaneUI.this.setRolloverTab(e.getX(), e.getY());
        }

        @Override
        public void focusGained(FocusEvent e) {
            BasicTabbedPaneUI.this.setFocusIndex(BasicTabbedPaneUI.this.tabPane.getSelectedIndex(), true);
        }

        @Override
        public void focusLost(FocusEvent e) {
            BasicTabbedPaneUI.this.repaintTab(BasicTabbedPaneUI.this.focusIndex);
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            JTabbedPane tp = (JTabbedPane)e.getContainer();
            Component child = e.getChild();
            if (child instanceof UIResource) {
                return;
            }
            BasicTabbedPaneUI.this.isRunsDirty = true;
            this.updateHtmlViews(tp.indexOfComponent(child), true);
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            JTabbedPane tp = (JTabbedPane)e.getContainer();
            Component child = e.getChild();
            if (child instanceof UIResource) {
                return;
            }
            Integer indexObj = (Integer)tp.getClientProperty("__index_to_remove__");
            if (indexObj != null) {
                int index = indexObj;
                if (BasicTabbedPaneUI.this.htmlViews != null && BasicTabbedPaneUI.this.htmlViews.size() > index) {
                    BasicTabbedPaneUI.this.htmlViews.removeElementAt(index);
                }
                tp.putClientProperty("__index_to_remove__", null);
            }
            BasicTabbedPaneUI.this.isRunsDirty = true;
            BasicTabbedPaneUI.this.updateMnemonics();
            BasicTabbedPaneUI.this.validateFocusIndex();
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        public MouseHandler(BasicTabbedPaneUI basicTabbedPaneUI) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public PropertyChangeHandler(BasicTabbedPaneUI basicTabbedPaneUI) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }
    }

    private static class ScrollableTabButton
    extends BasicArrowButton
    implements UIResource,
    SwingConstants {
        public ScrollableTabButton(int direction) {
            super(direction, UIManager.getColor("TabbedPane.selected"), UIManager.getColor("TabbedPane.shadow"), UIManager.getColor("TabbedPane.darkShadow"), UIManager.getColor("TabbedPane.highlight"));
        }
    }

    private class ScrollableTabPanel
    extends JPanel
    implements UIResource {
        public ScrollableTabPanel() {
            super(null);
            this.setOpaque(BasicTabbedPaneUI.this.tabPane.isOpaque());
            Color background = BasicTabbedPaneUI.this.tabPane.getBackground();
            Color tabAreaBackground = UIManager.getColor("TabbedPane.tabAreaBackground");
            if (background instanceof UIResource && tabAreaBackground != null) {
                this.setBackground(tabAreaBackground);
            } else {
                this.setBackground(background);
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            BasicTabbedPaneUI.this.paintTabArea(g, BasicTabbedPaneUI.this.tabPane.getTabPlacement(), BasicTabbedPaneUI.this.tabPane.getSelectedIndex());
            if (BasicTabbedPaneUI.this.tabScroller.croppedEdge.isParamsSet() && BasicTabbedPaneUI.this.tabContainer == null) {
                Rectangle croppedRect = BasicTabbedPaneUI.this.rects[BasicTabbedPaneUI.this.tabScroller.croppedEdge.getTabIndex()];
                g.translate(croppedRect.x, croppedRect.y);
                BasicTabbedPaneUI.this.tabScroller.croppedEdge.paintComponent(g);
                g.translate(-croppedRect.x, -croppedRect.y);
            }
        }

        @Override
        public void doLayout() {
            if (this.getComponentCount() > 0) {
                Component child = this.getComponent(0);
                child.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }

    private class ScrollableTabSupport
    implements ActionListener,
    ChangeListener {
        public ScrollableTabViewport viewport;
        public ScrollableTabPanel tabPanel;
        public JButton scrollForwardButton;
        public JButton scrollBackwardButton;
        public CroppedEdge croppedEdge;
        public int leadingTabIndex;
        private Point tabViewPosition = new Point(0, 0);

        ScrollableTabSupport(int tabPlacement) {
            this.viewport = new ScrollableTabViewport();
            this.tabPanel = new ScrollableTabPanel();
            this.viewport.setView(this.tabPanel);
            this.viewport.addChangeListener(this);
            this.croppedEdge = new CroppedEdge(BasicTabbedPaneUI.this);
            this.createButtons();
        }

        void createButtons() {
            int tabPlacement;
            if (this.scrollForwardButton != null) {
                BasicTabbedPaneUI.this.tabPane.remove(this.scrollForwardButton);
                this.scrollForwardButton.removeActionListener(this);
                BasicTabbedPaneUI.this.tabPane.remove(this.scrollBackwardButton);
                this.scrollBackwardButton.removeActionListener(this);
            }
            if ((tabPlacement = BasicTabbedPaneUI.this.tabPane.getTabPlacement()) == 1 || tabPlacement == 3) {
                this.scrollForwardButton = BasicTabbedPaneUI.this.createScrollButton(3);
                this.scrollBackwardButton = BasicTabbedPaneUI.this.createScrollButton(7);
            } else {
                this.scrollForwardButton = BasicTabbedPaneUI.this.createScrollButton(5);
                this.scrollBackwardButton = BasicTabbedPaneUI.this.createScrollButton(1);
            }
            this.scrollForwardButton.addActionListener(this);
            this.scrollBackwardButton.addActionListener(this);
            BasicTabbedPaneUI.this.tabPane.add(this.scrollForwardButton);
            BasicTabbedPaneUI.this.tabPane.add(this.scrollBackwardButton);
        }

        public void scrollForward(int tabPlacement) {
            Dimension viewSize = this.viewport.getViewSize();
            Rectangle viewRect = this.viewport.getViewRect();
            if (tabPlacement == 1 || tabPlacement == 3 ? viewRect.width >= viewSize.width - viewRect.x : viewRect.height >= viewSize.height - viewRect.y) {
                return;
            }
            this.setLeadingTabIndex(tabPlacement, this.leadingTabIndex + 1);
        }

        public void scrollBackward(int tabPlacement) {
            if (this.leadingTabIndex == 0) {
                return;
            }
            this.setLeadingTabIndex(tabPlacement, this.leadingTabIndex - 1);
        }

        public void setLeadingTabIndex(int tabPlacement, int index) {
            this.leadingTabIndex = index;
            Dimension viewSize = this.viewport.getViewSize();
            Rectangle viewRect = this.viewport.getViewRect();
            switch (tabPlacement) {
                case 1: 
                case 3: {
                    int n = this.tabViewPosition.x = this.leadingTabIndex == 0 ? 0 : BasicTabbedPaneUI.this.rects[this.leadingTabIndex].x;
                    if (viewSize.width - this.tabViewPosition.x >= viewRect.width) break;
                    Dimension extentSize = new Dimension(viewSize.width - this.tabViewPosition.x, viewRect.height);
                    this.viewport.setExtentSize(extentSize);
                    break;
                }
                case 2: 
                case 4: {
                    int n = this.tabViewPosition.y = this.leadingTabIndex == 0 ? 0 : BasicTabbedPaneUI.this.rects[this.leadingTabIndex].y;
                    if (viewSize.height - this.tabViewPosition.y >= viewRect.height) break;
                    Dimension extentSize = new Dimension(viewRect.width, viewSize.height - this.tabViewPosition.y);
                    this.viewport.setExtentSize(extentSize);
                }
            }
            this.viewport.setViewPosition(this.tabViewPosition);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateView();
        }

        private void updateView() {
            int tabPlacement = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            int tabCount = BasicTabbedPaneUI.this.tabPane.getTabCount();
            BasicTabbedPaneUI.this.assureRectsCreated(tabCount);
            Rectangle vpRect = this.viewport.getBounds();
            Dimension viewSize = this.viewport.getViewSize();
            Rectangle viewRect = this.viewport.getViewRect();
            this.leadingTabIndex = BasicTabbedPaneUI.this.getClosestTab(viewRect.x, viewRect.y);
            if (this.leadingTabIndex + 1 < tabCount) {
                switch (tabPlacement) {
                    case 1: 
                    case 3: {
                        if (BasicTabbedPaneUI.this.rects[this.leadingTabIndex].x >= viewRect.x) break;
                        ++this.leadingTabIndex;
                        break;
                    }
                    case 2: 
                    case 4: {
                        if (BasicTabbedPaneUI.this.rects[this.leadingTabIndex].y >= viewRect.y) break;
                        ++this.leadingTabIndex;
                    }
                }
            }
            Insets contentInsets = BasicTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
            switch (tabPlacement) {
                case 2: {
                    BasicTabbedPaneUI.this.tabPane.repaint(vpRect.x + vpRect.width, vpRect.y, contentInsets.left, vpRect.height);
                    this.scrollBackwardButton.setEnabled(viewRect.y > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.height - viewRect.y > viewRect.height);
                    break;
                }
                case 4: {
                    BasicTabbedPaneUI.this.tabPane.repaint(vpRect.x - contentInsets.right, vpRect.y, contentInsets.right, vpRect.height);
                    this.scrollBackwardButton.setEnabled(viewRect.y > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.height - viewRect.y > viewRect.height);
                    break;
                }
                case 3: {
                    BasicTabbedPaneUI.this.tabPane.repaint(vpRect.x, vpRect.y - contentInsets.bottom, vpRect.width, contentInsets.bottom);
                    this.scrollBackwardButton.setEnabled(viewRect.x > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.width - viewRect.x > viewRect.width);
                    break;
                }
                default: {
                    BasicTabbedPaneUI.this.tabPane.repaint(vpRect.x, vpRect.y + vpRect.height, vpRect.width, contentInsets.top);
                    this.scrollBackwardButton.setEnabled(viewRect.x > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.width - viewRect.x > viewRect.width);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String actionKey;
            Action action;
            ActionMap map = BasicTabbedPaneUI.this.tabPane.getActionMap();
            if (map != null && (action = map.get(actionKey = e.getSource() == this.scrollForwardButton ? "scrollTabsForwardAction" : "scrollTabsBackwardAction")) != null && action.isEnabled()) {
                action.actionPerformed(new ActionEvent(BasicTabbedPaneUI.this.tabPane, 1001, null, e.getWhen(), e.getModifiers()));
            }
        }

        public String toString() {
            return "viewport.viewSize=" + String.valueOf(this.viewport.getViewSize()) + "\nviewport.viewRectangle=" + String.valueOf(this.viewport.getViewRect()) + "\nleadingTabIndex=" + this.leadingTabIndex + "\ntabViewPosition=" + String.valueOf(this.tabViewPosition);
        }
    }

    private class ScrollableTabViewport
    extends JViewport
    implements UIResource {
        public ScrollableTabViewport() {
            this.setName("TabbedPane.scrollableViewport");
            this.setScrollMode(0);
            this.setOpaque(BasicTabbedPaneUI.this.tabPane.isOpaque());
            Color bgColor = UIManager.getColor("TabbedPane.tabAreaBackground");
            if (bgColor == null) {
                bgColor = BasicTabbedPaneUI.this.tabPane.getBackground();
            }
            this.setBackground(bgColor);
        }
    }

    public class TabSelectionHandler
    implements ChangeListener {
        public TabSelectionHandler(BasicTabbedPaneUI basicTabbedPaneUI) {
        }

        public void stateChanged(ChangeEvent changeEvent) {
        }
    }

    public class TabbedPaneLayout
    implements LayoutManager {
        public TabbedPaneLayout(BasicTabbedPaneUI basicTabbedPaneUI) {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return null;
        }

        public Dimension minimumLayoutSize(Container container) {
            return null;
        }

        protected Dimension calculateSize(boolean bl) {
            return null;
        }

        protected int preferredTabAreaHeight(int n, int n2) {
            return 0;
        }

        protected int preferredTabAreaWidth(int n, int n2) {
            return 0;
        }

        public void layoutContainer(Container container) {
        }

        public void calculateLayoutInfo() {
        }

        protected void calculateTabRects(int n, int n2) {
        }

        protected void rotateTabRuns(int n, int n2) {
        }

        protected void normalizeTabRuns(int n, int n2, int n3, int n4) {
        }

        protected void padTabRun(int n, int n2, int n3, int n4) {
        }

        protected void padSelectedTab(int n, int n2) {
        }
    }

    private class TabbedPaneScrollLayout
    extends TabbedPaneLayout {
        private TabbedPaneScrollLayout() {
            super(BasicTabbedPaneUI.this);
        }

        @Override
        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            return BasicTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, 1, BasicTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement));
        }

        @Override
        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            return BasicTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, 1, BasicTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement));
        }

        @Override
        public void layoutContainer(Container parent) {
            BasicTabbedPaneUI.this.setRolloverTab(-1);
            int tabPlacement = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            int tabCount = BasicTabbedPaneUI.this.tabPane.getTabCount();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            int selectedIndex = BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component visibleComponent = BasicTabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            Component selectedComponent = null;
            if (selectedIndex < 0) {
                if (visibleComponent != null) {
                    BasicTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                selectedComponent = BasicTabbedPaneUI.this.tabPane.getComponentAt(selectedIndex);
            }
            if (BasicTabbedPaneUI.this.tabPane.getTabCount() == 0) {
                BasicTabbedPaneUI.this.tabScroller.croppedEdge.resetParams();
                BasicTabbedPaneUI.this.tabScroller.scrollForwardButton.setVisible(false);
                BasicTabbedPaneUI.this.tabScroller.scrollBackwardButton.setVisible(false);
                return;
            }
            boolean shouldChangeFocus = false;
            if (selectedComponent != null) {
                if (selectedComponent != visibleComponent && visibleComponent != null && SwingUtilities.findFocusOwner(visibleComponent) != null) {
                    shouldChangeFocus = true;
                }
                BasicTabbedPaneUI.this.setVisibleComponent(selectedComponent);
            }
            Insets contentInsets = BasicTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
            Rectangle bounds = BasicTabbedPaneUI.this.tabPane.getBounds();
            int numChildren = BasicTabbedPaneUI.this.tabPane.getComponentCount();
            if (numChildren > 0) {
                int cw;
                int cy;
                int cx;
                int ty;
                int tx;
                int th;
                int tw;
                int ch = switch (tabPlacement) {
                    case 2 -> {
                        tw = BasicTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                        th = bounds.height - insets.top - insets.bottom;
                        tx = insets.left;
                        ty = insets.top;
                        cx = tx + tw + contentInsets.left;
                        cy = ty + contentInsets.top;
                        cw = bounds.width - insets.left - insets.right - tw - contentInsets.left - contentInsets.right;
                        yield bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                    }
                    case 4 -> {
                        tw = BasicTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                        th = bounds.height - insets.top - insets.bottom;
                        tx = bounds.width - insets.right - tw;
                        ty = insets.top;
                        cx = insets.left + contentInsets.left;
                        cy = insets.top + contentInsets.top;
                        cw = bounds.width - insets.left - insets.right - tw - contentInsets.left - contentInsets.right;
                        yield bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                    }
                    case 3 -> {
                        tw = bounds.width - insets.left - insets.right;
                        th = BasicTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                        tx = insets.left;
                        ty = bounds.height - insets.bottom - th;
                        cx = insets.left + contentInsets.left;
                        cy = insets.top + contentInsets.top;
                        cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                        yield bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                    }
                    default -> {
                        tw = bounds.width - insets.left - insets.right;
                        th = BasicTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                        tx = insets.left;
                        ty = insets.top;
                        cx = tx + contentInsets.left;
                        cy = ty + th + contentInsets.top;
                        cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                        yield bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                    }
                };
                for (int i = 0; i < numChildren; ++i) {
                    Component child = BasicTabbedPaneUI.this.tabPane.getComponent(i);
                    if (BasicTabbedPaneUI.this.tabScroller != null && child == BasicTabbedPaneUI.this.tabScroller.viewport) {
                        JViewport viewport = (JViewport)child;
                        Rectangle viewRect = viewport.getViewRect();
                        int vw = tw;
                        int vh = th;
                        Dimension butSize = BasicTabbedPaneUI.this.tabScroller.scrollForwardButton.getPreferredSize();
                        switch (tabPlacement) {
                            case 2: 
                            case 4: {
                                int totalTabHeight = BasicTabbedPaneUI.this.rects[tabCount - 1].y + BasicTabbedPaneUI.this.rects[tabCount - 1].height;
                                if (totalTabHeight <= th) break;
                                int n = vh = th > 2 * butSize.height ? th - 2 * butSize.height : 0;
                                if (totalTabHeight - viewRect.y > vh) break;
                                vh = totalTabHeight - viewRect.y;
                                break;
                            }
                            default: {
                                int totalTabWidth = BasicTabbedPaneUI.this.rects[tabCount - 1].x + BasicTabbedPaneUI.this.rects[tabCount - 1].width;
                                if (totalTabWidth <= tw) break;
                                int n = vw = tw > 2 * butSize.width ? tw - 2 * butSize.width : 0;
                                if (totalTabWidth - viewRect.x > vw) break;
                                vw = totalTabWidth - viewRect.x;
                            }
                        }
                        child.setBounds(tx, ty, vw, vh);
                        continue;
                    }
                    if (BasicTabbedPaneUI.this.tabScroller != null && (child == BasicTabbedPaneUI.this.tabScroller.scrollForwardButton || child == BasicTabbedPaneUI.this.tabScroller.scrollBackwardButton)) {
                        Component scrollbutton = child;
                        Dimension bsize = scrollbutton.getPreferredSize();
                        int bx = 0;
                        int by = 0;
                        int bw = bsize.width;
                        int bh = bsize.height;
                        boolean visible = false;
                        switch (tabPlacement) {
                            case 2: 
                            case 4: {
                                int totalTabHeight = BasicTabbedPaneUI.this.rects[tabCount - 1].y + BasicTabbedPaneUI.this.rects[tabCount - 1].height;
                                if (totalTabHeight <= th) break;
                                visible = true;
                                bx = tabPlacement == 2 ? tx + tw - bsize.width : tx;
                                by = child == BasicTabbedPaneUI.this.tabScroller.scrollForwardButton ? bounds.height - insets.bottom - bsize.height : bounds.height - insets.bottom - 2 * bsize.height;
                                break;
                            }
                            default: {
                                int totalTabWidth = BasicTabbedPaneUI.this.rects[tabCount - 1].x + BasicTabbedPaneUI.this.rects[tabCount - 1].width;
                                if (totalTabWidth <= tw) break;
                                visible = true;
                                bx = child == BasicTabbedPaneUI.this.tabScroller.scrollForwardButton ? bounds.width - insets.left - bsize.width : bounds.width - insets.left - 2 * bsize.width;
                                by = tabPlacement == 1 ? ty + th - bsize.height : ty;
                            }
                        }
                        child.setVisible(visible);
                        if (!visible) continue;
                        child.setBounds(bx, by, bw, bh);
                        continue;
                    }
                    child.setBounds(cx, cy, cw, ch);
                }
                super.layoutTabComponents();
                this.layoutCroppedEdge();
                if (shouldChangeFocus && !BasicTabbedPaneUI.this.requestFocusForVisibleComponent()) {
                    BasicTabbedPaneUI.this.tabPane.requestFocus();
                }
            }
        }

        private void layoutCroppedEdge() {
            BasicTabbedPaneUI.this.tabScroller.croppedEdge.resetParams();
            Rectangle viewRect = BasicTabbedPaneUI.this.tabScroller.viewport.getViewRect();
            block3: for (int i = 0; i < BasicTabbedPaneUI.this.rects.length; ++i) {
                Rectangle tabRect = BasicTabbedPaneUI.this.rects[i];
                switch (BasicTabbedPaneUI.this.tabPane.getTabPlacement()) {
                    case 2: 
                    case 4: {
                        int cropline = viewRect.y + viewRect.height;
                        if (tabRect.y >= cropline || tabRect.y + tabRect.height <= cropline) continue block3;
                        BasicTabbedPaneUI.this.tabScroller.croppedEdge.setParams(i, cropline - tabRect.y - 1, -BasicTabbedPaneUI.this.currentTabAreaInsets.left, 0);
                        continue block3;
                    }
                    default: {
                        int cropline = viewRect.x + viewRect.width;
                        if (tabRect.x >= cropline - 1 || tabRect.x + tabRect.width <= cropline) continue block3;
                        BasicTabbedPaneUI.this.tabScroller.croppedEdge.setParams(i, cropline - tabRect.x - 1, 0, -BasicTabbedPaneUI.this.currentTabAreaInsets.top);
                    }
                }
            }
        }

        @Override
        protected void calculateTabRects(int tabPlacement, int tabCount) {
            int i;
            FontMetrics metrics = BasicTabbedPaneUI.this.getFontMetrics();
            Dimension size = BasicTabbedPaneUI.this.tabPane.getSize();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            Insets tabAreaInsets = BasicTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            int fontHeight = metrics.getHeight();
            int selectedIndex = BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            boolean leftToRight = BasicGraphicsUtils.isLeftToRight((Component)BasicTabbedPaneUI.this.tabPane);
            int x = tabAreaInsets.left;
            int y = tabAreaInsets.top;
            int totalWidth = 0;
            int totalHeight = 0;
            switch (tabPlacement) {
                case 2: 
                case 4: {
                    BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                    break;
                }
                default: {
                    BasicTabbedPaneUI.this.maxTabHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                }
            }
            BasicTabbedPaneUI.this.runCount = 0;
            BasicTabbedPaneUI.this.selectedRun = -1;
            if (tabCount == 0) {
                return;
            }
            BasicTabbedPaneUI.this.selectedRun = 0;
            BasicTabbedPaneUI.this.runCount = 1;
            for (i = 0; i < tabCount; ++i) {
                Rectangle rect = BasicTabbedPaneUI.this.rects[i];
                if (!verticalTabRuns) {
                    if (i > 0) {
                        rect.x = BasicTabbedPaneUI.this.rects[i - 1].x + BasicTabbedPaneUI.this.rects[i - 1].width;
                    } else {
                        BasicTabbedPaneUI.this.tabRuns[0] = 0;
                        BasicTabbedPaneUI.this.maxTabWidth = 0;
                        totalHeight += BasicTabbedPaneUI.this.maxTabHeight;
                        rect.x = x;
                    }
                    rect.width = BasicTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics);
                    totalWidth = rect.x + rect.width;
                    BasicTabbedPaneUI.this.maxTabWidth = Math.max(BasicTabbedPaneUI.this.maxTabWidth, rect.width);
                    rect.y = y;
                    rect.height = BasicTabbedPaneUI.this.maxTabHeight;
                    continue;
                }
                if (i > 0) {
                    rect.y = BasicTabbedPaneUI.this.rects[i - 1].y + BasicTabbedPaneUI.this.rects[i - 1].height;
                } else {
                    BasicTabbedPaneUI.this.tabRuns[0] = 0;
                    BasicTabbedPaneUI.this.maxTabHeight = 0;
                    totalWidth = BasicTabbedPaneUI.this.maxTabWidth;
                    rect.y = y;
                }
                rect.height = BasicTabbedPaneUI.this.calculateTabHeight(tabPlacement, i, fontHeight);
                totalHeight = rect.y + rect.height;
                BasicTabbedPaneUI.this.maxTabHeight = Math.max(BasicTabbedPaneUI.this.maxTabHeight, rect.height);
                rect.x = x;
                rect.width = BasicTabbedPaneUI.this.maxTabWidth;
            }
            if (BasicTabbedPaneUI.this.tabsOverlapBorder) {
                this.padSelectedTab(tabPlacement, selectedIndex);
            }
            if (!leftToRight && !verticalTabRuns) {
                int rightMargin = size.width - (insets.right + tabAreaInsets.right);
                for (i = 0; i < tabCount; ++i) {
                    BasicTabbedPaneUI.this.rects[i].x = rightMargin - BasicTabbedPaneUI.this.rects[i].x - BasicTabbedPaneUI.this.rects[i].width;
                }
            }
            BasicTabbedPaneUI.this.tabScroller.tabPanel.setPreferredSize(new Dimension(totalWidth, totalHeight));
            BasicTabbedPaneUI.this.tabScroller.tabPanel.invalidate();
        }
    }
}

