/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.plaf.basic.BasicTransferable;
import javax.swing.plaf.basic.DragRecognitionSupport;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public class BasicTableUI
extends TableUI {
    protected JTable table;
    protected CellRendererPane rendererPane;
    protected KeyListener keyListener;
    protected FocusListener focusListener;
    protected MouseInputListener mouseInputListener;

    protected KeyListener createKeyListener() {
        return null;
    }

    protected FocusListener createFocusListener() {
        return null;
    }

    protected MouseInputListener createMouseInputListener() {
        return null;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return null;
    }

    public void installUI(JComponent jComponent) {
    }

    protected void installDefaults() {
    }

    protected void installListeners() {
    }

    protected void installKeyboardActions() {
    }

    public void uninstallUI(JComponent jComponent) {
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
    }

    protected void uninstallKeyboardActions() {
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    private static class Actions
    extends UIAction {
        private static final String CANCEL_EDITING = "cancel";
        private static final String SELECT_ALL = "selectAll";
        private static final String CLEAR_SELECTION = "clearSelection";
        private static final String START_EDITING = "startEditing";
        private static final String NEXT_ROW = "selectNextRow";
        private static final String NEXT_ROW_CELL = "selectNextRowCell";
        private static final String NEXT_ROW_EXTEND_SELECTION = "selectNextRowExtendSelection";
        private static final String NEXT_ROW_CHANGE_LEAD = "selectNextRowChangeLead";
        private static final String PREVIOUS_ROW = "selectPreviousRow";
        private static final String PREVIOUS_ROW_CELL = "selectPreviousRowCell";
        private static final String PREVIOUS_ROW_EXTEND_SELECTION = "selectPreviousRowExtendSelection";
        private static final String PREVIOUS_ROW_CHANGE_LEAD = "selectPreviousRowChangeLead";
        private static final String NEXT_COLUMN = "selectNextColumn";
        private static final String NEXT_COLUMN_CELL = "selectNextColumnCell";
        private static final String NEXT_COLUMN_EXTEND_SELECTION = "selectNextColumnExtendSelection";
        private static final String NEXT_COLUMN_CHANGE_LEAD = "selectNextColumnChangeLead";
        private static final String PREVIOUS_COLUMN = "selectPreviousColumn";
        private static final String PREVIOUS_COLUMN_CELL = "selectPreviousColumnCell";
        private static final String PREVIOUS_COLUMN_EXTEND_SELECTION = "selectPreviousColumnExtendSelection";
        private static final String PREVIOUS_COLUMN_CHANGE_LEAD = "selectPreviousColumnChangeLead";
        private static final String SCROLL_LEFT_CHANGE_SELECTION = "scrollLeftChangeSelection";
        private static final String SCROLL_LEFT_EXTEND_SELECTION = "scrollLeftExtendSelection";
        private static final String SCROLL_RIGHT_CHANGE_SELECTION = "scrollRightChangeSelection";
        private static final String SCROLL_RIGHT_EXTEND_SELECTION = "scrollRightExtendSelection";
        private static final String SCROLL_UP_CHANGE_SELECTION = "scrollUpChangeSelection";
        private static final String SCROLL_UP_EXTEND_SELECTION = "scrollUpExtendSelection";
        private static final String SCROLL_DOWN_CHANGE_SELECTION = "scrollDownChangeSelection";
        private static final String SCROLL_DOWN_EXTEND_SELECTION = "scrollDownExtendSelection";
        private static final String FIRST_COLUMN = "selectFirstColumn";
        private static final String FIRST_COLUMN_EXTEND_SELECTION = "selectFirstColumnExtendSelection";
        private static final String LAST_COLUMN = "selectLastColumn";
        private static final String LAST_COLUMN_EXTEND_SELECTION = "selectLastColumnExtendSelection";
        private static final String FIRST_ROW = "selectFirstRow";
        private static final String FIRST_ROW_EXTEND_SELECTION = "selectFirstRowExtendSelection";
        private static final String LAST_ROW = "selectLastRow";
        private static final String LAST_ROW_EXTEND_SELECTION = "selectLastRowExtendSelection";
        private static final String ADD_TO_SELECTION = "addToSelection";
        private static final String TOGGLE_AND_ANCHOR = "toggleAndAnchor";
        private static final String EXTEND_TO = "extendTo";
        private static final String MOVE_SELECTION_TO = "moveSelectionTo";
        private static final String FOCUS_HEADER = "focusHeader";
        protected int dx;
        protected int dy;
        protected boolean extend;
        protected boolean inSelection;
        protected boolean forwards;
        protected boolean vertically;
        protected boolean toLimit;
        protected int leadRow;
        protected int leadColumn;

        Actions(String name) {
            super(name);
        }

        Actions(String name, int dx, int dy, boolean extend, boolean inSelection) {
            super(name);
            if (inSelection) {
                this.inSelection = true;
                dx = Integer.signum(dx);
                dy = Integer.signum(dy);
                assert (!(dx != 0 && dy != 0 || dx == 0 && dy == 0));
            }
            this.dx = dx;
            this.dy = dy;
            this.extend = extend;
        }

        Actions(String name, boolean extend, boolean forwards, boolean vertically, boolean toLimit) {
            this(name, 0, 0, extend, false);
            this.forwards = forwards;
            this.vertically = vertically;
            this.toLimit = toLimit;
        }

        private static int clipToRange(int i, int a, int b) {
            return Math.min(Math.max(i, a), b - 1);
        }

        private void moveWithinTableRange(JTable table, int dx, int dy) {
            this.leadRow = Actions.clipToRange(this.leadRow + dy, 0, table.getRowCount());
            this.leadColumn = Actions.clipToRange(this.leadColumn + dx, 0, table.getColumnCount());
        }

        private boolean moveWithinSelectedRange(JTable table, int dx, int dy, ListSelectionModel rsm, ListSelectionModel csm) {
            boolean stayInSelection;
            int maxY;
            int minY;
            int maxX;
            int minX;
            int totalCount;
            boolean rs = table.getRowSelectionAllowed();
            boolean cs = table.getColumnSelectionAllowed();
            if (rs && cs) {
                totalCount = table.getSelectedRowCount() * table.getSelectedColumnCount();
                minX = csm.getMinSelectionIndex();
                maxX = csm.getMaxSelectionIndex();
                minY = rsm.getMinSelectionIndex();
                maxY = rsm.getMaxSelectionIndex();
            } else if (rs) {
                totalCount = table.getSelectedRowCount();
                minX = 0;
                maxX = table.getColumnCount() - 1;
                minY = rsm.getMinSelectionIndex();
                maxY = rsm.getMaxSelectionIndex();
            } else if (cs) {
                totalCount = table.getSelectedColumnCount();
                minX = csm.getMinSelectionIndex();
                maxX = csm.getMaxSelectionIndex();
                minY = 0;
                maxY = table.getRowCount() - 1;
            } else {
                totalCount = 0;
                maxY = 0;
                minY = 0;
                maxX = 0;
                minX = 0;
            }
            if (totalCount == 0 || totalCount == 1 && table.isCellSelected(this.leadRow, this.leadColumn)) {
                stayInSelection = false;
                maxX = table.getColumnCount() - 1;
                maxY = table.getRowCount() - 1;
                minX = Math.min(0, maxX);
                minY = Math.min(0, maxY);
            } else {
                stayInSelection = true;
            }
            if (dy == 1 && this.leadColumn == -1) {
                this.leadColumn = minX;
                this.leadRow = -1;
            } else if (dx == 1 && this.leadRow == -1) {
                this.leadRow = minY;
                this.leadColumn = -1;
            } else if (dy == -1 && this.leadColumn == -1) {
                this.leadColumn = maxX;
                this.leadRow = maxY + 1;
            } else if (dx == -1 && this.leadRow == -1) {
                this.leadRow = maxY;
                this.leadColumn = maxX + 1;
            }
            this.leadRow = Math.min(Math.max(this.leadRow, minY - 1), maxY + 1);
            this.leadColumn = Math.min(Math.max(this.leadColumn, minX - 1), maxX + 1);
            do {
                this.calcNextPos(dx, minX, maxX, dy, minY, maxY);
            } while (stayInSelection && !table.isCellSelected(this.leadRow, this.leadColumn));
            return stayInSelection;
        }

        private void calcNextPos(int dx, int minX, int maxX, int dy, int minY, int maxY) {
            if (dx != 0) {
                this.leadColumn += dx;
                if (this.leadColumn > maxX) {
                    this.leadColumn = minX;
                    ++this.leadRow;
                    if (this.leadRow > maxY) {
                        this.leadRow = minY;
                    }
                } else if (this.leadColumn < minX) {
                    this.leadColumn = maxX;
                    --this.leadRow;
                    if (this.leadRow < minY) {
                        this.leadRow = maxY;
                    }
                }
            } else {
                this.leadRow += dy;
                if (this.leadRow > maxY) {
                    this.leadRow = minY;
                    ++this.leadColumn;
                    if (this.leadColumn > maxX) {
                        this.leadColumn = minX;
                    }
                } else if (this.leadRow < minY) {
                    this.leadRow = maxY;
                    --this.leadColumn;
                    if (this.leadColumn < minX) {
                        this.leadColumn = maxX;
                    }
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTableHeader th;
            String key = this.getName();
            JTable table = (JTable)e.getSource();
            ListSelectionModel rsm = table.getSelectionModel();
            this.leadRow = BasicTableUI.getAdjustedLead((JTable)table, (boolean)true, (ListSelectionModel)rsm);
            ListSelectionModel csm = table.getColumnModel().getSelectionModel();
            this.leadColumn = BasicTableUI.getAdjustedLead((JTable)table, (boolean)false, (ListSelectionModel)csm);
            if (key == SCROLL_LEFT_CHANGE_SELECTION || key == SCROLL_LEFT_EXTEND_SELECTION || key == SCROLL_RIGHT_CHANGE_SELECTION || key == SCROLL_RIGHT_EXTEND_SELECTION || key == SCROLL_UP_CHANGE_SELECTION || key == SCROLL_UP_EXTEND_SELECTION || key == SCROLL_DOWN_CHANGE_SELECTION || key == SCROLL_DOWN_EXTEND_SELECTION || key == FIRST_COLUMN || key == FIRST_COLUMN_EXTEND_SELECTION || key == FIRST_ROW || key == FIRST_ROW_EXTEND_SELECTION || key == LAST_COLUMN || key == LAST_COLUMN_EXTEND_SELECTION || key == LAST_ROW || key == LAST_ROW_EXTEND_SELECTION) {
                if (this.toLimit) {
                    if (this.vertically) {
                        int rowCount = table.getRowCount();
                        this.dx = 0;
                        this.dy = this.forwards ? rowCount : -rowCount;
                    } else {
                        int colCount = table.getColumnCount();
                        this.dx = this.forwards ? colCount : -colCount;
                        this.dy = 0;
                    }
                } else {
                    if (!(SwingUtilities.getUnwrappedParent((Component)table).getParent() instanceof JScrollPane)) {
                        return;
                    }
                    Dimension delta = table.getParent().getSize();
                    if (this.vertically) {
                        r = table.getCellRect(this.leadRow, 0, true);
                        r.y = this.forwards ? (r.y += Math.max(delta.height, r.height)) : (r.y -= delta.height);
                        this.dx = 0;
                        int newRow = table.rowAtPoint(r.getLocation());
                        if (newRow == -1 && this.forwards) {
                            newRow = table.getRowCount();
                        }
                        this.dy = newRow - this.leadRow;
                    } else {
                        r = table.getCellRect(0, this.leadColumn, true);
                        r.x = this.forwards ? (r.x += Math.max(delta.width, r.width)) : (r.x -= delta.width);
                        int newColumn = table.columnAtPoint(r.getLocation());
                        if (newColumn == -1) {
                            boolean ltr = table.getComponentOrientation().isLeftToRight();
                            newColumn = this.forwards ? (ltr ? table.getColumnCount() : 0) : (ltr ? 0 : table.getColumnCount());
                        }
                        this.dx = newColumn - this.leadColumn;
                        this.dy = 0;
                    }
                }
            }
            if (key == NEXT_ROW || key == NEXT_ROW_CELL || key == NEXT_ROW_EXTEND_SELECTION || key == NEXT_ROW_CHANGE_LEAD || key == NEXT_COLUMN || key == NEXT_COLUMN_CELL || key == NEXT_COLUMN_EXTEND_SELECTION || key == NEXT_COLUMN_CHANGE_LEAD || key == PREVIOUS_ROW || key == PREVIOUS_ROW_CELL || key == PREVIOUS_ROW_EXTEND_SELECTION || key == PREVIOUS_ROW_CHANGE_LEAD || key == PREVIOUS_COLUMN || key == PREVIOUS_COLUMN_CELL || key == PREVIOUS_COLUMN_EXTEND_SELECTION || key == PREVIOUS_COLUMN_CHANGE_LEAD || key == SCROLL_LEFT_CHANGE_SELECTION || key == SCROLL_LEFT_EXTEND_SELECTION || key == SCROLL_RIGHT_CHANGE_SELECTION || key == SCROLL_RIGHT_EXTEND_SELECTION || key == SCROLL_UP_CHANGE_SELECTION || key == SCROLL_UP_EXTEND_SELECTION || key == SCROLL_DOWN_CHANGE_SELECTION || key == SCROLL_DOWN_EXTEND_SELECTION || key == FIRST_COLUMN || key == FIRST_COLUMN_EXTEND_SELECTION || key == FIRST_ROW || key == FIRST_ROW_EXTEND_SELECTION || key == LAST_COLUMN || key == LAST_COLUMN_EXTEND_SELECTION || key == LAST_ROW || key == LAST_ROW_EXTEND_SELECTION) {
                if (table.isEditing() && !table.getCellEditor().stopCellEditing()) {
                    return;
                }
                boolean changeLead = false;
                if (key == NEXT_ROW_CHANGE_LEAD || key == PREVIOUS_ROW_CHANGE_LEAD) {
                    changeLead = rsm.getSelectionMode() == 2;
                } else if (key == NEXT_COLUMN_CHANGE_LEAD || key == PREVIOUS_COLUMN_CHANGE_LEAD) {
                    boolean bl = changeLead = csm.getSelectionMode() == 2;
                }
                if (changeLead) {
                    this.moveWithinTableRange(table, this.dx, this.dy);
                    if (this.dy != 0) {
                        ((DefaultListSelectionModel)rsm).moveLeadSelectionIndex(this.leadRow);
                        if (BasicTableUI.getAdjustedLead((JTable)table, (boolean)false, (ListSelectionModel)csm) == -1 && table.getColumnCount() > 0) {
                            ((DefaultListSelectionModel)csm).moveLeadSelectionIndex(0);
                        }
                    } else {
                        ((DefaultListSelectionModel)csm).moveLeadSelectionIndex(this.leadColumn);
                        if (BasicTableUI.getAdjustedLead((JTable)table, (boolean)true, (ListSelectionModel)rsm) == -1 && table.getRowCount() > 0) {
                            ((DefaultListSelectionModel)rsm).moveLeadSelectionIndex(0);
                        }
                    }
                    if ((cellRect = table.getCellRect(this.leadRow, this.leadColumn, false)) != null) {
                        table.scrollRectToVisible(cellRect);
                    }
                } else if (!this.inSelection) {
                    this.moveWithinTableRange(table, this.dx, this.dy);
                    table.changeSelection(this.leadRow, this.leadColumn, false, this.extend);
                } else {
                    if (table.getRowCount() <= 0 || table.getColumnCount() <= 0) {
                        return;
                    }
                    if (this.moveWithinSelectedRange(table, this.dx, this.dy, rsm, csm)) {
                        if (rsm.isSelectedIndex(this.leadRow)) {
                            rsm.addSelectionInterval(this.leadRow, this.leadRow);
                        } else {
                            rsm.removeSelectionInterval(this.leadRow, this.leadRow);
                        }
                        if (csm.isSelectedIndex(this.leadColumn)) {
                            csm.addSelectionInterval(this.leadColumn, this.leadColumn);
                        } else {
                            csm.removeSelectionInterval(this.leadColumn, this.leadColumn);
                        }
                        cellRect = table.getCellRect(this.leadRow, this.leadColumn, false);
                        if (cellRect != null) {
                            table.scrollRectToVisible(cellRect);
                        }
                    } else {
                        table.changeSelection(this.leadRow, this.leadColumn, false, false);
                    }
                }
            } else if (key == CANCEL_EDITING) {
                if (table.isEditing()) {
                    table.getCellEditor().cancelCellEditing();
                }
                table.removeEditor();
            } else if (key == SELECT_ALL) {
                table.selectAll();
            } else if (key == CLEAR_SELECTION) {
                table.clearSelection();
            } else if (key == START_EDITING) {
                if (!table.hasFocus()) {
                    TableCellEditor cellEditor = table.getCellEditor();
                    if (cellEditor != null && !cellEditor.stopCellEditing()) {
                        return;
                    }
                    table.requestFocus();
                    return;
                }
                table.editCellAt(this.leadRow, this.leadColumn, e);
                Component editorComp = table.getEditorComponent();
                if (editorComp != null) {
                    editorComp.requestFocus();
                }
            } else if (key == ADD_TO_SELECTION) {
                if (!table.isCellSelected(this.leadRow, this.leadColumn)) {
                    int oldAnchorRow = rsm.getAnchorSelectionIndex();
                    int oldAnchorColumn = csm.getAnchorSelectionIndex();
                    rsm.setValueIsAdjusting(true);
                    csm.setValueIsAdjusting(true);
                    table.changeSelection(this.leadRow, this.leadColumn, true, false);
                    rsm.setAnchorSelectionIndex(oldAnchorRow);
                    csm.setAnchorSelectionIndex(oldAnchorColumn);
                    rsm.setValueIsAdjusting(false);
                    csm.setValueIsAdjusting(false);
                }
            } else if (key == TOGGLE_AND_ANCHOR) {
                table.changeSelection(this.leadRow, this.leadColumn, true, false);
            } else if (key == EXTEND_TO) {
                table.changeSelection(this.leadRow, this.leadColumn, false, true);
            } else if (key == MOVE_SELECTION_TO) {
                table.changeSelection(this.leadRow, this.leadColumn, false, false);
            } else if (key == FOCUS_HEADER && (th = table.getTableHeader()) != null) {
                TableHeaderUI thUI;
                int col = table.getSelectedColumn();
                if (col >= 0 && (thUI = th.getUI()) instanceof BasicTableHeaderUI) {
                    ((BasicTableHeaderUI)thUI).selectColumn(col);
                }
                th.requestFocusInWindow();
            }
        }

        @Override
        public boolean accept(Object sender) {
            String key = this.getName();
            if (sender instanceof JTable && Boolean.TRUE.equals(((JTable)sender).getClientProperty("Table.isFileList")) && (key == NEXT_COLUMN || key == NEXT_COLUMN_CELL || key == NEXT_COLUMN_EXTEND_SELECTION || key == NEXT_COLUMN_CHANGE_LEAD || key == PREVIOUS_COLUMN || key == PREVIOUS_COLUMN_CELL || key == PREVIOUS_COLUMN_EXTEND_SELECTION || key == PREVIOUS_COLUMN_CHANGE_LEAD || key == SCROLL_LEFT_CHANGE_SELECTION || key == SCROLL_LEFT_EXTEND_SELECTION || key == SCROLL_RIGHT_CHANGE_SELECTION || key == SCROLL_RIGHT_EXTEND_SELECTION || key == FIRST_COLUMN || key == FIRST_COLUMN_EXTEND_SELECTION || key == LAST_COLUMN || key == LAST_COLUMN_EXTEND_SELECTION || key == NEXT_ROW_CELL || key == PREVIOUS_ROW_CELL)) {
                return false;
            }
            if (key == CANCEL_EDITING && sender instanceof JTable) {
                return ((JTable)sender).isEditing();
            }
            if (key == NEXT_ROW_CHANGE_LEAD || key == PREVIOUS_ROW_CHANGE_LEAD) {
                return sender != null && ((JTable)sender).getSelectionModel() instanceof DefaultListSelectionModel;
            }
            if (key == NEXT_COLUMN_CHANGE_LEAD || key == PREVIOUS_COLUMN_CHANGE_LEAD) {
                return sender != null && ((JTable)sender).getColumnModel().getSelectionModel() instanceof DefaultListSelectionModel;
            }
            if (key == ADD_TO_SELECTION && sender instanceof JTable) {
                JTable table = (JTable)sender;
                int leadRow = BasicTableUI.getAdjustedLead((JTable)table, (boolean)true);
                int leadCol = BasicTableUI.getAdjustedLead((JTable)table, (boolean)false);
                return !table.isEditing() && !table.isCellSelected(leadRow, leadCol);
            }
            if (key == FOCUS_HEADER && sender instanceof JTable) {
                JTable table = (JTable)sender;
                return table.getTableHeader() != null;
            }
            return true;
        }
    }

    public class FocusHandler
    implements FocusListener {
        public FocusHandler(BasicTableUI basicTableUI) {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    private class Handler
    implements FocusListener,
    MouseInputListener,
    PropertyChangeListener,
    ListSelectionListener,
    ActionListener,
    DragRecognitionSupport.BeforeDrag {
        private Component dispatchComponent;
        private int pressedRow;
        private int pressedCol;
        private MouseEvent pressedEvent;
        private boolean dragPressDidSelection;
        private boolean dragStarted;
        private boolean shouldStartTimer;
        private boolean outsidePrefSize;
        private Timer timer = null;

        private Handler() {
        }

        private void repaintLeadCell() {
            int lr = BasicTableUI.getAdjustedLead((JTable)BasicTableUI.this.table, (boolean)true);
            int lc = BasicTableUI.getAdjustedLead((JTable)BasicTableUI.this.table, (boolean)false);
            if (lr < 0 || lc < 0) {
                return;
            }
            Rectangle dirtyRect = BasicTableUI.this.table.getCellRect(lr, lc, false);
            BasicTableUI.this.table.repaint(dirtyRect);
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.repaintLeadCell();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.repaintLeadCell();
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke((int)e.getKeyChar(), e.getModifiers());
            InputMap map = BasicTableUI.this.table.getInputMap(0);
            if (map != null && map.get(keyStroke) != null) {
                return;
            }
            map = BasicTableUI.this.table.getInputMap(1);
            if (map != null && map.get(keyStroke) != null) {
                return;
            }
            keyStroke = KeyStroke.getKeyStrokeForEvent(e);
            if (e.getKeyChar() == '\r') {
                return;
            }
            int leadRow = BasicTableUI.getAdjustedLead((JTable)BasicTableUI.this.table, (boolean)true);
            int leadColumn = BasicTableUI.getAdjustedLead((JTable)BasicTableUI.this.table, (boolean)false);
            if (leadRow != -1 && leadColumn != -1 && !BasicTableUI.this.table.isEditing() && !BasicTableUI.this.table.editCellAt(leadRow, leadColumn)) {
                return;
            }
            Component editorComp = BasicTableUI.this.table.getEditorComponent();
            if (BasicTableUI.this.table.isEditing() && editorComp instanceof JComponent) {
                Object binding;
                JComponent component = (JComponent)editorComp;
                map = component.getInputMap(0);
                Object object = binding = map != null ? map.get(keyStroke) : null;
                if (binding == null) {
                    map = component.getInputMap(1);
                    Object object2 = binding = map != null ? map.get(keyStroke) : null;
                }
                if (binding != null) {
                    Action action;
                    ActionMap am = component.getActionMap();
                    Action action2 = action = am != null ? am.get(binding) : null;
                    if (action != null && SwingUtilities.notifyAction(action, keyStroke, e, component, e.getModifiers())) {
                        e.consume();
                    }
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        private void setDispatchComponent(MouseEvent e) {
            Component editorComponent = BasicTableUI.this.table.getEditorComponent();
            Point p = e.getPoint();
            Point p2 = SwingUtilities.convertPoint(BasicTableUI.this.table, p, editorComponent);
            this.dispatchComponent = SwingUtilities.getDeepestComponentAt(editorComponent, p2.x, p2.y);
            SwingUtilities2.setSkipClickCount(this.dispatchComponent, e.getClickCount() - 1);
        }

        private boolean repostEvent(MouseEvent e) {
            if (this.dispatchComponent == null || !BasicTableUI.this.table.isEditing()) {
                return false;
            }
            MouseEvent e2 = SwingUtilities.convertMouseEvent(BasicTableUI.this.table, e, this.dispatchComponent);
            this.dispatchComponent.dispatchEvent(e2);
            return true;
        }

        private void setValueIsAdjusting(boolean flag) {
            BasicTableUI.this.table.getSelectionModel().setValueIsAdjusting(flag);
            BasicTableUI.this.table.getColumnModel().getSelectionModel().setValueIsAdjusting(flag);
        }

        private boolean canStartDrag() {
            if (this.pressedRow == -1 || this.pressedCol == -1) {
                return false;
            }
            if (BasicTableUI.this.isFileList) {
                return !this.outsidePrefSize;
            }
            if (BasicTableUI.this.table.getSelectionModel().getSelectionMode() == 0 && BasicTableUI.this.table.getColumnModel().getSelectionModel().getSelectionMode() == 0) {
                return true;
            }
            return BasicTableUI.this.table.isCellSelected(this.pressedRow, this.pressedCol);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities2.shouldIgnore(e, BasicTableUI.this.table)) {
                return;
            }
            if (BasicTableUI.this.table.isEditing() && !BasicTableUI.this.table.getCellEditor().stopCellEditing()) {
                Component editorComponent = BasicTableUI.this.table.getEditorComponent();
                if (editorComponent != null && !editorComponent.hasFocus()) {
                    SwingUtilities2.compositeRequestFocus(editorComponent);
                }
                return;
            }
            Point p = e.getPoint();
            this.pressedRow = BasicTableUI.this.table.rowAtPoint(p);
            this.pressedCol = BasicTableUI.this.table.columnAtPoint(p);
            this.outsidePrefSize = BasicTableUI.this.pointOutsidePrefSize(this.pressedRow, this.pressedCol, p);
            if (BasicTableUI.this.isFileList) {
                boolean bl = this.shouldStartTimer = BasicTableUI.this.table.isCellSelected(this.pressedRow, this.pressedCol) && !e.isShiftDown() && !BasicGraphicsUtils.isMenuShortcutKeyDown((InputEvent)e) && !this.outsidePrefSize;
            }
            if (BasicTableUI.this.table.getDragEnabled()) {
                this.mousePressedDND(e);
            } else {
                SwingUtilities2.adjustFocus(BasicTableUI.this.table);
                if (!BasicTableUI.this.isFileList) {
                    this.setValueIsAdjusting(true);
                }
                this.adjustSelection(e);
            }
        }

        private void mousePressedDND(MouseEvent e) {
            this.pressedEvent = e;
            boolean grabFocus = true;
            this.dragStarted = false;
            if (this.canStartDrag() && DragRecognitionSupport.mousePressed(e)) {
                this.dragPressDidSelection = false;
                if (BasicGraphicsUtils.isMenuShortcutKeyDown((InputEvent)e) && BasicTableUI.this.isFileList) {
                    return;
                }
                if (!e.isShiftDown() && BasicTableUI.this.table.isCellSelected(this.pressedRow, this.pressedCol)) {
                    BasicTableUI.this.table.getSelectionModel().addSelectionInterval(this.pressedRow, this.pressedRow);
                    BasicTableUI.this.table.getColumnModel().getSelectionModel().addSelectionInterval(this.pressedCol, this.pressedCol);
                    return;
                }
                this.dragPressDidSelection = true;
                grabFocus = false;
            } else if (!BasicTableUI.this.isFileList) {
                this.setValueIsAdjusting(true);
            }
            if (grabFocus) {
                SwingUtilities2.adjustFocus(BasicTableUI.this.table);
            }
            this.adjustSelection(e);
        }

        private void adjustSelection(MouseEvent e) {
            if (this.outsidePrefSize) {
                if (!(e.getID() != 501 || e.isShiftDown() && BasicTableUI.this.table.getSelectionModel().getSelectionMode() != 0)) {
                    BasicTableUI.this.table.clearSelection();
                    TableCellEditor tce = BasicTableUI.this.table.getCellEditor();
                    if (tce != null) {
                        tce.stopCellEditing();
                    }
                }
                return;
            }
            if (this.pressedCol == -1 || this.pressedRow == -1) {
                return;
            }
            boolean dragEnabled = BasicTableUI.this.table.getDragEnabled();
            if (!dragEnabled && !BasicTableUI.this.isFileList && BasicTableUI.this.table.editCellAt(this.pressedRow, this.pressedCol, e)) {
                this.setDispatchComponent(e);
                this.repostEvent(e);
            }
            TableCellEditor editor = BasicTableUI.this.table.getCellEditor();
            if (dragEnabled || editor == null || editor.shouldSelectCell(e)) {
                BasicTableUI.this.table.changeSelection(this.pressedRow, this.pressedCol, BasicGraphicsUtils.isMenuShortcutKeyDown((InputEvent)e), e.isShiftDown());
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            BasicTableUI.this.table.editCellAt(this.pressedRow, this.pressedCol, null);
            Component editorComponent = BasicTableUI.this.table.getEditorComponent();
            if (editorComponent != null && !editorComponent.hasFocus()) {
                SwingUtilities2.compositeRequestFocus(editorComponent);
            }
        }

        private void maybeStartTimer() {
            if (!this.shouldStartTimer) {
                return;
            }
            if (this.timer == null) {
                this.timer = new Timer(1200, this);
                this.timer.setRepeats(false);
            }
            this.timer.start();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities2.shouldIgnore(e, BasicTableUI.this.table)) {
                return;
            }
            if (BasicTableUI.this.table.getDragEnabled()) {
                this.mouseReleasedDND(e);
            } else if (BasicTableUI.this.isFileList) {
                this.maybeStartTimer();
            }
            this.pressedEvent = null;
            this.repostEvent(e);
            this.dispatchComponent = null;
            this.setValueIsAdjusting(false);
        }

        private void mouseReleasedDND(MouseEvent e) {
            MouseEvent me = DragRecognitionSupport.mouseReleased(e);
            if (me != null) {
                SwingUtilities2.adjustFocus(BasicTableUI.this.table);
                if (!this.dragPressDidSelection) {
                    this.adjustSelection(me);
                }
            }
            if (!this.dragStarted) {
                if (BasicTableUI.this.isFileList) {
                    this.maybeStartTimer();
                    return;
                }
                Point p = e.getPoint();
                if (this.pressedEvent != null && BasicTableUI.this.table.rowAtPoint(p) == this.pressedRow && BasicTableUI.this.table.columnAtPoint(p) == this.pressedCol && BasicTableUI.this.table.editCellAt(this.pressedRow, this.pressedCol, this.pressedEvent)) {
                    this.setDispatchComponent(this.pressedEvent);
                    this.repostEvent(this.pressedEvent);
                    TableCellEditor ce = BasicTableUI.this.table.getCellEditor();
                    if (ce != null) {
                        ce.shouldSelectCell(this.pressedEvent);
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void dragStarting(MouseEvent me) {
            this.dragStarted = true;
            if (BasicGraphicsUtils.isMenuShortcutKeyDown((InputEvent)me) && BasicTableUI.this.isFileList) {
                BasicTableUI.this.table.getSelectionModel().addSelectionInterval(this.pressedRow, this.pressedRow);
                BasicTableUI.this.table.getColumnModel().getSelectionModel().addSelectionInterval(this.pressedCol, this.pressedCol);
            }
            this.pressedEvent = null;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SwingUtilities2.shouldIgnore(e, BasicTableUI.this.table)) {
                return;
            }
            if (BasicTableUI.this.table.getDragEnabled() && (DragRecognitionSupport.mouseDragged(e, this) || this.dragStarted)) {
                return;
            }
            this.repostEvent(e);
            if (BasicTableUI.this.isFileList || BasicTableUI.this.table.isEditing()) {
                return;
            }
            Point p = e.getPoint();
            int row = BasicTableUI.this.table.rowAtPoint(p);
            int column = BasicTableUI.this.table.columnAtPoint(p);
            if (column == -1 || row == -1) {
                return;
            }
            BasicTableUI.this.table.changeSelection(row, column, BasicGraphicsUtils.isMenuShortcutKeyDown((InputEvent)e), true);
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String changeName = event.getPropertyName();
            if ("componentOrientation" == changeName) {
                InputMap inputMap = BasicTableUI.this.getInputMap(1);
                SwingUtilities.replaceUIInputMap(BasicTableUI.this.table, 1, inputMap);
                JTableHeader header = BasicTableUI.this.table.getTableHeader();
                if (header != null) {
                    header.setComponentOrientation((ComponentOrientation)event.getNewValue());
                }
            } else if ("dropLocation" == changeName) {
                JTable.DropLocation oldValue = (JTable.DropLocation)event.getOldValue();
                this.repaintDropLocation(oldValue);
                this.repaintDropLocation(BasicTableUI.this.table.getDropLocation());
            } else if ("Table.isFileList" == changeName) {
                BasicTableUI.this.isFileList = Boolean.TRUE.equals(BasicTableUI.this.table.getClientProperty("Table.isFileList"));
                BasicTableUI.this.table.revalidate();
                BasicTableUI.this.table.repaint();
                if (BasicTableUI.this.isFileList) {
                    BasicTableUI.this.table.getSelectionModel().addListSelectionListener(BasicTableUI.this.getHandler());
                } else {
                    BasicTableUI.this.table.getSelectionModel().removeListSelectionListener(BasicTableUI.this.getHandler());
                    this.timer = null;
                }
            } else if ("selectionModel" == changeName && BasicTableUI.this.isFileList) {
                ListSelectionModel old = (ListSelectionModel)event.getOldValue();
                old.removeListSelectionListener(BasicTableUI.this.getHandler());
                BasicTableUI.this.table.getSelectionModel().addListSelectionListener(BasicTableUI.this.getHandler());
            }
        }

        private void repaintDropLocation(JTable.DropLocation loc) {
            Rectangle rect;
            if (loc == null) {
                return;
            }
            if (!loc.isInsertRow() && !loc.isInsertColumn()) {
                Rectangle rect2 = BasicTableUI.this.table.getCellRect(loc.getRow(), loc.getColumn(), false);
                if (rect2 != null) {
                    BasicTableUI.this.table.repaint(rect2);
                }
                return;
            }
            if (loc.isInsertRow() && (rect = BasicTableUI.this.extendRect(BasicTableUI.this.getHDropLineRect(loc), true)) != null) {
                BasicTableUI.this.table.repaint(rect);
            }
            if (loc.isInsertColumn() && (rect = BasicTableUI.this.extendRect(BasicTableUI.this.getVDropLineRect(loc), false)) != null) {
                BasicTableUI.this.table.repaint(rect);
            }
        }
    }

    public class KeyHandler
    implements KeyListener {
        public KeyHandler(BasicTableUI basicTableUI) {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        public MouseInputHandler(BasicTableUI basicTableUI) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }
    }

    static class TableTransferHandler
    extends TransferHandler
    implements UIResource {
        TableTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (c instanceof JTable) {
                int[] cols;
                int counter;
                int[] rows;
                JTable table = (JTable)c;
                if (!table.getRowSelectionAllowed() && !table.getColumnSelectionAllowed()) {
                    return null;
                }
                if (!table.getRowSelectionAllowed()) {
                    int rowCount = table.getRowCount();
                    rows = new int[rowCount];
                    for (counter = 0; counter < rowCount; ++counter) {
                        rows[counter] = counter;
                    }
                } else {
                    rows = table.getSelectedRows();
                }
                if (!table.getColumnSelectionAllowed()) {
                    int colCount = table.getColumnCount();
                    cols = new int[colCount];
                    for (counter = 0; counter < colCount; ++counter) {
                        cols[counter] = counter;
                    }
                } else {
                    cols = table.getSelectedColumns();
                }
                if (rows == null || cols == null || rows.length == 0 || cols.length == 0) {
                    return null;
                }
                StringBuilder plainStr = new StringBuilder();
                StringBuilder htmlStr = new StringBuilder();
                htmlStr.append("<html>\n<body>\n<table>\n");
                for (int row = 0; row < rows.length; ++row) {
                    htmlStr.append("<tr>\n");
                    for (int col = 0; col < cols.length; ++col) {
                        Object obj = table.getValueAt(rows[row], cols[col]);
                        String val = obj == null ? "" : obj.toString();
                        plainStr.append(val).append('\t');
                        htmlStr.append("  <td>").append(val).append("</td>\n");
                    }
                    plainStr.deleteCharAt(plainStr.length() - 1).append('\n');
                    htmlStr.append("</tr>\n");
                }
                plainStr.deleteCharAt(plainStr.length() - 1);
                htmlStr.append("</table>\n</body>\n</html>");
                return new BasicTransferable(plainStr.toString(), htmlStr.toString());
            }
            return null;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }
    }
}

