/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.im.InputContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPasswordField;
import javax.swing.TransferHandler;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTransferable;
import javax.swing.plaf.basic.DragRecognitionSupport;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Position;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class BasicTextUI
extends TextUI
implements ViewFactory {
    protected Caret createCaret() {
        return null;
    }

    protected Highlighter createHighlighter() {
        return null;
    }

    protected String getKeymapName() {
        return null;
    }

    protected Keymap createKeymap() {
        return null;
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    protected abstract String getPropertyPrefix();

    protected void installDefaults() {
    }

    protected void uninstallDefaults() {
    }

    protected void installListeners() {
    }

    protected void uninstallListeners() {
    }

    protected void installKeyboardActions() {
    }

    protected void uninstallKeyboardActions() {
    }

    protected void paintBackground(Graphics graphics) {
    }

    protected final JTextComponent getComponent() {
        return null;
    }

    protected void modelChanged() {
    }

    protected final void setView(View view) {
    }

    protected void paintSafely(Graphics graphics) {
    }

    public void installUI(JComponent jComponent) {
    }

    public void uninstallUI(JComponent jComponent) {
    }

    public void update(Graphics graphics, JComponent jComponent) {
    }

    public final void paint(Graphics graphics, JComponent jComponent) {
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    protected Rectangle getVisibleEditorRect() {
        return null;
    }

    public Rectangle modelToView(JTextComponent jTextComponent, int n) throws BadLocationException {
        return null;
    }

    public Rectangle modelToView(JTextComponent jTextComponent, int n, Position.Bias bias) throws BadLocationException {
        return null;
    }

    public int viewToModel(JTextComponent jTextComponent, Point point) {
        return 0;
    }

    public int viewToModel(JTextComponent jTextComponent, Point point, Position.Bias[] biasArray) {
        return 0;
    }

    public int getNextVisualPositionFrom(JTextComponent jTextComponent, int n, Position.Bias bias, int n2, Position.Bias[] biasArray) throws BadLocationException {
        return 0;
    }

    public void damageRange(JTextComponent jTextComponent, int n, int n2) {
    }

    public void damageRange(JTextComponent jTextComponent, int n, int n2, Position.Bias bias, Position.Bias bias2) {
    }

    public EditorKit getEditorKit(JTextComponent jTextComponent) {
        return null;
    }

    public View getRootView(JTextComponent jTextComponent) {
        return null;
    }

    public String getToolTipText(JTextComponent jTextComponent, Point point) {
        return null;
    }

    public View create(Element element) {
        return null;
    }

    public View create(Element element, int n, int n2) {
        return null;
    }

    public static class BasicCaret
    extends DefaultCaret
    implements UIResource {
    }

    public static class BasicHighlighter
    extends DefaultHighlighter
    implements UIResource {
    }

    static class DragListener
    extends MouseInputAdapter
    implements DragRecognitionSupport.BeforeDrag {
        private boolean dragStarted;

        DragListener() {
        }

        @Override
        public void dragStarting(MouseEvent me) {
            this.dragStarted = true;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JTextComponent c = (JTextComponent)e.getSource();
            if (c.getDragEnabled()) {
                this.dragStarted = false;
                if (this.isDragPossible(e) && DragRecognitionSupport.mousePressed(e)) {
                    e.consume();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JTextComponent c = (JTextComponent)e.getSource();
            if (c.getDragEnabled()) {
                if (this.dragStarted) {
                    e.consume();
                }
                DragRecognitionSupport.mouseReleased(e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            JTextComponent c = (JTextComponent)e.getSource();
            if (c.getDragEnabled() && (this.dragStarted || DragRecognitionSupport.mouseDragged(e, this))) {
                e.consume();
            }
        }

        protected boolean isDragPossible(MouseEvent e) {
            int mark;
            Caret caret;
            int dot;
            JTextComponent c = (JTextComponent)e.getSource();
            if (c.isEnabled() && (dot = (caret = c.getCaret()).getDot()) != (mark = caret.getMark())) {
                Point p = new Point(e.getX(), e.getY());
                int pos = c.viewToModel(p);
                int p0 = Math.min(dot, mark);
                int p1 = Math.max(dot, mark);
                if (pos >= p0 && pos < p1) {
                    return true;
                }
            }
            return false;
        }
    }

    class FocusAction
    extends AbstractAction {
        FocusAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicTextUI.this.editor.requestFocus();
        }

        @Override
        public boolean isEnabled() {
            return BasicTextUI.this.editor.isEditable();
        }
    }

    class RootView
    extends View {
        private View view;

        RootView() {
            super(null);
        }

        void setView(View v) {
            View oldView = this.view;
            this.view = null;
            if (oldView != null) {
                oldView.setParent(null);
            }
            if (v != null) {
                v.setParent(this);
            }
            this.view = v;
        }

        @Override
        public AttributeSet getAttributes() {
            return null;
        }

        @Override
        public float getPreferredSpan(int axis) {
            if (this.view != null) {
                return this.view.getPreferredSpan(axis);
            }
            return 10.0f;
        }

        @Override
        public float getMinimumSpan(int axis) {
            if (this.view != null) {
                return this.view.getMinimumSpan(axis);
            }
            return 10.0f;
        }

        @Override
        public float getMaximumSpan(int axis) {
            return 2.1474836E9f;
        }

        @Override
        public void preferenceChanged(View child, boolean width, boolean height) {
            BasicTextUI.this.editor.revalidate();
        }

        @Override
        public float getAlignment(int axis) {
            if (this.view != null) {
                return this.view.getAlignment(axis);
            }
            return 0.0f;
        }

        @Override
        public void paint(Graphics g, Shape allocation) {
            if (this.view != null) {
                Rectangle alloc = allocation instanceof Rectangle ? (Rectangle)allocation : allocation.getBounds();
                this.setSize(alloc.width, alloc.height);
                this.view.paint(g, allocation);
            }
        }

        @Override
        public void setParent(View parent) {
            throw new Error("Can't set parent on root view");
        }

        @Override
        public int getViewCount() {
            return 1;
        }

        @Override
        public View getView(int n) {
            return this.view;
        }

        @Override
        public int getViewIndex(int pos, Position.Bias b) {
            return 0;
        }

        @Override
        public Shape getChildAllocation(int index, Shape a) {
            return a;
        }

        @Override
        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(pos, a, b);
            }
            return null;
        }

        @Override
        public Shape modelToView(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(p0, b0, p1, b1, a);
            }
            return null;
        }

        @Override
        public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
            if (this.view != null) {
                int retValue = this.view.viewToModel(x, y, a, bias);
                return retValue;
            }
            return -1;
        }

        @Override
        public int getNextVisualPositionFrom(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
            if (pos < -1 || pos > this.getDocument().getLength()) {
                throw new BadLocationException("invalid position", pos);
            }
            if (this.view != null) {
                int nextPos = this.view.getNextVisualPositionFrom(pos, b, a, direction, biasRet);
                if (nextPos != -1) {
                    pos = nextPos;
                } else {
                    biasRet[0] = b;
                }
            }
            return pos;
        }

        @Override
        public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            if (this.view != null) {
                this.view.insertUpdate(e, a, f);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            if (this.view != null) {
                this.view.removeUpdate(e, a, f);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            if (this.view != null) {
                this.view.changedUpdate(e, a, f);
            }
        }

        @Override
        public Document getDocument() {
            return BasicTextUI.this.editor.getDocument();
        }

        @Override
        public int getStartOffset() {
            if (this.view != null) {
                return this.view.getStartOffset();
            }
            return this.getElement().getStartOffset();
        }

        @Override
        public int getEndOffset() {
            if (this.view != null) {
                return this.view.getEndOffset();
            }
            return this.getElement().getEndOffset();
        }

        @Override
        public Element getElement() {
            if (this.view != null) {
                return this.view.getElement();
            }
            return BasicTextUI.this.editor.getDocument().getDefaultRootElement();
        }

        public View breakView(int axis, float len, Shape a) {
            throw new Error("Can't break root view");
        }

        @Override
        public int getResizeWeight(int axis) {
            if (this.view != null) {
                return this.view.getResizeWeight(axis);
            }
            return 0;
        }

        @Override
        public void setSize(float width, float height) {
            if (this.view != null) {
                this.view.setSize(width, height);
            }
        }

        @Override
        public Container getContainer() {
            return BasicTextUI.this.editor;
        }

        @Override
        public ViewFactory getViewFactory() {
            EditorKit kit = BasicTextUI.this.getEditorKit(BasicTextUI.this.editor);
            ViewFactory f = kit.getViewFactory();
            if (f != null) {
                return f;
            }
            return BasicTextUI.this;
        }
    }

    class TextActionWrapper
    extends TextAction {
        TextAction action;

        public TextActionWrapper(TextAction action) {
            super((String)action.getValue("Name"));
            this.action = null;
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.action.actionPerformed(e);
        }

        @Override
        public boolean isEnabled() {
            return BasicTextUI.this.editor == null || BasicTextUI.this.editor.isEditable() ? this.action.isEnabled() : false;
        }
    }

    static class TextTransferHandler
    extends TransferHandler
    implements UIResource {
        private JTextComponent exportComp;
        private boolean shouldRemove;
        private int p0;
        private int p1;
        private boolean modeBetween = false;
        private boolean isDrop = false;
        private int dropAction = 2;
        private Position.Bias dropBias;

        TextTransferHandler() {
        }

        protected DataFlavor getImportFlavor(DataFlavor[] flavors, JTextComponent c) {
            DataFlavor plainFlavor = null;
            DataFlavor refFlavor = null;
            DataFlavor stringFlavor = null;
            if (c instanceof JEditorPane) {
                for (int i = 0; i < flavors.length; ++i) {
                    String mime = flavors[i].getMimeType();
                    if (mime.startsWith(((JEditorPane)c).getEditorKit().getContentType())) {
                        return flavors[i];
                    }
                    if (plainFlavor == null && mime.startsWith("text/plain")) {
                        plainFlavor = flavors[i];
                        continue;
                    }
                    if (refFlavor == null && mime.startsWith("application/x-java-jvm-local-objectref") && flavors[i].getRepresentationClass() == String.class) {
                        refFlavor = flavors[i];
                        continue;
                    }
                    if (stringFlavor != null || !flavors[i].equals(DataFlavor.stringFlavor)) continue;
                    stringFlavor = flavors[i];
                }
                if (plainFlavor != null) {
                    return plainFlavor;
                }
                if (refFlavor != null) {
                    return refFlavor;
                }
                if (stringFlavor != null) {
                    return stringFlavor;
                }
                return null;
            }
            for (int i = 0; i < flavors.length; ++i) {
                String mime = flavors[i].getMimeType();
                if (mime.startsWith("text/plain")) {
                    return flavors[i];
                }
                if (refFlavor == null && mime.startsWith("application/x-java-jvm-local-objectref") && flavors[i].getRepresentationClass() == String.class) {
                    refFlavor = flavors[i];
                    continue;
                }
                if (stringFlavor != null || !flavors[i].equals(DataFlavor.stringFlavor)) continue;
                stringFlavor = flavors[i];
            }
            if (refFlavor != null) {
                return refFlavor;
            }
            if (stringFlavor != null) {
                return stringFlavor;
            }
            return null;
        }

        protected void handleReaderImport(Reader in, JTextComponent c, boolean useRead) throws BadLocationException, IOException {
            if (useRead) {
                int startPosition = c.getSelectionStart();
                int endPosition = c.getSelectionEnd();
                int length = endPosition - startPosition;
                EditorKit kit = c.getUI().getEditorKit(c);
                Document doc = c.getDocument();
                if (length > 0) {
                    doc.remove(startPosition, length);
                }
                kit.read(in, doc, startPosition);
            } else {
                int nch;
                char[] buff = new char[1024];
                boolean lastWasCR = false;
                StringBuilder sbuff = null;
                while ((nch = in.read(buff, 0, buff.length)) != -1) {
                    if (sbuff == null) {
                        sbuff = new StringBuilder(nch);
                    }
                    int last = 0;
                    block5: for (int counter = 0; counter < nch; ++counter) {
                        switch (buff[counter]) {
                            case '\r': {
                                if (lastWasCR) {
                                    if (counter == 0) {
                                        sbuff.append('\n');
                                        continue block5;
                                    }
                                    buff[counter - 1] = 10;
                                    continue block5;
                                }
                                lastWasCR = true;
                                continue block5;
                            }
                            case '\n': {
                                if (!lastWasCR) continue block5;
                                if (counter > last + 1) {
                                    sbuff.append(buff, last, counter - last - 1);
                                }
                                lastWasCR = false;
                                last = counter;
                                continue block5;
                            }
                            default: {
                                if (!lastWasCR) continue block5;
                                if (counter == 0) {
                                    sbuff.append('\n');
                                } else {
                                    buff[counter - 1] = 10;
                                }
                                lastWasCR = false;
                            }
                        }
                    }
                    if (last >= nch) continue;
                    if (lastWasCR) {
                        if (last >= nch - 1) continue;
                        sbuff.append(buff, last, nch - last - 1);
                        continue;
                    }
                    sbuff.append(buff, last, nch - last);
                }
                if (lastWasCR) {
                    sbuff.append('\n');
                }
                c.replaceSelection(sbuff != null ? sbuff.toString() : "");
            }
        }

        @Override
        public int getSourceActions(JComponent c) {
            if (c instanceof JPasswordField && c.getClientProperty("JPasswordField.cutCopyAllowed") != Boolean.TRUE) {
                return 0;
            }
            return ((JTextComponent)c).isEditable() ? 3 : 1;
        }

        @Override
        protected Transferable createTransferable(JComponent comp) {
            this.exportComp = (JTextComponent)comp;
            this.shouldRemove = true;
            this.p0 = this.exportComp.getSelectionStart();
            this.p1 = this.exportComp.getSelectionEnd();
            return this.p0 != this.p1 ? new TextTransferable(this.exportComp, this.p0, this.p1) : null;
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            if (this.shouldRemove && action == 2) {
                TextTransferable t = (TextTransferable)data;
                t.removeText();
            }
            this.exportComp = null;
        }

        public boolean importData(TransferHandler.TransferSupport support) {
            this.isDrop = support.isDrop();
            if (this.isDrop) {
                this.modeBetween = ((JTextComponent)support.getComponent()).getDropMode() == DropMode.INSERT;
                this.dropBias = ((JTextComponent.DropLocation)support.getDropLocation()).getBias();
                this.dropAction = support.getDropAction();
            }
            try {
                boolean bl = super.importData(support);
                return bl;
            }
            finally {
                this.isDrop = false;
                this.modeBetween = false;
                this.dropBias = null;
                this.dropAction = 2;
            }
        }

        @Override
        public boolean importData(JComponent comp, Transferable t) {
            int pos;
            JTextComponent c = (JTextComponent)comp;
            int n = pos = this.modeBetween ? c.getDropLocation().getIndex() : c.getCaretPosition();
            if (this.dropAction == 2 && c == this.exportComp && pos >= this.p0 && pos <= this.p1) {
                this.shouldRemove = false;
                return true;
            }
            boolean imported = false;
            DataFlavor importFlavor = this.getImportFlavor(t.getTransferDataFlavors(), c);
            if (importFlavor != null) {
                try {
                    Caret caret;
                    InputContext ic;
                    JEditorPane ep;
                    boolean useRead = false;
                    if (comp instanceof JEditorPane && !(ep = (JEditorPane)comp).getContentType().startsWith("text/plain") && importFlavor.getMimeType().startsWith(ep.getContentType())) {
                        useRead = true;
                    }
                    if ((ic = c.getInputContext()) != null) {
                        ic.endComposition();
                    }
                    Reader r = importFlavor.getReaderForText(t);
                    if (this.modeBetween) {
                        caret = c.getCaret();
                        if (caret instanceof DefaultCaret) {
                            ((DefaultCaret)caret).setDot(pos, this.dropBias);
                        } else {
                            c.setCaretPosition(pos);
                        }
                    }
                    this.handleReaderImport(r, c, useRead);
                    if (this.isDrop) {
                        c.requestFocus();
                        caret = c.getCaret();
                        if (caret instanceof DefaultCaret) {
                            int newPos = caret.getDot();
                            Position.Bias newBias = ((DefaultCaret)caret).getDotBias();
                            ((DefaultCaret)caret).setDot(pos, this.dropBias);
                            ((DefaultCaret)caret).moveDot(newPos, newBias);
                        } else {
                            c.select(pos, c.getCaretPosition());
                        }
                    }
                    imported = true;
                }
                catch (UnsupportedFlavorException | IOException | BadLocationException exception) {
                    // empty catch block
                }
            }
            return imported;
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] flavors) {
            JTextComponent c = (JTextComponent)comp;
            if (!c.isEditable() || !c.isEnabled()) {
                return false;
            }
            return this.getImportFlavor(flavors, c) != null;
        }

        static class TextTransferable
        extends BasicTransferable {
            Position p0;
            Position p1;
            String mimeType;
            String richText;
            JTextComponent c;

            TextTransferable(JTextComponent c, int start, int end) {
                super(null, null);
                this.c = c;
                Document doc = c.getDocument();
                try {
                    this.p0 = doc.createPosition(start);
                    this.p1 = doc.createPosition(end);
                    this.plainData = c.getSelectedText();
                    if (c instanceof JEditorPane) {
                        JEditorPane ep = (JEditorPane)c;
                        this.mimeType = ep.getContentType();
                        if (this.mimeType.startsWith("text/plain")) {
                            return;
                        }
                        StringWriter sw = new StringWriter(this.p1.getOffset() - this.p0.getOffset());
                        ep.getEditorKit().write(sw, doc, this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                        if (this.mimeType.startsWith("text/html")) {
                            this.htmlData = sw.toString();
                        } else {
                            this.richText = sw.toString();
                        }
                    }
                }
                catch (IOException | BadLocationException exception) {
                    // empty catch block
                }
            }

            void removeText() {
                if (this.p0 != null && this.p1 != null && this.p0.getOffset() != this.p1.getOffset()) {
                    try {
                        Document doc = this.c.getDocument();
                        doc.remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }

            @Override
            protected DataFlavor[] getRicherFlavors() {
                if (this.richText == null) {
                    return null;
                }
                try {
                    DataFlavor[] flavors = new DataFlavor[]{new DataFlavor(this.mimeType + ";class=java.lang.String"), new DataFlavor(this.mimeType + ";class=java.io.Reader"), new DataFlavor(this.mimeType + ";class=java.io.InputStream;charset=unicode")};
                    return flavors;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }

            @Override
            protected Object getRicherData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (this.richText == null) {
                    return null;
                }
                if (String.class.equals(flavor.getRepresentationClass())) {
                    return this.richText;
                }
                if (Reader.class.equals(flavor.getRepresentationClass())) {
                    return new StringReader(this.richText);
                }
                if (InputStream.class.equals(flavor.getRepresentationClass())) {
                    return new StringBufferInputStream(this.richText);
                }
                throw new UnsupportedFlavorException(flavor);
            }
        }
    }

    class UpdateHandler
    implements PropertyChangeListener,
    DocumentListener,
    LayoutManager2,
    UIResource {
        private Hashtable<Component, Object> constraints;
        private boolean i18nView = false;

        UpdateHandler() {
        }

        @Override
        public final void propertyChange(PropertyChangeEvent evt) {
            Object oldValue = evt.getOldValue();
            Object newValue = evt.getNewValue();
            String propertyName = evt.getPropertyName();
            if (oldValue instanceof Document || newValue instanceof Document) {
                if (oldValue != null) {
                    ((Document)oldValue).removeDocumentListener(this);
                    this.i18nView = false;
                }
                if (newValue != null) {
                    ((Document)newValue).addDocumentListener(this);
                    if ("document" == propertyName) {
                        BasicTextUI.this.setView(null);
                        BasicTextUI.this.propertyChange(evt);
                        BasicTextUI.this.modelChanged();
                        return;
                    }
                }
                BasicTextUI.this.modelChanged();
            }
            if ("focusAccelerator" == propertyName) {
                BasicTextUI.this.updateFocusAcceleratorBinding(true);
            } else if ("componentOrientation" == propertyName) {
                Document document = BasicTextUI.this.editor.getDocument();
                String I18NProperty = "i18n";
                if (ComponentOrientation.RIGHT_TO_LEFT == newValue && !Boolean.TRUE.equals(document.getProperty("i18n"))) {
                    document.putProperty("i18n", Boolean.TRUE);
                }
                BasicTextUI.this.modelChanged();
            } else if ("font" == propertyName) {
                BasicTextUI.this.modelChanged();
            } else if ("dropLocation" == propertyName) {
                this.dropIndexChanged();
            } else if ("editable" == propertyName) {
                BasicTextUI.this.updateCursor();
                BasicTextUI.this.modelChanged();
            }
            BasicTextUI.this.propertyChange(evt);
        }

        private void dropIndexChanged() {
            if (BasicTextUI.this.editor.getDropMode() == DropMode.USE_SELECTION) {
                return;
            }
            JTextComponent.DropLocation dropLocation = BasicTextUI.this.editor.getDropLocation();
            if (dropLocation == null) {
                if (BasicTextUI.this.dropCaret != null) {
                    BasicTextUI.this.dropCaret.deinstall(BasicTextUI.this.editor);
                    BasicTextUI.this.editor.repaint(BasicTextUI.this.dropCaret);
                    BasicTextUI.this.dropCaret = null;
                }
            } else {
                if (BasicTextUI.this.dropCaret == null) {
                    BasicTextUI.this.dropCaret = new BasicCaret();
                    BasicTextUI.this.dropCaret.install(BasicTextUI.this.editor);
                    BasicTextUI.this.dropCaret.setVisible(true);
                }
                BasicTextUI.this.dropCaret.setDot(dropLocation.getIndex(), dropLocation.getBias());
            }
        }

        @Override
        public final void insertUpdate(DocumentEvent e) {
            Boolean i18nFlag;
            Document doc = e.getDocument();
            Object o = doc.getProperty("i18n");
            if (o instanceof Boolean && (i18nFlag = (Boolean)o) != this.i18nView) {
                this.i18nView = i18nFlag;
                BasicTextUI.this.modelChanged();
                return;
            }
            Rectangle alloc = BasicTextUI.this.painted ? BasicTextUI.this.getVisibleEditorRect() : null;
            BasicTextUI.this.rootView.insertUpdate(e, alloc, BasicTextUI.this.rootView.getViewFactory());
        }

        @Override
        public final void removeUpdate(DocumentEvent e) {
            Rectangle alloc = BasicTextUI.this.painted ? BasicTextUI.this.getVisibleEditorRect() : null;
            BasicTextUI.this.rootView.removeUpdate(e, alloc, BasicTextUI.this.rootView.getViewFactory());
        }

        @Override
        public final void changedUpdate(DocumentEvent e) {
            Rectangle alloc = BasicTextUI.this.painted ? BasicTextUI.this.getVisibleEditorRect() : null;
            BasicTextUI.this.rootView.changedUpdate(e, alloc, BasicTextUI.this.rootView.getViewFactory());
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (this.constraints != null) {
                this.constraints.remove(comp);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Rectangle alloc;
            if (this.constraints != null && !this.constraints.isEmpty() && (alloc = BasicTextUI.this.getVisibleEditorRect()) != null) {
                Document doc = BasicTextUI.this.editor.getDocument();
                if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)doc).readLock();
                }
                try {
                    BasicTextUI.this.rootView.setSize(alloc.width, alloc.height);
                    Enumeration<Component> components = this.constraints.keys();
                    while (components.hasMoreElements()) {
                        Component comp = components.nextElement();
                        View v = (View)this.constraints.get(comp);
                        Shape ca = this.calculateViewPosition(alloc, v);
                        if (ca == null) continue;
                        Rectangle compAlloc = ca instanceof Rectangle ? (Rectangle)ca : ca.getBounds();
                        comp.setBounds(compAlloc);
                    }
                }
                finally {
                    if (doc instanceof AbstractDocument) {
                        ((AbstractDocument)doc).readUnlock();
                    }
                }
            }
        }

        Shape calculateViewPosition(Shape alloc, View v) {
            int pos = v.getStartOffset();
            View child = null;
            View parent = BasicTextUI.this.rootView;
            while (parent != null && parent != v) {
                int index = ((View)parent).getViewIndex(pos, Position.Bias.Forward);
                alloc = ((View)parent).getChildAllocation(index, alloc);
                child = ((View)parent).getView(index);
                parent = child;
            }
            return child != null ? alloc : null;
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraint) {
            if (constraint instanceof View) {
                if (this.constraints == null) {
                    this.constraints = new Hashtable(7);
                }
                this.constraints.put(comp, constraint);
            }
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return null;
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.5f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.5f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }
    }
}

