/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.basic.BasicLookAndFeel;
import sun.swing.UIAction;

public class BasicToolBarUI
extends ToolBarUI
implements SwingConstants {
    protected JToolBar toolBar;
    protected DragWindow dragWindow;
    protected int focusedCompIndex;
    protected Color dockingColor;
    protected Color floatingColor;
    protected Color dockingBorderColor;
    protected Color floatingBorderColor;
    protected MouseInputListener dockingListener;
    protected PropertyChangeListener propertyListener;
    protected ContainerListener toolBarContListener;
    protected FocusListener toolBarFocusListener;
    protected String constraintBeforeFloating;
    @Deprecated
    protected KeyStroke upKey;
    @Deprecated
    protected KeyStroke downKey;
    @Deprecated
    protected KeyStroke leftKey;
    @Deprecated
    protected KeyStroke rightKey;

    public static ComponentUI createUI(JComponent jComponent) {
        return null;
    }

    public void installUI(JComponent jComponent) {
    }

    public void uninstallUI(JComponent jComponent) {
    }

    protected void installDefaults() {
    }

    protected void uninstallDefaults() {
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
    }

    protected void installListeners() {
    }

    protected void uninstallListeners() {
    }

    protected void installKeyboardActions() {
    }

    protected void uninstallKeyboardActions() {
    }

    protected void navigateFocusedComp(int n) {
    }

    protected Border createRolloverBorder() {
        return null;
    }

    protected Border createNonRolloverBorder() {
        return null;
    }

    protected JFrame createFloatingFrame(JToolBar jToolBar) {
        return null;
    }

    protected RootPaneContainer createFloatingWindow(JToolBar jToolBar) {
        return null;
    }

    protected DragWindow createDragWindow(JToolBar jToolBar) {
        return null;
    }

    public boolean isRolloverBorders() {
        return false;
    }

    public void setRolloverBorders(boolean bl) {
    }

    protected void installRolloverBorders(JComponent jComponent) {
    }

    protected void installNonRolloverBorders(JComponent jComponent) {
    }

    protected void installNormalBorders(JComponent jComponent) {
    }

    protected void setBorderToRollover(Component component) {
    }

    protected void setBorderToNonRollover(Component component) {
    }

    protected void setBorderToNormal(Component component) {
    }

    public void setFloatingLocation(int n, int n2) {
    }

    public boolean isFloating() {
        return false;
    }

    public void setFloating(boolean bl, Point point) {
    }

    public void setOrientation(int n) {
    }

    public Color getDockingColor() {
        return null;
    }

    public void setDockingColor(Color color) {
    }

    public Color getFloatingColor() {
        return null;
    }

    public void setFloatingColor(Color color) {
    }

    public boolean canDock(Component component, Point point) {
        return false;
    }

    protected void dragTo(Point point, Point point2) {
    }

    protected void floatAt(Point point, Point point2) {
    }

    protected ContainerListener createToolBarContListener() {
        return null;
    }

    protected FocusListener createToolBarFocusListener() {
        return null;
    }

    protected PropertyChangeListener createPropertyListener() {
        return null;
    }

    protected MouseInputListener createDockingListener() {
        return null;
    }

    protected WindowListener createFrameListener() {
        return null;
    }

    protected void paintDragWindow(Graphics graphics) {
    }

    private static class Actions
    extends UIAction {
        private static final String NAVIGATE_RIGHT = "navigateRight";
        private static final String NAVIGATE_LEFT = "navigateLeft";
        private static final String NAVIGATE_UP = "navigateUp";
        private static final String NAVIGATE_DOWN = "navigateDown";

        public Actions(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String key = this.getName();
            JToolBar toolBar = (JToolBar)evt.getSource();
            BasicToolBarUI ui = (BasicToolBarUI)BasicLookAndFeel.getUIOfType((ComponentUI)toolBar.getUI(), BasicToolBarUI.class);
            if (NAVIGATE_RIGHT == key) {
                ui.navigateFocusedComp(3);
            } else if (NAVIGATE_LEFT == key) {
                ui.navigateFocusedComp(7);
            } else if (NAVIGATE_UP == key) {
                ui.navigateFocusedComp(1);
            } else if (NAVIGATE_DOWN == key) {
                ui.navigateFocusedComp(5);
            }
        }
    }

    public class DockingListener
    implements MouseInputListener {
        protected JToolBar toolBar;
        protected boolean isDragging;
        protected Point origin;

        public DockingListener(BasicToolBarUI basicToolBarUI, JToolBar jToolBar) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    protected class DragWindow
    extends Window {
        public void setOrientation(int n) {
        }

        public Point getOffset() {
            return null;
        }

        public void setOffset(Point point) {
        }

        public void setBorderColor(Color color) {
        }

        public Color getBorderColor() {
            return null;
        }

        public void paint(Graphics graphics) {
        }

        public Insets getInsets() {
            return null;
        }
    }

    protected class FrameListener
    extends WindowAdapter {
        protected FrameListener(BasicToolBarUI basicToolBarUI) {
        }

        public void windowClosing(WindowEvent windowEvent) {
        }
    }

    private class Handler
    implements ContainerListener,
    FocusListener,
    MouseInputListener,
    PropertyChangeListener {
        JToolBar tb;
        boolean isDragging = false;
        Point origin = null;

        private Handler() {
        }

        @Override
        public void componentAdded(ContainerEvent evt) {
            Component c = evt.getChild();
            if (BasicToolBarUI.this.toolBarFocusListener != null) {
                c.addFocusListener(BasicToolBarUI.this.toolBarFocusListener);
            }
            if (BasicToolBarUI.this.isRolloverBorders()) {
                BasicToolBarUI.this.setBorderToRollover(c);
            } else {
                BasicToolBarUI.this.setBorderToNonRollover(c);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent evt) {
            Component c = evt.getChild();
            if (BasicToolBarUI.this.toolBarFocusListener != null) {
                c.removeFocusListener(BasicToolBarUI.this.toolBarFocusListener);
            }
            BasicToolBarUI.this.setBorderToNormal(c);
        }

        @Override
        public void focusGained(FocusEvent evt) {
            Component c = evt.getComponent();
            BasicToolBarUI.this.focusedCompIndex = BasicToolBarUI.this.toolBar.getComponentIndex(c);
        }

        @Override
        public void focusLost(FocusEvent evt) {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (!this.tb.isEnabled()) {
                return;
            }
            this.isDragging = false;
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (!this.tb.isEnabled()) {
                return;
            }
            if (this.isDragging) {
                Point position = evt.getPoint();
                if (this.origin == null) {
                    this.origin = evt.getComponent().getLocationOnScreen();
                }
                BasicToolBarUI.this.floatAt(position, this.origin);
            }
            this.origin = null;
            this.isDragging = false;
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            if (!this.tb.isEnabled()) {
                return;
            }
            this.isDragging = true;
            Point position = evt.getPoint();
            if (this.origin == null) {
                this.origin = evt.getComponent().getLocationOnScreen();
            }
            BasicToolBarUI.this.dragTo(position, this.origin);
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (propertyName == "lookAndFeel") {
                BasicToolBarUI.this.toolBar.updateUI();
            } else if (propertyName == "orientation") {
                Component[] components = BasicToolBarUI.this.toolBar.getComponents();
                int orientation = (Integer)evt.getNewValue();
                for (int i = 0; i < components.length; ++i) {
                    if (!(components[i] instanceof JToolBar.Separator)) continue;
                    JToolBar.Separator separator = (JToolBar.Separator)components[i];
                    if (orientation == 0) {
                        separator.setOrientation(1);
                    } else {
                        separator.setOrientation(0);
                    }
                    Dimension size = separator.getSeparatorSize();
                    if (size == null || size.width == size.height) continue;
                    Dimension newSize = new Dimension(size.height, size.width);
                    separator.setSeparatorSize(newSize);
                }
            } else if (propertyName == IS_ROLLOVER) {
                BasicToolBarUI.this.installNormalBorders(BasicToolBarUI.this.toolBar);
                BasicToolBarUI.this.setRolloverBorders((Boolean)evt.getNewValue());
            }
        }
    }

    protected class PropertyListener
    implements PropertyChangeListener {
        protected PropertyListener(BasicToolBarUI basicToolBarUI) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }
    }

    protected class ToolBarContListener
    implements ContainerListener {
        protected ToolBarContListener(BasicToolBarUI basicToolBarUI) {
        }

        public void componentAdded(ContainerEvent containerEvent) {
        }

        public void componentRemoved(ContainerEvent containerEvent) {
        }
    }

    protected class ToolBarFocusListener
    implements FocusListener {
        protected ToolBarFocusListener(BasicToolBarUI basicToolBarUI) {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

