/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalBumps;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;
import sun.swing.CachedPainter;
import sun.swing.SwingUtilities2;

public class MetalIconFactory
implements Serializable {
    public static final boolean DARK = false;
    public static final boolean LIGHT = true;

    public static Icon getFileChooserDetailViewIcon() {
        return null;
    }

    public static Icon getFileChooserHomeFolderIcon() {
        return null;
    }

    public static Icon getFileChooserListViewIcon() {
        return null;
    }

    public static Icon getFileChooserNewFolderIcon() {
        return null;
    }

    public static Icon getFileChooserUpFolderIcon() {
        return null;
    }

    public static Icon getInternalFrameAltMaximizeIcon(int n) {
        return null;
    }

    public static Icon getInternalFrameCloseIcon(int n) {
        return null;
    }

    public static Icon getInternalFrameDefaultMenuIcon() {
        return null;
    }

    public static Icon getInternalFrameMaximizeIcon(int n) {
        return null;
    }

    public static Icon getInternalFrameMinimizeIcon(int n) {
        return null;
    }

    public static Icon getRadioButtonIcon() {
        return null;
    }

    public static Icon getCheckBoxIcon() {
        return null;
    }

    public static Icon getTreeComputerIcon() {
        return null;
    }

    public static Icon getTreeFloppyDriveIcon() {
        return null;
    }

    public static Icon getTreeFolderIcon() {
        return null;
    }

    public static Icon getTreeHardDriveIcon() {
        return null;
    }

    public static Icon getTreeLeafIcon() {
        return null;
    }

    public static Icon getTreeControlIcon(boolean bl) {
        return null;
    }

    public static Icon getMenuArrowIcon() {
        return null;
    }

    public static Icon getMenuItemCheckIcon() {
        return null;
    }

    public static Icon getMenuItemArrowIcon() {
        return null;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        return null;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        return null;
    }

    public static Icon getHorizontalSliderThumbIcon() {
        return null;
    }

    public static Icon getVerticalSliderThumbIcon() {
        return null;
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxIcon() {
        }

        protected int getControlSize() {
            return 13;
        }

        private void paintOceanIcon(Component c, Graphics g, int x, int y) {
            ButtonModel model = ((JCheckBox)c).getModel();
            g.translate(x, y);
            int w = this.getIconWidth();
            int h = this.getIconHeight();
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed()) {
                    g.setColor(MetalLookAndFeel.getControlShadow());
                    g.fillRect(0, 0, w, h);
                    g.setColor(MetalLookAndFeel.getControlDarkShadow());
                    g.fillRect(0, 0, w, 2);
                    g.fillRect(0, 2, 2, h - 2);
                    g.fillRect(w - 1, 1, 1, h - 1);
                    g.fillRect(1, h - 1, w - 2, 1);
                } else if (model.isRollover()) {
                    MetalUtils.drawGradient(c, g, "CheckBox.gradient", 0, 0, w, h, true);
                    g.setColor(MetalLookAndFeel.getControlDarkShadow());
                    g.drawRect(0, 0, w - 1, h - 1);
                    g.setColor(MetalLookAndFeel.getPrimaryControl());
                    g.drawRect(1, 1, w - 3, h - 3);
                    g.drawRect(2, 2, w - 5, h - 5);
                } else {
                    MetalUtils.drawGradient(c, g, "CheckBox.gradient", 0, 0, w, h, true);
                    g.setColor(MetalLookAndFeel.getControlDarkShadow());
                    g.drawRect(0, 0, w - 1, h - 1);
                }
                g.setColor(MetalLookAndFeel.getControlInfo());
            } else {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
                g.drawRect(0, 0, w - 1, h - 1);
            }
            g.translate(-x, -y);
            if (model.isSelected()) {
                this.drawCheck(c, g, x, y);
            }
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (MetalLookAndFeel.usingOcean()) {
                this.paintOceanIcon(c, g, x, y);
                return;
            }
            ButtonModel model = ((JCheckBox)c).getModel();
            int controlSize = this.getControlSize();
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed()) {
                    g.setColor(MetalLookAndFeel.getControlShadow());
                    g.fillRect(x, y, controlSize - 1, controlSize - 1);
                    MetalUtils.drawPressed3DBorder(g, x, y, controlSize, controlSize);
                } else {
                    MetalUtils.drawFlush3DBorder(g, x, y, controlSize, controlSize);
                }
                g.setColor(c.getForeground());
            } else {
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.drawRect(x, y, controlSize - 2, controlSize - 2);
            }
            if (model.isSelected()) {
                this.drawCheck(c, g, x, y);
            }
        }

        protected void drawCheck(Component c, Graphics g, int x, int y) {
            int controlSize = this.getControlSize();
            int csx = controlSize - 3;
            int csy1 = controlSize - 6;
            int csy2 = controlSize - 4;
            int csy3 = controlSize - 3;
            int[] xPoints = new int[]{3, 5, 5, csx, csx, 5, 5, 3};
            int[] yPoints = new int[]{5, 5, csy1, 2, 4, csy2, csy3, csy3};
            g.translate(x, y);
            g.fillPolygon(xPoints, yPoints, 8);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return this.getControlSize();
        }

        @Override
        public int getIconHeight() {
            return this.getControlSize();
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxMenuItemIcon() {
        }

        public void paintOceanIcon(Component c, Graphics g, int x, int y) {
            ButtonModel model = ((JMenuItem)c).getModel();
            boolean isSelected = model.isSelected();
            boolean isEnabled = model.isEnabled();
            boolean isPressed = model.isPressed();
            boolean isArmed = model.isArmed();
            g.translate(x, y);
            if (isEnabled) {
                MetalUtils.drawGradient(c, g, "CheckBoxMenuItem.gradient", 1, 1, 7, 7, true);
                if (isPressed || isArmed) {
                    g.setColor(MetalLookAndFeel.getControlInfo());
                    g.drawLine(0, 0, 8, 0);
                    g.drawLine(0, 0, 0, 8);
                    g.drawLine(8, 2, 8, 8);
                    g.drawLine(2, 8, 8, 8);
                    g.setColor(MetalLookAndFeel.getPrimaryControl());
                    g.drawLine(9, 1, 9, 9);
                    g.drawLine(1, 9, 9, 9);
                } else {
                    g.setColor(MetalLookAndFeel.getControlDarkShadow());
                    g.drawLine(0, 0, 8, 0);
                    g.drawLine(0, 0, 0, 8);
                    g.drawLine(8, 2, 8, 8);
                    g.drawLine(2, 8, 8, 8);
                    g.setColor(MetalLookAndFeel.getControlHighlight());
                    g.drawLine(9, 1, 9, 9);
                    g.drawLine(1, 9, 9, 9);
                }
            } else {
                g.setColor(MetalLookAndFeel.getMenuDisabledForeground());
                g.drawRect(0, 0, 8, 8);
            }
            if (isSelected) {
                if (isEnabled) {
                    if (isArmed || c instanceof JMenu && isSelected) {
                        g.setColor(MetalLookAndFeel.getMenuSelectedForeground());
                    } else {
                        g.setColor(MetalLookAndFeel.getControlInfo());
                    }
                } else {
                    g.setColor(MetalLookAndFeel.getMenuDisabledForeground());
                }
                this.drawCheck(g);
            }
            g.translate(-x, -y);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (MetalLookAndFeel.usingOcean()) {
                this.paintOceanIcon(c, g, x, y);
                return;
            }
            JMenuItem b = (JMenuItem)c;
            ButtonModel model = b.getModel();
            boolean isSelected = model.isSelected();
            boolean isEnabled = model.isEnabled();
            boolean isPressed = model.isPressed();
            boolean isArmed = model.isArmed();
            g.translate(x, y);
            if (isEnabled) {
                if (isPressed || isArmed) {
                    g.setColor(MetalLookAndFeel.getControlInfo());
                    g.drawLine(0, 0, 8, 0);
                    g.drawLine(0, 0, 0, 8);
                    g.drawLine(8, 2, 8, 8);
                    g.drawLine(2, 8, 8, 8);
                    g.setColor(MetalLookAndFeel.getPrimaryControl());
                    g.drawLine(1, 1, 7, 1);
                    g.drawLine(1, 1, 1, 7);
                    g.drawLine(9, 1, 9, 9);
                    g.drawLine(1, 9, 9, 9);
                } else {
                    g.setColor(MetalLookAndFeel.getControlDarkShadow());
                    g.drawLine(0, 0, 8, 0);
                    g.drawLine(0, 0, 0, 8);
                    g.drawLine(8, 2, 8, 8);
                    g.drawLine(2, 8, 8, 8);
                    g.setColor(MetalLookAndFeel.getControlHighlight());
                    g.drawLine(1, 1, 7, 1);
                    g.drawLine(1, 1, 1, 7);
                    g.drawLine(9, 1, 9, 9);
                    g.drawLine(1, 9, 9, 9);
                }
            } else {
                g.setColor(MetalLookAndFeel.getMenuDisabledForeground());
                g.drawRect(0, 0, 8, 8);
            }
            if (isSelected) {
                if (isEnabled) {
                    if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                        g.setColor(MetalLookAndFeel.getMenuSelectedForeground());
                    } else {
                        g.setColor(b.getForeground());
                    }
                } else {
                    g.setColor(MetalLookAndFeel.getMenuDisabledForeground());
                }
                this.drawCheck(g);
            }
            g.translate(-x, -y);
        }

        private void drawCheck(Graphics g) {
            int[] xPoints = new int[]{2, 3, 3, 8, 9, 3, 2};
            int[] yPoints = new int[]{2, 2, 5, 0, 0, 6, 6};
            g.drawPolygon(xPoints, yPoints, 7);
        }

        @Override
        public int getIconWidth() {
            return MetalIconFactory.menuCheckIconSize.width;
        }

        @Override
        public int getIconHeight() {
            return MetalIconFactory.menuCheckIconSize.height;
        }
    }

    private static class FileChooserDetailViewIcon
    implements Icon,
    UIResource,
    Serializable {
        private FileChooserDetailViewIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            g.drawLine(2, 2, 5, 2);
            g.drawLine(2, 3, 2, 7);
            g.drawLine(3, 7, 6, 7);
            g.drawLine(6, 6, 6, 3);
            g.drawLine(2, 10, 5, 10);
            g.drawLine(2, 11, 2, 15);
            g.drawLine(3, 15, 6, 15);
            g.drawLine(6, 14, 6, 11);
            g.drawLine(8, 5, 15, 5);
            g.drawLine(8, 13, 15, 13);
            g.setColor(MetalLookAndFeel.getPrimaryControl());
            g.drawRect(3, 3, 2, 3);
            g.drawRect(3, 11, 2, 3);
            g.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            g.drawLine(4, 4, 4, 5);
            g.drawLine(4, 12, 4, 13);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return 18;
        }

        @Override
        public int getIconHeight() {
            return 18;
        }
    }

    private static class FileChooserHomeFolderIcon
    implements Icon,
    UIResource,
    Serializable {
        private FileChooserHomeFolderIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            g.drawLine(8, 1, 1, 8);
            g.drawLine(8, 1, 15, 8);
            g.drawLine(11, 2, 11, 3);
            g.drawLine(12, 2, 12, 4);
            g.drawLine(3, 7, 3, 15);
            g.drawLine(13, 7, 13, 15);
            g.drawLine(4, 15, 12, 15);
            g.drawLine(6, 9, 6, 14);
            g.drawLine(10, 9, 10, 14);
            g.drawLine(7, 9, 9, 9);
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.fillRect(8, 2, 1, 1);
            g.fillRect(7, 3, 3, 1);
            g.fillRect(6, 4, 5, 1);
            g.fillRect(5, 5, 7, 1);
            g.fillRect(4, 6, 9, 2);
            g.drawLine(9, 12, 9, 12);
            g.setColor(MetalLookAndFeel.getPrimaryControl());
            g.drawLine(4, 8, 12, 8);
            g.fillRect(4, 9, 2, 6);
            g.fillRect(11, 9, 2, 6);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return 18;
        }

        @Override
        public int getIconHeight() {
            return 18;
        }
    }

    private static class FileChooserListViewIcon
    implements Icon,
    UIResource,
    Serializable {
        private FileChooserListViewIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            g.drawLine(2, 2, 5, 2);
            g.drawLine(2, 3, 2, 7);
            g.drawLine(3, 7, 6, 7);
            g.drawLine(6, 6, 6, 3);
            g.drawLine(10, 2, 13, 2);
            g.drawLine(10, 3, 10, 7);
            g.drawLine(11, 7, 14, 7);
            g.drawLine(14, 6, 14, 3);
            g.drawLine(2, 10, 5, 10);
            g.drawLine(2, 11, 2, 15);
            g.drawLine(3, 15, 6, 15);
            g.drawLine(6, 14, 6, 11);
            g.drawLine(10, 10, 13, 10);
            g.drawLine(10, 11, 10, 15);
            g.drawLine(11, 15, 14, 15);
            g.drawLine(14, 14, 14, 11);
            g.drawLine(8, 5, 8, 5);
            g.drawLine(16, 5, 16, 5);
            g.drawLine(8, 13, 8, 13);
            g.drawLine(16, 13, 16, 13);
            g.setColor(MetalLookAndFeel.getPrimaryControl());
            g.drawRect(3, 3, 2, 3);
            g.drawRect(11, 3, 2, 3);
            g.drawRect(3, 11, 2, 3);
            g.drawRect(11, 11, 2, 3);
            g.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            g.drawLine(4, 4, 4, 5);
            g.drawLine(12, 4, 12, 5);
            g.drawLine(4, 12, 4, 13);
            g.drawLine(12, 12, 12, 13);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return 18;
        }

        @Override
        public int getIconHeight() {
            return 18;
        }
    }

    private static class FileChooserNewFolderIcon
    implements Icon,
    UIResource,
    Serializable {
        private FileChooserNewFolderIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.setColor(MetalLookAndFeel.getPrimaryControl());
            g.fillRect(3, 5, 12, 9);
            g.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            g.drawLine(1, 6, 1, 14);
            g.drawLine(2, 14, 15, 14);
            g.drawLine(15, 13, 15, 5);
            g.drawLine(2, 5, 9, 5);
            g.drawLine(10, 6, 14, 6);
            g.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            g.drawLine(2, 6, 2, 13);
            g.drawLine(3, 6, 9, 6);
            g.drawLine(10, 7, 14, 7);
            g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            g.drawLine(11, 3, 15, 3);
            g.drawLine(10, 4, 15, 4);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return 18;
        }

        @Override
        public int getIconHeight() {
            return 18;
        }
    }

    private static class FileChooserUpFolderIcon
    implements Icon,
    UIResource,
    Serializable {
        private FileChooserUpFolderIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.setColor(MetalLookAndFeel.getPrimaryControl());
            g.fillRect(3, 5, 12, 9);
            g.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            g.drawLine(1, 6, 1, 14);
            g.drawLine(2, 14, 15, 14);
            g.drawLine(15, 13, 15, 5);
            g.drawLine(2, 5, 9, 5);
            g.drawLine(10, 6, 14, 6);
            g.drawLine(8, 13, 8, 16);
            g.drawLine(8, 9, 8, 9);
            g.drawLine(7, 10, 9, 10);
            g.drawLine(6, 11, 10, 11);
            g.drawLine(5, 12, 11, 12);
            g.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            g.drawLine(2, 6, 2, 13);
            g.drawLine(3, 6, 9, 6);
            g.drawLine(10, 7, 14, 7);
            g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            g.drawLine(11, 3, 15, 3);
            g.drawLine(10, 4, 15, 4);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return 18;
        }

        @Override
        public int getIconHeight() {
            return 18;
        }
    }

    public static class FileIcon16
    implements Icon,
    Serializable {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        public int getShift() {
            return 0;
        }

        public int getAdditionalHeight() {
            return 0;
        }

        public int getIconWidth() {
            return 0;
        }

        public int getIconHeight() {
            return 0;
        }
    }

    public static class FolderIcon16
    implements Icon,
    Serializable {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        public int getShift() {
            return 0;
        }

        public int getAdditionalHeight() {
            return 0;
        }

        public int getIconWidth() {
            return 0;
        }

        public int getIconHeight() {
            return 0;
        }
    }

    private static class HorizontalSliderThumbIcon
    implements Icon,
    Serializable,
    UIResource {
        protected static MetalBumps controlBumps;
        protected static MetalBumps primaryBumps;

        public HorizontalSliderThumbIcon() {
            controlBumps = new MetalBumps(10, 6, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlInfo(), MetalLookAndFeel.getControl());
            primaryBumps = new MetalBumps(10, 6, MetalLookAndFeel.getPrimaryControl(), MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getPrimaryControlShadow());
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            Rectangle clip = g.getClipBounds();
            g.clipRect(0, 0, this.getIconWidth(), this.getIconHeight());
            if (c.hasFocus()) {
                g.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            } else {
                g.setColor(c.isEnabled() ? MetalLookAndFeel.getPrimaryControlInfo() : MetalLookAndFeel.getControlDarkShadow());
            }
            g.drawLine(1, 0, 13, 0);
            g.drawLine(0, 1, 0, 8);
            g.drawLine(14, 1, 14, 8);
            g.drawLine(1, 9, 7, 15);
            g.drawLine(7, 15, 14, 8);
            if (c.hasFocus()) {
                g.setColor(c.getForeground());
            } else {
                g.setColor(MetalLookAndFeel.getControl());
            }
            g.fillRect(1, 1, 13, 8);
            g.drawLine(2, 9, 12, 9);
            g.drawLine(3, 10, 11, 10);
            g.drawLine(4, 11, 10, 11);
            g.drawLine(5, 12, 9, 12);
            g.drawLine(6, 13, 8, 13);
            g.drawLine(7, 14, 7, 14);
            if (c.isEnabled()) {
                if (c.hasFocus()) {
                    primaryBumps.paintIcon(c, g, 2, 2);
                } else {
                    controlBumps.paintIcon(c, g, 2, 2);
                }
            }
            if (c.isEnabled()) {
                g.setColor(c.hasFocus() ? MetalLookAndFeel.getPrimaryControl() : MetalLookAndFeel.getControlHighlight());
                g.drawLine(1, 1, 13, 1);
                g.drawLine(1, 1, 1, 8);
            }
            g.setClip(clip);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return 15;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }

    static class ImageCacher {
        Vector<ImageGcPair> images = new Vector(1, 1);
        ImageGcPair currentImageGcPair;

        ImageCacher() {
        }

        Image getImage(GraphicsConfiguration newGC) {
            if (this.currentImageGcPair == null || !this.currentImageGcPair.hasSameConfiguration(newGC)) {
                for (ImageGcPair imgGcPair : this.images) {
                    if (!imgGcPair.hasSameConfiguration(newGC)) continue;
                    this.currentImageGcPair = imgGcPair;
                    return imgGcPair.image;
                }
                return null;
            }
            return this.currentImageGcPair.image;
        }

        void cacheImage(Image image, GraphicsConfiguration gc) {
            ImageGcPair imgGcPair = new ImageGcPair(image, gc);
            this.images.addElement(imgGcPair);
            this.currentImageGcPair = imgGcPair;
        }

        static class ImageGcPair {
            Image image;
            GraphicsConfiguration gc;

            ImageGcPair(Image image, GraphicsConfiguration gc) {
                this.image = image;
                this.gc = gc;
            }

            boolean hasSameConfiguration(GraphicsConfiguration newGC) {
                return newGC != null && newGC.equals(this.gc) || newGC == null && this.gc == null;
            }
        }
    }

    private static class InternalFrameAltMaximizeIcon
    implements Icon,
    UIResource,
    Serializable {
        int iconSize = 16;

        public InternalFrameAltMaximizeIcon(int size) {
            this.iconSize = size;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JButton parentButton = (JButton)c;
            ButtonModel buttonModel = parentButton.getModel();
            ColorUIResource backgroundColor = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource internalBackgroundColor = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource mainItemColor = MetalLookAndFeel.getPrimaryControlDarkShadow();
            ColorUIResource darkHighlightColor = MetalLookAndFeel.getBlack();
            ColorUIResource ulLightHighlightColor = MetalLookAndFeel.getWhite();
            ColorUIResource lrLightHighlightColor = MetalLookAndFeel.getWhite();
            if (parentButton.getClientProperty("paintActive") != Boolean.TRUE) {
                internalBackgroundColor = backgroundColor = MetalLookAndFeel.getControl();
                mainItemColor = MetalLookAndFeel.getControlDarkShadow();
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    ulLightHighlightColor = internalBackgroundColor = MetalLookAndFeel.getControlShadow();
                    mainItemColor = darkHighlightColor;
                }
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                ulLightHighlightColor = internalBackgroundColor = MetalLookAndFeel.getPrimaryControlShadow();
                mainItemColor = darkHighlightColor;
            }
            g.translate(x, y);
            g.setColor(backgroundColor);
            g.fillRect(0, 0, this.iconSize, this.iconSize);
            g.setColor(internalBackgroundColor);
            g.fillRect(3, 6, this.iconSize - 9, this.iconSize - 9);
            g.setColor(darkHighlightColor);
            g.drawRect(1, 5, this.iconSize - 8, this.iconSize - 8);
            g.drawLine(1, this.iconSize - 2, 1, this.iconSize - 2);
            g.setColor(lrLightHighlightColor);
            g.drawRect(2, 6, this.iconSize - 7, this.iconSize - 7);
            g.setColor(ulLightHighlightColor);
            g.drawRect(3, 7, this.iconSize - 9, this.iconSize - 9);
            g.setColor(mainItemColor);
            g.drawRect(2, 6, this.iconSize - 8, this.iconSize - 8);
            g.setColor(ulLightHighlightColor);
            g.drawLine(this.iconSize - 6, 8, this.iconSize - 6, 8);
            g.drawLine(this.iconSize - 9, 6, this.iconSize - 7, 8);
            g.setColor(mainItemColor);
            g.drawLine(3, this.iconSize - 3, 3, this.iconSize - 3);
            g.setColor(darkHighlightColor);
            g.drawLine(this.iconSize - 6, 9, this.iconSize - 6, 9);
            g.setColor(backgroundColor);
            g.drawLine(this.iconSize - 9, 5, this.iconSize - 9, 5);
            g.setColor(mainItemColor);
            g.fillRect(this.iconSize - 7, 3, 3, 5);
            g.drawLine(this.iconSize - 6, 5, this.iconSize - 3, 2);
            g.drawLine(this.iconSize - 6, 6, this.iconSize - 2, 2);
            g.drawLine(this.iconSize - 6, 7, this.iconSize - 3, 7);
            g.setColor(darkHighlightColor);
            g.drawLine(this.iconSize - 8, 2, this.iconSize - 7, 2);
            g.drawLine(this.iconSize - 8, 3, this.iconSize - 8, 7);
            g.drawLine(this.iconSize - 6, 4, this.iconSize - 3, 1);
            g.drawLine(this.iconSize - 4, 6, this.iconSize - 3, 6);
            g.setColor(lrLightHighlightColor);
            g.drawLine(this.iconSize - 6, 3, this.iconSize - 6, 3);
            g.drawLine(this.iconSize - 4, 5, this.iconSize - 2, 3);
            g.drawLine(this.iconSize - 4, 8, this.iconSize - 3, 8);
            g.drawLine(this.iconSize - 2, 8, this.iconSize - 2, 7);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return this.iconSize;
        }

        @Override
        public int getIconHeight() {
            return this.iconSize;
        }
    }

    private static class InternalFrameCloseIcon
    implements Icon,
    UIResource,
    Serializable {
        int iconSize = 16;

        public InternalFrameCloseIcon(int size) {
            this.iconSize = size;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JButton parentButton = (JButton)c;
            ButtonModel buttonModel = parentButton.getModel();
            ColorUIResource backgroundColor = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource internalBackgroundColor = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource mainItemColor = MetalLookAndFeel.getPrimaryControlDarkShadow();
            ColorUIResource darkHighlightColor = MetalLookAndFeel.getBlack();
            ColorUIResource xLightHighlightColor = MetalLookAndFeel.getWhite();
            ColorUIResource boxLightHighlightColor = MetalLookAndFeel.getWhite();
            if (parentButton.getClientProperty("paintActive") != Boolean.TRUE) {
                internalBackgroundColor = backgroundColor = MetalLookAndFeel.getControl();
                mainItemColor = MetalLookAndFeel.getControlDarkShadow();
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    xLightHighlightColor = internalBackgroundColor = MetalLookAndFeel.getControlShadow();
                    mainItemColor = darkHighlightColor;
                }
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                xLightHighlightColor = internalBackgroundColor = MetalLookAndFeel.getPrimaryControlShadow();
                mainItemColor = darkHighlightColor;
            }
            int oneHalf = this.iconSize / 2;
            g.translate(x, y);
            g.setColor(backgroundColor);
            g.fillRect(0, 0, this.iconSize, this.iconSize);
            g.setColor(internalBackgroundColor);
            g.fillRect(3, 3, this.iconSize - 6, this.iconSize - 6);
            g.setColor(darkHighlightColor);
            g.drawRect(1, 1, this.iconSize - 3, this.iconSize - 3);
            g.drawRect(2, 2, this.iconSize - 5, this.iconSize - 5);
            g.setColor(boxLightHighlightColor);
            g.drawRect(2, 2, this.iconSize - 3, this.iconSize - 3);
            g.setColor(mainItemColor);
            g.drawRect(2, 2, this.iconSize - 4, this.iconSize - 4);
            g.drawLine(3, this.iconSize - 3, 3, this.iconSize - 3);
            g.drawLine(this.iconSize - 3, 3, this.iconSize - 3, 3);
            g.setColor(darkHighlightColor);
            g.drawLine(4, 5, 5, 4);
            g.drawLine(4, this.iconSize - 6, this.iconSize - 6, 4);
            g.setColor(xLightHighlightColor);
            g.drawLine(6, this.iconSize - 5, this.iconSize - 5, 6);
            g.drawLine(oneHalf, oneHalf + 2, oneHalf + 2, oneHalf);
            g.drawLine(this.iconSize - 5, this.iconSize - 5, this.iconSize - 4, this.iconSize - 5);
            g.drawLine(this.iconSize - 5, this.iconSize - 4, this.iconSize - 5, this.iconSize - 4);
            g.setColor(mainItemColor);
            g.drawLine(5, 5, this.iconSize - 6, this.iconSize - 6);
            g.drawLine(6, 5, this.iconSize - 5, this.iconSize - 6);
            g.drawLine(5, 6, this.iconSize - 6, this.iconSize - 5);
            g.drawLine(5, this.iconSize - 5, this.iconSize - 5, 5);
            g.drawLine(5, this.iconSize - 6, this.iconSize - 6, 5);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return this.iconSize;
        }

        @Override
        public int getIconHeight() {
            return this.iconSize;
        }
    }

    private static class InternalFrameDefaultMenuIcon
    implements Icon,
    UIResource,
    Serializable {
        private InternalFrameDefaultMenuIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            ColorUIResource windowBodyColor = MetalLookAndFeel.getWindowBackground();
            ColorUIResource titleColor = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource edgeColor = MetalLookAndFeel.getPrimaryControlDarkShadow();
            g.translate(x, y);
            g.setColor(titleColor);
            g.fillRect(0, 0, 16, 16);
            g.setColor(windowBodyColor);
            g.fillRect(2, 6, 13, 9);
            g.drawLine(2, 2, 2, 2);
            g.drawLine(5, 2, 5, 2);
            g.drawLine(8, 2, 8, 2);
            g.drawLine(11, 2, 11, 2);
            g.setColor(edgeColor);
            g.drawRect(1, 1, 13, 13);
            g.drawLine(1, 0, 14, 0);
            g.drawLine(15, 1, 15, 14);
            g.drawLine(1, 15, 14, 15);
            g.drawLine(0, 1, 0, 14);
            g.drawLine(2, 5, 13, 5);
            g.drawLine(3, 3, 3, 3);
            g.drawLine(6, 3, 6, 3);
            g.drawLine(9, 3, 9, 3);
            g.drawLine(12, 3, 12, 3);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }

    private static class InternalFrameMaximizeIcon
    implements Icon,
    UIResource,
    Serializable {
        protected int iconSize = 16;

        public InternalFrameMaximizeIcon(int size) {
            this.iconSize = size;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JButton parentButton = (JButton)c;
            ButtonModel buttonModel = parentButton.getModel();
            ColorUIResource backgroundColor = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource internalBackgroundColor = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource mainItemColor = MetalLookAndFeel.getPrimaryControlDarkShadow();
            ColorUIResource darkHighlightColor = MetalLookAndFeel.getBlack();
            ColorUIResource ulLightHighlightColor = MetalLookAndFeel.getWhite();
            ColorUIResource lrLightHighlightColor = MetalLookAndFeel.getWhite();
            if (parentButton.getClientProperty("paintActive") != Boolean.TRUE) {
                internalBackgroundColor = backgroundColor = MetalLookAndFeel.getControl();
                mainItemColor = MetalLookAndFeel.getControlDarkShadow();
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    ulLightHighlightColor = internalBackgroundColor = MetalLookAndFeel.getControlShadow();
                    mainItemColor = darkHighlightColor;
                }
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                ulLightHighlightColor = internalBackgroundColor = MetalLookAndFeel.getPrimaryControlShadow();
                mainItemColor = darkHighlightColor;
            }
            g.translate(x, y);
            g.setColor(backgroundColor);
            g.fillRect(0, 0, this.iconSize, this.iconSize);
            g.setColor(internalBackgroundColor);
            g.fillRect(3, 7, this.iconSize - 10, this.iconSize - 10);
            g.setColor(ulLightHighlightColor);
            g.drawRect(3, 7, this.iconSize - 10, this.iconSize - 10);
            g.setColor(lrLightHighlightColor);
            g.drawRect(2, 6, this.iconSize - 7, this.iconSize - 7);
            g.setColor(darkHighlightColor);
            g.drawRect(1, 5, this.iconSize - 7, this.iconSize - 7);
            g.drawRect(2, 6, this.iconSize - 9, this.iconSize - 9);
            g.setColor(mainItemColor);
            g.drawRect(2, 6, this.iconSize - 8, this.iconSize - 8);
            g.setColor(darkHighlightColor);
            g.drawLine(3, this.iconSize - 5, this.iconSize - 9, 7);
            g.drawLine(this.iconSize - 6, 4, this.iconSize - 5, 3);
            g.drawLine(this.iconSize - 7, 1, this.iconSize - 7, 2);
            g.drawLine(this.iconSize - 6, 1, this.iconSize - 2, 1);
            g.setColor(ulLightHighlightColor);
            g.drawLine(5, this.iconSize - 4, this.iconSize - 8, 9);
            g.setColor(lrLightHighlightColor);
            g.drawLine(this.iconSize - 6, 3, this.iconSize - 4, 5);
            g.drawLine(this.iconSize - 4, 5, this.iconSize - 4, 6);
            g.drawLine(this.iconSize - 2, 7, this.iconSize - 1, 7);
            g.drawLine(this.iconSize - 1, 2, this.iconSize - 1, 6);
            g.setColor(mainItemColor);
            g.drawLine(3, this.iconSize - 4, this.iconSize - 3, 2);
            g.drawLine(3, this.iconSize - 3, this.iconSize - 2, 2);
            g.drawLine(4, this.iconSize - 3, 5, this.iconSize - 3);
            g.drawLine(this.iconSize - 7, 8, this.iconSize - 7, 9);
            g.drawLine(this.iconSize - 6, 2, this.iconSize - 4, 2);
            g.drawRect(this.iconSize - 3, 3, 1, 3);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return this.iconSize;
        }

        @Override
        public int getIconHeight() {
            return this.iconSize;
        }
    }

    private static class InternalFrameMinimizeIcon
    implements Icon,
    UIResource,
    Serializable {
        int iconSize = 16;

        public InternalFrameMinimizeIcon(int size) {
            this.iconSize = size;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JButton parentButton = (JButton)c;
            ButtonModel buttonModel = parentButton.getModel();
            ColorUIResource backgroundColor = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource internalBackgroundColor = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource mainItemColor = MetalLookAndFeel.getPrimaryControlDarkShadow();
            ColorUIResource darkHighlightColor = MetalLookAndFeel.getBlack();
            ColorUIResource ulLightHighlightColor = MetalLookAndFeel.getWhite();
            ColorUIResource lrLightHighlightColor = MetalLookAndFeel.getWhite();
            if (parentButton.getClientProperty("paintActive") != Boolean.TRUE) {
                internalBackgroundColor = backgroundColor = MetalLookAndFeel.getControl();
                mainItemColor = MetalLookAndFeel.getControlDarkShadow();
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    ulLightHighlightColor = internalBackgroundColor = MetalLookAndFeel.getControlShadow();
                    mainItemColor = darkHighlightColor;
                }
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                ulLightHighlightColor = internalBackgroundColor = MetalLookAndFeel.getPrimaryControlShadow();
                mainItemColor = darkHighlightColor;
            }
            g.translate(x, y);
            g.setColor(backgroundColor);
            g.fillRect(0, 0, this.iconSize, this.iconSize);
            g.setColor(internalBackgroundColor);
            g.fillRect(4, 11, this.iconSize - 13, this.iconSize - 13);
            g.setColor(lrLightHighlightColor);
            g.drawRect(2, 10, this.iconSize - 10, this.iconSize - 11);
            g.setColor(ulLightHighlightColor);
            g.drawRect(3, 10, this.iconSize - 12, this.iconSize - 12);
            g.setColor(darkHighlightColor);
            g.drawRect(1, 8, this.iconSize - 10, this.iconSize - 10);
            g.drawRect(2, 9, this.iconSize - 12, this.iconSize - 12);
            g.setColor(mainItemColor);
            g.drawRect(2, 9, this.iconSize - 11, this.iconSize - 11);
            g.drawLine(this.iconSize - 10, 10, this.iconSize - 10, 10);
            g.drawLine(3, this.iconSize - 3, 3, this.iconSize - 3);
            g.setColor(mainItemColor);
            g.fillRect(this.iconSize - 7, 3, 3, 5);
            g.drawLine(this.iconSize - 6, 5, this.iconSize - 3, 2);
            g.drawLine(this.iconSize - 6, 6, this.iconSize - 2, 2);
            g.drawLine(this.iconSize - 6, 7, this.iconSize - 3, 7);
            g.setColor(darkHighlightColor);
            g.drawLine(this.iconSize - 8, 2, this.iconSize - 7, 2);
            g.drawLine(this.iconSize - 8, 3, this.iconSize - 8, 7);
            g.drawLine(this.iconSize - 6, 4, this.iconSize - 3, 1);
            g.drawLine(this.iconSize - 4, 6, this.iconSize - 3, 6);
            g.setColor(lrLightHighlightColor);
            g.drawLine(this.iconSize - 6, 3, this.iconSize - 6, 3);
            g.drawLine(this.iconSize - 4, 5, this.iconSize - 2, 3);
            g.drawLine(this.iconSize - 7, 8, this.iconSize - 3, 8);
            g.drawLine(this.iconSize - 2, 8, this.iconSize - 2, 7);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return this.iconSize;
        }

        @Override
        public int getIconHeight() {
            return this.iconSize;
        }
    }

    private static class MenuArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private MenuArrowIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JMenuItem b = (JMenuItem)c;
            ButtonModel model = b.getModel();
            g.translate(x, y);
            if (!model.isEnabled()) {
                g.setColor(MetalLookAndFeel.getMenuDisabledForeground());
            } else if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(MetalLookAndFeel.getMenuSelectedForeground());
            } else {
                g.setColor(b.getForeground());
            }
            if (MetalUtils.isLeftToRight(b)) {
                int[] xPoints = new int[]{0, 3, 3, 0};
                int[] yPoints = new int[]{0, 3, 4, 7};
                g.fillPolygon(xPoints, yPoints, 4);
                g.drawPolygon(xPoints, yPoints, 4);
            } else {
                int[] xPoints = new int[]{4, 4, 1, 1};
                int[] yPoints = new int[]{0, 7, 4, 3};
                g.fillPolygon(xPoints, yPoints, 4);
                g.drawPolygon(xPoints, yPoints, 4);
            }
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return MetalIconFactory.menuArrowIconSize.width;
        }

        @Override
        public int getIconHeight() {
            return MetalIconFactory.menuArrowIconSize.height;
        }
    }

    private static class MenuItemArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private MenuItemArrowIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return MetalIconFactory.menuArrowIconSize.width;
        }

        @Override
        public int getIconHeight() {
            return MetalIconFactory.menuArrowIconSize.height;
        }
    }

    private static class OceanHorizontalSliderThumbIcon
    extends CachedPainter
    implements Icon,
    Serializable,
    UIResource {
        private static Polygon THUMB_SHAPE = new Polygon(new int[]{0, 14, 14, 7, 0}, new int[]{0, 0, 8, 15, 8}, 5);

        OceanHorizontalSliderThumbIcon() {
            super(3);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            this.paint(c, g, x, y, this.getIconWidth(), this.getIconHeight(), c.hasFocus(), c.isEnabled(), MetalLookAndFeel.getCurrentTheme());
        }

        @Override
        protected Image createImage(Component c, int w, int h, GraphicsConfiguration config, Object[] args) {
            if (config == null) {
                return new BufferedImage(w, h, 2);
            }
            return config.createCompatibleImage(w, h, 2);
        }

        @Override
        protected void paintToImage(Component c, Image image, Graphics g2, int w, int h, Object[] args) {
            Graphics2D g = (Graphics2D)g2;
            boolean hasFocus = (Boolean)args[0];
            boolean enabled = (Boolean)args[1];
            Rectangle clip = g.getClipBounds();
            g.clip(THUMB_SHAPE);
            if (!enabled) {
                g.setColor(MetalLookAndFeel.getControl());
                g.fillRect(1, 1, 13, 14);
            } else if (hasFocus) {
                MetalUtils.drawGradient(c, g, "Slider.focusGradient", 1, 1, 13, 14, true);
            } else {
                MetalUtils.drawGradient(c, g, "Slider.gradient", 1, 1, 13, 14, true);
            }
            g.setClip(clip);
            if (hasFocus) {
                g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            } else {
                g.setColor(enabled ? MetalLookAndFeel.getPrimaryControlInfo() : MetalLookAndFeel.getControlDarkShadow());
            }
            g.drawLine(1, 0, 13, 0);
            g.drawLine(0, 1, 0, 8);
            g.drawLine(14, 1, 14, 8);
            g.drawLine(1, 9, 7, 15);
            g.drawLine(7, 15, 14, 8);
            if (hasFocus && enabled) {
                g.setColor(MetalLookAndFeel.getPrimaryControl());
                g.fillRect(1, 1, 13, 1);
                g.fillRect(1, 2, 1, 7);
                g.fillRect(13, 2, 1, 7);
                g.drawLine(2, 9, 7, 14);
                g.drawLine(8, 13, 12, 9);
            }
        }

        @Override
        public int getIconWidth() {
            return 15;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }

    private static class OceanVerticalSliderThumbIcon
    extends CachedPainter
    implements Icon,
    Serializable,
    UIResource {
        private static Polygon LTR_THUMB_SHAPE = new Polygon(new int[]{0, 8, 15, 8, 0}, new int[]{0, 0, 7, 14, 14}, 5);
        private static Polygon RTL_THUMB_SHAPE = new Polygon(new int[]{15, 15, 7, 0, 7}, new int[]{0, 14, 14, 7, 0}, 5);

        OceanVerticalSliderThumbIcon() {
            super(3);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            this.paint(c, g, x, y, this.getIconWidth(), this.getIconHeight(), MetalUtils.isLeftToRight(c), c.hasFocus(), c.isEnabled(), MetalLookAndFeel.getCurrentTheme());
        }

        @Override
        protected void paintToImage(Component c, Image image, Graphics g2, int w, int h, Object[] args) {
            Graphics2D g = (Graphics2D)g2;
            boolean leftToRight = (Boolean)args[0];
            boolean hasFocus = (Boolean)args[1];
            boolean enabled = (Boolean)args[2];
            Rectangle clip = g.getClipBounds();
            if (leftToRight) {
                g.clip(LTR_THUMB_SHAPE);
            } else {
                g.clip(RTL_THUMB_SHAPE);
            }
            if (!enabled) {
                g.setColor(MetalLookAndFeel.getControl());
                g.fillRect(1, 1, 14, 14);
            } else if (hasFocus) {
                MetalUtils.drawGradient(c, g, "Slider.focusGradient", 1, 1, 14, 14, false);
            } else {
                MetalUtils.drawGradient(c, g, "Slider.gradient", 1, 1, 14, 14, false);
            }
            g.setClip(clip);
            if (hasFocus) {
                g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            } else {
                g.setColor(enabled ? MetalLookAndFeel.getPrimaryControlInfo() : MetalLookAndFeel.getControlDarkShadow());
            }
            if (leftToRight) {
                g.drawLine(1, 0, 8, 0);
                g.drawLine(0, 1, 0, 13);
                g.drawLine(1, 14, 8, 14);
                g.drawLine(9, 1, 15, 7);
                g.drawLine(9, 13, 15, 7);
            } else {
                g.drawLine(7, 0, 14, 0);
                g.drawLine(15, 1, 15, 13);
                g.drawLine(7, 14, 14, 14);
                g.drawLine(0, 7, 6, 1);
                g.drawLine(0, 7, 6, 13);
            }
            if (hasFocus && enabled) {
                g.setColor(MetalLookAndFeel.getPrimaryControl());
                if (leftToRight) {
                    g.drawLine(1, 1, 8, 1);
                    g.drawLine(1, 1, 1, 13);
                    g.drawLine(1, 13, 8, 13);
                    g.drawLine(9, 2, 14, 7);
                    g.drawLine(9, 12, 14, 7);
                } else {
                    g.drawLine(7, 1, 14, 1);
                    g.drawLine(14, 1, 14, 13);
                    g.drawLine(7, 13, 14, 13);
                    g.drawLine(1, 7, 7, 1);
                    g.drawLine(1, 7, 7, 13);
                }
            }
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 15;
        }

        @Override
        protected Image createImage(Component c, int w, int h, GraphicsConfiguration config, Object[] args) {
            if (config == null) {
                return new BufferedImage(w, h, 2);
            }
            return config.createCompatibleImage(w, h, 2);
        }
    }

    public static class PaletteCloseIcon
    implements Icon,
    UIResource,
    Serializable {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        public int getIconWidth() {
            return 0;
        }

        public int getIconHeight() {
            return 0;
        }
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private RadioButtonIcon() {
        }

        public void paintOceanIcon(Component c, Graphics g, int x, int y) {
            ButtonModel model = ((JRadioButton)c).getModel();
            boolean enabled = model.isEnabled();
            boolean pressed = enabled && model.isPressed() && model.isArmed();
            boolean rollover = enabled && model.isRollover();
            g.translate(x, y);
            if (enabled && !pressed) {
                MetalUtils.drawGradient(c, g, "RadioButton.gradient", 1, 1, 10, 10, true);
                g.setColor(c.getBackground());
                g.fillRect(1, 1, 1, 1);
                g.fillRect(10, 1, 1, 1);
                g.fillRect(1, 10, 1, 1);
                g.fillRect(10, 10, 1, 1);
            } else if (pressed || !enabled) {
                if (pressed) {
                    g.setColor(MetalLookAndFeel.getPrimaryControl());
                } else {
                    g.setColor(MetalLookAndFeel.getControl());
                }
                g.fillOval(1, 1, 9, 9);
            }
            if (!enabled) {
                g.setColor(MetalLookAndFeel.getInactiveControlTextColor());
            } else {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
            }
            g.drawOval(0, 0, 11, 11);
            if (pressed) {
                g.drawArc(1, 1, 10, 10, 60, 160);
            } else if (rollover) {
                g.setColor(MetalLookAndFeel.getPrimaryControl());
                g.drawOval(2, 2, 7, 7);
            }
            if (model.isSelected()) {
                if (enabled) {
                    g.setColor(MetalLookAndFeel.getControlInfo());
                } else {
                    g.setColor(MetalLookAndFeel.getControlDarkShadow());
                }
                g.fillOval(2, 2, 7, 7);
            }
            g.translate(-x, -y);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Object aaHint = SwingUtilities2.getAndSetAntialisingHintForScaledGraphics(g);
            if (MetalLookAndFeel.usingOcean()) {
                this.paintOceanIcon(c, g, x, y);
                SwingUtilities2.setAntialiasingHintForScaledGraphics(g, aaHint);
                return;
            }
            JRadioButton rb = (JRadioButton)c;
            ButtonModel model = rb.getModel();
            boolean drawDot = model.isSelected();
            Color background = c.getBackground();
            Color dotColor = c.getForeground();
            ColorUIResource shadow = MetalLookAndFeel.getControlShadow();
            ColorUIResource darkCircle = MetalLookAndFeel.getControlDarkShadow();
            Color whiteInnerLeftArc = MetalLookAndFeel.getControlHighlight();
            Color whiteOuterRightArc = MetalLookAndFeel.getControlHighlight();
            Color interiorColor = background;
            if (!model.isEnabled()) {
                whiteInnerLeftArc = whiteOuterRightArc = background;
                dotColor = shadow;
                darkCircle = dotColor;
            } else if (model.isPressed() && model.isArmed()) {
                interiorColor = shadow;
                whiteInnerLeftArc = interiorColor;
            }
            g.translate(x, y);
            if (c.isOpaque()) {
                g.setColor(interiorColor);
                g.fillRect(2, 2, 9, 9);
            }
            g.setColor(darkCircle);
            g.drawOval(0, 0, 11, 11);
            g.setColor(whiteInnerLeftArc);
            g.drawArc(1, 1, 10, 10, 60, 160);
            g.setColor(whiteOuterRightArc);
            g.drawArc(-1, -1, 13, 13, 235, 180);
            if (drawDot) {
                g.setColor(dotColor);
                g.fillOval(2, 2, 7, 7);
            }
            g.translate(-x, -y);
            SwingUtilities2.setAntialiasingHintForScaledGraphics(g, aaHint);
        }

        @Override
        public int getIconWidth() {
            return 13;
        }

        @Override
        public int getIconHeight() {
            return 13;
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private RadioButtonMenuItemIcon() {
        }

        public void paintOceanIcon(Component c, Graphics g, int x, int y) {
            ButtonModel model = ((JMenuItem)c).getModel();
            boolean isSelected = model.isSelected();
            boolean isEnabled = model.isEnabled();
            boolean isPressed = model.isPressed();
            boolean isArmed = model.isArmed();
            g.translate(x, y);
            if (isEnabled) {
                MetalUtils.drawGradient(c, g, "RadioButtonMenuItem.gradient", 1, 1, 7, 7, true);
                if (isPressed || isArmed) {
                    g.setColor(MetalLookAndFeel.getPrimaryControl());
                } else {
                    g.setColor(MetalLookAndFeel.getControlHighlight());
                }
                g.drawArc(-1, -1, 10, 10, 245, 140);
                if (isPressed || isArmed) {
                    g.setColor(MetalLookAndFeel.getControlInfo());
                } else {
                    g.setColor(MetalLookAndFeel.getControlDarkShadow());
                }
            } else {
                g.setColor(MetalLookAndFeel.getMenuDisabledForeground());
            }
            g.drawOval(0, 0, 8, 8);
            if (isSelected) {
                if (isEnabled) {
                    if (isArmed || c instanceof JMenu && model.isSelected()) {
                        g.setColor(MetalLookAndFeel.getMenuSelectedForeground());
                    } else {
                        g.setColor(MetalLookAndFeel.getControlInfo());
                    }
                } else {
                    g.setColor(MetalLookAndFeel.getMenuDisabledForeground());
                }
                g.fillOval(2, 2, 4, 4);
                g.drawOval(2, 2, 4, 4);
            }
            g.translate(-x, -y);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Object aaHint = SwingUtilities2.getAndSetAntialisingHintForScaledGraphics(g);
            if (MetalLookAndFeel.usingOcean()) {
                this.paintOceanIcon(c, g, x, y);
                SwingUtilities2.setAntialiasingHintForScaledGraphics(g, aaHint);
                return;
            }
            JMenuItem b = (JMenuItem)c;
            ButtonModel model = b.getModel();
            boolean isSelected = model.isSelected();
            boolean isEnabled = model.isEnabled();
            boolean isPressed = model.isPressed();
            boolean isArmed = model.isArmed();
            g.translate(x, y);
            if (isEnabled) {
                if (isPressed || isArmed) {
                    g.setColor(MetalLookAndFeel.getPrimaryControl());
                    g.drawOval(1, 1, 8, 8);
                    g.setColor(MetalLookAndFeel.getControlInfo());
                    g.drawOval(0, 0, 8, 8);
                } else {
                    g.setColor(MetalLookAndFeel.getControlHighlight());
                    g.drawOval(1, 1, 8, 8);
                    g.setColor(MetalLookAndFeel.getControlDarkShadow());
                    g.drawOval(0, 0, 8, 8);
                }
            } else {
                g.setColor(MetalLookAndFeel.getMenuDisabledForeground());
                g.drawOval(0, 0, 8, 8);
            }
            if (isSelected) {
                if (isEnabled) {
                    if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                        g.setColor(MetalLookAndFeel.getMenuSelectedForeground());
                    } else {
                        g.setColor(b.getForeground());
                    }
                } else {
                    g.setColor(MetalLookAndFeel.getMenuDisabledForeground());
                }
                g.fillOval(2, 2, 4, 4);
                g.drawOval(2, 2, 4, 4);
            }
            g.translate(-x, -y);
            SwingUtilities2.setAntialiasingHintForScaledGraphics(g, aaHint);
        }

        @Override
        public int getIconWidth() {
            return MetalIconFactory.menuCheckIconSize.width;
        }

        @Override
        public int getIconHeight() {
            return MetalIconFactory.menuCheckIconSize.height;
        }
    }

    private static class TreeComputerIcon
    implements Icon,
    UIResource,
    Serializable {
        private TreeComputerIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.setColor(MetalLookAndFeel.getPrimaryControl());
            g.fillRect(5, 4, 6, 4);
            g.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            g.drawLine(2, 2, 2, 8);
            g.drawLine(13, 2, 13, 8);
            g.drawLine(3, 1, 12, 1);
            g.drawLine(12, 9, 12, 9);
            g.drawLine(3, 9, 3, 9);
            g.drawLine(4, 4, 4, 7);
            g.drawLine(5, 3, 10, 3);
            g.drawLine(11, 4, 11, 7);
            g.drawLine(5, 8, 10, 8);
            g.drawLine(1, 10, 14, 10);
            g.drawLine(14, 10, 14, 14);
            g.drawLine(1, 14, 14, 14);
            g.drawLine(1, 10, 1, 14);
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawLine(6, 12, 8, 12);
            g.drawLine(10, 12, 12, 12);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }

    public static class TreeControlIcon
    implements Icon,
    Serializable {
        protected boolean isLight;

        public TreeControlIcon(boolean bl) {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        public void paintMe(Component component, Graphics graphics, int n, int n2) {
        }

        public int getIconWidth() {
            return 0;
        }

        public int getIconHeight() {
            return 0;
        }
    }

    private static class TreeFloppyDriveIcon
    implements Icon,
    UIResource,
    Serializable {
        private TreeFloppyDriveIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.setColor(MetalLookAndFeel.getPrimaryControl());
            g.fillRect(2, 2, 12, 12);
            g.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            g.drawLine(1, 1, 13, 1);
            g.drawLine(14, 2, 14, 14);
            g.drawLine(1, 14, 14, 14);
            g.drawLine(1, 1, 1, 14);
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.fillRect(5, 2, 6, 5);
            g.drawLine(4, 8, 11, 8);
            g.drawLine(3, 9, 3, 13);
            g.drawLine(12, 9, 12, 13);
            g.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            g.fillRect(8, 3, 2, 3);
            g.fillRect(4, 9, 8, 5);
            g.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            g.drawLine(5, 10, 9, 10);
            g.drawLine(5, 12, 8, 12);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }

    public static class TreeFolderIcon
    extends FolderIcon16 {
        public int getShift() {
            return 0;
        }

        public int getAdditionalHeight() {
            return 0;
        }
    }

    private static class TreeHardDriveIcon
    implements Icon,
    UIResource,
    Serializable {
        private TreeHardDriveIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            g.drawLine(1, 4, 1, 5);
            g.drawLine(2, 3, 3, 3);
            g.drawLine(4, 2, 11, 2);
            g.drawLine(12, 3, 13, 3);
            g.drawLine(14, 4, 14, 5);
            g.drawLine(12, 6, 13, 6);
            g.drawLine(4, 7, 11, 7);
            g.drawLine(2, 6, 3, 6);
            g.drawLine(1, 7, 1, 8);
            g.drawLine(2, 9, 3, 9);
            g.drawLine(4, 10, 11, 10);
            g.drawLine(12, 9, 13, 9);
            g.drawLine(14, 7, 14, 8);
            g.drawLine(1, 10, 1, 11);
            g.drawLine(2, 12, 3, 12);
            g.drawLine(4, 13, 11, 13);
            g.drawLine(12, 12, 13, 12);
            g.drawLine(14, 10, 14, 11);
            g.setColor(MetalLookAndFeel.getControlShadow());
            g.drawLine(7, 6, 7, 6);
            g.drawLine(9, 6, 9, 6);
            g.drawLine(10, 5, 10, 5);
            g.drawLine(11, 6, 11, 6);
            g.drawLine(12, 5, 13, 5);
            g.drawLine(13, 4, 13, 4);
            g.drawLine(7, 9, 7, 9);
            g.drawLine(9, 9, 9, 9);
            g.drawLine(10, 8, 10, 8);
            g.drawLine(11, 9, 11, 9);
            g.drawLine(12, 8, 13, 8);
            g.drawLine(13, 7, 13, 7);
            g.drawLine(7, 12, 7, 12);
            g.drawLine(9, 12, 9, 12);
            g.drawLine(10, 11, 10, 11);
            g.drawLine(11, 12, 11, 12);
            g.drawLine(12, 11, 13, 11);
            g.drawLine(13, 10, 13, 10);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(4, 3, 5, 3);
            g.drawLine(7, 3, 9, 3);
            g.drawLine(11, 3, 11, 3);
            g.drawLine(2, 4, 6, 4);
            g.drawLine(8, 4, 8, 4);
            g.drawLine(2, 5, 3, 5);
            g.drawLine(4, 6, 4, 6);
            g.drawLine(2, 7, 3, 7);
            g.drawLine(2, 8, 3, 8);
            g.drawLine(4, 9, 4, 9);
            g.drawLine(2, 10, 3, 10);
            g.drawLine(2, 11, 3, 11);
            g.drawLine(4, 12, 4, 12);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }

    public static class TreeLeafIcon
    extends FileIcon16 {
        public int getShift() {
            return 0;
        }

        public int getAdditionalHeight() {
            return 0;
        }
    }

    private static class VerticalSliderThumbIcon
    implements Icon,
    Serializable,
    UIResource {
        protected static MetalBumps controlBumps;
        protected static MetalBumps primaryBumps;

        public VerticalSliderThumbIcon() {
            controlBumps = new MetalBumps(6, 10, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlInfo(), MetalLookAndFeel.getControl());
            primaryBumps = new MetalBumps(6, 10, MetalLookAndFeel.getPrimaryControl(), MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getPrimaryControlShadow());
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int offset;
            boolean leftToRight = MetalUtils.isLeftToRight(c);
            g.translate(x, y);
            Rectangle clip = g.getClipBounds();
            g.clipRect(0, 0, this.getIconWidth(), this.getIconHeight());
            if (c.hasFocus()) {
                g.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            } else {
                g.setColor(c.isEnabled() ? MetalLookAndFeel.getPrimaryControlInfo() : MetalLookAndFeel.getControlDarkShadow());
            }
            if (leftToRight) {
                g.drawLine(1, 0, 8, 0);
                g.drawLine(0, 1, 0, 13);
                g.drawLine(1, 14, 8, 14);
                g.drawLine(9, 1, 15, 7);
                g.drawLine(9, 13, 15, 7);
            } else {
                g.drawLine(7, 0, 14, 0);
                g.drawLine(15, 1, 15, 13);
                g.drawLine(7, 14, 14, 14);
                g.drawLine(0, 7, 6, 1);
                g.drawLine(0, 7, 6, 13);
            }
            if (c.hasFocus()) {
                g.setColor(c.getForeground());
            } else {
                g.setColor(MetalLookAndFeel.getControl());
            }
            if (leftToRight) {
                g.fillRect(1, 1, 8, 13);
                g.drawLine(9, 2, 9, 12);
                g.drawLine(10, 3, 10, 11);
                g.drawLine(11, 4, 11, 10);
                g.drawLine(12, 5, 12, 9);
                g.drawLine(13, 6, 13, 8);
                g.drawLine(14, 7, 14, 7);
            } else {
                g.fillRect(7, 1, 8, 13);
                g.drawLine(6, 3, 6, 12);
                g.drawLine(5, 4, 5, 11);
                g.drawLine(4, 5, 4, 10);
                g.drawLine(3, 6, 3, 9);
                g.drawLine(2, 7, 2, 8);
            }
            int n = offset = leftToRight ? 2 : 8;
            if (c.isEnabled()) {
                if (c.hasFocus()) {
                    primaryBumps.paintIcon(c, g, offset, 2);
                } else {
                    controlBumps.paintIcon(c, g, offset, 2);
                }
            }
            if (c.isEnabled()) {
                g.setColor(c.hasFocus() ? MetalLookAndFeel.getPrimaryControl() : MetalLookAndFeel.getControlHighlight());
                if (leftToRight) {
                    g.drawLine(1, 1, 8, 1);
                    g.drawLine(1, 1, 1, 13);
                } else {
                    g.drawLine(8, 1, 14, 1);
                    g.drawLine(1, 7, 7, 1);
                }
            }
            g.setClip(clip);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 15;
        }
    }
}

