/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.tree.TreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDocument
implements Document,
Serializable {
    protected EventListenerList listenerList;
    protected static final String BAD_LOCATION = "document location failure";
    public static final String ParagraphElementName = "paragraph";
    public static final String ContentElementName = "content";
    public static final String SectionElementName = "section";
    public static final String BidiElementName = "bidi level";
    public static final String ElementNameAttribute = "$ename";

    protected AbstractDocument(Content content) {
    }

    protected AbstractDocument(Content content, AttributeContext attributeContext) {
    }

    public Dictionary<Object, Object> getDocumentProperties() {
        return null;
    }

    public void setDocumentProperties(Dictionary<Object, Object> dictionary) {
    }

    protected void fireInsertUpdate(DocumentEvent documentEvent) {
    }

    protected void fireChangedUpdate(DocumentEvent documentEvent) {
    }

    protected void fireRemoveUpdate(DocumentEvent documentEvent) {
    }

    protected void fireUndoableEditUpdate(UndoableEditEvent undoableEditEvent) {
    }

    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        return null;
    }

    public int getAsynchronousLoadPriority() {
        return 0;
    }

    public void setAsynchronousLoadPriority(int n) {
    }

    public void setDocumentFilter(DocumentFilter documentFilter) {
    }

    public DocumentFilter getDocumentFilter() {
        return null;
    }

    @Override
    public void render(Runnable runnable) {
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public void addDocumentListener(DocumentListener documentListener) {
    }

    @Override
    public void removeDocumentListener(DocumentListener documentListener) {
    }

    public DocumentListener[] getDocumentListeners() {
        return null;
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
    }

    public UndoableEditListener[] getUndoableEditListeners() {
        return null;
    }

    @Override
    public final Object getProperty(Object object) {
        return null;
    }

    @Override
    public final void putProperty(Object object, Object object2) {
    }

    @Override
    public void remove(int n, int n2) throws BadLocationException {
    }

    public void replace(int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
    }

    @Override
    public String getText(int n, int n2) throws BadLocationException {
        return null;
    }

    @Override
    public void getText(int n, int n2, Segment segment) throws BadLocationException {
    }

    @Override
    public synchronized Position createPosition(int n) throws BadLocationException {
        return null;
    }

    @Override
    public final Position getStartPosition() {
        return null;
    }

    @Override
    public final Position getEndPosition() {
        return null;
    }

    @Override
    public Element[] getRootElements() {
        return null;
    }

    @Override
    public abstract Element getDefaultRootElement();

    public Element getBidiRootElement() {
        return null;
    }

    public abstract Element getParagraphElement(int var1);

    protected final AttributeContext getAttributeContext() {
        return null;
    }

    protected void insertUpdate(DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
    }

    protected void removeUpdate(DefaultDocumentEvent defaultDocumentEvent) {
    }

    protected void postRemoveUpdate(DefaultDocumentEvent defaultDocumentEvent) {
    }

    public void dump(PrintStream printStream) {
    }

    protected final Content getContent() {
        return null;
    }

    protected Element createLeafElement(Element element, AttributeSet attributeSet, int n, int n2) {
        return null;
    }

    protected Element createBranchElement(Element element, AttributeSet attributeSet) {
        return null;
    }

    protected final synchronized Thread getCurrentWriter() {
        return null;
    }

    protected final synchronized void writeLock() {
    }

    protected final synchronized void writeUnlock() {
    }

    public final synchronized void readLock() {
    }

    public final synchronized void readUnlock() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class AbstractElement
    implements Element,
    MutableAttributeSet,
    Serializable,
    TreeNode {
        public AbstractElement(AbstractDocument abstractDocument, Element element, AttributeSet attributeSet) {
        }

        public void dump(PrintStream printStream, int n) {
        }

        @Override
        public int getAttributeCount() {
            return 0;
        }

        @Override
        public boolean isDefined(Object object) {
            return false;
        }

        @Override
        public boolean isEqual(AttributeSet attributeSet) {
            return false;
        }

        @Override
        public AttributeSet copyAttributes() {
            return null;
        }

        @Override
        public Object getAttribute(Object object) {
            return null;
        }

        @Override
        public Enumeration<?> getAttributeNames() {
            return null;
        }

        @Override
        public boolean containsAttribute(Object object, Object object2) {
            return false;
        }

        @Override
        public boolean containsAttributes(AttributeSet attributeSet) {
            return false;
        }

        @Override
        public AttributeSet getResolveParent() {
            return null;
        }

        @Override
        public void addAttribute(Object object, Object object2) {
        }

        @Override
        public void addAttributes(AttributeSet attributeSet) {
        }

        @Override
        public void removeAttribute(Object object) {
        }

        @Override
        public void removeAttributes(Enumeration<?> enumeration) {
        }

        @Override
        public void removeAttributes(AttributeSet attributeSet) {
        }

        @Override
        public void setResolveParent(AttributeSet attributeSet) {
        }

        @Override
        public Document getDocument() {
            return null;
        }

        @Override
        public Element getParentElement() {
            return null;
        }

        @Override
        public AttributeSet getAttributes() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public abstract int getStartOffset();

        @Override
        public abstract int getEndOffset();

        @Override
        public abstract Element getElement(int var1);

        @Override
        public abstract int getElementCount();

        @Override
        public abstract int getElementIndex(int var1);

        @Override
        public abstract boolean isLeaf();

        @Override
        public TreeNode getChildAt(int n) {
            return null;
        }

        @Override
        public int getChildCount() {
            return 0;
        }

        @Override
        public TreeNode getParent() {
            return null;
        }

        @Override
        public int getIndex(TreeNode treeNode) {
            return 0;
        }

        @Override
        public abstract boolean getAllowsChildren();

        @Override
        public abstract Enumeration children();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface AttributeContext {
        public AttributeSet addAttribute(AttributeSet var1, Object var2, Object var3);

        public AttributeSet addAttributes(AttributeSet var1, AttributeSet var2);

        public AttributeSet removeAttribute(AttributeSet var1, Object var2);

        public AttributeSet removeAttributes(AttributeSet var1, Enumeration<?> var2);

        public AttributeSet removeAttributes(AttributeSet var1, AttributeSet var2);

        public AttributeSet getEmptySet();

        public void reclaim(AttributeSet var1);
    }

    class BidiElement
    extends LeafElement {
        BidiElement(Element parent, int start, int end, int level) {
            super(AbstractDocument.this, parent, new SimpleAttributeSet(), start, end);
            this.addAttribute(StyleConstants.BidiLevel, level);
        }

        @Override
        public String getName() {
            return AbstractDocument.BidiElementName;
        }

        int getLevel() {
            Integer o = (Integer)this.getAttribute(StyleConstants.BidiLevel);
            if (o != null) {
                return o;
            }
            return 0;
        }

        boolean isLeftToRight() {
            return this.getLevel() % 2 == 0;
        }
    }

    class BidiRootElement
    extends BranchElement {
        BidiRootElement() {
            super(AbstractDocument.this, null, null);
        }

        @Override
        public String getName() {
            return "bidi root";
        }
    }

    public class BranchElement
    extends AbstractElement {
        public BranchElement(AbstractDocument abstractDocument, Element element, AttributeSet attributeSet) {
        }

        public Element positionToElement(int n) {
            return null;
        }

        public void replace(int n, int n2, Element[] elementArray) {
        }

        public String toString() {
            return null;
        }

        public String getName() {
            return null;
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return 0;
        }

        public Element getElement(int n) {
            return null;
        }

        public int getElementCount() {
            return 0;
        }

        public int getElementIndex(int n) {
            return 0;
        }

        public boolean isLeaf() {
            return false;
        }

        public boolean getAllowsChildren() {
            return false;
        }

        public Enumeration children() {
            return null;
        }
    }

    public static interface Content {
        public Position createPosition(int var1) throws BadLocationException;

        public int length();

        public UndoableEdit insertString(int var1, String var2) throws BadLocationException;

        public UndoableEdit remove(int var1, int var2) throws BadLocationException;

        public String getString(int var1, int var2) throws BadLocationException;

        public void getChars(int var1, int var2, Segment var3) throws BadLocationException;
    }

    public class DefaultDocumentEvent
    extends CompoundEdit
    implements DocumentEvent {
        public DefaultDocumentEvent(AbstractDocument abstractDocument, int n, int n2, DocumentEvent.EventType eventType) {
        }

        public String toString() {
            return null;
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            return false;
        }

        public void redo() throws CannotRedoException {
        }

        public void undo() throws CannotUndoException {
        }

        public boolean isSignificant() {
            return false;
        }

        public String getPresentationName() {
            return null;
        }

        public String getUndoPresentationName() {
            return null;
        }

        public String getRedoPresentationName() {
            return null;
        }

        public DocumentEvent.EventType getType() {
            return null;
        }

        public int getOffset() {
            return 0;
        }

        public int getLength() {
            return 0;
        }

        public Document getDocument() {
            return null;
        }

        public DocumentEvent.ElementChange getChange(Element element) {
            return null;
        }
    }

    private class DefaultFilterBypass
    extends DocumentFilter.FilterBypass {
        private DefaultFilterBypass() {
        }

        @Override
        public Document getDocument() {
            return AbstractDocument.this;
        }

        @Override
        public void remove(int offset, int length) throws BadLocationException {
            AbstractDocument.this.handleRemove(offset, length);
        }

        @Override
        public void insertString(int offset, String string, AttributeSet attr) throws BadLocationException {
            AbstractDocument.this.handleInsertString(offset, string, attr);
        }

        @Override
        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            AbstractDocument.this.handleRemove(offset, length);
            AbstractDocument.this.handleInsertString(offset, text, attrs);
        }
    }

    public static class ElementEdit
    extends AbstractUndoableEdit
    implements DocumentEvent.ElementChange {
        public ElementEdit(Element element, int n, Element[] elementArray, Element[] elementArray2) {
        }

        public Element getElement() {
            return null;
        }

        public int getIndex() {
            return 0;
        }

        public Element[] getChildrenRemoved() {
            return null;
        }

        public Element[] getChildrenAdded() {
            return null;
        }

        public void redo() throws CannotRedoException {
        }

        public void undo() throws CannotUndoException {
        }
    }

    public class LeafElement
    extends AbstractElement {
        public LeafElement(AbstractDocument abstractDocument, Element element, AttributeSet attributeSet, int n, int n2) {
        }

        public String toString() {
            return null;
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return 0;
        }

        public String getName() {
            return null;
        }

        public int getElementIndex(int n) {
            return 0;
        }

        public Element getElement(int n) {
            return null;
        }

        public int getElementCount() {
            return 0;
        }

        public boolean isLeaf() {
            return false;
        }

        public boolean getAllowsChildren() {
            return false;
        }

        public Enumeration children() {
            return null;
        }
    }

    class UndoRedoDocumentEvent
    implements DocumentEvent {
        private DefaultDocumentEvent src = null;
        private DocumentEvent.EventType type = null;

        public UndoRedoDocumentEvent(AbstractDocument this$0, DefaultDocumentEvent src, boolean isUndo) {
            this.src = src;
            this.type = isUndo ? (src.getType().equals(DocumentEvent.EventType.INSERT) ? DocumentEvent.EventType.REMOVE : (src.getType().equals(DocumentEvent.EventType.REMOVE) ? DocumentEvent.EventType.INSERT : src.getType())) : src.getType();
        }

        public DefaultDocumentEvent getSource() {
            return this.src;
        }

        @Override
        public int getOffset() {
            return this.src.getOffset();
        }

        @Override
        public int getLength() {
            return this.src.getLength();
        }

        @Override
        public Document getDocument() {
            return this.src.getDocument();
        }

        @Override
        public DocumentEvent.EventType getType() {
            return this.type;
        }

        @Override
        public DocumentEvent.ElementChange getChange(Element elem) {
            return this.src.getChange(elem);
        }
    }
}

