/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.Segment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCaret
extends Rectangle
implements Caret,
FocusListener,
MouseListener,
MouseMotionListener {
    public static final int UPDATE_WHEN_ON_EDT = 0;
    public static final int NEVER_UPDATE = 1;
    public static final int ALWAYS_UPDATE = 2;
    protected EventListenerList listenerList;
    protected transient ChangeEvent changeEvent;

    public void setUpdatePolicy(int n) {
    }

    public int getUpdatePolicy() {
        return 0;
    }

    protected final JTextComponent getComponent() {
        return null;
    }

    protected final synchronized void repaint() {
    }

    protected synchronized void damage(Rectangle rectangle) {
    }

    protected void adjustVisibility(Rectangle rectangle) {
    }

    protected Highlighter.HighlightPainter getSelectionPainter() {
        return null;
    }

    protected void positionCaret(MouseEvent mouseEvent) {
    }

    protected void moveCaret(MouseEvent mouseEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void paint(Graphics graphics) {
    }

    @Override
    public void install(JTextComponent jTextComponent) {
    }

    @Override
    public void deinstall(JTextComponent jTextComponent) {
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
    }

    public ChangeListener[] getChangeListeners() {
        return null;
    }

    protected void fireStateChanged() {
    }

    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        return null;
    }

    @Override
    public void setSelectionVisible(boolean bl) {
    }

    @Override
    public boolean isSelectionVisible() {
        return false;
    }

    public boolean isActive() {
        return false;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public void setVisible(boolean bl) {
    }

    @Override
    public void setBlinkRate(int n) {
    }

    @Override
    public int getBlinkRate() {
        return 0;
    }

    @Override
    public int getDot() {
        return 0;
    }

    @Override
    public int getMark() {
        return 0;
    }

    @Override
    public void setDot(int n) {
    }

    @Override
    public void moveDot(int n) {
    }

    @Override
    public void setMagicCaretPosition(Point point) {
    }

    @Override
    public Point getMagicCaretPosition() {
        return null;
    }

    @Override
    public boolean equals(Object object) {
        return false;
    }

    @Override
    public String toString() {
        return null;
    }

    private class DefaultFilterBypass
    extends NavigationFilter.FilterBypass {
        private DefaultFilterBypass() {
        }

        @Override
        public Caret getCaret() {
            return DefaultCaret.this;
        }

        @Override
        public void setDot(int dot, Position.Bias bias) {
            DefaultCaret.this.handleSetDot(dot, bias);
        }

        @Override
        public void moveDot(int dot, Position.Bias bias) {
            DefaultCaret.this.handleMoveDot(dot, bias);
        }
    }

    class Handler
    implements PropertyChangeListener,
    DocumentListener,
    ActionListener,
    ClipboardOwner {
        Handler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if ((DefaultCaret.this.width == 0 || DefaultCaret.this.height == 0) && DefaultCaret.this.component != null) {
                TextUI mapper = DefaultCaret.this.component.getUI();
                try {
                    Rectangle r = mapper.modelToView(DefaultCaret.this.component, DefaultCaret.this.dot, DefaultCaret.this.dotBias);
                    if (r != null && r.width != 0 && r.height != 0) {
                        DefaultCaret.this.damage(r);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            DefaultCaret.this.visible = !DefaultCaret.this.visible;
            DefaultCaret.this.repaint();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            int newMark;
            if (DefaultCaret.this.getUpdatePolicy() == 1 || DefaultCaret.this.getUpdatePolicy() == 0 && !SwingUtilities.isEventDispatchThread()) {
                if ((e.getOffset() <= DefaultCaret.this.dot || e.getOffset() <= DefaultCaret.this.mark) && DefaultCaret.this.selectionTag != null) {
                    try {
                        DefaultCaret.this.component.getHighlighter().changeHighlight(DefaultCaret.this.selectionTag, Math.min(DefaultCaret.this.dot, DefaultCaret.this.mark), Math.max(DefaultCaret.this.dot, DefaultCaret.this.mark));
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                }
                return;
            }
            int offset = e.getOffset();
            int length = e.getLength();
            int newDot = DefaultCaret.this.dot;
            short changed = 0;
            if (e instanceof AbstractDocument.UndoRedoDocumentEvent) {
                DefaultCaret.this.setDot(offset + length);
                return;
            }
            if (newDot >= offset) {
                newDot += length;
                changed = (short)(changed | 1);
            }
            if ((newMark = DefaultCaret.this.mark) >= offset) {
                newMark += length;
                changed = (short)(changed | 2);
            }
            if (changed != 0) {
                Position.Bias dotBias = DefaultCaret.this.dotBias;
                if (DefaultCaret.this.dot == offset) {
                    boolean isNewline;
                    Document doc = DefaultCaret.this.component.getDocument();
                    try {
                        Segment s = new Segment();
                        doc.getText(newDot - 1, 1, s);
                        isNewline = s.count > 0 && s.array[s.offset] == '\n';
                    }
                    catch (BadLocationException ble) {
                        isNewline = false;
                    }
                    dotBias = isNewline ? Position.Bias.Forward : Position.Bias.Backward;
                }
                if (newMark == newDot) {
                    DefaultCaret.this.setDot(newDot, dotBias);
                    DefaultCaret.this.ensureValidPosition();
                } else {
                    DefaultCaret.this.setDot(newMark, DefaultCaret.this.markBias);
                    if (DefaultCaret.this.getDot() == newMark) {
                        DefaultCaret.this.moveDot(newDot, dotBias);
                    }
                    DefaultCaret.this.ensureValidPosition();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeUpdate(DocumentEvent e) {
            if (DefaultCaret.this.getUpdatePolicy() == 1 || DefaultCaret.this.getUpdatePolicy() == 0 && !SwingUtilities.isEventDispatchThread()) {
                int length = DefaultCaret.this.component.getDocument().getLength();
                DefaultCaret.this.dot = Math.min(DefaultCaret.this.dot, length);
                DefaultCaret.this.mark = Math.min(DefaultCaret.this.mark, length);
                if ((e.getOffset() < DefaultCaret.this.dot || e.getOffset() < DefaultCaret.this.mark) && DefaultCaret.this.selectionTag != null) {
                    try {
                        DefaultCaret.this.component.getHighlighter().changeHighlight(DefaultCaret.this.selectionTag, Math.min(DefaultCaret.this.dot, DefaultCaret.this.mark), Math.max(DefaultCaret.this.dot, DefaultCaret.this.mark));
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                }
                return;
            }
            int offs0 = e.getOffset();
            int offs1 = offs0 + e.getLength();
            int newDot = DefaultCaret.this.dot;
            boolean adjustDotBias = false;
            int newMark = DefaultCaret.this.mark;
            boolean adjustMarkBias = false;
            if (e instanceof AbstractDocument.UndoRedoDocumentEvent) {
                DefaultCaret.this.setDot(offs0);
                return;
            }
            if (newDot >= offs1) {
                if ((newDot -= offs1 - offs0) == offs1) {
                    adjustDotBias = true;
                }
            } else if (newDot >= offs0) {
                newDot = offs0;
                adjustDotBias = true;
            }
            if (newMark >= offs1) {
                if ((newMark -= offs1 - offs0) == offs1) {
                    adjustMarkBias = true;
                }
            } else if (newMark >= offs0) {
                newMark = offs0;
                adjustMarkBias = true;
            }
            if (newMark == newDot) {
                DefaultCaret.this.forceCaretPositionChange = true;
                try {
                    DefaultCaret.this.setDot(newDot, DefaultCaret.this.guessBiasForOffset(newDot, DefaultCaret.this.dotBias, DefaultCaret.this.dotLTR));
                }
                finally {
                    DefaultCaret.this.forceCaretPositionChange = false;
                }
                DefaultCaret.this.ensureValidPosition();
            } else {
                Position.Bias dotBias = DefaultCaret.this.dotBias;
                Position.Bias markBias = DefaultCaret.this.markBias;
                if (adjustDotBias) {
                    dotBias = DefaultCaret.this.guessBiasForOffset(newDot, dotBias, DefaultCaret.this.dotLTR);
                }
                if (adjustMarkBias) {
                    markBias = DefaultCaret.this.guessBiasForOffset(DefaultCaret.this.mark, markBias, DefaultCaret.this.markLTR);
                }
                DefaultCaret.this.setDot(newMark, markBias);
                if (DefaultCaret.this.getDot() == newMark) {
                    DefaultCaret.this.moveDot(newDot, dotBias);
                }
                DefaultCaret.this.ensureValidPosition();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (DefaultCaret.this.getUpdatePolicy() == 1 || DefaultCaret.this.getUpdatePolicy() == 0 && !SwingUtilities.isEventDispatchThread()) {
                return;
            }
            if (e instanceof AbstractDocument.UndoRedoDocumentEvent) {
                DefaultCaret.this.setDot(e.getOffset() + e.getLength());
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object oldValue = evt.getOldValue();
            Object newValue = evt.getNewValue();
            if (oldValue instanceof Document || newValue instanceof Document) {
                DefaultCaret.this.setDot(0);
                if (oldValue != null) {
                    ((Document)oldValue).removeDocumentListener(this);
                }
                if (newValue != null) {
                    ((Document)newValue).addDocumentListener(this);
                }
            } else if ("enabled".equals(evt.getPropertyName())) {
                Boolean enabled = (Boolean)evt.getNewValue();
                if (DefaultCaret.this.component.isFocusOwner()) {
                    if (enabled == Boolean.TRUE) {
                        if (DefaultCaret.this.component.isEditable()) {
                            DefaultCaret.this.setVisible(true);
                        }
                        DefaultCaret.this.setSelectionVisible(true);
                    } else {
                        DefaultCaret.this.setVisible(false);
                        DefaultCaret.this.setSelectionVisible(false);
                    }
                }
            } else if ("caretWidth".equals(evt.getPropertyName())) {
                Integer newWidth = (Integer)evt.getNewValue();
                DefaultCaret.this.caretWidth = newWidth != null ? newWidth : -1;
                DefaultCaret.this.repaint();
            } else if ("caretAspectRatio".equals(evt.getPropertyName())) {
                Number newRatio = (Number)evt.getNewValue();
                DefaultCaret.this.aspectRatio = newRatio != null ? newRatio.floatValue() : -1.0f;
                DefaultCaret.this.repaint();
            }
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
            if (DefaultCaret.this.ownsSelection) {
                DefaultCaret.this.ownsSelection = false;
                if (DefaultCaret.this.component != null && !DefaultCaret.this.component.hasFocus()) {
                    DefaultCaret.this.setSelectionVisible(false);
                }
            }
        }
    }

    class SafeScroller
    implements Runnable {
        Rectangle r;

        SafeScroller(Rectangle r) {
            this.r = r;
        }

        @Override
        public void run() {
            if (DefaultCaret.this.component != null) {
                DefaultCaret.this.component.scrollRectToVisible(this.r);
            }
        }
    }
}

