/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;

public class DefaultHighlighter
extends LayeredHighlighter {
    public static final LayeredHighlighter.LayerPainter DefaultPainter;

    public void paint(Graphics graphics) {
    }

    public void install(JTextComponent jTextComponent) {
    }

    public void deinstall(JTextComponent jTextComponent) {
    }

    public Object addHighlight(int n, int n2, Highlighter.HighlightPainter highlightPainter) throws BadLocationException {
        return null;
    }

    public void removeHighlight(Object object) {
    }

    public void removeAllHighlights() {
    }

    public void changeHighlight(Object object, int n, int n2) throws BadLocationException {
    }

    public Highlighter.Highlight[] getHighlights() {
        return null;
    }

    public void paintLayeredHighlights(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
    }

    public void setDrawsLayeredHighlights(boolean bl) {
    }

    public boolean getDrawsLayeredHighlights() {
        return false;
    }

    public static class DefaultHighlightPainter
    extends LayeredHighlighter.LayerPainter {
        public DefaultHighlightPainter(Color color) {
        }

        public Color getColor() {
            return null;
        }

        public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
        }

        public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
            return null;
        }
    }

    static class HighlightInfo
    implements Highlighter.Highlight {
        Position p0;
        Position p1;
        Highlighter.HighlightPainter painter;

        HighlightInfo() {
        }

        @Override
        public int getStartOffset() {
            return this.p0.getOffset();
        }

        @Override
        public int getEndOffset() {
            return this.p1.getOffset();
        }

        @Override
        public Highlighter.HighlightPainter getPainter() {
            return this.painter;
        }
    }

    static class LayeredHighlightInfo
    extends HighlightInfo {
        int x;
        int y;
        int width;
        int height;

        LayeredHighlightInfo() {
        }

        void union(Shape bounds) {
            if (bounds == null) {
                return;
            }
            Rectangle alloc = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
            if (this.width == 0 || this.height == 0) {
                this.x = alloc.x;
                this.y = alloc.y;
                this.width = alloc.width;
                this.height = alloc.height;
            } else {
                this.width = Math.max(this.x + this.width, alloc.x + alloc.width);
                this.height = Math.max(this.y + this.height, alloc.y + alloc.height);
                this.x = Math.min(this.x, alloc.x);
                this.width -= this.x;
                this.y = Math.min(this.y, alloc.y);
                this.height -= this.y;
            }
        }

        void paintLayeredHighlights(Graphics g, int p0, int p1, Shape viewBounds, JTextComponent editor, View view) {
            int start = this.getStartOffset();
            int end = this.getEndOffset();
            p0 = Math.max(start, p0);
            p1 = Math.min(end, p1);
            this.union(((LayeredHighlighter.LayerPainter)this.painter).paintLayer(g, p0, p1, viewBounds, editor, view));
        }
    }

    class SafeDamager
    implements Runnable {
        private Vector<Position> p0 = new Vector(10);
        private Vector<Position> p1 = new Vector(10);
        private Document lastDoc = null;

        SafeDamager() {
        }

        @Override
        public synchronized void run() {
            TextUI mapper;
            if (DefaultHighlighter.this.component != null && (mapper = DefaultHighlighter.this.component.getUI()) != null && this.lastDoc == DefaultHighlighter.this.component.getDocument()) {
                int len = this.p0.size();
                for (int i = 0; i < len; ++i) {
                    mapper.damageRange(DefaultHighlighter.this.component, this.p0.get(i).getOffset(), this.p1.get(i).getOffset());
                }
            }
            this.p0.clear();
            this.p1.clear();
            this.lastDoc = null;
        }

        public synchronized void damageRange(Position pos0, Position pos1) {
            if (DefaultHighlighter.this.component == null) {
                this.p0.clear();
                this.lastDoc = null;
                return;
            }
            boolean addToQueue = this.p0.isEmpty();
            Document curDoc = DefaultHighlighter.this.component.getDocument();
            if (curDoc != this.lastDoc) {
                if (!this.p0.isEmpty()) {
                    this.p0.clear();
                    this.p1.clear();
                }
                this.lastDoc = curDoc;
            }
            this.p0.add(pos0);
            this.p1.add(pos1);
            if (addToQueue) {
                SwingUtilities.invokeLater(this);
            }
        }
    }
}

