/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.FlowView;
import javax.swing.text.GlyphView;
import javax.swing.text.Position;
import javax.swing.text.TabExpander;
import javax.swing.text.TabSet;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class ParagraphView
extends FlowView
implements TabExpander {
    protected int firstLineIndent;

    public ParagraphView(Element element) {
    }

    protected void setJustification(int n) {
    }

    protected void setLineSpacing(float f) {
    }

    protected void setFirstLineIndent(float f) {
    }

    protected void setPropertiesFromAttributes() {
    }

    protected int getLayoutViewCount() {
        return 0;
    }

    protected View getLayoutView(int n) {
        return null;
    }

    protected void adjustRow(Row row, int n, int n2) {
    }

    protected int getNextNorthSouthVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        return 0;
    }

    protected int getClosestPositionTo(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray, int n3, int n4) throws BadLocationException {
        return 0;
    }

    protected boolean flipEastAndWestAtEnds(int n, Position.Bias bias) {
        return false;
    }

    public int getFlowSpan(int n) {
        return 0;
    }

    public int getFlowStart(int n) {
        return 0;
    }

    protected View createRow() {
        return null;
    }

    public float nextTabStop(float f, int n) {
        return 0.0f;
    }

    protected TabSet getTabSet() {
        return null;
    }

    protected float getPartialSize(int n, int n2) {
        return 0.0f;
    }

    protected int findOffsetToCharactersInString(char[] cArray, int n) {
        return 0;
    }

    protected float getTabBase() {
        return 0.0f;
    }

    public void paint(Graphics graphics, Shape shape) {
    }

    public float getAlignment(int n) {
        return 0.0f;
    }

    public View breakView(int n, float f, Shape shape) {
        return null;
    }

    public int getBreakWeight(int n, float f) {
        return 0;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
    }

    class Row
    extends BoxView {
        static final int SPACE_ADDON = 0;
        static final int SPACE_ADDON_LEFTOVER_END = 1;
        static final int START_JUSTIFIABLE = 2;
        static final int END_JUSTIFIABLE = 3;
        int[] justificationData;

        Row(Element elem) {
            super(elem, 0);
            this.justificationData = null;
        }

        @Override
        protected void loadChildren(ViewFactory f) {
        }

        @Override
        public AttributeSet getAttributes() {
            View p = this.getParent();
            return p != null ? p.getAttributes() : null;
        }

        @Override
        public float getAlignment(int axis) {
            if (axis == 0) {
                switch (ParagraphView.this.justification) {
                    case 0: {
                        return 0.0f;
                    }
                    case 2: {
                        return 1.0f;
                    }
                    case 1: {
                        return 0.5f;
                    }
                    case 3: {
                        float rv = 0.5f;
                        if (this.isJustifiableDocument()) {
                            rv = 0.0f;
                        }
                        return rv;
                    }
                }
            }
            return super.getAlignment(axis);
        }

        @Override
        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            Rectangle r = a.getBounds();
            View v = this.getViewAtPosition(pos, r);
            if (v != null && !v.getElement().isLeaf()) {
                return super.modelToView(pos, a, b);
            }
            r = a.getBounds();
            int height = r.height;
            int y = r.y;
            Shape loc = super.modelToView(pos, a, b);
            Rectangle2D bounds = loc.getBounds2D();
            bounds.setRect(bounds.getX(), y, bounds.getWidth(), height);
            return bounds;
        }

        @Override
        public int getStartOffset() {
            int offs = Integer.MAX_VALUE;
            int n = this.getViewCount();
            for (int i = 0; i < n; ++i) {
                View v = this.getView(i);
                offs = Math.min(offs, v.getStartOffset());
            }
            return offs;
        }

        @Override
        public int getEndOffset() {
            int offs = 0;
            int n = this.getViewCount();
            for (int i = 0; i < n; ++i) {
                View v = this.getView(i);
                offs = Math.max(offs, v.getEndOffset());
            }
            return offs;
        }

        @Override
        protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            this.baselineLayout(targetSpan, axis, offsets, spans);
        }

        @Override
        protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
            return this.baselineRequirements(axis, r);
        }

        private boolean isLastRow() {
            View parent = this.getParent();
            return parent == null || this == parent.getView(parent.getViewCount() - 1);
        }

        private boolean isBrokenRow() {
            View lastView;
            boolean rv = false;
            int viewsCount = this.getViewCount();
            if (viewsCount > 0 && (lastView = this.getView(viewsCount - 1)).getBreakWeight(0, 0.0f, 0.0f) >= 3000) {
                rv = true;
            }
            return rv;
        }

        private boolean isJustifiableDocument() {
            return !Boolean.TRUE.equals(this.getDocument().getProperty("i18n"));
        }

        private boolean isJustifyEnabled() {
            boolean ret = ParagraphView.this.justification == 3;
            ret = ret && this.isJustifiableDocument();
            ret = ret && !this.isLastRow();
            ret = ret && !this.isBrokenRow();
            return ret;
        }

        @Override
        protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
            int[] oldJustficationData = this.justificationData;
            this.justificationData = null;
            SizeRequirements ret = super.calculateMajorAxisRequirements(axis, r);
            if (this.isJustifyEnabled()) {
                this.justificationData = oldJustficationData;
            }
            return ret;
        }

        @Override
        protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            int[] oldJustficationData = this.justificationData;
            this.justificationData = null;
            super.layoutMajorAxis(targetSpan, axis, offsets, spans);
            if (!this.isJustifyEnabled()) {
                return;
            }
            int currentSpan = 0;
            for (int span : spans) {
                currentSpan += span;
            }
            if (currentSpan == targetSpan) {
                return;
            }
            int extendableSpaces = 0;
            int startJustifiableContent = -1;
            int endJustifiableContent = -1;
            int lastLeadingSpaces = 0;
            int rowStartOffset = this.getStartOffset();
            int rowEndOffset = this.getEndOffset();
            int[] spaceMap = new int[rowEndOffset - rowStartOffset];
            for (int i = this.getViewCount() - 1; i >= 0; --i) {
                View view = this.getView(i);
                if (!(view instanceof GlyphView)) continue;
                GlyphView.JustificationInfo justificationInfo = ((GlyphView)view).getJustificationInfo(rowStartOffset);
                int viewStartOffset = view.getStartOffset();
                int offset = viewStartOffset - rowStartOffset;
                for (int j = 0; j < justificationInfo.spaceMap.length(); ++j) {
                    if (!justificationInfo.spaceMap.get(j)) continue;
                    spaceMap[j + offset] = 1;
                }
                if (startJustifiableContent > 0) {
                    if (justificationInfo.end >= 0) {
                        extendableSpaces += justificationInfo.trailingSpaces;
                    } else {
                        lastLeadingSpaces += justificationInfo.trailingSpaces;
                    }
                }
                if (justificationInfo.start >= 0) {
                    startJustifiableContent = justificationInfo.start + viewStartOffset;
                    extendableSpaces += lastLeadingSpaces;
                }
                if (justificationInfo.end >= 0 && endJustifiableContent < 0) {
                    endJustifiableContent = justificationInfo.end + viewStartOffset;
                }
                extendableSpaces += justificationInfo.contentSpaces;
                lastLeadingSpaces = justificationInfo.leadingSpaces;
                if (justificationInfo.hasTab) break;
            }
            if (extendableSpaces <= 0) {
                return;
            }
            int adjustment = targetSpan - currentSpan;
            int spaceAddon = extendableSpaces > 0 ? adjustment / extendableSpaces : 0;
            int spaceAddonLeftoverEnd = -1;
            int i = startJustifiableContent - rowStartOffset;
            int leftover = adjustment - spaceAddon * extendableSpaces;
            while (leftover > 0) {
                spaceAddonLeftoverEnd = i;
                leftover -= spaceMap[i];
                ++i;
            }
            if (spaceAddon > 0 || spaceAddonLeftoverEnd >= 0) {
                this.justificationData = oldJustficationData != null ? oldJustficationData : new int[4];
                this.justificationData[0] = spaceAddon;
                this.justificationData[1] = spaceAddonLeftoverEnd;
                this.justificationData[2] = startJustifiableContent - rowStartOffset;
                this.justificationData[3] = endJustifiableContent - rowStartOffset;
                super.layoutMajorAxis(targetSpan, axis, offsets, spans);
            }
        }

        @Override
        public float getMaximumSpan(int axis) {
            float ret = 0 == axis && this.isJustifyEnabled() ? Float.MAX_VALUE : super.getMaximumSpan(axis);
            return ret;
        }

        @Override
        protected int getViewIndexAtPosition(int pos) {
            if (pos < this.getStartOffset() || pos >= this.getEndOffset()) {
                return -1;
            }
            for (int counter = this.getViewCount() - 1; counter >= 0; --counter) {
                View v = this.getView(counter);
                if (pos < v.getStartOffset() || pos >= v.getEndOffset()) continue;
                return counter;
            }
            return -1;
        }

        @Override
        protected short getLeftInset() {
            int adjustment = 0;
            View parentView = this.getParent();
            if (parentView != null && this == parentView.getView(0)) {
                adjustment = ParagraphView.this.firstLineIndent;
            }
            return (short)(super.getLeftInset() + adjustment);
        }

        @Override
        protected short getBottomInset() {
            return (short)((float)super.getBottomInset() + (float)(this.minorRequest != null ? this.minorRequest.preferred : 0) * ParagraphView.this.lineSpacing);
        }
    }
}

