/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.StyleSheet;

public class CSS
implements Serializable {
    public static Attribute[] getAllAttributeKeys() {
        return null;
    }

    public static final Attribute getAttribute(String string) {
        return null;
    }

    public static final class Attribute {
        public static final Attribute BACKGROUND;
        public static final Attribute BACKGROUND_ATTACHMENT;
        public static final Attribute BACKGROUND_COLOR;
        public static final Attribute BACKGROUND_IMAGE;
        public static final Attribute BACKGROUND_POSITION;
        public static final Attribute BACKGROUND_REPEAT;
        public static final Attribute BORDER;
        public static final Attribute BORDER_BOTTOM;
        public static final Attribute BORDER_BOTTOM_WIDTH;
        public static final Attribute BORDER_COLOR;
        public static final Attribute BORDER_LEFT;
        public static final Attribute BORDER_LEFT_WIDTH;
        public static final Attribute BORDER_RIGHT;
        public static final Attribute BORDER_RIGHT_WIDTH;
        public static final Attribute BORDER_STYLE;
        public static final Attribute BORDER_TOP;
        public static final Attribute BORDER_TOP_WIDTH;
        public static final Attribute BORDER_WIDTH;
        public static final Attribute CLEAR;
        public static final Attribute COLOR;
        public static final Attribute DISPLAY;
        public static final Attribute FLOAT;
        public static final Attribute FONT;
        public static final Attribute FONT_FAMILY;
        public static final Attribute FONT_SIZE;
        public static final Attribute FONT_STYLE;
        public static final Attribute FONT_VARIANT;
        public static final Attribute FONT_WEIGHT;
        public static final Attribute HEIGHT;
        public static final Attribute LETTER_SPACING;
        public static final Attribute LINE_HEIGHT;
        public static final Attribute LIST_STYLE;
        public static final Attribute LIST_STYLE_IMAGE;
        public static final Attribute LIST_STYLE_POSITION;
        public static final Attribute LIST_STYLE_TYPE;
        public static final Attribute MARGIN;
        public static final Attribute MARGIN_BOTTOM;
        public static final Attribute MARGIN_LEFT;
        public static final Attribute MARGIN_RIGHT;
        public static final Attribute MARGIN_TOP;
        public static final Attribute PADDING;
        public static final Attribute PADDING_BOTTOM;
        public static final Attribute PADDING_LEFT;
        public static final Attribute PADDING_RIGHT;
        public static final Attribute PADDING_TOP;
        public static final Attribute TEXT_ALIGN;
        public static final Attribute TEXT_DECORATION;
        public static final Attribute TEXT_INDENT;
        public static final Attribute TEXT_TRANSFORM;
        public static final Attribute VERTICAL_ALIGN;
        public static final Attribute WORD_SPACING;
        public static final Attribute WHITE_SPACE;
        public static final Attribute WIDTH;

        public String toString() {
            return null;
        }

        public String getDefaultValue() {
            return null;
        }

        public boolean isInherited() {
            return false;
        }
    }

    static class BackgroundImage
    extends CssValue {
        private boolean loadedImage;
        private ImageIcon image;

        BackgroundImage() {
        }

        @Override
        Object parseCssValue(String value) {
            BackgroundImage retValue = new BackgroundImage();
            retValue.svalue = value;
            return retValue;
        }

        @Override
        Object parseHtmlValue(String value) {
            return this.parseCssValue(value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ImageIcon getImage(URL base) {
            if (!this.loadedImage) {
                BackgroundImage backgroundImage = this;
                synchronized (backgroundImage) {
                    if (!this.loadedImage) {
                        URL url = CSS.getURL((URL)base, (String)this.svalue);
                        this.loadedImage = true;
                        if (url != null) {
                            this.image = new ImageIcon();
                            Image tmpImg = Toolkit.getDefaultToolkit().createImage(url);
                            if (tmpImg != null) {
                                this.image.setImage(tmpImg);
                            }
                        }
                    }
                }
            }
            return this.image;
        }
    }

    static class BackgroundPosition
    extends CssValue {
        float horizontalPosition;
        float verticalPosition;
        short relative;

        BackgroundPosition() {
        }

        @Override
        Object parseCssValue(String value) {
            String[] strings = CSS.parseStrings((String)value);
            int count = strings.length;
            BackgroundPosition bp = new BackgroundPosition();
            bp.relative = (short)5;
            bp.svalue = value;
            if (count > 0) {
                int found = 0;
                int index = 0;
                while (index < count) {
                    String string;
                    if ((string = strings[index++]).equals("center")) {
                        found = (short)(found | 4);
                        continue;
                    }
                    if ((found & 1) == 0) {
                        if (string.equals("top")) {
                            found = (short)(found | 1);
                        } else if (string.equals("bottom")) {
                            found = (short)(found | 1);
                            bp.verticalPosition = 1.0f;
                            continue;
                        }
                    }
                    if ((found & 2) != 0) continue;
                    if (string.equals("left")) {
                        found = (short)(found | 2);
                        bp.horizontalPosition = 0.0f;
                        continue;
                    }
                    if (!string.equals("right")) continue;
                    found = (short)(found | 2);
                    bp.horizontalPosition = 1.0f;
                }
                if (found != 0) {
                    if (found & true) {
                        if ((found & 2) == 0) {
                            bp.horizontalPosition = 0.5f;
                        }
                    } else if ((found & 2) == 2) {
                        bp.verticalPosition = 0.5f;
                    } else {
                        bp.verticalPosition = 0.5f;
                        bp.horizontalPosition = 0.5f;
                    }
                } else {
                    LengthUnit lu = new LengthUnit(strings[0], 0, 0.0f);
                    if (lu.type == 0) {
                        bp.horizontalPosition = lu.value;
                        bp.relative = (short)(1 ^ bp.relative);
                    } else if (lu.type == 1) {
                        bp.horizontalPosition = lu.value;
                    } else if (lu.type == 3) {
                        bp.horizontalPosition = lu.value;
                        bp.relative = (short)(1 ^ bp.relative | 2);
                    }
                    if (count > 1) {
                        lu = new LengthUnit(strings[1], 0, 0.0f);
                        if (lu.type == 0) {
                            bp.verticalPosition = lu.value;
                            bp.relative = (short)(4 ^ bp.relative);
                        } else if (lu.type == 1) {
                            bp.verticalPosition = lu.value;
                        } else if (lu.type == 3) {
                            bp.verticalPosition = lu.value;
                            bp.relative = (short)(4 ^ bp.relative | 8);
                        }
                    } else {
                        bp.verticalPosition = 0.5f;
                    }
                }
            }
            return bp;
        }

        boolean isHorizontalPositionRelativeToSize() {
            return (this.relative & 1) == 1;
        }

        boolean isHorizontalPositionRelativeToFontSize() {
            return (this.relative & 2) == 2;
        }

        float getHorizontalPosition() {
            return this.horizontalPosition;
        }

        boolean isVerticalPositionRelativeToSize() {
            return (this.relative & 4) == 4;
        }

        boolean isVerticalPositionRelativeToFontSize() {
            return (this.relative & 8) == 8;
        }

        float getVerticalPosition() {
            return this.verticalPosition;
        }
    }

    static class BorderStyle
    extends CssValue {
        private transient Value style;

        BorderStyle() {
        }

        Value getValue() {
            return this.style;
        }

        @Override
        Object parseCssValue(String value) {
            Value cssv = CSS.getValue((String)value);
            if (cssv != null && (cssv == Value.INSET || cssv == Value.OUTSET || cssv == Value.NONE || cssv == Value.DOTTED || cssv == Value.DASHED || cssv == Value.SOLID || cssv == Value.DOUBLE || cssv == Value.GROOVE || cssv == Value.RIDGE)) {
                BorderStyle bs = new BorderStyle();
                bs.svalue = value;
                bs.style = cssv;
                return bs;
            }
            return null;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            if (this.style == null) {
                s.writeObject(null);
            } else {
                s.writeObject(this.style.toString());
            }
        }

        private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
            s.defaultReadObject();
            Object value = s.readObject();
            if (value != null) {
                this.style = CSS.getValue((String)((String)value));
            }
        }
    }

    static class BorderWidthValue
    extends LengthValue {
        private static final float[] values = new float[]{1.0f, 2.0f, 4.0f};

        BorderWidthValue(String svalue, int index) {
            this.svalue = svalue;
            this.span = values[index];
            this.percentage = false;
        }

        @Override
        Object parseCssValue(String value) {
            if (value != null) {
                if (value.equals("thick")) {
                    return new BorderWidthValue(value, 2);
                }
                if (value.equals("medium")) {
                    return new BorderWidthValue(value, 1);
                }
                if (value.equals("thin")) {
                    return new BorderWidthValue(value, 0);
                }
            }
            return super.parseCssValue(value);
        }

        @Override
        Object parseHtmlValue(String value) {
            if (value == "#DEFAULT") {
                return this.parseCssValue("medium");
            }
            return this.parseCssValue(value);
        }
    }

    static class ColorValue
    extends CssValue {
        Color c;

        ColorValue() {
        }

        Color getValue() {
            return this.c;
        }

        @Override
        Object parseCssValue(String value) {
            Color c = CSS.stringToColor((String)value);
            if (c != null) {
                ColorValue cv = new ColorValue();
                cv.svalue = value;
                cv.c = c;
                return cv;
            }
            return null;
        }

        @Override
        Object parseHtmlValue(String value) {
            return this.parseCssValue(value);
        }

        @Override
        Object fromStyleConstants(StyleConstants key, Object value) {
            ColorValue colorValue = new ColorValue();
            colorValue.c = (Color)value;
            colorValue.svalue = CSS.colorToHex((Color)colorValue.c);
            return colorValue;
        }

        @Override
        Object toStyleConstants(StyleConstants key, View v) {
            return this.c;
        }
    }

    static class CssValue
    implements Serializable {
        String svalue;

        CssValue() {
        }

        Object parseCssValue(String value) {
            return value;
        }

        Object parseHtmlValue(String value) {
            return this.parseCssValue(value);
        }

        Object fromStyleConstants(StyleConstants key, Object value) {
            return null;
        }

        Object toStyleConstants(StyleConstants key, View v) {
            return null;
        }

        public String toString() {
            return this.svalue;
        }
    }

    static class CssValueMapper
    extends CssValue {
        CssValueMapper() {
        }

        @Override
        Object parseCssValue(String value) {
            Object retValue = cssValueToInternalValueMap.get(value);
            if (retValue == null) {
                retValue = cssValueToInternalValueMap.get(value.toLowerCase());
            }
            return retValue;
        }

        @Override
        Object parseHtmlValue(String value) {
            Object retValue = htmlValueToCssValueMap.get(value);
            if (retValue == null) {
                retValue = htmlValueToCssValueMap.get(value.toLowerCase());
            }
            return retValue;
        }
    }

    static class FontFamily
    extends CssValue {
        String family;

        FontFamily() {
        }

        String getValue() {
            return this.family;
        }

        @Override
        Object parseCssValue(String value) {
            int cIndex = value.indexOf(44);
            FontFamily ff = new FontFamily();
            ff.svalue = value;
            ff.family = null;
            if (cIndex == -1) {
                this.setFontName(ff, value);
            } else {
                boolean done = false;
                int length = value.length();
                cIndex = 0;
                while (!done) {
                    while (cIndex < length && Character.isWhitespace(value.charAt(cIndex))) {
                        ++cIndex;
                    }
                    int lastIndex = cIndex;
                    if ((cIndex = value.indexOf(44, cIndex)) == -1) {
                        cIndex = length;
                    }
                    if (lastIndex < length) {
                        if (lastIndex != cIndex) {
                            int lastCharIndex = cIndex;
                            if (cIndex > 0 && value.charAt(cIndex - 1) == ' ') {
                                --lastCharIndex;
                            }
                            this.setFontName(ff, value.substring(lastIndex, lastCharIndex));
                            done = ff.family != null;
                        }
                        ++cIndex;
                        continue;
                    }
                    done = true;
                }
            }
            if (ff.family == null) {
                ff.family = "SansSerif";
            }
            return ff;
        }

        private void setFontName(FontFamily ff, String fontName) {
            ff.family = fontName;
        }

        @Override
        Object parseHtmlValue(String value) {
            return this.parseCssValue(value);
        }

        @Override
        Object fromStyleConstants(StyleConstants key, Object value) {
            return this.parseCssValue(value.toString());
        }

        @Override
        Object toStyleConstants(StyleConstants key, View v) {
            return this.family;
        }
    }

    class FontSize
    extends CssValue {
        float value;
        boolean index;
        LengthUnit lu;

        FontSize() {
        }

        int getValue(AttributeSet a, StyleSheet ss) {
            AttributeSet resolveParent;
            ss = CSS.this.getStyleSheet(ss);
            if (this.index) {
                return Math.round(CSS.this.getPointSize((int)this.value, ss));
            }
            if (this.lu == null) {
                return Math.round(this.value);
            }
            if (this.lu.type == 0) {
                boolean isW3CLengthUnits = ss == null ? false : ss.isW3CLengthUnits();
                return Math.round(this.lu.getValue(isW3CLengthUnits));
            }
            if (a != null && (resolveParent = a.getResolveParent()) != null) {
                int pValue = StyleConstants.getFontSize(resolveParent);
                float retValue = this.lu.type == 1 || this.lu.type == 3 ? this.lu.value * (float)pValue : this.lu.value + (float)pValue;
                return Math.round(retValue);
            }
            return 12;
        }

        @Override
        Object parseCssValue(String value) {
            FontSize fs = new FontSize();
            fs.svalue = value;
            try {
                if (value.equals("xx-small")) {
                    fs.value = 1.0f;
                    fs.index = true;
                } else if (value.equals("x-small")) {
                    fs.value = 2.0f;
                    fs.index = true;
                } else if (value.equals("small")) {
                    fs.value = 3.0f;
                    fs.index = true;
                } else if (value.equals("medium")) {
                    fs.value = 4.0f;
                    fs.index = true;
                } else if (value.equals("large")) {
                    fs.value = 5.0f;
                    fs.index = true;
                } else if (value.equals("x-large")) {
                    fs.value = 6.0f;
                    fs.index = true;
                } else if (value.equals("xx-large")) {
                    fs.value = 7.0f;
                    fs.index = true;
                } else {
                    fs.lu = new LengthUnit(value, 1, 1.0f);
                }
            }
            catch (NumberFormatException nfe) {
                fs = null;
            }
            return fs;
        }

        @Override
        Object parseHtmlValue(String value) {
            if (value == null || value.length() == 0) {
                return null;
            }
            FontSize fs = new FontSize();
            fs.svalue = value;
            try {
                int baseFontSize = CSS.this.getBaseFontSize();
                if (value.charAt(0) == '+') {
                    int relSize = Integer.parseInt(value.substring(1));
                    fs.value = baseFontSize + relSize;
                    fs.index = true;
                } else if (value.charAt(0) == '-') {
                    int relSize = -Integer.parseInt(value.substring(1));
                    fs.value = baseFontSize + relSize;
                    fs.index = true;
                } else {
                    fs.value = Integer.parseInt(value);
                    if (fs.value > 7.0f) {
                        fs.value = 7.0f;
                    } else if (fs.value < 0.0f) {
                        fs.value = 0.0f;
                    }
                    fs.index = true;
                }
            }
            catch (NumberFormatException nfe) {
                fs = null;
            }
            return fs;
        }

        @Override
        Object fromStyleConstants(StyleConstants key, Object value) {
            if (value instanceof Number) {
                FontSize fs = new FontSize();
                fs.value = CSS.getIndexOfSize((float)((Number)value).floatValue(), (int[])StyleSheet.sizeMapDefault);
                fs.svalue = Integer.toString((int)fs.value);
                fs.index = true;
                return fs;
            }
            return this.parseCssValue(value.toString());
        }

        @Override
        Object toStyleConstants(StyleConstants key, View v) {
            if (v != null) {
                return this.getValue(v.getAttributes(), null);
            }
            return this.getValue(null, null);
        }
    }

    static class FontWeight
    extends CssValue {
        int weight;

        FontWeight() {
        }

        int getValue() {
            return this.weight;
        }

        @Override
        Object parseCssValue(String value) {
            FontWeight fw = new FontWeight();
            fw.svalue = value;
            if (value.equals("bold")) {
                fw.weight = 700;
            } else if (value.equals("normal")) {
                fw.weight = 400;
            } else {
                try {
                    fw.weight = Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    fw = null;
                }
            }
            return fw;
        }

        @Override
        Object fromStyleConstants(StyleConstants key, Object value) {
            if (value.equals(Boolean.TRUE)) {
                return this.parseCssValue("bold");
            }
            return this.parseCssValue("normal");
        }

        @Override
        Object toStyleConstants(StyleConstants key, View v) {
            return this.weight > 500 ? Boolean.TRUE : Boolean.FALSE;
        }

        boolean isBold() {
            return this.weight > 500;
        }
    }

    static interface LayoutIterator {
        public static final int WorstAdjustmentWeight = 2;

        public void setOffset(int var1);

        public int getOffset();

        public void setSpan(int var1);

        public int getSpan();

        public int getCount();

        public void setIndex(int var1);

        public float getMinimumSpan(float var1);

        public float getPreferredSpan(float var1);

        public float getMaximumSpan(float var1);

        public int getAdjustmentWeight();

        public float getBorderWidth();

        public float getLeadingCollapseSpan();

        public float getTrailingCollapseSpan();
    }

    static class LengthUnit
    implements Serializable {
        static Hashtable<String, Float> lengthMapping = new Hashtable(6);
        static Hashtable<String, Float> w3cLengthMapping = new Hashtable(6);
        short type;
        float value;
        String units = null;
        static final short UNINITIALIZED_LENGTH = 10;

        LengthUnit(String value, short defaultType, float defaultValue) {
            this.parse(value, defaultType, defaultValue);
        }

        void parse(String value, short defaultType, float defaultValue) {
            this.type = defaultType;
            this.value = defaultValue;
            int length = value.length();
            if (length < 1) {
                return;
            }
            if (value.charAt(length - 1) == '%') {
                try {
                    this.value = Float.parseFloat(value.substring(0, length - 1)) / 100.0f;
                    this.type = 1;
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (length >= 2) {
                this.units = value.substring(length - 2, length);
                Float scale = lengthMapping.get(this.units);
                if (scale != null) {
                    try {
                        this.value = Float.parseFloat(value.substring(0, length - 2));
                        this.type = 0;
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (this.units.equals("em") || this.units.equals("ex")) {
                    try {
                        this.value = Float.parseFloat(value.substring(0, length - 2));
                        this.type = (short)3;
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (value.equals("larger")) {
                    this.value = 2.0f;
                    this.type = (short)2;
                } else if (value.equals("smaller")) {
                    this.value = -2.0f;
                    this.type = (short)2;
                } else {
                    try {
                        this.value = Float.parseFloat(value);
                        this.type = 0;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                try {
                    this.value = Float.parseFloat(value);
                    this.type = 0;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        float getValue(boolean w3cLengthUnits) {
            Float scaleFloat;
            Hashtable<String, Float> mapping = w3cLengthUnits ? w3cLengthMapping : lengthMapping;
            float scale = 1.0f;
            if (this.units != null && (scaleFloat = mapping.get(this.units)) != null) {
                scale = scaleFloat.floatValue();
            }
            return this.value * scale;
        }

        static float getValue(float value, String units, Boolean w3cLengthUnits) {
            Float scaleFloat;
            Hashtable<String, Float> mapping = w3cLengthUnits != false ? w3cLengthMapping : lengthMapping;
            float scale = 1.0f;
            if (units != null && (scaleFloat = mapping.get(units)) != null) {
                scale = scaleFloat.floatValue();
            }
            return value * scale;
        }

        public String toString() {
            return this.type + " " + this.value;
        }

        static {
            lengthMapping.put("pt", Float.valueOf(1.0f));
            lengthMapping.put("px", Float.valueOf(1.3f));
            lengthMapping.put("mm", Float.valueOf(2.83464f));
            lengthMapping.put("cm", Float.valueOf(28.3464f));
            lengthMapping.put("pc", Float.valueOf(12.0f));
            lengthMapping.put("in", Float.valueOf(72.0f));
            w3cLengthMapping.put("pt", Float.valueOf(1.3333334f));
            w3cLengthMapping.put("px", Float.valueOf(1.0f));
            w3cLengthMapping.put("mm", Float.valueOf(3.7795277f));
            w3cLengthMapping.put("cm", Float.valueOf(37.795277f));
            w3cLengthMapping.put("pc", Float.valueOf(16.0f));
            w3cLengthMapping.put("in", Float.valueOf(96.0f));
        }
    }

    static class LengthValue
    extends CssValue {
        boolean mayBeNegative;
        boolean percentage;
        float span;
        String units = null;

        LengthValue() {
            this(false);
        }

        LengthValue(boolean mayBeNegative) {
            this.mayBeNegative = mayBeNegative;
        }

        float getValue() {
            return this.getValue(false);
        }

        float getValue(boolean isW3CLengthUnits) {
            return this.getValue(0.0f, isW3CLengthUnits);
        }

        float getValue(float currentValue) {
            return this.getValue(currentValue, false);
        }

        float getValue(float currentValue, boolean isW3CLengthUnits) {
            if (this.percentage) {
                return this.span * currentValue;
            }
            return LengthUnit.getValue(this.span, this.units, isW3CLengthUnits);
        }

        boolean isPercentage() {
            return this.percentage;
        }

        @Override
        Object parseCssValue(String value) {
            LengthValue lv;
            try {
                float absolute = Float.parseFloat(value);
                lv = new LengthValue();
                lv.span = absolute;
            }
            catch (NumberFormatException nfe) {
                LengthUnit lu = new LengthUnit(value, 10, 0.0f);
                switch (lu.type) {
                    case 0: {
                        lv = new LengthValue();
                        lv.span = this.mayBeNegative ? lu.value : Math.max(0.0f, lu.value);
                        lv.units = lu.units;
                        break;
                    }
                    case 1: {
                        lv = new LengthValue();
                        lv.span = Math.max(0.0f, Math.min(1.0f, lu.value));
                        lv.percentage = true;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            lv.svalue = value;
            return lv;
        }

        @Override
        Object parseHtmlValue(String value) {
            if (value.equals("#DEFAULT")) {
                value = "1";
            }
            return this.parseCssValue(value);
        }

        @Override
        Object fromStyleConstants(StyleConstants key, Object value) {
            LengthValue v = new LengthValue();
            v.svalue = value.toString();
            v.span = ((Float)value).floatValue();
            return v;
        }

        @Override
        Object toStyleConstants(StyleConstants key, View v) {
            return Float.valueOf(this.getValue(false));
        }
    }

    static class ShorthandBackgroundParser {
        ShorthandBackgroundParser() {
        }

        static void parseShorthandBackground(CSS css, String value, MutableAttributeSet attr) {
            String[] strings = CSS.parseStrings((String)value);
            int count = strings.length;
            int index = 0;
            int found = 0;
            while (index < count) {
                String string = strings[index++];
                if ((found & 1) == 0 && ShorthandBackgroundParser.isImage(string)) {
                    css.addInternalCSSValue(attr, Attribute.BACKGROUND_IMAGE, string);
                    found = (short)(found | 1);
                    continue;
                }
                if ((found & 2) == 0 && ShorthandBackgroundParser.isRepeat(string)) {
                    css.addInternalCSSValue(attr, Attribute.BACKGROUND_REPEAT, string);
                    found = (short)(found | 2);
                    continue;
                }
                if ((found & 4) == 0 && ShorthandBackgroundParser.isAttachment(string)) {
                    css.addInternalCSSValue(attr, Attribute.BACKGROUND_ATTACHMENT, string);
                    found = (short)(found | 4);
                    continue;
                }
                if ((found & 8) == 0 && ShorthandBackgroundParser.isPosition(string)) {
                    if (index < count && ShorthandBackgroundParser.isPosition(strings[index])) {
                        css.addInternalCSSValue(attr, Attribute.BACKGROUND_POSITION, string + " " + strings[index++]);
                    } else {
                        css.addInternalCSSValue(attr, Attribute.BACKGROUND_POSITION, string);
                    }
                    found = (short)(found | 8);
                    continue;
                }
                if ((found & 0x10) != 0 || !ShorthandBackgroundParser.isColor(string)) continue;
                css.addInternalCSSValue(attr, Attribute.BACKGROUND_COLOR, string);
                found = (short)(found | 0x10);
            }
            if (!(found & true)) {
                css.addInternalCSSValue(attr, Attribute.BACKGROUND_IMAGE, null);
            }
            if ((found & 2) == 0) {
                css.addInternalCSSValue(attr, Attribute.BACKGROUND_REPEAT, "repeat");
            }
            if ((found & 4) == 0) {
                css.addInternalCSSValue(attr, Attribute.BACKGROUND_ATTACHMENT, "scroll");
            }
            if ((found & 8) == 0) {
                css.addInternalCSSValue(attr, Attribute.BACKGROUND_POSITION, null);
            }
        }

        static boolean isImage(String string) {
            return string.startsWith("url(") && string.endsWith(")");
        }

        static boolean isRepeat(String string) {
            return string.equals("repeat-x") || string.equals("repeat-y") || string.equals("repeat") || string.equals("no-repeat");
        }

        static boolean isAttachment(String string) {
            return string.equals("fixed") || string.equals("scroll");
        }

        static boolean isPosition(String string) {
            return string.equals("top") || string.equals("bottom") || string.equals("left") || string.equals("right") || string.equals("center") || string.length() > 0 && Character.isDigit(string.charAt(0));
        }

        static boolean isColor(String string) {
            return CSS.stringToColor((String)string) != null;
        }
    }

    static class ShorthandFontParser {
        ShorthandFontParser() {
        }

        static void parseShorthandFont(CSS css, String value, MutableAttributeSet attr) {
            String[] strings = CSS.parseStrings((String)value);
            int count = strings.length;
            int index = 0;
            int found = 0;
            int maxC = Math.min(3, count);
            while (index < maxC) {
                if (!(found & true) && ShorthandFontParser.isFontStyle(strings[index])) {
                    css.addInternalCSSValue(attr, Attribute.FONT_STYLE, strings[index++]);
                    found = (short)(found | 1);
                    continue;
                }
                if ((found & 2) == 0 && ShorthandFontParser.isFontVariant(strings[index])) {
                    css.addInternalCSSValue(attr, Attribute.FONT_VARIANT, strings[index++]);
                    found = (short)(found | 2);
                    continue;
                }
                if ((found & 4) == 0 && ShorthandFontParser.isFontWeight(strings[index])) {
                    css.addInternalCSSValue(attr, Attribute.FONT_WEIGHT, strings[index++]);
                    found = (short)(found | 4);
                    continue;
                }
                if (!strings[index].equals("normal")) break;
                ++index;
            }
            if (!(found & true)) {
                css.addInternalCSSValue(attr, Attribute.FONT_STYLE, "normal");
            }
            if ((found & 2) == 0) {
                css.addInternalCSSValue(attr, Attribute.FONT_VARIANT, "normal");
            }
            if ((found & 4) == 0) {
                css.addInternalCSSValue(attr, Attribute.FONT_WEIGHT, "normal");
            }
            if (index < count) {
                String fontSize = strings[index];
                int slashIndex = fontSize.indexOf(47);
                if (slashIndex != -1) {
                    fontSize = fontSize.substring(0, slashIndex);
                    strings[index] = strings[index].substring(slashIndex);
                } else {
                    ++index;
                }
                css.addInternalCSSValue(attr, Attribute.FONT_SIZE, fontSize);
            } else {
                css.addInternalCSSValue(attr, Attribute.FONT_SIZE, "medium");
            }
            if (index < count && strings[index].startsWith("/")) {
                String lineHeight = null;
                if (strings[index].equals("/")) {
                    if (++index < count) {
                        lineHeight = strings[index++];
                    }
                } else {
                    lineHeight = strings[index++].substring(1);
                }
                if (lineHeight != null) {
                    css.addInternalCSSValue(attr, Attribute.LINE_HEIGHT, lineHeight);
                } else {
                    css.addInternalCSSValue(attr, Attribute.LINE_HEIGHT, "normal");
                }
            } else {
                css.addInternalCSSValue(attr, Attribute.LINE_HEIGHT, "normal");
            }
            if (index < count) {
                Object family = strings[index++];
                while (index < count) {
                    family = (String)family + " " + strings[index++];
                }
                css.addInternalCSSValue(attr, Attribute.FONT_FAMILY, (String)family);
            } else {
                css.addInternalCSSValue(attr, Attribute.FONT_FAMILY, "SansSerif");
            }
        }

        private static boolean isFontStyle(String string) {
            return string.equals("italic") || string.equals("oblique");
        }

        private static boolean isFontVariant(String string) {
            return string.equals("small-caps");
        }

        private static boolean isFontWeight(String string) {
            if (string.equals("bold") || string.equals("bolder") || string.equals("italic") || string.equals("lighter")) {
                return true;
            }
            return string.length() == 3 && string.charAt(0) >= '1' && string.charAt(0) <= '9' && string.charAt(1) == '0' && string.charAt(2) == '0';
        }
    }

    static class ShorthandMarginParser {
        ShorthandMarginParser() {
        }

        static void parseShorthandMargin(CSS css, String value, MutableAttributeSet attr, Attribute[] names) {
            String[] strings = CSS.parseStrings((String)value);
            int count = strings.length;
            boolean index = false;
            switch (count) {
                case 0: {
                    return;
                }
                case 1: {
                    for (int counter = 0; counter < 4; ++counter) {
                        css.addInternalCSSValue(attr, names[counter], strings[0]);
                    }
                    break;
                }
                case 2: {
                    css.addInternalCSSValue(attr, names[0], strings[0]);
                    css.addInternalCSSValue(attr, names[2], strings[0]);
                    css.addInternalCSSValue(attr, names[1], strings[1]);
                    css.addInternalCSSValue(attr, names[3], strings[1]);
                    break;
                }
                case 3: {
                    css.addInternalCSSValue(attr, names[0], strings[0]);
                    css.addInternalCSSValue(attr, names[1], strings[1]);
                    css.addInternalCSSValue(attr, names[2], strings[2]);
                    css.addInternalCSSValue(attr, names[3], strings[1]);
                    break;
                }
                default: {
                    for (int counter = 0; counter < 4; ++counter) {
                        css.addInternalCSSValue(attr, names[counter], strings[counter]);
                    }
                }
            }
        }
    }

    static class StringValue
    extends CssValue {
        StringValue() {
        }

        @Override
        Object parseCssValue(String value) {
            StringValue sv = new StringValue();
            sv.svalue = value;
            return sv;
        }

        @Override
        Object fromStyleConstants(StyleConstants key, Object value) {
            if (key == StyleConstants.Italic) {
                if (value.equals(Boolean.TRUE)) {
                    return this.parseCssValue("italic");
                }
                return this.parseCssValue("");
            }
            if (key == StyleConstants.Underline) {
                if (value.equals(Boolean.TRUE)) {
                    return this.parseCssValue("underline");
                }
                return this.parseCssValue("");
            }
            if (key == StyleConstants.Alignment) {
                int align = (Integer)value;
                return this.parseCssValue(switch (align) {
                    case 0 -> "left";
                    case 2 -> "right";
                    case 1 -> "center";
                    case 3 -> "justify";
                    default -> "left";
                });
            }
            if (key == StyleConstants.StrikeThrough) {
                if (value.equals(Boolean.TRUE)) {
                    return this.parseCssValue("line-through");
                }
                return this.parseCssValue("");
            }
            if (key == StyleConstants.Superscript) {
                if (value.equals(Boolean.TRUE)) {
                    return this.parseCssValue("super");
                }
                return this.parseCssValue("");
            }
            if (key == StyleConstants.Subscript) {
                if (value.equals(Boolean.TRUE)) {
                    return this.parseCssValue("sub");
                }
                return this.parseCssValue("");
            }
            return null;
        }

        @Override
        Object toStyleConstants(StyleConstants key, View v) {
            if (key == StyleConstants.Italic) {
                if (this.svalue.contains("italic")) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (key == StyleConstants.Underline) {
                if (this.svalue.contains("underline")) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (key == StyleConstants.Alignment) {
                if (this.svalue.equals("right")) {
                    return 2;
                }
                if (this.svalue.equals("center")) {
                    return 1;
                }
                if (this.svalue.equals("justify")) {
                    return 3;
                }
                return 0;
            }
            if (key == StyleConstants.StrikeThrough) {
                if (this.svalue.contains("line-through")) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (key == StyleConstants.Superscript) {
                if (this.svalue.contains("super")) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (key == StyleConstants.Subscript) {
                if (this.svalue.contains("sub")) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            return null;
        }

        boolean isItalic() {
            return this.svalue.contains("italic");
        }

        boolean isStrike() {
            return this.svalue.contains("line-through");
        }

        boolean isUnderline() {
            return this.svalue.contains("underline");
        }

        boolean isSub() {
            return this.svalue.contains("sub");
        }

        boolean isSup() {
            return this.svalue.contains("sup");
        }
    }

    static final class Value {
        static final Value INHERITED = new Value("inherited");
        static final Value NONE = new Value("none");
        static final Value HIDDEN = new Value("hidden");
        static final Value DOTTED = new Value("dotted");
        static final Value DASHED = new Value("dashed");
        static final Value SOLID = new Value("solid");
        static final Value DOUBLE = new Value("double");
        static final Value GROOVE = new Value("groove");
        static final Value RIDGE = new Value("ridge");
        static final Value INSET = new Value("inset");
        static final Value OUTSET = new Value("outset");
        static final Value DISC = new Value("disc");
        static final Value CIRCLE = new Value("circle");
        static final Value SQUARE = new Value("square");
        static final Value DECIMAL = new Value("decimal");
        static final Value LOWER_ROMAN = new Value("lower-roman");
        static final Value UPPER_ROMAN = new Value("upper-roman");
        static final Value LOWER_ALPHA = new Value("lower-alpha");
        static final Value UPPER_ALPHA = new Value("upper-alpha");
        static final Value BACKGROUND_NO_REPEAT = new Value("no-repeat");
        static final Value BACKGROUND_REPEAT = new Value("repeat");
        static final Value BACKGROUND_REPEAT_X = new Value("repeat-x");
        static final Value BACKGROUND_REPEAT_Y = new Value("repeat-y");
        static final Value BACKGROUND_SCROLL = new Value("scroll");
        static final Value BACKGROUND_FIXED = new Value("fixed");
        private String name;
        static final Value[] allValues = new Value[]{INHERITED, NONE, DOTTED, DASHED, SOLID, DOUBLE, GROOVE, RIDGE, INSET, OUTSET, DISC, CIRCLE, SQUARE, DECIMAL, LOWER_ROMAN, UPPER_ROMAN, LOWER_ALPHA, UPPER_ALPHA, BACKGROUND_NO_REPEAT, BACKGROUND_REPEAT, BACKGROUND_REPEAT_X, BACKGROUND_REPEAT_Y, BACKGROUND_FIXED, BACKGROUND_FIXED};

        private Value(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

