/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.SizeRequirements;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.ObjectView;
import javax.swing.text.html.StyleSheet;

public class HTMLEditorKit
extends StyledEditorKit
implements Accessible {
    public static final String DEFAULT_CSS = "default.css";
    public static final String BOLD_ACTION = "html-bold-action";
    public static final String ITALIC_ACTION = "html-italic-action";
    public static final String PARA_INDENT_LEFT = "html-para-indent-left";
    public static final String PARA_INDENT_RIGHT = "html-para-indent-right";
    public static final String FONT_CHANGE_BIGGER = "html-font-bigger";
    public static final String FONT_CHANGE_SMALLER = "html-font-smaller";
    public static final String COLOR_ACTION = "html-color-action";
    public static final String LOGICAL_STYLE_ACTION = "html-logical-style-action";
    public static final String IMG_ALIGN_TOP = "html-image-align-top";
    public static final String IMG_ALIGN_MIDDLE = "html-image-align-middle";
    public static final String IMG_ALIGN_BOTTOM = "html-image-align-bottom";
    public static final String IMG_BORDER = "html-image-border";

    public String getContentType() {
        return null;
    }

    public ViewFactory getViewFactory() {
        return null;
    }

    public Document createDefaultDocument() {
        return null;
    }

    public void read(Reader reader, Document document, int n) throws IOException, BadLocationException {
    }

    public void insertHTML(HTMLDocument hTMLDocument, int n, String string, int n2, int n3, HTML.Tag tag) throws BadLocationException, IOException {
    }

    public void write(Writer writer, Document document, int n, int n2) throws IOException, BadLocationException {
    }

    public void install(JEditorPane jEditorPane) {
    }

    public void deinstall(JEditorPane jEditorPane) {
    }

    public void setStyleSheet(StyleSheet styleSheet) {
    }

    public StyleSheet getStyleSheet() {
        return null;
    }

    public Action[] getActions() {
        return null;
    }

    protected void createInputAttributes(Element element, MutableAttributeSet mutableAttributeSet) {
    }

    public MutableAttributeSet getInputAttributes() {
        return null;
    }

    public void setDefaultCursor(Cursor cursor) {
    }

    public Cursor getDefaultCursor() {
        return null;
    }

    public void setLinkCursor(Cursor cursor) {
    }

    public Cursor getLinkCursor() {
        return null;
    }

    public boolean isAutoFormSubmission() {
        return false;
    }

    public void setAutoFormSubmission(boolean bl) {
    }

    public Object clone() {
        return null;
    }

    protected Parser getParser() {
        return null;
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    static class ActivateLinkAction
    extends TextAction {
        public ActivateLinkAction(String actionName) {
            super(actionName);
        }

        private void activateLink(String href, HTMLDocument doc, JEditorPane editor, int offset) {
            try {
                URL page = (URL)doc.getProperty("stream");
                URL url = new URL(page, href);
                HyperlinkEvent linkEvent = new HyperlinkEvent(editor, HyperlinkEvent.EventType.ACTIVATED, url, url.toExternalForm(), doc.getCharacterElement(offset));
                editor.fireHyperlinkUpdate(linkEvent);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }

        private void doObjectAction(JEditorPane editor, Element elem) {
            AccessibleAction aa;
            AccessibleContext ac;
            ObjectView objectView;
            Component comp;
            View view = this.getView(editor, elem);
            if (view instanceof ObjectView && (comp = (objectView = (ObjectView)view).getComponent()) instanceof Accessible && (ac = comp.getAccessibleContext()) != null && (aa = ac.getAccessibleAction()) != null) {
                aa.doAccessibleAction(0);
            }
        }

        private View getRootView(JEditorPane editor) {
            return editor.getUI().getRootView(editor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private View getView(JEditorPane editor, Element elem) {
            Object lock = this.lock(editor);
            try {
                View rootView = this.getRootView(editor);
                int start = elem.getStartOffset();
                if (rootView != null) {
                    View view = this.getView(rootView, elem, start);
                    return view;
                }
                View view = null;
                return view;
            }
            finally {
                this.unlock(lock);
            }
        }

        private View getView(View parent, Element elem, int start) {
            if (parent.getElement() == elem) {
                return parent;
            }
            int index = parent.getViewIndex(start, Position.Bias.Forward);
            if (index != -1 && index < parent.getViewCount()) {
                return this.getView(parent.getView(index), elem, start);
            }
            return null;
        }

        private Object lock(JEditorPane editor) {
            Document document = editor.getDocument();
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
                return document;
            }
            return null;
        }

        private void unlock(Object key) {
            if (key != null) {
                ((AbstractDocument)key).readUnlock();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Element currentElement;
            JTextComponent c = this.getTextComponent(e);
            if (c.isEditable() || !(c instanceof JEditorPane)) {
                return;
            }
            JEditorPane editor = (JEditorPane)c;
            Document d = editor.getDocument();
            if (!(d instanceof HTMLDocument)) {
                return;
            }
            HTMLDocument doc = (HTMLDocument)d;
            ElementIterator ei = new ElementIterator(doc);
            int currentOffset = editor.getCaretPosition();
            Object urlString = null;
            Object objString = null;
            while ((currentElement = ei.next()) != null) {
                Object obj;
                String name = currentElement.getName();
                AttributeSet attr = currentElement.getAttributes();
                Object href = HTMLEditorKit.getAttrValue((AttributeSet)attr, (HTML.Attribute)HTML.Attribute.HREF);
                if (href != null) {
                    if (currentOffset < currentElement.getStartOffset() || currentOffset > currentElement.getEndOffset()) continue;
                    this.activateLink((String)href, doc, editor, currentOffset);
                    return;
                }
                if (!name.equals(HTML.Tag.OBJECT.toString()) || (obj = HTMLEditorKit.getAttrValue((AttributeSet)attr, (HTML.Attribute)HTML.Attribute.CLASSID)) == null || currentOffset < currentElement.getStartOffset() || currentOffset > currentElement.getEndOffset()) continue;
                this.doObjectAction(editor, currentElement);
                return;
            }
        }
    }

    public static class HTMLFactory
    implements ViewFactory {
        public View create(Element element) {
            return null;
        }

        static class BodyBlockView
        extends BlockView
        implements ComponentListener {
            private Reference<JViewport> cachedViewPort = null;
            private boolean isListening = false;
            private int viewVisibleWidth = Integer.MAX_VALUE;
            private int componentVisibleWidth = Integer.MAX_VALUE;

            public BodyBlockView(Element elem) {
                super(elem, 1);
            }

            @Override
            protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
                r = super.calculateMajorAxisRequirements(axis, r);
                r.maximum = Integer.MAX_VALUE;
                return r;
            }

            @Override
            protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
                Container container;
                Container container2 = this.getContainer();
                if (container2 instanceof JEditorPane && (container = container2.getParent()) instanceof JViewport) {
                    JViewport viewPort = (JViewport)container;
                    if (this.cachedViewPort != null) {
                        cachedObject = this.cachedViewPort.get();
                        if (cachedObject != null) {
                            if (cachedObject != viewPort) {
                                cachedObject.removeComponentListener(this);
                            }
                        } else {
                            this.cachedViewPort = null;
                        }
                    }
                    if (this.cachedViewPort == null) {
                        viewPort.addComponentListener(this);
                        this.cachedViewPort = new WeakReference<JViewport>(viewPort);
                    }
                    this.componentVisibleWidth = viewPort.getExtentSize().width;
                    if (this.componentVisibleWidth > 0) {
                        Insets insets = container2.getInsets();
                        this.viewVisibleWidth = this.componentVisibleWidth - insets.left - this.getLeftInset();
                        targetSpan = Math.min(targetSpan, this.viewVisibleWidth);
                    }
                } else if (this.cachedViewPort != null) {
                    cachedObject = this.cachedViewPort.get();
                    if (cachedObject != null) {
                        cachedObject.removeComponentListener(this);
                    }
                    this.cachedViewPort = null;
                }
                super.layoutMinorAxis(targetSpan, axis, offsets, spans);
            }

            @Override
            public void setParent(View parent) {
                if (parent == null && this.cachedViewPort != null) {
                    JViewport cachedObject = this.cachedViewPort.get();
                    if (cachedObject != null) {
                        cachedObject.removeComponentListener(this);
                    }
                    this.cachedViewPort = null;
                }
                super.setParent(parent);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void componentResized(ComponentEvent e) {
                Document doc;
                if (!(e.getSource() instanceof JViewport)) {
                    return;
                }
                JViewport viewPort = (JViewport)e.getSource();
                if (this.componentVisibleWidth != viewPort.getExtentSize().width && (doc = this.getDocument()) instanceof AbstractDocument) {
                    AbstractDocument document = (AbstractDocument)this.getDocument();
                    document.readLock();
                    try {
                        this.layoutChanged(0);
                        this.preferenceChanged(null, true, true);
                    }
                    finally {
                        document.readUnlock();
                    }
                }
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        }
    }

    public static abstract class HTMLTextAction
    extends StyledEditorKit.StyledTextAction {
        public HTMLTextAction(String string) {
        }

        protected HTMLDocument getHTMLDocument(JEditorPane jEditorPane) {
            return null;
        }

        protected HTMLEditorKit getHTMLEditorKit(JEditorPane jEditorPane) {
            return null;
        }

        protected Element[] getElementsAt(HTMLDocument hTMLDocument, int n) {
            return null;
        }

        protected int elementCountToTag(HTMLDocument hTMLDocument, int n, HTML.Tag tag) {
            return 0;
        }

        protected Element findElementMatchingTag(HTMLDocument hTMLDocument, int n, HTML.Tag tag) {
            return null;
        }
    }

    static class InsertHRAction
    extends InsertHTMLTextAction {
        InsertHRAction() {
            super("InsertHR", "<hr>", null, HTML.Tag.IMPLIED, null, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            int offset;
            HTMLDocument doc;
            Element paragraph;
            JEditorPane editor = this.getEditor(ae);
            if (editor != null && (paragraph = (doc = this.getHTMLDocument(editor)).getParagraphElement(offset = editor.getSelectionStart())).getParentElement() != null) {
                this.parentTag = (HTML.Tag)paragraph.getParentElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
                super.actionPerformed(ae);
            }
        }
    }

    public static class InsertHTMLTextAction
    extends HTMLTextAction {
        protected String html;
        protected HTML.Tag parentTag;
        protected HTML.Tag addTag;
        protected HTML.Tag alternateParentTag;
        protected HTML.Tag alternateAddTag;

        public InsertHTMLTextAction(String string, String string2, HTML.Tag tag, HTML.Tag tag2) {
        }

        public InsertHTMLTextAction(String string, String string2, HTML.Tag tag, HTML.Tag tag2, HTML.Tag tag3, HTML.Tag tag4) {
        }

        protected void insertHTML(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n, String string, int n2, int n3, HTML.Tag tag) {
        }

        protected void insertAtBoundary(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n, Element element, String string, HTML.Tag tag, HTML.Tag tag2) {
        }

        @Deprecated
        protected void insertAtBoundry(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n, Element element, String string, HTML.Tag tag, HTML.Tag tag2) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public static class LinkController
    extends MouseAdapter
    implements MouseMotionListener,
    Serializable {
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        protected void activateLink(int n, JEditorPane jEditorPane) {
        }
    }

    static class NavigateLinkAction
    extends TextAction
    implements CaretListener {
        private static final FocusHighlightPainter focusPainter = new FocusHighlightPainter(null);
        private final boolean focusBack;

        public NavigateLinkAction(String actionName) {
            super(actionName);
            this.focusBack = "previous-link-action".equals(actionName);
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            JTextComponent comp;
            HTMLEditorKit kit;
            Object src = e.getSource();
            if (src instanceof JTextComponent && (kit = this.getHTMLEditorKit(comp = (JTextComponent)src)) != null && kit.foundLink) {
                kit.foundLink = false;
                comp.getAccessibleContext().firePropertyChange("AccessibleHypertextOffset", kit.prevHypertextOffset, e.getDot());
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Element nextElement;
            JTextComponent comp = this.getTextComponent(e);
            if (comp == null || comp.isEditable()) {
                return;
            }
            Document doc = comp.getDocument();
            HTMLEditorKit kit = this.getHTMLEditorKit(comp);
            if (doc == null || kit == null) {
                return;
            }
            ElementIterator ei = new ElementIterator(doc);
            int currentOffset = comp.getCaretPosition();
            int prevStartOffset = -1;
            int prevEndOffset = -1;
            while ((nextElement = ei.next()) != null) {
                String name = nextElement.getName();
                AttributeSet attr = nextElement.getAttributes();
                Object href = HTMLEditorKit.getAttrValue((AttributeSet)attr, (HTML.Attribute)HTML.Attribute.HREF);
                if (!name.equals(HTML.Tag.OBJECT.toString()) && href == null) continue;
                int elementOffset = nextElement.getStartOffset();
                if (this.focusBack) {
                    if (elementOffset >= currentOffset && prevStartOffset >= 0) {
                        kit.foundLink = true;
                        comp.setCaretPosition(prevStartOffset);
                        this.moveCaretPosition(comp, kit, prevStartOffset, prevEndOffset);
                        kit.prevHypertextOffset = prevStartOffset;
                        return;
                    }
                } else if (elementOffset > currentOffset) {
                    kit.foundLink = true;
                    comp.setCaretPosition(elementOffset);
                    this.moveCaretPosition(comp, kit, elementOffset, nextElement.getEndOffset());
                    kit.prevHypertextOffset = elementOffset;
                    return;
                }
                prevStartOffset = nextElement.getStartOffset();
                prevEndOffset = nextElement.getEndOffset();
            }
            if (this.focusBack && prevStartOffset >= 0) {
                kit.foundLink = true;
                comp.setCaretPosition(prevStartOffset);
                this.moveCaretPosition(comp, kit, prevStartOffset, prevEndOffset);
                kit.prevHypertextOffset = prevStartOffset;
            }
        }

        private void moveCaretPosition(JTextComponent comp, HTMLEditorKit kit, int mark, int dot) {
            Highlighter h = comp.getHighlighter();
            if (h != null) {
                int p0 = Math.min(dot, mark);
                int p1 = Math.max(dot, mark);
                try {
                    if (kit.linkNavigationTag != null) {
                        h.changeHighlight(kit.linkNavigationTag, p0, p1);
                    } else {
                        kit.linkNavigationTag = h.addHighlight(p0, p1, focusPainter);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        private HTMLEditorKit getHTMLEditorKit(JTextComponent comp) {
            EditorKit kit;
            if (comp instanceof JEditorPane && (kit = ((JEditorPane)comp).getEditorKit()) instanceof HTMLEditorKit) {
                return (HTMLEditorKit)kit;
            }
            return null;
        }

        static class FocusHighlightPainter
        extends DefaultHighlighter.DefaultHighlightPainter {
            FocusHighlightPainter(Color color) {
                super(color);
            }

            @Override
            public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
                Color color = this.getColor();
                if (color == null) {
                    g.setColor(c.getSelectionColor());
                } else {
                    g.setColor(color);
                }
                if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
                    Rectangle alloc = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
                    g.drawRect(alloc.x, alloc.y, alloc.width - 1, alloc.height);
                    return alloc;
                }
                try {
                    Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
                    Rectangle r = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                    g.drawRect(r.x, r.y, r.width - 1, r.height);
                    return r;
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
            }
        }
    }

    public static abstract class Parser {
        public abstract void parse(Reader var1, ParserCallback var2, boolean var3) throws IOException;
    }

    public static class ParserCallback {
        public static final Object IMPLIED;

        public void flush() throws BadLocationException {
        }

        public void handleText(char[] cArray, int n) {
        }

        public void handleComment(char[] cArray, int n) {
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
        }

        public void handleEndTag(HTML.Tag tag, int n) {
        }

        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
        }

        public void handleError(String string, int n) {
        }

        public void handleEndOfLineString(String string) {
        }
    }
}

