/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableHeightLayoutCache
extends AbstractLayoutCache {
    @Override
    public void setModel(TreeModel treeModel) {
    }

    @Override
    public void setRootVisible(boolean bl) {
    }

    @Override
    public void setRowHeight(int n) {
    }

    @Override
    public void setNodeDimensions(AbstractLayoutCache.NodeDimensions nodeDimensions) {
    }

    @Override
    public void setExpandedState(TreePath treePath, boolean bl) {
    }

    @Override
    public boolean getExpandedState(TreePath treePath) {
        return false;
    }

    @Override
    public Rectangle getBounds(TreePath treePath, Rectangle rectangle) {
        return null;
    }

    @Override
    public TreePath getPathForRow(int n) {
        return null;
    }

    @Override
    public int getRowForPath(TreePath treePath) {
        return 0;
    }

    @Override
    public int getRowCount() {
        return 0;
    }

    @Override
    public void invalidatePathBounds(TreePath treePath) {
    }

    @Override
    public int getPreferredHeight() {
        return 0;
    }

    @Override
    public int getPreferredWidth(Rectangle rectangle) {
        return 0;
    }

    @Override
    public TreePath getPathClosestTo(int n, int n2) {
        return null;
    }

    @Override
    public Enumeration<TreePath> getVisiblePathsFrom(TreePath treePath) {
        return null;
    }

    @Override
    public int getVisibleChildCount(TreePath treePath) {
        return 0;
    }

    @Override
    public void invalidateSizes() {
    }

    @Override
    public boolean isExpanded(TreePath treePath) {
        return false;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
    }

    private class TreeStateNode
    extends DefaultMutableTreeNode {
        protected int preferredWidth;
        protected int preferredHeight;
        protected int xOrigin;
        protected int yOrigin;
        protected boolean expanded;
        protected boolean hasBeenExpanded;
        protected TreePath path;

        public TreeStateNode(Object value) {
            super(value);
        }

        @Override
        public void setParent(MutableTreeNode parent) {
            super.setParent(parent);
            if (parent != null) {
                this.path = ((TreeStateNode)parent).getTreePath().pathByAddingChild(this.getUserObject());
                VariableHeightLayoutCache.this.addMapping(this);
            }
        }

        @Override
        public void remove(int childIndex) {
            TreeStateNode node = (TreeStateNode)this.getChildAt(childIndex);
            node.removeFromMapping();
            super.remove(childIndex);
        }

        @Override
        public void setUserObject(Object o) {
            super.setUserObject(o);
            if (this.path != null) {
                TreeStateNode parent = (TreeStateNode)this.getParent();
                if (parent != null) {
                    this.resetChildrenPaths(parent.getTreePath());
                } else {
                    this.resetChildrenPaths(null);
                }
            }
        }

        @Override
        public Enumeration<TreeNode> children() {
            if (!this.isExpanded()) {
                return DefaultMutableTreeNode.EMPTY_ENUMERATION;
            }
            return super.children();
        }

        @Override
        public boolean isLeaf() {
            return VariableHeightLayoutCache.this.getModel().isLeaf(this.getValue());
        }

        public Rectangle getNodeBounds(Rectangle placeIn) {
            if (placeIn == null) {
                placeIn = new Rectangle(this.getXOrigin(), this.getYOrigin(), this.getPreferredWidth(), this.getPreferredHeight());
            } else {
                placeIn.x = this.getXOrigin();
                placeIn.y = this.getYOrigin();
                placeIn.width = this.getPreferredWidth();
                placeIn.height = this.getPreferredHeight();
            }
            return placeIn;
        }

        public int getXOrigin() {
            if (!this.hasValidSize()) {
                this.updatePreferredSize(this.getRow());
            }
            return this.xOrigin;
        }

        public int getYOrigin() {
            if (VariableHeightLayoutCache.this.isFixedRowHeight()) {
                int aRow = this.getRow();
                if (aRow == -1) {
                    return -1;
                }
                return VariableHeightLayoutCache.this.getRowHeight() * aRow;
            }
            return this.yOrigin;
        }

        public int getPreferredHeight() {
            if (VariableHeightLayoutCache.this.isFixedRowHeight()) {
                return VariableHeightLayoutCache.this.getRowHeight();
            }
            if (!this.hasValidSize()) {
                this.updatePreferredSize(this.getRow());
            }
            return this.preferredHeight;
        }

        public int getPreferredWidth() {
            if (!this.hasValidSize()) {
                this.updatePreferredSize(this.getRow());
            }
            return this.preferredWidth;
        }

        public boolean hasValidSize() {
            return this.preferredHeight != 0;
        }

        public int getRow() {
            return VariableHeightLayoutCache.this.visibleNodes.indexOf(this);
        }

        public boolean hasBeenExpanded() {
            return this.hasBeenExpanded;
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public TreeStateNode getLastVisibleNode() {
            TreeStateNode node = this;
            while (node.isExpanded() && node.getChildCount() > 0) {
                node = (TreeStateNode)node.getLastChild();
            }
            return node;
        }

        public boolean isVisible() {
            if (this == VariableHeightLayoutCache.this.root) {
                return true;
            }
            TreeStateNode parent = (TreeStateNode)this.getParent();
            return parent != null && parent.isExpanded() && parent.isVisible();
        }

        public int getModelChildCount() {
            if (this.hasBeenExpanded) {
                return super.getChildCount();
            }
            return VariableHeightLayoutCache.this.getModel().getChildCount(this.getValue());
        }

        public int getVisibleChildCount() {
            int childCount = 0;
            if (this.isExpanded()) {
                int maxCounter = this.getChildCount();
                childCount += maxCounter;
                for (int counter = 0; counter < maxCounter; ++counter) {
                    childCount += ((TreeStateNode)this.getChildAt(counter)).getVisibleChildCount();
                }
            }
            return childCount;
        }

        public void toggleExpanded() {
            if (this.isExpanded()) {
                this.collapse();
            } else {
                this.expand();
            }
        }

        public void makeVisible() {
            TreeStateNode parent = (TreeStateNode)this.getParent();
            if (parent != null) {
                parent.expandParentAndReceiver();
            }
        }

        public void expand() {
            this.expand(true);
        }

        public void collapse() {
            this.collapse(true);
        }

        public Object getValue() {
            return this.getUserObject();
        }

        public TreePath getTreePath() {
            return this.path;
        }

        protected void resetChildrenPaths(TreePath parentPath) {
            VariableHeightLayoutCache.this.removeMapping(this);
            this.path = parentPath == null ? new TreePath(this.getUserObject()) : parentPath.pathByAddingChild(this.getUserObject());
            VariableHeightLayoutCache.this.addMapping(this);
            for (int counter = this.getChildCount() - 1; counter >= 0; --counter) {
                ((TreeStateNode)this.getChildAt(counter)).resetChildrenPaths(this.path);
            }
        }

        protected void setYOrigin(int newYOrigin) {
            this.yOrigin = newYOrigin;
        }

        protected void shiftYOriginBy(int offset) {
            this.yOrigin += offset;
        }

        protected void updatePreferredSize() {
            this.updatePreferredSize(this.getRow());
        }

        protected void updatePreferredSize(int index) {
            Rectangle bounds = VariableHeightLayoutCache.this.getNodeDimensions(this.getUserObject(), index, this.getLevel(), this.isExpanded(), VariableHeightLayoutCache.this.boundsBuffer);
            if (bounds == null || bounds.height == 0) {
                this.xOrigin = 0;
                this.preferredHeight = 0;
                this.preferredWidth = 0;
                VariableHeightLayoutCache.this.updateNodeSizes = true;
            } else {
                this.xOrigin = bounds.x;
                this.preferredWidth = bounds.width;
                this.preferredHeight = VariableHeightLayoutCache.this.isFixedRowHeight() ? VariableHeightLayoutCache.this.getRowHeight() : bounds.height;
            }
        }

        protected void markSizeInvalid() {
            this.preferredHeight = 0;
        }

        protected void deepMarkSizeInvalid() {
            this.markSizeInvalid();
            for (int counter = this.getChildCount() - 1; counter >= 0; --counter) {
                ((TreeStateNode)this.getChildAt(counter)).deepMarkSizeInvalid();
            }
        }

        protected Enumeration<TreeNode> getLoadedChildren(boolean createIfNeeded) {
            if (!createIfNeeded || this.hasBeenExpanded) {
                return super.children();
            }
            Object realNode = this.getValue();
            TreeModel treeModel = VariableHeightLayoutCache.this.getModel();
            int count = treeModel.getChildCount(realNode);
            this.hasBeenExpanded = true;
            int childRow = this.getRow();
            if (childRow == -1) {
                for (int i = 0; i < count; ++i) {
                    TreeStateNode newNode = VariableHeightLayoutCache.this.createNodeForValue(treeModel.getChild(realNode, i));
                    this.add(newNode);
                    newNode.updatePreferredSize(-1);
                }
            } else {
                ++childRow;
                for (int i = 0; i < count; ++i) {
                    TreeStateNode newNode = VariableHeightLayoutCache.this.createNodeForValue(treeModel.getChild(realNode, i));
                    this.add(newNode);
                    newNode.updatePreferredSize(childRow++);
                }
            }
            return super.children();
        }

        protected void didAdjustTree() {
        }

        protected void expandParentAndReceiver() {
            TreeStateNode parent = (TreeStateNode)this.getParent();
            if (parent != null) {
                parent.expandParentAndReceiver();
            }
            this.expand();
        }

        protected void expand(boolean adjustTree) {
            if (!this.isExpanded() && !this.isLeaf()) {
                int newYOrigin;
                boolean isFixed = VariableHeightLayoutCache.this.isFixedRowHeight();
                int startHeight = this.getPreferredHeight();
                int originalRow = this.getRow();
                this.expanded = true;
                this.updatePreferredSize(originalRow);
                if (!this.hasBeenExpanded) {
                    Object realNode = this.getValue();
                    TreeModel treeModel = VariableHeightLayoutCache.this.getModel();
                    int count = treeModel.getChildCount(realNode);
                    int offset = originalRow == -1 ? -1 : originalRow + 1;
                    this.hasBeenExpanded = true;
                    for (int i = 0; i < count; ++i) {
                        TreeStateNode newNode = VariableHeightLayoutCache.this.createNodeForValue(treeModel.getChild(realNode, i));
                        this.add(newNode);
                        newNode.updatePreferredSize(offset);
                    }
                }
                int i = originalRow;
                Enumeration cursor = this.preorderEnumeration();
                cursor.nextElement();
                int n = newYOrigin = isFixed || this == VariableHeightLayoutCache.this.root && !VariableHeightLayoutCache.this.isRootVisible() ? 0 : this.getYOrigin() + this.getPreferredHeight();
                if (!isFixed) {
                    while (cursor.hasMoreElements()) {
                        TreeStateNode aNode = (TreeStateNode)cursor.nextElement();
                        if (!VariableHeightLayoutCache.this.updateNodeSizes && !aNode.hasValidSize()) {
                            aNode.updatePreferredSize(i + 1);
                        }
                        aNode.setYOrigin(newYOrigin);
                        newYOrigin += aNode.getPreferredHeight();
                        VariableHeightLayoutCache.this.visibleNodes.insertElementAt(aNode, ++i);
                    }
                } else {
                    while (cursor.hasMoreElements()) {
                        TreeStateNode aNode = (TreeStateNode)cursor.nextElement();
                        VariableHeightLayoutCache.this.visibleNodes.insertElementAt(aNode, ++i);
                    }
                }
                if (adjustTree && (originalRow != i || this.getPreferredHeight() != startHeight)) {
                    if (!isFixed && ++i < VariableHeightLayoutCache.this.getRowCount()) {
                        int heightDiff = newYOrigin - (this.getYOrigin() + this.getPreferredHeight()) + (this.getPreferredHeight() - startHeight);
                        for (int counter = VariableHeightLayoutCache.this.visibleNodes.size() - 1; counter >= i; --counter) {
                            ((TreeStateNode)VariableHeightLayoutCache.this.visibleNodes.elementAt(counter)).shiftYOriginBy(heightDiff);
                        }
                    }
                    this.didAdjustTree();
                    VariableHeightLayoutCache.this.visibleNodesChanged();
                }
                if (VariableHeightLayoutCache.this.treeSelectionModel != null) {
                    VariableHeightLayoutCache.this.treeSelectionModel.resetRowSelection();
                }
            }
        }

        protected void collapse(boolean adjustTree) {
            if (this.isExpanded()) {
                int counter;
                Enumeration cursor = this.preorderEnumeration();
                cursor.nextElement();
                int rowsDeleted = 0;
                boolean isFixed = VariableHeightLayoutCache.this.isFixedRowHeight();
                int lastYEnd = isFixed ? 0 : this.getPreferredHeight() + this.getYOrigin();
                int startHeight = this.getPreferredHeight();
                int startYEnd = lastYEnd;
                int myRow = this.getRow();
                if (!isFixed) {
                    while (cursor.hasMoreElements()) {
                        node = (TreeStateNode)cursor.nextElement();
                        if (!node.isVisible()) continue;
                        ++rowsDeleted;
                        lastYEnd = node.getYOrigin() + node.getPreferredHeight();
                    }
                } else {
                    while (cursor.hasMoreElements()) {
                        node = (TreeStateNode)cursor.nextElement();
                        if (!node.isVisible()) continue;
                        ++rowsDeleted;
                    }
                }
                for (counter = rowsDeleted + myRow; counter > myRow; --counter) {
                    VariableHeightLayoutCache.this.visibleNodes.removeElementAt(counter);
                }
                this.expanded = false;
                if (myRow == -1) {
                    this.markSizeInvalid();
                } else if (adjustTree) {
                    this.updatePreferredSize(myRow);
                }
                if (myRow != -1 && adjustTree && (rowsDeleted > 0 || startHeight != this.getPreferredHeight())) {
                    if (!isFixed && myRow + 1 < VariableHeightLayoutCache.this.getRowCount() && (startYEnd += this.getPreferredHeight() - startHeight) != lastYEnd) {
                        int shiftAmount = startYEnd - lastYEnd;
                        int maxCounter = VariableHeightLayoutCache.this.visibleNodes.size();
                        for (counter = myRow + 1; counter < maxCounter; ++counter) {
                            ((TreeStateNode)VariableHeightLayoutCache.this.visibleNodes.elementAt(counter)).shiftYOriginBy(shiftAmount);
                        }
                    }
                    this.didAdjustTree();
                    VariableHeightLayoutCache.this.visibleNodesChanged();
                }
                if (VariableHeightLayoutCache.this.treeSelectionModel != null && rowsDeleted > 0 && myRow != -1) {
                    VariableHeightLayoutCache.this.treeSelectionModel.resetRowSelection();
                }
            }
        }

        protected void removeFromMapping() {
            if (this.path != null) {
                VariableHeightLayoutCache.this.removeMapping(this);
                for (int counter = this.getChildCount() - 1; counter >= 0; --counter) {
                    ((TreeStateNode)this.getChildAt(counter)).removeFromMapping();
                }
            }
        }
    }

    private class VisibleTreeStateNodeEnumeration
    implements Enumeration<TreePath> {
        protected TreeStateNode parent;
        protected int nextIndex;
        protected int childCount;

        protected VisibleTreeStateNodeEnumeration(TreeStateNode node) {
            this(node, -1);
        }

        protected VisibleTreeStateNodeEnumeration(TreeStateNode parent, int startIndex) {
            this.parent = parent;
            this.nextIndex = startIndex;
            this.childCount = this.parent.getChildCount();
        }

        @Override
        public boolean hasMoreElements() {
            return this.parent != null;
        }

        @Override
        public TreePath nextElement() {
            TreePath retObject;
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("No more visible paths");
            }
            if (this.nextIndex == -1) {
                retObject = this.parent.getTreePath();
            } else {
                TreeStateNode node = (TreeStateNode)this.parent.getChildAt(this.nextIndex);
                retObject = node.getTreePath();
            }
            this.updateNextObject();
            return retObject;
        }

        protected void updateNextObject() {
            if (!this.updateNextIndex()) {
                this.findNextValidParent();
            }
        }

        protected boolean findNextValidParent() {
            if (this.parent == VariableHeightLayoutCache.this.root) {
                this.parent = null;
                return false;
            }
            while (this.parent != null) {
                TreeStateNode newParent = (TreeStateNode)this.parent.getParent();
                if (newParent != null) {
                    this.nextIndex = newParent.getIndex(this.parent);
                    this.parent = newParent;
                    this.childCount = this.parent.getChildCount();
                    if (!this.updateNextIndex()) continue;
                    return true;
                }
                this.parent = null;
            }
            return false;
        }

        protected boolean updateNextIndex() {
            if (this.nextIndex == -1 && !this.parent.isExpanded() || this.childCount == 0 || ++this.nextIndex >= this.childCount) {
                return false;
            }
            TreeStateNode child = (TreeStateNode)this.parent.getChildAt(this.nextIndex);
            if (child != null && child.isExpanded()) {
                this.parent = child;
                this.nextIndex = -1;
                this.childCount = child.getChildCount();
            }
            return true;
        }
    }
}

