/*
 * Decompiled with CFR 0.152.
 */
package com.anvisics.jleveldb;

public class ArraySerializer {
    public static final int START_ARRAY = 1;
    public static final int ELEMENT = 2;
    public static final int END_ARRAY = 3;
    public static final int END = 4;

    public static void startArray(StringBuilder stringBuilder, boolean bl) {
        if (!bl) {
            stringBuilder.append(",");
        }
        stringBuilder.append("[");
    }

    public static void value(StringBuilder stringBuilder, String string, boolean bl) {
        if (!bl) {
            stringBuilder.append(",");
        }
        string = string.replace("\\", "\\\\");
        string = string.replace("[", "\\[").replace("]", "\\]").replace(",", "\\,");
        stringBuilder.append(string);
    }

    public static void endArray(StringBuilder stringBuilder) {
        stringBuilder.append("]");
    }

    private static void testCase(String string, String[] stringArray) {
        int n;
        EntityValueTokenizer entityValueTokenizer = new EntityValueTokenizer();
        entityValueTokenizer.tokenize(string);
        int n2 = 0;
        while ((n = entityValueTokenizer.next()) != 4) {
            if (n == 2) {
                ArraySerializer.assertEquals(stringArray[n2], entityValueTokenizer.value(), string + " " + n2);
            } else if (n == 1) {
                ArraySerializer.assertEquals(stringArray[n2], "[", string + " " + n2);
            } else if (n == 3) {
                ArraySerializer.assertEquals(stringArray[n2], "]", string + " " + n2);
            }
            ++n2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.equals("[")) {
                ArraySerializer.startArray(stringBuilder, bl);
                bl = true;
                continue;
            }
            if (string2.equals("]")) {
                ArraySerializer.endArray(stringBuilder);
                continue;
            }
            ArraySerializer.value(stringBuilder, string2, bl);
            bl = false;
        }
        String string3 = stringBuilder.toString().replace("\\\\", "\\");
        if (!string3.equals(string) && !stringBuilder.toString().equals(string)) {
            System.err.println("Serialization of value is probably wrong : " + string3 + " original " + string);
        }
    }

    private static void assertEquals(String string, String string2, String string3) {
        if (!string.equals(string2)) {
            throw new IllegalArgumentException("Expected '" + string + "' != '" + string2 + "' : " + string3);
        }
    }

    private static void testCases() {
        ArraySerializer.testCase("[1,2,[]]", new String[]{"[", "1", "2", "[", "]", "]"});
        ArraySerializer.testCase("[[1,2],[1,2]]", new String[]{"[", "[", "1", "2", "]", "[", "1", "2", "]", "]"});
        ArraySerializer.testCase("[1, 2, 4,[1,3\\,4]]", new String[]{"[", "1", " 2", " 4", "[", "1", "3,4", "]", "]"});
        ArraySerializer.testCase("[1,4,\\[1,3\\,4\\]]", new String[]{"[", "1", "4", "[1", "3,4]", "]"});
        ArraySerializer.testCase("[1,\\4,3\\[,4\\]]", new String[]{"[", "1", "\\4", "3[", "4]", "]"});
        ArraySerializer.testCase("[1,\\4,3\\[,4\\]]", new String[]{"[", "1", "\\4", "3[", "4]", "]"});
        ArraySerializer.testCase("[1,\\\\,3]", new String[]{"[", "1", "\\", "3", "]"});
        ArraySerializer.testCase("[\\\\1,\\\\2,333\\\\]", new String[]{"[", "\\1", "\\2", "333\\", "]"});
        ArraySerializer.testCase("[2,]", new String[]{"[", "2", "", "]"});
        ArraySerializer.testCase("[,2]", new String[]{"[", "", "2", "]"});
        ArraySerializer.testCase("[,2,,]", new String[]{"[", "", "2", "", "", "]"});
        ArraySerializer.testCase("[,,]", new String[]{"[", "", "", "", "]"});
        ArraySerializer.testCase("[1,,[,,]]", new String[]{"[", "1", "", "[", "", "", "", "]", "]"});
        ArraySerializer.testCase("14555", new String[]{"14555"});
        ArraySerializer.testCase("\\[1\\]", new String[]{"[1]"});
        ArraySerializer.testCase("\\[1\\,2", new String[]{"[1,2"});
        System.out.println("All is successfull");
    }

    public static void main(String[] stringArray) {
        ArraySerializer.testCases();
    }

    public static class EntityValueTokenizer {
        private String tokenize;
        private int lastReadIndex;
        private String value;
        private boolean firstElementAfterArrayOpened;

        public EntityValueTokenizer() {
            this.tokenize("");
        }

        public void tokenize(String string) {
            this.lastReadIndex = 0;
            this.tokenize = string;
            this.value = "";
            this.firstElementAfterArrayOpened = false;
        }

        public int next() {
            boolean bl;
            int n;
            this.value = "";
            if ((n = this.lastReadIndex++) >= this.tokenize.length()) {
                return 4;
            }
            if (this.tokenize.charAt(n) == '[') {
                this.firstElementAfterArrayOpened = true;
                return 1;
            }
            if (this.tokenize.charAt(n) == ']') {
                return 3;
            }
            int n2 = n;
            if (this.tokenize.charAt(n) == ',') {
                if (this.firstElementAfterArrayOpened) {
                    this.firstElementAfterArrayOpened = false;
                    --this.lastReadIndex;
                    return 2;
                }
                ++n2;
            }
            this.firstElementAfterArrayOpened = false;
            boolean bl2 = bl = this.tokenize.charAt(n) == '\\';
            while (++n < this.tokenize.length()) {
                char c = this.tokenize.charAt(n);
                if (c == '\\') {
                    if (bl) {
                        this.value = this.value + this.tokenize.substring(n2, n - 1);
                        n2 = n;
                        bl = false;
                    } else {
                        bl = true;
                    }
                } else {
                    if (c == ',' || c == ']' || c == '[') {
                        if (!bl) {
                            if (c != '[' || this.value.length() != 0) break;
                            ++this.lastReadIndex;
                            this.firstElementAfterArrayOpened = true;
                            return 1;
                        }
                        this.value = this.value + this.tokenize.substring(n2, n - 1);
                        n2 = n;
                    }
                    bl = false;
                }
                ++this.lastReadIndex;
            }
            this.value = this.value + this.tokenize.substring(n2, n);
            return 2;
        }

        public String value() {
            return this.value;
        }
    }
}

