/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.EngineManager;
import alice.tuprolog.ExecutionContext;
import alice.tuprolog.OperatorManager;
import alice.tuprolog.Parser;
import alice.tuprolog.Prolog;
import alice.tuprolog.Struct;
import alice.tuprolog.Var;
import alice.util.OneWayList;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;

public abstract class Term
implements Serializable {
    public static final Term TRUE = new Struct("true");
    public static final Term FALSE = new Struct("false");

    public abstract boolean isNumber();

    public abstract boolean isStruct();

    public abstract boolean isVar();

    public abstract boolean isEmptyList();

    public abstract boolean isAtomic();

    public abstract boolean isCompound();

    public abstract boolean isAtom();

    public abstract boolean isList();

    public abstract boolean isGround();

    public boolean equals(Object object) {
        if (!(object instanceof Term)) {
            return false;
        }
        return this.isEqual((Term)object);
    }

    public abstract boolean isGreater(Term var1);

    public abstract boolean isEqual(Term var1);

    public abstract Term getTerm();

    public abstract void free();

    abstract long resolveTerm(long var1);

    public void resolveTerm() {
        this.resolveTerm(System.currentTimeMillis());
    }

    public Term copyGoal(AbstractMap abstractMap, int n) {
        return this.copy(abstractMap, n);
    }

    public Term copyResult(Collection collection, List list) {
        IdentityHashMap<Var, Var> identityHashMap = new IdentityHashMap<Var, Var>();
        for (Var var : collection) {
            Var var2 = new Var();
            if (!var.isAnonymous()) {
                var2 = new Var(var.getOriginalName());
            }
            identityHashMap.put(var, var2);
            list.add(var2);
        }
        return this.copy(identityHashMap, new IdentityHashMap());
    }

    abstract Term copy(AbstractMap var1, int var2);

    abstract Term copy(AbstractMap var1, AbstractMap var2);

    public boolean unify(Prolog prolog, Term term) {
        EngineManager engineManager = prolog.getEngineManager();
        this.resolveTerm();
        term.resolveTerm();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        boolean bl = this.unify(arrayList, arrayList2, term);
        if (bl) {
            ExecutionContext executionContext = engineManager.getCurrentContext();
            if (executionContext != null) {
                int n = engineManager.env == null ? -2 : engineManager.env.nDemoSteps;
                executionContext.trailingVars = new OneWayList(arrayList, executionContext.trailingVars);
                int n2 = 0;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    ((Var)iterator.next()).rename(n, n2);
                }
                iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    ((Var)iterator.next()).rename(n, n2);
                }
            }
            return true;
        }
        Var.free(arrayList);
        Var.free(arrayList2);
        return false;
    }

    public boolean match(Term term) {
        this.resolveTerm();
        term.resolveTerm();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        boolean bl = this.unify(arrayList, arrayList2, term);
        Var.free(arrayList);
        Var.free(arrayList2);
        return bl;
    }

    abstract boolean unify(List var1, List var2, Term var3);

    public static Term createTerm(String string) {
        return Parser.parseSingleTerm(string);
    }

    public static Term parse(String string) {
        return Term.createTerm(string);
    }

    public static Term createTerm(String string, OperatorManager operatorManager) {
        return Parser.parseSingleTerm(string, operatorManager);
    }

    public static Term parse(String string, OperatorManager operatorManager) {
        return Term.createTerm(string, operatorManager);
    }

    public static Iterator getIterator(String string) {
        return new Parser(string).iterator();
    }

    String toStringAsArgX(OperatorManager operatorManager, int n) {
        return this.toStringAsArg(operatorManager, n, true);
    }

    String toStringAsArgY(OperatorManager operatorManager, int n) {
        return this.toStringAsArg(operatorManager, n, false);
    }

    String toStringAsArg(OperatorManager operatorManager, int n, boolean bl) {
        return this.toString();
    }

    public Term iteratedGoalTerm() {
        return this;
    }
}

