/*
 * Decompiled with CFR 0.152.
 */
package android.support.multidex;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.multidex.MultiDexExtractor;
import android.util.Log;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;

public final class MultiDex {
    static final String TAG = "MultiDex";
    private static final String OLD_SECONDARY_FOLDER_NAME = "secondary-dexes";
    private static final String SECONDARY_FOLDER_NAME = "code_cache" + File.separator + "secondary-dexes";
    private static final int MAX_SUPPORTED_SDK_VERSION = 20;
    private static final int MIN_SDK_VERSION = 4;
    private static final int VM_WITH_MULTIDEX_VERSION_MAJOR = 2;
    private static final int VM_WITH_MULTIDEX_VERSION_MINOR = 1;
    private static final Set<String> installedApk = new HashSet<String>();
    private static final boolean IS_VM_MULTIDEX_CAPABLE = MultiDex.isVMMultidexCapable(System.getProperty("java.vm.version"));

    private MultiDex() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void install(Context context) {
        Log.i((String)TAG, (String)"install");
        if (IS_VM_MULTIDEX_CAPABLE) {
            Log.i((String)TAG, (String)"VM has multidex support, MultiDex support library is disabled.");
            return;
        }
        if (Build.VERSION.SDK_INT < 4) {
            throw new RuntimeException("Multi dex installation failed. SDK " + Build.VERSION.SDK_INT + " is unsupported. Min SDK version is " + 4 + ".");
        }
        try {
            ApplicationInfo applicationInfo = MultiDex.getApplicationInfo(context);
            if (applicationInfo == null) {
                return;
            }
            Set<String> set = installedApk;
            synchronized (set) {
                ClassLoader loader;
                String apkPath = applicationInfo.sourceDir;
                if (installedApk.contains(apkPath)) {
                    return;
                }
                installedApk.add(apkPath);
                if (Build.VERSION.SDK_INT > 20) {
                    Log.w((String)TAG, (String)("MultiDex is not guaranteed to work in SDK version " + Build.VERSION.SDK_INT + ": SDK version higher than " + 20 + " should be backed by " + "runtime with built-in multidex capabilty but it's not the " + "case here: java.vm.version=\"" + System.getProperty("java.vm.version") + "\""));
                }
                try {
                    loader = context.getClassLoader();
                }
                catch (RuntimeException e) {
                    Log.w((String)TAG, (String)"Failure while trying to obtain Context class loader. Must be running in test mode. Skip patching.", (Throwable)e);
                    return;
                }
                if (loader == null) {
                    Log.e((String)TAG, (String)"Context class loader is null. Must be running in test mode. Skip patching.");
                    return;
                }
                try {
                    MultiDex.clearOldDexDir(context);
                }
                catch (Throwable t) {
                    Log.w((String)TAG, (String)"Something went wrong when trying to clear old MultiDex extraction, continuing without cleaning.", (Throwable)t);
                }
                File dexDir = new File(applicationInfo.dataDir, SECONDARY_FOLDER_NAME);
                List<File> files = MultiDexExtractor.load(context, applicationInfo, dexDir, false);
                if (MultiDex.checkValidZipFiles(files)) {
                    MultiDex.installSecondaryDexes(loader, dexDir, files);
                } else {
                    Log.w((String)TAG, (String)"Files were not valid zip files.  Forcing a reload.");
                    files = MultiDexExtractor.load(context, applicationInfo, dexDir, true);
                    if (MultiDex.checkValidZipFiles(files)) {
                        MultiDex.installSecondaryDexes(loader, dexDir, files);
                    } else {
                        throw new RuntimeException("Zip files were not valid.");
                    }
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Multidex installation failure", (Throwable)e);
            throw new RuntimeException("Multi dex installation failed (" + e.getMessage() + ").");
        }
        Log.i((String)TAG, (String)"install done");
    }

    private static ApplicationInfo getApplicationInfo(Context context) throws PackageManager.NameNotFoundException {
        String packageName;
        PackageManager pm;
        try {
            pm = context.getPackageManager();
            packageName = context.getPackageName();
        }
        catch (RuntimeException e) {
            Log.w((String)TAG, (String)"Failure while trying to obtain ApplicationInfo from Context. Must be running in test mode. Skip patching.", (Throwable)e);
            return null;
        }
        if (pm == null || packageName == null) {
            return null;
        }
        ApplicationInfo applicationInfo = pm.getApplicationInfo(packageName, 128);
        return applicationInfo;
    }

    static boolean isVMMultidexCapable(String versionString) {
        Matcher matcher;
        boolean isMultidexCapable = false;
        if (versionString != null && (matcher = Pattern.compile("(\\d+)\\.(\\d+)(\\.\\d+)?").matcher(versionString)).matches()) {
            try {
                int major = Integer.parseInt(matcher.group(1));
                int minor = Integer.parseInt(matcher.group(2));
                isMultidexCapable = major > 2 || major == 2 && minor >= 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Log.i((String)TAG, (String)("VM with version " + versionString + (isMultidexCapable ? " has multidex support" : " does not have multidex support")));
        return isMultidexCapable;
    }

    private static void installSecondaryDexes(ClassLoader loader, File dexDir, List<File> files) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, InvocationTargetException, NoSuchMethodException, IOException {
        if (!files.isEmpty()) {
            if (Build.VERSION.SDK_INT >= 19) {
                V19.install(loader, files, dexDir);
            } else if (Build.VERSION.SDK_INT >= 14) {
                V14.install(loader, files, dexDir);
            } else {
                V4.install(loader, files);
            }
        }
    }

    private static boolean checkValidZipFiles(List<File> files) {
        for (File file : files) {
            if (MultiDexExtractor.verifyZipFile(file)) continue;
            return false;
        }
        return true;
    }

    private static Field findField(Object instance, String name) throws NoSuchFieldException {
        for (Class<?> clazz = instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(name);
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        throw new NoSuchFieldException("Field " + name + " not found in " + instance.getClass());
    }

    private static Method findMethod(Object instance, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        for (Class<?> clazz = instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Method method = clazz.getDeclaredMethod(name, parameterTypes);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                return method;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        throw new NoSuchMethodException("Method " + name + " with parameters " + Arrays.asList(parameterTypes) + " not found in " + instance.getClass());
    }

    private static void expandFieldArray(Object instance, String fieldName, Object[] extraElements) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field jlrField = MultiDex.findField(instance, fieldName);
        Object[] original = (Object[])jlrField.get(instance);
        Object[] combined = (Object[])Array.newInstance(original.getClass().getComponentType(), original.length + extraElements.length);
        System.arraycopy(original, 0, combined, 0, original.length);
        System.arraycopy(extraElements, 0, combined, original.length, extraElements.length);
        jlrField.set(instance, combined);
    }

    private static void clearOldDexDir(Context context) throws Exception {
        File dexDir = new File(context.getFilesDir(), OLD_SECONDARY_FOLDER_NAME);
        if (dexDir.isDirectory()) {
            Log.i((String)TAG, (String)("Clearing old secondary dex dir (" + dexDir.getPath() + ")."));
            File[] files = dexDir.listFiles();
            if (files == null) {
                Log.w((String)TAG, (String)("Failed to list secondary dex dir content (" + dexDir.getPath() + ")."));
                return;
            }
            for (File oldFile : files) {
                Log.i((String)TAG, (String)("Trying to delete old file " + oldFile.getPath() + " of size " + oldFile.length()));
                if (!oldFile.delete()) {
                    Log.w((String)TAG, (String)("Failed to delete old file " + oldFile.getPath()));
                    continue;
                }
                Log.i((String)TAG, (String)("Deleted old file " + oldFile.getPath()));
            }
            if (!dexDir.delete()) {
                Log.w((String)TAG, (String)("Failed to delete secondary dex dir " + dexDir.getPath()));
            } else {
                Log.i((String)TAG, (String)("Deleted old secondary dex dir " + dexDir.getPath()));
            }
        }
    }

    private static final class V4 {
        private V4() {
        }

        private static void install(ClassLoader loader, List<File> additionalClassPathEntries) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, IOException {
            int extraSize = additionalClassPathEntries.size();
            Field pathField = MultiDex.findField(loader, "path");
            StringBuilder path = new StringBuilder((String)pathField.get(loader));
            Object[] extraPaths = new String[extraSize];
            Object[] extraFiles = new File[extraSize];
            Object[] extraZips = new ZipFile[extraSize];
            Object[] extraDexs = new DexFile[extraSize];
            ListIterator<File> iterator = additionalClassPathEntries.listIterator();
            while (iterator.hasNext()) {
                File additionalEntry = iterator.next();
                String entryPath = additionalEntry.getAbsolutePath();
                path.append(':').append(entryPath);
                int index = iterator.previousIndex();
                extraPaths[index] = entryPath;
                extraFiles[index] = additionalEntry;
                extraZips[index] = new ZipFile(additionalEntry);
                extraDexs[index] = DexFile.loadDex((String)entryPath, (String)(entryPath + ".dex"), (int)0);
            }
            pathField.set(loader, path.toString());
            MultiDex.expandFieldArray(loader, "mPaths", extraPaths);
            MultiDex.expandFieldArray(loader, "mFiles", extraFiles);
            MultiDex.expandFieldArray(loader, "mZips", extraZips);
            MultiDex.expandFieldArray(loader, "mDexs", extraDexs);
        }
    }

    private static final class V14 {
        private V14() {
        }

        private static void install(ClassLoader loader, List<File> additionalClassPathEntries, File optimizedDirectory) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, InvocationTargetException, NoSuchMethodException {
            Field pathListField = MultiDex.findField(loader, "pathList");
            Object dexPathList = pathListField.get(loader);
            MultiDex.expandFieldArray(dexPathList, "dexElements", V14.makeDexElements(dexPathList, new ArrayList<File>(additionalClassPathEntries), optimizedDirectory));
        }

        private static Object[] makeDexElements(Object dexPathList, ArrayList<File> files, File optimizedDirectory) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            Method makeDexElements = MultiDex.findMethod(dexPathList, "makeDexElements", new Class[]{ArrayList.class, File.class});
            return (Object[])makeDexElements.invoke(dexPathList, files, optimizedDirectory);
        }
    }

    private static final class V19 {
        private V19() {
        }

        private static void install(ClassLoader loader, List<File> additionalClassPathEntries, File optimizedDirectory) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, InvocationTargetException, NoSuchMethodException {
            Field pathListField = MultiDex.findField(loader, "pathList");
            Object dexPathList = pathListField.get(loader);
            ArrayList<IOException> suppressedExceptions = new ArrayList<IOException>();
            MultiDex.expandFieldArray(dexPathList, "dexElements", V19.makeDexElements(dexPathList, new ArrayList<File>(additionalClassPathEntries), optimizedDirectory, suppressedExceptions));
            if (suppressedExceptions.size() > 0) {
                for (IOException e : suppressedExceptions) {
                    Log.w((String)MultiDex.TAG, (String)"Exception in makeDexElement", (Throwable)e);
                }
                Field suppressedExceptionsField = MultiDex.findField(loader, "dexElementsSuppressedExceptions");
                IOException[] dexElementsSuppressedExceptions = (IOException[])suppressedExceptionsField.get(loader);
                if (dexElementsSuppressedExceptions == null) {
                    dexElementsSuppressedExceptions = suppressedExceptions.toArray(new IOException[suppressedExceptions.size()]);
                } else {
                    IOException[] combined = new IOException[suppressedExceptions.size() + dexElementsSuppressedExceptions.length];
                    suppressedExceptions.toArray(combined);
                    System.arraycopy(dexElementsSuppressedExceptions, 0, combined, suppressedExceptions.size(), dexElementsSuppressedExceptions.length);
                    dexElementsSuppressedExceptions = combined;
                }
                suppressedExceptionsField.set(loader, dexElementsSuppressedExceptions);
            }
        }

        private static Object[] makeDexElements(Object dexPathList, ArrayList<File> files, File optimizedDirectory, ArrayList<IOException> suppressedExceptions) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            Method makeDexElements = MultiDex.findMethod(dexPathList, "makeDexElements", new Class[]{ArrayList.class, File.class, ArrayList.class});
            return (Object[])makeDexElements.invoke(dexPathList, files, optimizedDirectory, suppressedExceptions);
        }
    }
}

