/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.ImageReader;
import javax.imageio.ImageTranscoder;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageTranscoderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImageIO {
    public static void scanForPlugins() {
    }

    public static void setUseCache(boolean bl) {
    }

    public static boolean getUseCache() {
        return false;
    }

    public static void setCacheDirectory(File file) {
    }

    public static File getCacheDirectory() {
        return null;
    }

    public static ImageInputStream createImageInputStream(Object object) throws IOException {
        return null;
    }

    public static ImageOutputStream createImageOutputStream(Object object) throws IOException {
        return null;
    }

    public static String[] getReaderFormatNames() {
        return null;
    }

    public static String[] getReaderMIMETypes() {
        return null;
    }

    public static Iterator<ImageReader> getImageReaders(Object object) {
        return null;
    }

    public static Iterator<ImageReader> getImageReadersByFormatName(String string) {
        return null;
    }

    public static Iterator<ImageReader> getImageReadersBySuffix(String string) {
        return null;
    }

    public static Iterator<ImageReader> getImageReadersByMIMEType(String string) {
        return null;
    }

    public static String[] getWriterFormatNames() {
        return null;
    }

    public static String[] getWriterMIMETypes() {
        return null;
    }

    public static Iterator<ImageWriter> getImageWritersByFormatName(String string) {
        return null;
    }

    public static Iterator<ImageWriter> getImageWritersBySuffix(String string) {
        return null;
    }

    public static Iterator<ImageWriter> getImageWritersByMIMEType(String string) {
        return null;
    }

    public static ImageWriter getImageWriter(ImageReader imageReader) {
        return null;
    }

    public static ImageReader getImageReader(ImageWriter imageWriter) {
        return null;
    }

    public static Iterator<ImageWriter> getImageWriters(ImageTypeSpecifier imageTypeSpecifier, String string) {
        return null;
    }

    public static Iterator<ImageTranscoder> getImageTranscoders(ImageReader imageReader, ImageWriter imageWriter) {
        return null;
    }

    public static BufferedImage read(File file) throws IOException {
        return null;
    }

    public static BufferedImage read(InputStream inputStream) throws IOException {
        return null;
    }

    public static BufferedImage read(URL uRL) throws IOException {
        return null;
    }

    public static BufferedImage read(ImageInputStream imageInputStream) throws IOException {
        return null;
    }

    public static boolean write(RenderedImage renderedImage, String string, ImageOutputStream imageOutputStream) throws IOException {
        return false;
    }

    public static boolean write(RenderedImage renderedImage, String string, File file) throws IOException {
        return false;
    }

    public static boolean write(RenderedImage renderedImage, String string, OutputStream outputStream) throws IOException {
        return false;
    }

    static class CacheInfo {
        boolean useCache = true;
        File cacheDirectory = null;
        Boolean hasPermission = null;

        public boolean getUseCache() {
            return this.useCache;
        }

        public void setUseCache(boolean useCache) {
            this.useCache = useCache;
        }

        public File getCacheDirectory() {
            return this.cacheDirectory;
        }

        public void setCacheDirectory(File cacheDirectory) {
            this.cacheDirectory = cacheDirectory;
        }

        public Boolean getHasPermission() {
            return this.hasPermission;
        }

        public void setHasPermission(Boolean hasPermission) {
            this.hasPermission = hasPermission;
        }
    }

    static class CanDecodeInputFilter
    implements ServiceRegistry.Filter {
        Object input;

        public CanDecodeInputFilter(Object input) {
            this.input = input;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean filter(Object elt) {
            try {
                ImageReaderSpi spi = (ImageReaderSpi)elt;
                ImageInputStream stream = null;
                if (this.input instanceof ImageInputStream) {
                    stream = (ImageInputStream)this.input;
                }
                boolean canDecode = false;
                if (stream != null) {
                    stream.mark();
                }
                try {
                    canDecode = spi.canDecodeInput(this.input);
                }
                finally {
                    if (stream != null) {
                        stream.reset();
                    }
                }
                return canDecode;
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    static class CanEncodeImageAndFormatFilter
    implements ServiceRegistry.Filter {
        ImageTypeSpecifier type;
        String formatName;

        public CanEncodeImageAndFormatFilter(ImageTypeSpecifier type, String formatName) {
            this.type = type;
            this.formatName = formatName;
        }

        @Override
        public boolean filter(Object elt) {
            ImageWriterSpi spi = (ImageWriterSpi)elt;
            return Arrays.asList(spi.getFormatNames()).contains(this.formatName) && spi.canEncodeImage(this.type);
        }
    }

    static class ContainsFilter
    implements ServiceRegistry.Filter {
        Method method;
        String name;

        public ContainsFilter(Method method, String name) {
            this.method = method;
            this.name = name;
        }

        @Override
        public boolean filter(Object elt) {
            try {
                return ImageIO.contains((String[])((String[])this.method.invoke(elt, new Object[0])), (String)this.name);
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    static class ImageReaderIterator
    implements Iterator<ImageReader> {
        private Iterator<ImageReaderSpi> iter;

        public ImageReaderIterator(Iterator<ImageReaderSpi> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public ImageReader next() {
            ImageReaderSpi spi = null;
            try {
                spi = this.iter.next();
                return spi.createReaderInstance();
            }
            catch (IOException e) {
                theRegistry.deregisterServiceProvider(spi, ImageReaderSpi.class);
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class ImageTranscoderIterator
    implements Iterator<ImageTranscoder> {
        public Iterator<ImageTranscoderSpi> iter;

        public ImageTranscoderIterator(Iterator<ImageTranscoderSpi> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public ImageTranscoder next() {
            ImageTranscoderSpi spi = null;
            spi = this.iter.next();
            return spi.createTranscoderInstance();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class ImageWriterIterator
    implements Iterator<ImageWriter> {
        private Iterator<ImageWriterSpi> iter;

        public ImageWriterIterator(Iterator<ImageWriterSpi> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public ImageWriter next() {
            ImageWriterSpi spi = null;
            try {
                spi = this.iter.next();
                return spi.createWriterInstance();
            }
            catch (IOException e) {
                theRegistry.deregisterServiceProvider(spi, ImageWriterSpi.class);
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class TranscoderFilter
    implements ServiceRegistry.Filter {
        String readerSpiName;
        String writerSpiName;

        public TranscoderFilter(ImageReaderSpi readerSpi, ImageWriterSpi writerSpi) {
            this.readerSpiName = readerSpi.getClass().getName();
            this.writerSpiName = writerSpi.getClass().getName();
        }

        @Override
        public boolean filter(Object elt) {
            ImageTranscoderSpi spi = (ImageTranscoderSpi)elt;
            String readerName = spi.getReaderServiceProviderName();
            String writerName = spi.getWriterServiceProviderName();
            return readerName.equals(this.readerSpiName) && writerName.equals(this.writerSpiName);
        }
    }
}

