/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import javax.security.auth.PrivateCredentialPermission;
import javax.security.auth.Subject;
import sun.security.util.ResourcesMgr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Subject
implements Serializable {
    public Subject() {
    }

    public Subject(boolean bl, Set<? extends Principal> set, Set<?> set2, Set<?> set3) {
    }

    public void setReadOnly() {
    }

    public boolean isReadOnly() {
        return false;
    }

    public static Subject getSubject(AccessControlContext accessControlContext) {
        return null;
    }

    public static Object doAs(Subject subject, PrivilegedAction privilegedAction) {
        return null;
    }

    public static Object doAs(Subject subject, PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        return null;
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedAction privilegedAction, AccessControlContext accessControlContext) {
        return null;
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedExceptionAction privilegedExceptionAction, AccessControlContext accessControlContext) throws PrivilegedActionException {
        return null;
    }

    public Set<Principal> getPrincipals() {
        return null;
    }

    public <T extends Principal> Set<T> getPrincipals(Class<T> clazz) {
        return null;
    }

    public Set<Object> getPublicCredentials() {
        return null;
    }

    public Set<Object> getPrivateCredentials() {
        return null;
    }

    public <T> Set<T> getPublicCredentials(Class<T> clazz) {
        return null;
    }

    public <T> Set<T> getPrivateCredentials(Class<T> clazz) {
        return null;
    }

    public boolean equals(Object object) {
        return false;
    }

    public String toString() {
        return null;
    }

    public int hashCode() {
        return 0;
    }

    private class ClassSet<T>
    extends AbstractSet<T> {
        private final int which;
        private final Class<T> c;
        private final Set<T> set;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClassSet(int which, Class<T> c) {
            this.which = which;
            this.c = c;
            this.set = new HashSet<T>();
            switch (which) {
                case 1: {
                    Set set = Subject.this.principals;
                    synchronized (set) {
                        this.populateSet();
                        break;
                    }
                }
                case 2: {
                    Set set = Subject.this.pubCredentials;
                    synchronized (set) {
                        this.populateSet();
                        break;
                    }
                }
                default: {
                    Set set = Subject.this.privCredentials;
                    synchronized (set) {
                        this.populateSet();
                        break;
                    }
                }
            }
        }

        private void populateSet() {
            final Iterator iterator = switch (this.which) {
                case 1 -> Subject.this.principals.iterator();
                case 2 -> Subject.this.pubCredentials.iterator();
                default -> Subject.this.privCredentials.iterator();
            };
            while (iterator.hasNext()) {
                Object next = this.which == 3 ? AccessController.doPrivileged(new PrivilegedAction<Object>(this){

                    @Override
                    public Object run() {
                        return iterator.next();
                    }
                }) : iterator.next();
                if (!this.c.isAssignableFrom(next.getClass())) continue;
                if (this.which != 3) {
                    this.set.add(next);
                    continue;
                }
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkPermission(new PrivateCredentialPermission(next.getClass().getName(), Subject.this.getPrincipals()));
                }
                this.set.add(next);
            }
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public Iterator<T> iterator() {
            return this.set.iterator();
        }

        @Override
        public boolean add(T o) {
            if (!this.c.isAssignableFrom(o.getClass())) {
                MessageFormat form = new MessageFormat(ResourcesMgr.getString("attempting.to.add.an.object.which.is.not.an.instance.of.class"));
                Object[] source = new Object[]{this.c.toString()};
                throw new SecurityException(form.format(source));
            }
            return this.set.add(o);
        }
    }

    private static class SecureSet<E>
    implements Set<E>,
    Serializable {
        private static final long serialVersionUID = 7911754171111800359L;
        private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("this$0", Subject.class), new ObjectStreamField("elements", LinkedList.class), new ObjectStreamField("which", Integer.TYPE)};
        Subject subject;
        LinkedList<E> elements;
        private int which;

        SecureSet(Subject subject, int which) {
            this.subject = subject;
            this.which = which;
            this.elements = new LinkedList();
        }

        SecureSet(Subject subject, int which, LinkedList<E> list) {
            this.subject = subject;
            this.which = which;
            this.elements = list;
        }

        @Override
        public int size() {
            return this.elements.size();
        }

        @Override
        public Iterator<E> iterator() {
            final LinkedList<E> list = this.elements;
            return new Iterator<E>(){
                final ListIterator<E> i;
                {
                    this.i = list.listIterator(0);
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public E next() {
                    if (which != 3) {
                        return this.i.next();
                    }
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        try {
                            sm.checkPermission(new PrivateCredentialPermission(list.get(this.i.nextIndex()).getClass().getName(), subject.getPrincipals()));
                        }
                        catch (SecurityException se) {
                            this.i.next();
                            throw se;
                        }
                    }
                    return this.i.next();
                }

                @Override
                public void remove() {
                    if (subject.isReadOnly()) {
                        throw new IllegalStateException(ResourcesMgr.getString("Subject.is.read.only"));
                    }
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        switch (which) {
                            case 1: {
                                sm.checkPermission(AuthPermissionHolder.MODIFY_PRINCIPALS_PERMISSION);
                                break;
                            }
                            case 2: {
                                sm.checkPermission(AuthPermissionHolder.MODIFY_PUBLIC_CREDENTIALS_PERMISSION);
                                break;
                            }
                            default: {
                                sm.checkPermission(AuthPermissionHolder.MODIFY_PRIVATE_CREDENTIALS_PERMISSION);
                            }
                        }
                    }
                    this.i.remove();
                }
            };
        }

        @Override
        public boolean add(E o) {
            Objects.requireNonNull(o, ResourcesMgr.getString("invalid.null.input.s."));
            if (this.subject.isReadOnly()) {
                throw new IllegalStateException(ResourcesMgr.getString("Subject.is.read.only"));
            }
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                switch (this.which) {
                    case 1: {
                        sm.checkPermission(AuthPermissionHolder.MODIFY_PRINCIPALS_PERMISSION);
                        break;
                    }
                    case 2: {
                        sm.checkPermission(AuthPermissionHolder.MODIFY_PUBLIC_CREDENTIALS_PERMISSION);
                        break;
                    }
                    default: {
                        sm.checkPermission(AuthPermissionHolder.MODIFY_PRIVATE_CREDENTIALS_PERMISSION);
                    }
                }
            }
            switch (this.which) {
                case 1: {
                    if (o instanceof Principal) break;
                    throw new SecurityException(ResourcesMgr.getString("attempting.to.add.an.object.which.is.not.an.instance.of.java.security.Principal.to.a.Subject.s.Principal.Set"));
                }
            }
            if (!this.elements.contains(o)) {
                return this.elements.add(o);
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            Objects.requireNonNull(o, ResourcesMgr.getString("invalid.null.input.s."));
            final Iterator<E> e = this.iterator();
            while (e.hasNext()) {
                Object next = this.which != 3 ? e.next() : AccessController.doPrivileged(new PrivilegedAction<E>(){

                    @Override
                    public E run() {
                        return e.next();
                    }
                });
                if (!next.equals(o)) continue;
                e.remove();
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(Object o) {
            Objects.requireNonNull(o, ResourcesMgr.getString("invalid.null.input.s."));
            final Iterator<E> e = this.iterator();
            while (e.hasNext()) {
                Object next;
                if (this.which != 3) {
                    next = e.next();
                } else {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        sm.checkPermission(new PrivateCredentialPermission(o.getClass().getName(), this.subject.getPrincipals()));
                    }
                    next = AccessController.doPrivileged(new PrivilegedAction<E>(){

                        @Override
                        public E run() {
                            return e.next();
                        }
                    });
                }
                if (!next.equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            boolean result = false;
            c = Subject.collectionNullClean(c);
            for (Object item : c) {
                result |= this.add(item);
            }
            return result;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            c = Subject.collectionNullClean(c);
            boolean modified = false;
            final Iterator<E> e = this.iterator();
            block0: while (e.hasNext()) {
                Object next = this.which != 3 ? e.next() : AccessController.doPrivileged(new PrivilegedAction<E>(){

                    @Override
                    public E run() {
                        return e.next();
                    }
                });
                for (Object o : c) {
                    if (!next.equals(o)) continue;
                    e.remove();
                    modified = true;
                    continue block0;
                }
            }
            return modified;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            c = Subject.collectionNullClean(c);
            for (Object item : c) {
                if (this.contains(item)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            c = Subject.collectionNullClean(c);
            boolean modified = false;
            final Iterator<E> e = this.iterator();
            while (e.hasNext()) {
                Object next = this.which != 3 ? e.next() : AccessController.doPrivileged(new PrivilegedAction<E>(){

                    @Override
                    public E run() {
                        return e.next();
                    }
                });
                if (c.contains(next)) continue;
                e.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public void clear() {
            final Iterator<E> e = this.iterator();
            while (e.hasNext()) {
                Object next = this.which != 3 ? e.next() : AccessController.doPrivileged(new PrivilegedAction<E>(){

                    @Override
                    public E run() {
                        return e.next();
                    }
                });
                e.remove();
            }
        }

        @Override
        public boolean isEmpty() {
            return this.elements.isEmpty();
        }

        @Override
        public Object[] toArray() {
            Iterator<E> e = this.iterator();
            while (e.hasNext()) {
                e.next();
            }
            return this.elements.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            Iterator<E> e = this.iterator();
            while (e.hasNext()) {
                e.next();
            }
            return this.elements.toArray(a);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            if (c.size() != this.size()) {
                return false;
            }
            try {
                return this.containsAll(c);
            }
            catch (ClassCastException | NullPointerException unused) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (E obj : this) {
                if (obj == null) continue;
                h += obj.hashCode();
            }
            return h;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            if (this.which == 3) {
                Iterator<E> i = this.iterator();
                while (i.hasNext()) {
                    i.next();
                }
            }
            ObjectOutputStream.PutField fields = oos.putFields();
            fields.put("this$0", this.subject);
            fields.put("elements", this.elements);
            fields.put("which", this.which);
            oos.writeFields();
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ObjectInputStream.GetField fields = ois.readFields();
            this.subject = (Subject)fields.get("this$0", null);
            this.which = fields.get("which", 0);
            LinkedList tmp = (LinkedList)fields.get("elements", null);
            this.elements = Subject.collectionNullClean((Collection)tmp);
        }
    }
}

